<?php
namespace App\Http\Controllers\WeChatApplet\Technician;

use App\Http\Models\Api\Common;
use App\Services\Business\DeliveryService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Export;
use App\Http\Models\Services\Prints;
use App\Http\Models\Services\Dispatch;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\WashDispatchService;
use App\Services\Business\WashDispatchBasicService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use App\Services\Business\WashOrderService;
use App\Services\CommonService;

// 技师小程序-仓库发货
class WashDeliveryController extends Controller
{

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function index (Request $request)
    {
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::list($user_info,$input);
        return response()->json($data);
    }

    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function add (Request $request)
    {
        $request = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::add($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function edit (Request $request)
    {
        $request = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::edit($user_info,$request);
        return response()->json($data);
    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function editStatus (Request $request)
    {
        $request = $request->all();
        $data = DeliveryService::editStatus($request);
        return response()->json($data);
    }

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function allIndex (Request $request)
    {
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::allIndex($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function addDelivery(Request $request)
    {
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::addDelivery($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function deliveryList(Request $request)
    {
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::deliveryList($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function deliveryEdit(Request $request)
    {
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data = DeliveryService::editDelivery($user_info,$input);
        return response()->json($data);
    }
}
