<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use App\Http\Models\Api\Common;
use App\Models\BasicManagement\Admin;
use App\Services\SystemsManage\PersonalService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\BasicManagement\AdminService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyEmployeeListController;
use App\Services\Shop\ShopService;

// 技师小程序个人中心
class PersonalController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new AdminService();
        $this->bootWithService($service);
    }

    // 个人中心
    public function personal(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'personal';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::personal($user_info, $request->all());
        return response()->json($return_data);
    }

    // 获取个人所有门店信息
    public function getPersonalShops(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'personal';
        logFileRecord($log_record, 'wash/getPersonalShops', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::getPersonalShops($user_info);
        return response()->json($return_data);
    }

    // 个人中心
    public function BusPersonal(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'personal';
        logFileRecord($log_record, 'wash/BusPersonal', 2);

        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::BusPersonal($user_info, $request->all());
        return response()->json($return_data);
    }

    // 工单统计
    public function getOrderNumList(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getOrderNumList';
        logFileRecord($log_record, 'wash/getOrderNumList', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::getOrderNumList($user_info, $request->all(), $request['show_count']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }


    // 个人中心-编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = AdminService::edit($user_info, $request->all());

        if ($return_data['code'] == 200) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '个人中心-小程序', '编辑信息', '个人信息编辑成功');
            return $this->success('编辑成功');
        } else {
            DB::rollBack();
            return $this->error($return_data['msg'], ErrorInc::MYSQL_FAILED);
        }
    }

    // 收藏技师
    public function collectionTh(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->collectionThValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = AdminService::collectionTh($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
            return $this->success('收藏成功');
        } else {
            DB::rollBack();
            return $this->error('收藏失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 取消收藏技师
    public function cancelCoTh(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->collectionThValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = AdminService::cancelCoTh($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
            return $this->success('取消收藏成功');
        } else {
            DB::rollBack();
            return $this->error('取消收藏失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 收藏的技师列表
    public function myCoTh(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::myCoTh($user_info, $request->all());
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 技师动态
    public function technicianDynamics(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::technicianDynamics($user_info, $request->all());
        if (isset($request['add_num']) && $request['add_num'] == 1) {
            $find_most = DB::table('moudle_statistics')
                ->where('most_shop_id', $user_info->adm_shop_id)
                ->where('most_adm_id', $user_info->adm_id)
                ->where('most_moudle_id', 4)
                ->first();
            $update_data['most_nums'] = $find_most->most_nums + 1;
            $update_data['most_update_time'] = date('Y-m-d H:i:s');
            if ($update_data['most_nums'] >= 3) {
                $update_data['most_remind'] = 2;
            }
            $update_res = DB::table('moudle_statistics')
                ->where('most_id', $find_most->most_id)
                ->update($update_data);
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 技师动态工单列表
    public function workOrderTh(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->collectionThValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::workOrderTh($user_info, $request->all(), 10);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 角色
    public function getRole(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('role')
            ->leftjoin('shop', 'shop_id', '=', 'rol_shop_id')
            ->where(function ($query) use ($request) {
                if (!empty($request['shop_id'])) {
                    $query->where('rol_shop_id', $request['shop_id']);
                }
            })
            ->where('rol_state', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['rol_id'])) {
                    $query->where('rol_id', $request['rol_id']);
                }
            })
            ->select('rol_id', 'rol_name', 'rol_state', 'rol_type', 'rol_description', 'rol_category', 'shop_store_name')
            ->orderBy('rol_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'暂无数据', 'data'=>'']);
        }
    }

    // 查询角色及相关数据
    public function getRoleData(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getRoleDataValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        $list_data = DB::table('role')
            ->where('rol_id', $request['rol_id'])
            ->select('rol_id', 'rol_name', 'rol_state', 'rol_type', 'rol_description', 'rol_category')
            ->first();
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'暂无数据', 'data'=>'']);
        }
    }

    // 创建账号-新增审核
    public function addProcess(Request $request)
    {
        $data = PersonalService::Add($request->all(),1);
        return response()->json($data);
    }

    // 审核创建账号
    public function Process(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'Process';
        logFileRecord($log_record, 'wash/Personal', 2);
        
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $data = PersonalService::Edit($user_info,$request->all());
        return response()->json($data);
    }

    // 审核列表
    public function index(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::index($user_info, $request->all());
        return response()->json($return_data);
    }

    // 审核驳回原因
    public function getReason(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getReasonValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getReason';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::getReason($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 门店经营驾驶舱
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-19
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function dataCount(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'dataCount';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::dataCount($user_info, $request->all());
        // 获取当前列表下的按钮
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        if (!empty($return_data)) {
            $buttonData = [];
            $buttonData[] = 'orderCount';
            $buttonData[] = 'goods';
            $buttonData[] = 'sales';
            $button_one = [];
            foreach ($list_button as $key => $value) {
                if (in_array($value['pri_operate_method'],$buttonData)) {
                    $button_one[] = $value;
                }
            }
            $return_data['button'] = $button_one;
        }
        return response()->json($return_data);
    }

    /**
     * 门店经营驾驶舱-销售额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-19
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function salesVolume(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'salesVolume';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = AdminService::salesVolume($user_info, $request->all());
        
        return response()->json($return_data);
    }

    /**
     * 邀请记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function invitation(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'invitation';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::invitation($user_info, $request->all());
        
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 邀请码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getInvQrimg(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getInvQrimg';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::getInvQrimg($user_info, $request->all());
        
        return response()->json($return_data);
    }

    /**
     * 新增邀请码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-14
     * @param  Request          $request [description]
     */
    public function addInvCode(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getInvQrimg';
        logFileRecord($log_record, 'wash/Personal', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::addInvCode($user_info, $request->all());
        
        return response()->json($return_data);
    }
}
