<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberListController;
use App\Http\Requests\Validators\Business\WashOrderValidator;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\WeChatApplet\Technician\MemberService;
use App\Services\LoginUserService;
use App\Http\Requests\Validators\WeChatApplet\Technician\MemberValidator;
use DB;
use App\Services\Business\WashOrderService;
use App\Http\Models\Api\Common;

class MemberController extends Controller
{
    public $dataService = null;
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataService = $service = new MemberService();
        $this->bootWithService($service);
    }

    // 编辑会员车牌号
    public function editMember(Request $request)
    {
        // 查询会员信息
        if ($request['type'] == 1) {
            if (isset($request['mem_id']) && !empty($request['mem_id'])) {
                $list_data = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_name', 'mem_id', 'mem_phone', 'mem_car_num', 'mem_car_series', 'mem_car_color', 'mem_source', 'mem_sex')
                    ->first();
                if ($list_data) {
                    $list_data->mem_car_num = DB::table('member_car')
                        ->where('meca_mem_id', $request['mem_id'])
                        ->value('meca_car_num');
                    return ['code' => 200, 'msg' => 'success', 'data' => $list_data];
                } else {
                    return ['code' => 500, 'msg' => '查无数据', 'data' => '查无数据'];
                }
            } else {
                return ['code' => 500, 'msg' => '请选择会员', 'data' => '请选择会员'];
            }
        }
        // 验证数据
        $verify_data = new MemberValidator;
        $error_message = $verify_data->editMemberValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => $error_message, 'data' => '']);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'editMember';
        logFileRecord($log_record, 'Technician/editMember', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $result = $this->dataService->editMember($user_info, $request->all());

        return $result;
    }

    /**
     * 充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function recharge(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'recharge';
        logFileRecord($log_record, 'Technician/recharge', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if (empty($request['type'])) {
            return response()->json(['code' => 500, 'msg' => '请选择会员类型', 'data' => '']);
        }
        if ($request['type'] == 1) {
            $result = WashOrderService::recharge($user_info, $request->all());
            if ($result['code'] == 200) {
                $data = [
                    'oplo_module'=>'会员列表',
                    'oplo_action'=>'充值',
                    'oplo_content'=>'会员充值',
                    'oplo_ip'=>getRealIp($request),
                    'order_number'=>$result['log_data']['order_number'],
                    'work_number'=>'',
                    'data_source'=>2,//操作来源  1 PC  2 小程序
                ];
                $log = addNewLog($user_info, $data);
            }
        } else {
            $result = WashOrderService::busRecharge($user_info, $request->all());
            if ($result['code'] == 200) {
                $data = [
                    'oplo_module'=>'会员列表',
                    'oplo_action'=>'充值',
                    'oplo_content'=>'企业会员充值',
                    'oplo_ip'=>getRealIp($request),
                    'order_number'=>$result['log_data']['order_number'],
                    'work_number'=>'',
                    'data_source'=>2,//操作来源  1 PC  2 小程序
                ];
                $log = addNewLog($user_info, $data);
            }
        }
        
        return response()->json($result);
    }

    /**
     * 充值记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function reclog(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'reclog';
        logFileRecord($log_record, 'Technician/reclog', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $result = WashOrderService::reclog($user_info, $request->all(), $request['show_count']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$result]);
    }

    /**
     * 获取会员余额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getBanlance(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getBanlance';
        logFileRecord($log_record, 'Technician/getBanlance', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if (!isset($request['type'])) {
            $request['type'] = 1;
        }
        if (empty($request['type'])) {
            return response()->json(['code' => 500, 'msg' => '请选择会员类型', 'data' => '']);
        }
        if ($request['type'] == 1) {
            $result = WashOrderService::getBanlance($user_info, $request->all());
        } else {
            $result = WashOrderService::busBanlance($user_info, $request->all());
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$result]);
    }
    /**|---------------------------------------------------------------------------------
     * @name 订单编辑用户信息
     * @param array $user_info 用户信息
     * @param array $request 请求信息
     * @retrun /multitype:array
     * @author dou 2025/3/28 16:38
     * |---------------------------------------------------------------------------------
     */
    public function editOrderMember ( Request $request ){
        if ($request['edit_type'] == 2) {
            $verify_data = new WashOrderValidator();
            $error_message = $verify_data->addMemberValidator($request->all());
            if ($error_message) {
                return response()->json(['code' => 500, 'msg' => $error_message, 'data' => '参数错误', 'error_message' => $error_message]);
            }
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        return MemberService::editOrderMember($user_info, $request, $request->ip());
    }
}
