<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\WeChatApplet\Technician\ContactUsService;
use App\Services\LoginUserService;
use App\Http\Requests\Validators\WeChatApplet\Technician\ContactUsValidator;
use DB;
use App\Http\Controllers\WeChatApplet\LoginController;
use App\Http\Models\Api\Common;
use BlueCity\Core\Inc\ErrorInc;

class ContactUsController extends Controller
{
    public $dataService = null;
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataService = $service = new ContactUsService();
        $this->bootWithService($service);
    }

    /**
     * 联系我们
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function right(Request $request)
    {
        $data[0]['title'] = '电话咨询';
        $data[0]['data']['phone'] = '02282939965';
        $data[0]['data']['work_time'] = '工作日：8:30-18:00';
        $data[1]['title'] = '聆听·建议反馈';
        $data[1]['data']['content'] = '我们不是完美的，我们 渴望您的建议';
        $data[2]['title'] = '教学视频';
        $data[2]['data']['content'] = '我们在这里为您准备了 使用手册和教学视频';

        return response()->json(['code' => 200, 'msg' => 'success', 'data' =>$data]);
    }

    /**
     * 获取模块
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getModel(Request $request) {
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 查询账号信息
        $find_admin = DB::table('admin as adm')
             ->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'adm.adm_id')
            ->leftjoin('role', 'role.rol_id', '=', 'asr.role_id')
            ->leftjoin('shop', 'shop.shop_id', '=', 'asr.shop_id')
            ->where('adm.adm_id', $user_info->adm_id)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            ->select('adm.adm_id', 'adm.adm_name', 'adm.adm_account', 'adm.adm_phone', 'asr.shop_cid as adm_cid', 'asr.shop_id as adm_shop_id', 'asr.adm_state', 'rol_state', 'rol_privilege', 'rol_privilege_multiple', 'asr.superior_shop_id as adm_superior_shop_id', 'shop_source_identify')
            ->first();
        // 查找此用户对应得角色权限
        $login = new LoginController;
        $role_auth = $login->getRolePrivilege($find_admin);
        $role_model = array_merge($role_auth['role_auth1'],$role_auth['role_auth2']);
        $role_model = array_merge($role_model,$role_auth['role_auth3']);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' =>$role_model]);
    }

    /**
     * 提交
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function submit(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'submit';
        logFileRecord($log_record, 'ContactUs/submit', 2);
        request()->offsetSet('rt', 'wechat');
        // 验证参数
        $error_message = $this->dataService->mainValidator->submitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM, );
        }
        $user_info = LoginUserService::getUser();

        $add_data['fee_shop_id'] = $user_info->adm_shop_id;
        $add_data['fee_pri_id'] = $request['fee_pri_id'];
        $add_data['fee_pri_name'] = $request['fee_pri_name'];
        $add_data['fee_create_id'] = $user_info->adm_id;
        $add_data['fee_create_name'] = $user_info->adm_name;
        $add_data['fee_state'] = 1;
        $add_data['fee_pic_url'] = json_encode($request['fee_pic_url'], true);
        $add_data['fee_title'] = $request['fee_title'];
        $add_data['fee_content'] = $request['fee_content'];
        $add_res = DB::table('feedback')->insertGetId($add_data);
        if ($add_res) {
            $log_data = [
                'oplo_module'=>'意见反馈',
                'oplo_action'=>'反馈提交',
                'oplo_content'=>'提交成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>'',
                'work_number'=>'',
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
            return response()->json(['code' => 200, 'msg' => '提交成功', 'data' =>'']);
        }
    }

    /**
     * 培训视频列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function video(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'video';
        logFileRecord($log_record, 'Technician/video', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if (empty($request['inv_type'])) {
            return response()->json(['code' => 500, 'msg' => '请选择类型', 'data' => '']);
        }
        $result = ContactUsService::video($user_info,$request);
        return response()->json($result);
    }

    /**
     * 立即试用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function tryNow(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'video';
        logFileRecord($log_record, 'Technician/tryNow', 2);

        // // 验证参数
        // $error_message = $this->dataService->mainValidator->tryNowValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error($error_message, ErrorInc::INVALID_PARAM, );
        // }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $result = ContactUsService::tryNow($user_info,$request);
        return response()->json($result);
    }
}
