<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use App\Services\AfterOrder\AfterOrderService;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Http\Controllers\Api\Verify\AfterOrderManage\AfterOrderManageController;
use App\Http\Models\Api\Common;
use App\Services\LoginUserService;
use Illuminate\Support\Facades\DB;
// 售后列表
class AfterOrderController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;


    /**
     * 售后列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function index(Request $request){
        // 验证数据
        $verify_data = new AfterOrderManageController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误']);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $request = $request->all();
        $data = AfterOrderService::index($user_info,$request);
        return response()->json($data);
    }

    /**
     * 售后详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function info(Request $request){
        // 验证数据
        $verify_data = new AfterOrderManageController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误']);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $request = $request->all();
        $data = AfterOrderService::info($user_info,$request);
        return response()->json($data);
    }

    /**
     * 售后处理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function dealwith(Request $request){
        // 验证数据
        $verify_data = new AfterOrderManageController;
        $error_message = $verify_data->dealwithValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'']);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $request = $request->all();
        $data = AfterOrderService::dealwith($user_info,$request);
        return response()->json($data);
    }

    /**
     * 售后处理-完工
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function complete(Request $request){
        // 验证数据
        $verify_data = new AfterOrderManageController;
        $error_message = $verify_data->completeValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'']);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $request = $request->all();
        DB::beginTransaction();
        $data = AfterOrderService::complete($user_info,$request);
        if ($data['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($data);
    }

    // 获取施工部位
    public function getParts(Request $request) {
        $type = DB::table('auto_parts')
            ->where('enabled', 1)
            ->select('type', 'type_id')
            ->groupBy('type')
            ->get()->toArray();
        $new_data = [];
        foreach ($type as $key1 => $value1) {
            $new_data[$key1]['type'] = $value1->type;
            $new_data[$key1]['type_id'] = $value1->type_id;
            $new_data[$key1]['type_num'] = 0;
            $new_data[$key1]['data'] = DB::table('auto_parts')
                ->where('enabled', 1)
                ->where('type', $value1->type)
                ->select('title', 'id', 'type')
                ->get()->toArray();
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>$new_data]);
    }
}
