<?php
namespace App\Http\Controllers\WeChatApplet\PublicsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\PublicSearch;

class PublicSearchController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 搜索商品品牌
    public function searchBrand(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        
        $select_field = "bra_id, bra_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchBrand($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data_info']]);
    }

    // 搜索品牌系列
    public function searchBrandSerie(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        
        $select_field = "brse_id, brse_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchBrandSerie($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data_info']]);
    }

    // 搜索商品品类
    public function searchCategory(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        
        $select_field = "cate_id, cate_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchCategory($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data_info']]);
    }

    // 搜索仓库
    public function searchWarehouse(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        
        $select_field = "ware_id, ware_name, ware_type";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchWarehouse($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data']]);
    }

    // 搜索服务技师
    public function searchTechnician(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        $search_data = $request->all();
        $public_search = new PublicSearch;
        $list_data = $public_search->searchTechnician($user_info, $search_data);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data_info']]);
    }

    // 搜索业务员
    public function searchSalesman(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $select_field = "adm_id, adm_name, adm_phone";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchSalesman($user_info, $request->all(), $select_field, $this->show_count);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data']]);
    }

    // 搜索人员
    public function searchPersonel(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $select_field = "adm_id, adm_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchPersonel($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data']]);
    }

    // 搜索客户单位
    public function searchChannelUnit(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $select_field = "chun_id, chun_unit_name, chun_name, chun_phone, chun_province, chun_city, chun_county, chun_address";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchChannelUnit($user_info, $request->all(), $this->show_count, $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data']]);
    }

    // 搜索业务划区
    public function searchPrecincts(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $select_field = "prec_id, prec_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchPrecincts($user_info, $request->all(), $select_field);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data['data']]);
    }

    // 搜索仓位
    public function searchFreight(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        $list_data = DB::table('warehouse_freight')
            ->where('wafr_shop_id', $shop_id)
            ->where('wafr_ware_id', $request['ware_id'])
            ->where('wafr_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['wafr_name'])) {
                    $query->where('wafr_name', 'like', '%'.$search_data['wafr_name'].'%');
                }
            })
            ->select('wafr_id', 'wafr_name', 'wafr_rank')
            ->paginate(1500);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();
        
        return response()->json(['code'=>200, 'msg'=>'success', 'data_info'=>$data_info]);
    }

    // 搜索采购退货仓位
    public function searchFreightGoods(Request $request)
    {
        $search_data = $request->all();
        $list_data = DB::table('warehouse_freight_goods as wafg')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'wafg.wafg_goo_id')
            ->where('wafg_ware_id', $request['ware_id'])
            ->where('goo_delete', 1)
            ->where('goo_state', 1)
            ->where(function ($query) use ($search_data) {
                $query->where('wafg_stock_number', '>', 0)
                    ->orWhere('wafg_priority_stock_number', '>', 0)
                    ->orWhere('wafg_unchecked_stock_number', '>', 0);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_id'])) {
                    $query->where('wafg_goo_id', $search_data['goo_id']);
                }
            }) //品类id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['wafr_id'])) {
                    $query->where('wafg_wafr_id', $search_data['wafr_id']);
                }
            }) //仓位id
            ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number')
            ->orderBy('goo_goods_encode', 'asc')
            ->get()->toArray();
        $data_info['data'] = $list_data; //返回数据
        if ($data_info['data']) {
            // 查询仓位数据
            $wafg_wafr_id = array_column($data_info['data'], 'wafg_wafr_id');
            $wafr_data = DB::table('warehouse_freight')
                ->whereIn('wafr_id', $wafg_wafr_id)
                ->pluck('wafr_name', 'wafr_id')
                ->toArray();
            foreach ($data_info['data'] as $key => $value) {
                if (!empty($value->wafg_wafr_id)) {
                    $data_info['data'][$key]->wafr_name = $wafr_data[$value->wafg_wafr_id];
                } else {
                    $data_info['data'][$key]->wafr_name = '';
                }
            }
        }
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 洗美技师小程序-搜索质检项
    public function searchQualityReward(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        // 质检奖惩管理，质检标准管理查询
        $list_data = DB::table('wash_quality_reward_punishment')
            ->where('qurp_shop_id', $user_info->adm_shop_id)
            ->where('qurp_type', 1)//类型1质检标准2奖励项3惩罚项
            ->where('qurp_state', 1)//状态1启用2停用
            ->where('qurp_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['qurp_name'])) {
                    $query->where('qurp_name', 'like', '%'.$search_data['qurp_name'].'%');
                }
            })
            ->select('qurp_id', 'qurp_name', 'qurp_standard_type', 'qurp_standard')
            ->paginate(1500);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();
        
        return response()->json(['code'=>200, 'msg'=>'success', 'data_info'=>$data_info]);
    }
    
}
