<?php
namespace App\Http\Controllers\WeChatApplet\OtherSystemInterfaces;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\WeChatApplet\Verify\OtherSystemInterfaces\VerifyOtherSystemOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class OtherSystemOrdersController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 接单
    public function orderReceiving(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->orderReceivingValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $order_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'ord.ord_id', '=', 'orcl.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_cid', 'ord_shop_id', 'ord_superior_shop_id', 'ord_other_system_number', 'ord_wor_state', 'ord_order_number', 'ord_type','orcl_join_wor_id')
            ->first();
        if ($order_data->ord_wor_state != 7) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是待接单状态,不能接单']);
        }

        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_type = $user_info->shop_superior_id ? 2 : 1;//接单类型：1总店接单2加盟店接单

        DB::beginTransaction();

        $order_update['ord_wor_state'] = 1;
        $order_update['ord_update_time'] = date('Y-m-d H:i:s');
        $order_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($order_update);

        // 判断是否有预约时间
        if (!empty($request['appoint_time'])) {
            $param['daytime'] = $request['appoint_time'];//速电-预约时间

            $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
            $orcl_res =  DB::table('order_client')
                ->where('orcl_ord_id', $request['ord_id'])
                ->update($orcl_edit);

            // 预约备注内容
            $remark_data = '预约时间：'.$request['appoint_time'];
            if (!empty($request['appoint_remark'])) {
                $remark_data .= ' '.$request['appoint_remark'];
            }
            $remark_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-接单预约');

            if ($orcl_res && $remark_res) {
                $appoint_res = true;
            } else {
                $appoint_res = false;
            }
        } else {
            $appoint_res = true;
        }

        $log_res = orderLog($user_info, $request['ord_id'], 0, '接受订单');
        if ($order_res && $log_res && $appoint_res) {
            // 判断总店、加盟店接单
            if (config('apisystem.SYNC_STATE') && $shop_type == 1) {
                // 总店接单，同步速电
                sdOrderLog($order_data, 0, $order_data->orcl_join_wor_id, '接受订单');
                $url = config('apisystem.sd_server_name').'/index.php/sync_receipt_status';
                $param['serial_number'] = $order_data->ord_other_system_number;//第三方工单号
                $param['type'] = 1;
                $param['ip'] = getRealIp($request);
                $param['time'] = date('Y-m-d H:i:s');//收货时间
                $param['token'] = md5(md5($param['time'].config('apisystem.sd_token')));//token
                $doPost_res = Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res);
                if ($doPost_res->code != 200) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
                }
            } else {
                // 加盟店接单
                $wor = DB::table('work_order')->where('wor_id', $order_data->orcl_join_wor_id)->first(['wor_cid as adm_cid','wor_superior_shop_id as shop_superior_id','wor_shop_id as adm_shop_id']);
                $store_name = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_store_name');
                $wor->adm_name = $store_name;
                $wor->adm_id = 0;
                orderLog($wor, 0, $order_data->orcl_join_wor_id, '接受订单');
            }

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0;//原始单号创建人
            $inhi_data['inhi_original_id'] = $request['ord_id'];//原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number;//原始单号
            $inhi_data['inhi_original_state'] = $order_update['ord_wor_state'];//原始单状态
            $inhi_data['inhi_original_operation'] = '门店接单';//操作
            $inhi_data['inhi_operation_state'] = 18;//操作状态：18门店接单
            addInformationHint($user_info, $inhi_data, 3);

            Common::addLog($user_info, getRealIp($request), '订单列表', '接单', '订单:'.$order_data->ord_order_number.' 接单成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'接单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'接单失败']);
        }
    }
}
