<?php
namespace App\Http\Controllers\WeChatApplet\DataSearch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Api\Common;

// 微信小程序 -- 数据查询 -- 销售统计
class DataStatisticalController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $search_data = $request->all();
        
        $find_ord_data = DB::table('order as ord')
            ->leftjoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1)
            ->whereNotIn('orgo_state', [2, 3])
            ->where('ord_delete', 1)
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->selectRaw('count(ord_id) as num, sum(orgo_goo_quantity * orgo_goo_price) as allprice, sum(orgo_goo_quantity) as allnum, ord_service_type, orgo_state, sum(orgo_goo_quantity * orgo_goo_cost) as allcost, ord_order_number')
            ->groupBy('ord_service_type', 'orgo_state')
            ->get()->toArray();
        $find_ord_data = $this->objectToArray($find_ord_data);
        // 统计订单的服务项目金额
        $find_orcl_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1)
            ->where('ord_delete', 1)
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('orcl_rescue_service_price as service_price', 'ord_order_number')
            ->get()->toArray();
        $find_orcl_data = $this->objectToArray($find_orcl_data);
        $allshow = [];
        $allprice = 0;//销售合计
        $all_service_price = 0;//服务项目金额合计
        $allnum = 0;//数量合计
        $allcost = 0;//成本合计
        foreach ($find_ord_data as $key => $value) {
            if ($value['ord_service_type'] == '4' || $value['orgo_state'] == '4') {
                $allprice -= $value['allprice'];
                $allnum -= $value['allnum'];
                $allcost -= $value['allcost'];
            } else {
                $allprice += $value['allprice'];
                $allnum += $value['allnum'];
                $allcost += $value['allcost'];
            }
        }
        foreach ($find_orcl_data as $key => $value) {
            $all_service_price += $value['service_price'];
        }
        $allshow['profits'] = $allprice;//销售合计
        $allshow['all_service_price'] = $all_service_price;//服务金额合计
        $allshow['allnum'] = $allnum;//数量合计
        $allshow['allcost'] = $allcost;//成本合计
        $allshow['profit'] = ($allprice - $allcost);//利润 = 营业额（销售合计） - 商品成本（成本合计）
        return response()->json(['code'=>200, 'msg'=>'success', 'allshow'=>$allshow]);
    }

    /**|---------------------------------------------------------------------------------
     * @name  对象转数组
     * @param $object 对象数据
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/9/30 16:35>
     * |---------------------------------------------------------------------------------
     */
    public function objectToArray($object)
    {
        // 先编码成json字符串，再解码成数组
        return json_decode(json_encode($object), true);
    }
}
