<?php

namespace App\Http\Controllers\Mounting\Verify\BasicManage;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

// 作品管理验证器
class VerifyWorkVerificationController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prma_name.required' => '请输入:分类名称',
            'prma_name.max' => '分类名称长度超过最大限制',
            'prma_type.required' => '请选择模块',
            'prma_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prma_name' => 'required|max:20',
            'prma_remark' => 'max:255',
            'prma_type' => [
                'required',
                Rule::in([1,2,3,4]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prma_id.required' => '参数错误',
            'prma_id.integer' => '参数错误',
            'prma_name.required' => '请输入:分类名称',
            'prma_unusual_name.max' => '分类名称长度超过最大限制',
            'prma_type.required' => '请选择模块',
            'prma_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prma_id' => 'required|integer',
            'prma_name' => 'required|max:20',
            'prma_remark' => 'max:255',
            'prma_type' => [
                'required',
                Rule::in([1,2,3,4]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prma_id.required' => '参数错误',
            'prma_id.array' => '参数错误',
            'prma_type.required' => '请选择模块',
            'prma_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prma_id' => 'required|array',
            'prma_type' => [
                'required',
                Rule::in([1, 2, 3, 4]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 视频图文启用验证器
    public function ivstartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prco_id.required' => '参数错误',
            'prco_id.array' => '参数错误',
            'prma_type.required' => '请选择模块',
            'prma_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prco_id' => 'required|array',
            'prma_type' => [
                'required',
                Rule::in([1, 2, 3, 4]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索作品管理数据
    public function searchValidateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
            'prma_type.required' => '请选择模块',
            'prma_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'prma_type' => [
                'required',
                Rule::in([1, 2,3,4]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
