<?php

namespace App\Http\Controllers\Mounting\Finance;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Finance\WashRechargeService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\Business\WashWorkService;

// 充值管理
class WashRechargeController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashRechargeService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->index($user_info, $request->all(), 10);

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $exist = WashRechargeService::Exists($user_info, $request['rech_type'], $request['rech_client_id']);
        if ($exist) {
            return $this->error('此客户已经存在', ErrorInc::DATA_EXIST);
        }
        DB::beginTransaction();
        $res = WashRechargeService::add($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '新增', '新增成功');
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        if ($request['type'] == 1) {
            $return_data = DB::table('wash_recharge')
                ->where('rech_id', $request['rech_id'])
                ->select('rech_id', 'rech_client_id', 'rech_client_name', 'rech_phone', 'rech_car_num', 'rech_car_vin', 'rech_type', 'rech_balance', 'rech_time_start', 'rech_time_end')
                ->first();
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }
        // 验证参数

        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $res = WashRechargeService::edit($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '修改', '修改成功');
            DB::commit();
            return $this->success('修改成功');
        } else {
            DB::rollBack();
            return $this->error('修改失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashRechargeService::editState($request['rech_id'], 1);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '启用', '启用成功');
            return $this->success('启用成功');
        } else {
            return $this->error('启用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashRechargeService::editState($request['rech_id'], 2);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '停用', '停用成功');
            return $this->success('停用成功');
        } else {
            return $this->error('停用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 销户
    public function accountCancellation(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->accountCancellationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashRechargeService::deleteState($request->all(), 1);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '销户', '销户成功');
            return $this->success('销户成功');
        } else {
            return $this->error('销户失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashRechargeService::info($user_info, $request->all());
        return response()->json($return_data);
    }

    // 充值
    public function recharge(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->rechargeShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        if ($request['type'] == 1) {
            $return_data = DB::table('wash_recharge')
                ->where('rech_id', $request['rech_id'])
                ->select('rech_id', 'rech_client_id', 'rech_client_name', 'rech_phone', 'rech_car_num', 'rech_car_vin', 'rech_type', 'rech_balance', 'rech_time_start', 'rech_time_end')
                ->first();
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }

        // 验证参数
        $error_message = $this->dataService->mainValidator->rechargeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        DB::beginTransaction();
        $res = WashRechargeService::recharge($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '充值管理', '充值', '充值成功');
            DB::commit();
            return $this->success('充值成功');
        } else {
            DB::rollBack();
            return $this->error('充值失败', ErrorInc::MYSQL_FAILED);
        }
    }
}
