<?php

namespace App\Http\Controllers\Mounting\Finance;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Finance\WashPerformanceService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\Business\WashWorkService;
use App\Http\Models\Api\Common;

// 绩效明细
class WashPerformanceController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashPerformanceService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        $user_info = LoginUserService::getUser();
        if ($request['type'] == '1') {
            // 按工单分类查询
            $search_data = $this->dataService->searchWork($user_info, $request->all(), 10);
        } else {
            // 按技师分类查询
            $search_data = $this->dataService->searchTechnician($user_info, $request->all(), 10);
        }

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
       
        $return_data = WashPerformanceService::info($user_info, $request->all());
        return response()->json($return_data);
    }

    // 导出
    public function lead(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $user_info = LoginUserService::getUser();
        if ($request['type'] == '1') {
            // 按工单分类导出
            $lead_res = $this->dataService->leadWork($user_info, $request->all());
        } elseif ($request['type'] == 2) {
            // 按技师分类导出
            $lead_res = $this->dataService->lead($user_info, $request->all());
        } else {
            // 按技师详情导出
            $lead_res = $this->dataService->leadInfo($user_info, $request->all());
        }
        return $lead_res;
        if ($lead_res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '绩效列表', '导出', '导出成功');
        }
        return response()->json($lead_res);
    }
}
