<?php
namespace App\Http\Controllers\Mounting\Business;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\ReservationService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 预约单列表
class ReservationController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new ReservationService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ReservationService::info($user_info, $request->all());
        return response()->json($return_data);
    }
    
    // 取消
    public function cancel(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        // 取消预约单
        $return_data = ReservationService::cancel($user_info, $request->all(), 3);
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLogType($user_info, $request['reli_id'], 1, '取消预约单');
        if ($request['remark']) {
            // 添加备注
            $orre_res = orderRemarkType($user_info, $request['reli_id'], 1, $request['remark'], '预约单列表-取消');
        } else {
            $orre_res = true;
        }
         // 预约单信息
        $find_reli_data = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'reli.reli_id', '=', 'recl.recl_reli_id')
            ->where('reli_id', $request['reli_id'])
            ->select('reli_number', 'reli_shop_id', 'reli_client_id')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_reli_data->reli_shop_id)
            ->where('ussh_user_id', $find_reli_data->reli_client_id)
            ->value('ussh_weus_id');
        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_reli_data->reli_shop_id;
        //     $add_data['primary_id'] = $request['reli_id']; //单据的主键id
        //     $add_data['primary_type'] = 3; //单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1; //阅读状态：1未读2已读
        //     $add_data['content'] = '您的预约单：' . $find_reli_data->reli_number . '取消成功,取消人：' . $user_info->adm_name; //操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }
        // if ($addUserMessage_res['code'] != 200) {
        //     return $addUserMessage_res;
        // }
        if ($orlo_res && $orre_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '预约单列表', '取消预约单', '取消预约单'.$return_data['data']['reli_number'].'成功');
            return $this->success('取消预约单成功');
        } else {
            DB::rollBack();
            return $this->error('取消预约单失败', ErrorInc::MYSQL_FAILED);
        }
    }
    
    // 备注
    public function remark(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->remarkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ReservationService::remarkSearch($user_info, $request->all());
        $orre_res = orderRemarkType($user_info, $request['reli_id'], 1, $request['remark'], '预约单列表-备注');
        if ($orre_res) {
            OperationLog::addLog($user_info, getRealIp($request), '预约单列表', '备注', '预约单 '.$return_data['reli_number']. ' 添加备注 :' . $request['remark']);
            return $this->success('备注成功');
        } else {
            return $this->error('备注失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 预约设置
    public function appointmentSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentSetValidator($request->all());
        if (!empty($error_message)) {
            // return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'请求参数错误！222', 'data'=>$error_message];
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->appointmentSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLogType($user_info, $request['reli_id'], 1, '预约设置');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (!empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemarkType($user_info, $request['reli_id'], 1, $request['appoint_remark'], '预约单列表-预约设置');
        if ($orlo_res && $orre_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '预约单列表', '预约设置', '预约设置：'.$return_data['data']['reli_number'].'成功');
            return $this->success('预约设置成功');
        } else {
            DB::rollBack();
            return $this->error('预约设置失败', ErrorInc::MYSQL_FAILED);
            return response()->json($return_data);
        }
    }
}
