<?php

namespace App\Http\Controllers\Mounting\BasicManage;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\ValidateCarTestService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;

use function PHPSTORM_META\type;

class ValidateCarTestController extends Controller
{
    public $dataService = null;  // ResourceControllerMethod 必备参数
    public $dataFields = ['vacm_unusual_name', 'vacm_type', 'vacm_remark'];  // 保存和修改时的 fields 参数
    protected $validateRules = [
        'rules' => [
            'vacm_unusual_name' => 'required',
            'vacm_type' => 'required|numberic'
        ],
        'messages' => [

        ],
        'attributes' => [
            'vacm_unusual_name' => '异常名称',
            'vacm_type' => '类型',
            'vacm_remark' => '备注',
        ]
    ];

    public function __construct()
    {
        $service = new ValidateCarTestService();
        $this->bootWithService($service);
    }

    use ResourceControllerMethod;


    // public function _setStore($data) {
    //     $userInfor = LoginUserService::getUser();
    //     $data['vacm_type'] = $data['vacm_type'];
    //     $data['vacm_unusual_name'] = $data['vacm_unusual_name'];
    //     $data['vacm_remark'] = $data['vacm_remark'] ?? '';
    //     unset($data['vacm_id']);
    //     $data['vacm_shop_id'] = $userInfor['adm_shop_id'];
    //     $data['vacm_superior_shop_id'] = $userInfor['shop_superior_id'];
    //     $data['vacm_cid'] = $userInfor['adm_cid'];
    //     $data['grle_state'] = 1;
    //     $data['grle_delete'] = 1;
    //     return $data;
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $param['type'] = $request->input('type', 1);
        $param['keywords'] = $request->input('vacm_unusual_name', '');
        $param['vacm_state'] = $request->input('vacm_state', '');
        // 查询字段
        $field_columns = ['vacm_id', 'vacm_unusual_name', 'vacm_remark', 'vacm_state', 'vacm_create_time'];

        $service = new ValidateCarTestService();
        $search_data = $service->search($param, $field_columns, $request->input('page', 1), 2);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return $this->success('查询成功', $search_data);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $exist = ValidateCarTestService::nameExists($user_info, $request['vacm_unusual_name'], $request['vacm_type'], 0);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        $res = ValidateCarTestService::add($user_info, $request->all());
        if ($res) {
            $hint = $this->typeHint($request['vacm_type']);
            OperationLog::addLog($user_info, getRealIp($request), '验车管理', '新增', '新增'.$hint.':'.$request['vacm_unusual_name'].'成功');
            return $this->success('新增成功');
        } else {
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $exist = ValidateCarTestService::nameExists($user_info, $request['vacm_unusual_name'], $request['vacm_type'], $request['vacm_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        $res = ValidateCarTestService::edit($request->all());
        if ($res) {
            $hint = $this->typeHint($request['vacm_type']);
            OperationLog::addLog($user_info, getRealIp($request), '验车管理', '编辑', '编辑'.$hint.':'.$request['vacm_unusual_name'].'成功');
            return $this->success('编辑成功');
        } else {
            return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ValidateCarTestService::editState($request['id'], 1);
        if ($res) {
            // 获取启用的名称
            $field_columns = ['vacm_unusual_name'];
            $find_vacm = ValidateCarTestService::getFieldsByIdAll($user_info, [4,5,6], $field_columns);
            $vacm_unusual_name = array_column($find_vacm, 'vacm_unusual_name');

            $hint = $this->typeHint($request['vacm_type']);
            OperationLog::addLog($user_info, getRealIp($request), '验车管理', '启用', $hint.'：（'.implode(',', $vacm_unusual_name).'）启用成功');
            return $this->success('启用成功');
        } else {
            return $this->error('启用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ValidateCarTestService::editState($request['id'], 2);
        if ($res) {
            // 获取停用的名称
            $field_columns = ['vacm_unusual_name'];
            $find_vacm = ValidateCarTestService::getFieldsByIdAll($user_info, [4,5,6], $field_columns);
            $vacm_unusual_name = array_column($find_vacm, 'vacm_unusual_name');

            $hint = $this->typeHint($request['vacm_type']);
            OperationLog::addLog($user_info, getRealIp($request), '验车管理', '停用', $hint.'：（'.implode(',', $vacm_unusual_name).'）停用成功');
            return $this->success('停用成功');
        } else {
            return $this->error('停用失败', ErrorInc::MYSQL_FAILED);
        }
    }
    
    // 删除
    public function delete(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ValidateCarTestService::editDelete($request['id'], 2);
        if ($res) {
            // 获取删除的名称
            $field_columns = ['vacm_unusual_name'];
            $find_vacm = ValidateCarTestService::getFieldsByIdAll($user_info, [4,5,6], $field_columns);
            $vacm_unusual_name = array_column($find_vacm, 'vacm_unusual_name');

            $hint = $this->typeHint($request['vacm_type']);
            OperationLog::addLog($user_info, getRealIp($request), '验车管理', '删除', $hint.'：（'.implode(',', $vacm_unusual_name).'）删除成功');
            return $this->success('删除成功');
        } else {
            return $this->error('删除失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 搜索验车管理数据
    public function searchValidateCar(Request $request)
    {
        $param['type'] = $request->input('type', 1);
        $param['keywords'] = $request->input('vacm_unusual_name', '');
        $param['vacm_state'] = 1;
        // 查询字段
        $field_columns = ['vacm_id', 'vacm_unusual_name'];

        $service = new ValidateCarTestService();
        $search_data = $service->search($param, $field_columns, $request->input('page', 1), 0);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return $this->success('查询成功', $search_data);
        }
    }

    // 类型提示信息
    private function typeHint($type)
    {
        if ($type == 1) {
            $hint = '车内异常管理';
        } else {
            $hint = '外观异常管理';
        }
        return $hint;  
    }
}
