<?php

namespace App\Http\Controllers\Mounting\BasicManage;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\BasicManagement\ShareTemplateService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;

// 分享模板管理
class ShareTemplateController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new ShareTemplateService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 查询字段
        $field_columns = ['shte_id', 'shte_type', 'shte_name', 'shte_shop_id', 'shte_adm_id', 'shte_state', 'shte_delete', 'shte_create_time'];
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10, $field_columns);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $return_data = ShareTemplateService::info($user_info, $request->all());
        if ($return_data) {
           return response()->json($return_data);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $exist = ShareTemplateService::nameExists($user_info, $request['shte_name'], 0);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        $res = ShareTemplateService::add($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '分享模板管理', '新增', '新增'.$request['shte_name'].'成功');
            return $this->success('新增成功');
        } else {
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $field_columns = ['shte_id', 'shte_type', 'shte_name', 'shte_shop_id', 'shte_adm_id', 'shte_content', 'shte_state', 'shte_delete', 'shte_create_time'];
            $return_data = ShareTemplateService::getFieldsById($user_info, $request['shte_id'], $field_columns);
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $exist = ShareTemplateService::nameExists($user_info, $request['shte_name'], $request['shte_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        $res = ShareTemplateService::edit($request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '分享模板管理', '编辑', '编辑'.$request['shte_name'].'成功');
            return $this->success('编辑成功');
        } else {
            return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ShareTemplateService::editState($request['shte_id'], 1);
        if ($res) {
            // 获取启用的名称
            $field_columns = ['shte_name'];
            $find_shte = ShareTemplateService::getFieldsById($user_info, $request['shte_id'], $field_columns);

            OperationLog::addLog($user_info, getRealIp($request), '分享模板管理', '启用', $find_shte->shte_name.'启用成功');
            return $this->success('启用成功');
        } else {
            return $this->error('启用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ShareTemplateService::editState($request['shte_id'], 2);
        if ($res) {
            // 获取停用的名称
            $field_columns = ['shte_name'];
            $find_shte = ShareTemplateService::getFieldsById($user_info, $request['shte_id'], $field_columns);

            OperationLog::addLog($user_info, getRealIp($request), '分享模板管理', '停用', $find_shte->shte_name.'停用成功');
            return $this->success('停用成功');
        } else {
            return $this->error('停用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->deleteValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = ShareTemplateService::deleteState($request['shte_id']);
        if ($res) {
            // 获取停用的名称
            $field_columns = ['shte_name'];
            $find_shte = ShareTemplateService::getFieldsById($user_info, $request['shte_id'], $field_columns);

            OperationLog::addLog($user_info, getRealIp($request), '分享模板管理', '删除', $find_shte->shte_name.'删除成功');
            return $this->success('删除成功');
        } else {
            return $this->error('删除失败', ErrorInc::MYSQL_FAILED);
        }
    }
}