<?php
/**
 * 测试文件（权限服务）
 * 文件简单描述（权限基础操作权限）
 * @author DouBin
 * @Date: 2023-07-07 007
 * @Time: 下午 3:59:11
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Http\Controllers\Dou;

use App\Services\CommonService;
use App\Services\Point\PointService;
use App\Services\ThreeApi\BaiDu\BaiDuService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;
use DB;
use Pinyin;

class MyTestController extends Controller
{
    public function test ( Request $request ){
        $rea = DB::table('shop_qr')
            ->where('shqr_number','111111111')
            ->delete();
        if($rea){
            return response()->json(['code'=>200, 'msg'=>'操作成功', 'data'=>$rea]);
        }else{
            return response()->json(['code'=>201, 'msg'=>'操作失败', 'data'=>$rea]);
        }
//        $day = date('t',time());
//        $week = date('w',time());
//        $daytime = CommonService::getDiffDate('2023-09-01', '2023-09-18');
//        $data = PointService::getSigninData();
//        return ['code'=>200, 'msg'=>'修改成功', 'data'=>$data];
//        $img = file_get_contents('https://pics3.baidu.com/feed/8ad4b31c8701a18bb4d1d408b9ecc0012938fe88.png?token=bd5e3a479c509f3f68cc4cd807bd898e');
//        $img = base64_encode($img);
//        $bodys = array(
//            'image'=>$img
//        );
//        return response()->json(BaiDuService::getPicData($bodys, 1));
        $res = BaiDuService::getAccessToken();
        if(!isset($res['access_token'])){
            return response()->json(['code'=>201, 'msg'=>'授权失败', 'data'=>$res]);
        }else{
            $token = $res['access_token'];
            /*-----------------------------------车牌号---------------------------------*/
//            $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate?access_token=' . $token;// 车牌号
//            $img = file_get_contents('https://pics3.baidu.com/feed/8ad4b31c8701a18bb4d1d408b9ecc0012938fe88.png?token=bd5e3a479c509f3f68cc4cd807bd898e');
//            $img = base64_encode($img);
//            $bodys = array(
////                'url' => 'https://pics3.baidu.com/feed/8ad4b31c8701a18bb4d1d408b9ecc0012938fe88.png?token=bd5e3a479c509f3f68cc4cd807bd898e'
//                'image'=>$img
//            );
            /*-----------------------------------车牌号---------------------------------*/
            /*-----------------------------------营业执照---------------------------------*/
//            $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/business_license?access_token=' . $token;
//            $img = file_get_contents('https://gimg2.baidu.com/image_search/src=https%3A%2F%2Fwww.generalwatertech.com%2Fuploadfiles%2F2020%2F01%2F20200109175314541.jpg%3FMS5qcGc%3D&refer=http%3A%2F%2Fwww.generalwatertech.com&app=2002&size=f10000,10000&q=a80&n=0&g=0n&fmt=jpeg?sec=1691314201&t=dbbb9cd6090db5b8fd6e1f8bfd561c45');
//            $img = base64_encode($img);
//            $bodys = array(
//                'image' => $img
//            );
            /*-----------------------------------营业执照---------------------------------*/
            /*-----------------------------------身份证---------------------------------*/
//            $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/idcard?access_token=' . $token;
//            $img = file_get_contents('https://image2.sina.com.cn/dy/c/2004-03-29/U48P1T1D3073262F23DT20040329135445.jpg');
//            $img = base64_encode($img);
//            $bodys = array(
//                'id_card_side' => "front",
//                'image' => $img
//            );
            /*-----------------------------------身份证---------------------------------*/
            /*-----------------------------------通用文字识别---------------------------------*/
            $img = file_get_contents('https://xmtest.bluearp.com/202309204.jpg');
            $img = base64_encode($img);
            $bodys = array(
                'image'=>$img
            );
            $res = BaiDuService::getPicData($bodys, 4);
            if($res['code']==200) {
                $res = json_decode(json_encode($res['data']),true);
                $words = '';
                if (isset($res['words_result']) && !empty($res['words_result'])) {
                    foreach ($res['words_result'] as $k => $v) {
                        if (strpos($v['words'], 'AS') && (strpos($v['words'], '备件条码') || strpos($v['words'], '备件') || strpos($v['words'], '条码') || strpos($v['words'], '件条'))) {
                            $words = 'AS' . explode('AS', $v['words'])[1];
                            return response()->json(['code' => 200, 'msg' => '操作成功', 'data' => $words]);
                        } elseif (strpos($v['words'], 'AS') && (strpos($v['words'], '备') || strpos($v['words'], '件') || strpos($v['words'], '码') || strpos($v['words'], '条'))) {
                            $words = $words = 'AS' . explode('AS', $v['words'])[1];
                        }
                    }
                }
                if ($words != '') {
                    return response()->json(['code' => 200, 'msg' => '操作成功', 'data' => $words]);
                } else {
                    return response()->json(['code' => 202, 'msg' => '操作失败', 'data' => $words]);
                }
            }else{
                return $res;
            }
            /*-----------------------------------通用文字识别---------------------------------*/
            $res = CommonService::requestPost($url, $bodys,['Content-Type'=>'application/x-www-form-urlencoded']);
            return response()->json(['code'=>200, 'msg'=>'操作成功', 'data'=>json_decode($res)]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 入口
     * @param string method 接口方法
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/5/28 14:28
     * |---------------------------------------------------------------------------------
    */
    public function dataApi ( Request $request ){
        $input = $request->all();
        if(empty($input['method'])){
            return $this->error('缺少必要参数1',ErrorInc::FAILED_PARAM);
        }
        $api=['sysVipDetail','sysMyVipDetail','sysMemberInitial','sysWarehouseGoodsNumber','sysChildGood','sysVipcaRecordDatail','sysWashPerformanceWork'];
        if(!in_array($input['method'],$api)){
            return $this->error('缺少必要参数2',ErrorInc::INVALID_PARAM,$input);
        }else {
            $api = (string)$input['method'];
            return $this->$api($input);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 同步会员卡列表信息到详情
     * @param string vica_id 会员卡数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/5/21 16:47
     * |---------------------------------------------------------------------------------
    */
    public function sysVipDetail ( $search_data ){
        if(isset($search_data['vica_id'])) {
            $vipcar = DB::table('vip_card')
                ->where('vica_id','>',$search_data['vica_id'])
                ->first();
            if($vipcar){
                $vipcar = CommonService::dataToArray($vipcar);
                $vipdetai = DB::table('vip_card_detail')
                    ->where('vicad_vcid',$vipcar['vica_id'])
                    ->value('vicad_id');
                if($vipdetai){
                    return response()->json(['code'=>200, 'msg'=>'操作成功1', 'data'=>$vipcar['vica_id']]);
                }else{
                    $detail['vicad_vcid'] = $vipcar['vica_id'];
                    $detail['vicad_data_id'] = $vipcar['vica_sepr_id'];
                    $detail['vicad_data_name'] = $vipcar['vica_sepr_name'];
                    $detail['vicad_num'] = $vipcar['vica_num'];//vica_price
                    $detail['vicad_goo_price'] = $vipcar['vica_price'];
                    $detail['vicad_type'] = 2;
                    $res = DB::table('vip_card_detail')->insert($detail);
                    if($res){
                        return response()->json(['code'=>200, 'msg'=>'操作成功2', 'data'=>$vipcar['vica_id']]);
                    }else{
                        return response()->json(['code'=>500, 'msg'=>'操作失败', 'data'=>[]]);
                    }
                }
            }else{
                return response()->json(['code'=>300, 'msg'=>'更新完毕', 'data'=>[]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'缺少参数', 'data'=>[]]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 同步我的会员卡列表信息到详情
     * @param string myvi_id 我的会员卡数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/5/21 16:47
     * |---------------------------------------------------------------------------------
     */
    public function sysMyVipDetail ( $search_data ){
        if(isset($search_data['myvi_id'])) {
            $vipcar = DB::table('myvip')
                ->where('myvi_id','>',$search_data['myvi_id'])
                ->first();
            if($vipcar){
                $vipcar = CommonService::dataToArray($vipcar);
                $vipdetai = DB::table('myvip_detail')
                    ->where('myvid_mvid',$vipcar['myvi_id'])
                    ->value('myvid_id');
                if($vipdetai){
                    return response()->json(['code'=>200, 'msg'=>'操作成功1', 'data'=>$vipcar['myvi_id']]);
                }else{
                    $detail['myvid_mvid'] = $vipcar['myvi_id'];
                    $detail['myvid_surplus_times'] = $vipcar['myvi_surplus_times'];
                    $detail['myvid_all_times'] = $vipcar['myvi_all_times'];
                    $detail['myvid_data_id'] = $vipcar['myvi_sepr_id'];
                    $detail['myvid_data_name'] = $vipcar['myvi_sepr_name'];
                    $detail['myvid_goo_price'] = DB::table('vip_card')->where('vica_id','=',$vipcar['myvi_vica_id'])->value('vica_price');
                    $detail['myvid_type'] = 2;
                    $res = DB::table('myvip_detail')->insert($detail);
                    if($res){
                        return response()->json(['code'=>200, 'msg'=>'操作成功2', 'data'=>$vipcar['myvi_id']]);
                    }else{
                        return response()->json(['code'=>500, 'msg'=>'操作失败', 'data'=>[]]);
                    }
                }
            }else{
                return response()->json(['code'=>300, 'msg'=>'更新完毕', 'data'=>[]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'缺少参数', 'data'=>[]]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 同步会员首字母
     * @param int mem_id 会员数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/6/5 16:51
     * |---------------------------------------------------------------------------------
    */
    public function sysMemberInitial ( $search_data ){
        if(isset($search_data['mem_id'])) {
            $member = DB::table('member')
                ->where('mem_id','>',$search_data['mem_id'])
                ->first();
            if($member){
                $member = CommonService::dataToArray($member);
                $rest = mb_substr($member['mem_name'], 0, 1, 'utf-8');
                if ($rest) {
                    $mb = mb_strlen($rest, 'utf-8');
                    $st = strlen($rest);
                    if ($st == $mb) { //英文
                        $data['mem_initial'] = strtoupper($rest);
                    } else { //汉字
                        $data['mem_initial'] = substr(strtoupper(Pinyin::abbr($member['mem_name'])), 0, 1);
                    }
                } else {
                    $data['mem_initial'] = '';
                }
                $data['mem_update_time'] = date("Y-m-d H:i:s");
                $res = DB::table('member')->where('mem_id',$member['mem_id'])->update($data);
                if($res){
                    return response()->json(['code'=>200, 'msg'=>'操作成功2', 'data'=>$member['mem_id']]);
                }else{
                    return response()->json(['code'=>500, 'msg'=>'操作失败', 'data'=>[]]);
                }
            }else{
                return response()->json(['code'=>300, 'msg'=>'更新完毕', 'data'=>[]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'缺少参数', 'data'=>[]]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 同步库存卷转化回米
     * @param string goo_id 商品数据id
     * @retrun \Illuminate\Http\JsonResponse  sysWarehouseGoodsNumber
     * @author dou 2024/6/20 11:53
     * |---------------------------------------------------------------------------------
    */
    public function sysChildGood ( $search_data ){
        if(isset($search_data['goo_id'])) {
            $goods = DB::table('goods')
                ->where('goo_id','>',$search_data['goo_id'])
                ->where('goo_unta_id',1)
                ->where('goo_fid',0)
                ->first();
            if($goods){
                $goods = CommonService::dataToArray($goods);
                $child_goods = DB::table('goods')
                    ->where('goo_fid',$goods['goo_id'])
                    ->where('goo_level',2)
                    ->first();
                if($child_goods){
                    return response()->json(['code'=>200, 'msg'=>'操作成功2', 'data'=>$goods['goo_id']]);
                }else{
                    $id = $goods['goo_id'];
                    unset($goods['goo_id']);
                    if($goods['goo_unit_conversion']!=0) {
                        $goods['goo_price'] = ceil($goods['goo_price']/$goods['goo_unit_conversion']);
                        $goods['goo_wholesale_price'] = ceil($goods['goo_wholesale_price']/$goods['goo_unit_conversion']);
                        $goods['goo_purchase_price'] = ceil($goods['goo_purchase_price']/$goods['goo_unit_conversion']);
                        $goods['goo_recycle_price'] = ceil($goods['goo_recycle_price']/$goods['goo_unit_conversion']);
                        $goods['goo_assign_price'] = ceil($goods['goo_assign_price']/$goods['goo_unit_conversion']);
                        $goods['goo_direct_accounting_price'] = ceil($goods['goo_direct_accounting_price']/$goods['goo_unit_conversion']);
                    }
                    $goods['goo_unit_conversion'] = 0;
                    $goods['goo_level'] = 2;
                    $goods['goo_unta_id'] = 4;
                    $goods['goo_unit'] = '米';
                    $goods['goo_fid'] = $id;
                    $res = DB::table('goods')->insert($goods);
                    if($res){
                        return response()->json(['code'=>200, 'msg'=>'操作成功1', 'data'=>$id]);
                    }else{
                        return response()->json(['code'=>500, 'msg'=>'操作失败', 'data'=>[]]);
                    }
                }
            }else{
                return response()->json(['code'=>300, 'msg'=>'更新完毕', 'data'=>[]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'缺少参数', 'data'=>[]]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 同步会员卡使用详情表
     * @param string vcre_id 会员卡消费记录id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/7/9 14:46
     * |---------------------------------------------------------------------------------
    */
    public function sysVipcaRecordDatail ( $search_data ){
        if(isset($search_data['vcre_id'])) {
            $vip_card_record = DB::table('vip_card_record')
                ->where('vcre_id','>',$search_data['vcre_id'])
                ->where('vcre_id','<',6149)
                ->first();
            if($vip_card_record){
                $vip_card_record = CommonService::dataToArray($vip_card_record);
                $myvip = DB::table('myvip')
                    ->where('myvi_id',$vip_card_record['vcre_myvi_id'])
                    ->first();//获取我的会员卡记录
                if($myvip){
                    $myvip = CommonService::dataToArray($myvip);
                    $myvip_detail = DB::table('myvip_detail')
                        ->where('myvid_mvid',$myvip['myvi_id'])
                        ->first();//获取我的会员卡详情
                    if($myvip_detail){
                        $myvip_detail = CommonService::dataToArray($myvip_detail);
                        $vipca_record_datail = DB::table('vipca_record_datail')
                            ->where('vcrd_vcre_id',$vip_card_record['vcre_id'])
                            ->first();//获取我的会员卡记录
                        if($vipca_record_datail){
                            return response()->json(['code'=>200, 'msg'=>'操作成功2', 'data'=>$vip_card_record['vcre_id']]);
                        }else{
                            $vcrd['vcrd_vcre_id'] = $vip_card_record['vcre_id'];
                            $vcrd['vcrd_myvid_id'] = $myvip_detail['myvid_id'];
                            $vcrd['vcrd_num'] = trim(trim(explode('（', $vip_card_record['vcre_num_change'])[0],'-'),'+');
                            $vcrd['vcrd_description'] = str_ireplace('次）','',str_ireplace('（剩余：','/余',$vip_card_record['vcre_num_change']));
                            $vcrd['vcrd_create_time'] = $vip_card_record['vcre_create_time'] ;
                            $res = DB::table('vipca_record_datail')->insert($vcrd);
                            if($res){
                                return response()->json(['code'=>200, 'msg'=>'操作成功1', 'data'=>$vip_card_record['vcre_id'],'adddata'=>$vcrd]);
                            }else{
                                return response()->json(['code'=>500, 'msg'=>'操作失败', 'data'=>[]]);
                            }
                        }
                    }else{
                        return response()->json(['code'=>500, 'msg'=>'myvip_detail数据异常', 'data'=>[]]);
                    }
                }else{
                    return response()->json(['code'=>200, 'msg'=>'操作成功3', 'data'=>$vip_card_record['vcre_id']]);
//                    return response()->json(['code'=>500, 'msg'=>'myvip数据异常', 'data'=>[]]);
                }
            }else{
                return response()->json(['code'=>300, 'msg'=>'更新完毕', 'data'=>[]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'缺少参数', 'data'=>[]]);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 处理添加重复绩效数据
     * @retrun /multitype:array
     * @author dou 2024/11/29 14:03
     * |---------------------------------------------------------------------------------
    */
    public function sysWashPerformanceWork ( $search_data ){
        $list = DB::table('linshi')->where('F',1)->first();
        $list = CommonService::dataToArray($list);
        if($list){
            $data = DB::table('wash_performance_work')
                ->where('pewo_wor_number',$list['B'])
                ->where('pewo_service_adm_id',$list['C'])
                ->where('pewo_shop_id',$list['E'])
                ->orderBy('pewo_create_time','desc')
                ->first();
            $data = CommonService::dataToArray($data);
            if($data){
                CommonService::startmysql();
                $res = DB::table('wash_performance_work')
                    ->where('pewo_wor_number',$list['B'])
                    ->where('pewo_service_adm_id',$list['C'])
                    ->where('pewo_shop_id',$list['E'])
                    ->where('pewo_id','!=',$data['pewo_id'])
                    ->orderBy('pewo_create_time','desc')
                    ->delete();
                $sql = CommonService::showmysql();
                if($res){
                    DB::table('linshi')->where('id',$list['id'])->update(['F'=>2,'G'=>$sql]);
                }else{
                    DB::table('linshi')->where('id',$list['id'])->update(['F'=>3,'G'=>$sql]);
                }
                return response()->json(['code'=>200, 'msg'=>'操作成功', 'data'=>['data'=>$data,'res'=>$res]]);
            }else{
                return response()->json(['code'=>300, 'msg'=>'操作成功', 'data'=>['data'=>$data]]);
            }
        }else{
            return response()->json(['code'=>500, 'msg'=>'无更多数据', 'data'=>[]]);
        }
    }
}
