<?php
/*
|--------------------------------------------------------------------------
| 技师相关公用接口控制器
|--------------------------------------------------------------------------
|
|  @Date: 2021/8/25
|  @Time: 23:33
|  @version 1.0
|  @copyright BlueCity
*/

namespace App\Http\Controllers\Common;

use App\Services\LoginUserService;
use App\Services\TechnicalTitleService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;

class TechnicalsController extends Controller
{
    //

    /**
     * @api {post} /api/Common/technical/{shopID}/title 门店全部职称
     * @apiGroup common_technical
     * @apiName 公共技师接口
     * @apiVersion 1.0.0
     *
     * @apiDescription 获取门店全部职称列表
     *
     * @apiParam {int} $shopID        门店ID
     * @apiParam {String} $keywords   职称关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function title($shopID, Request $request) {
        $keywords = $request->get('keywords');
        if (!empty($keywords)) {
            $data = TechnicalTitleService::searchTitle($keywords, $shopID);
        } else {
            $data = TechnicalTitleService::getAll([], $shopID,1);
        }

        return $this->success('获取成功', $data);
    }

    /**
     * @api {post} /api/Common/technical/{shopID}/level 门店全部级别
     * @apiGroup common_technical
     * @apiName 公共技师接口
     * @apiVersion 1.0.0
     *
     * @apiDescription 获取门店全部级别列表
     *
     * @apiParam {int} $shopID        门店ID
     * @apiParam {String} $keywords   级别关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function level($shopID, Request $request) {
        $keywords = $request->get('keywords');
        $titleID = $request->get('title_id');
        if (!empty($keywords)) {
            $data = TechnicalLevelService::searchLevel($keywords, $titleID, $shopID);
        } else {
            $data = TechnicalLevelService::getAll([], $shopID);
        }

        return $this->success('获取成功', $data);
    }

    /**
     * @api {post} /api/Common/technical/{shopID}/member 门店全部技师
     * @apiGroup common_technical
     * @apiName 公共技师接口
     * @apiVersion 1.0.0
     *
     * @apiDescription 获取门店全部技师列表
     *
     * @apiParam {int} $shopID        门店ID
     * @apiParam {String} $keywords   技师关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function member($shopID, Request $request) {

    }

}
