<?php
namespace App\Http\Controllers\Common;

use App\Http\Models\Api\Common;
use App\Models\BasicManagement\Admin;
use App\Models\Functions;
use App\Services\Business\ExcelInfoService;
use App\Services\CommonService;
use App\Services\FunctionsService;
use App\Services\MeritPayOptionsService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\Business\ExceloutService;
use DB;

//通用方法控制器
class CommonController extends Controller
{

    use \App\ExcelTemp\ExcelTemp;
    /**
     * @name 获取导出
     * @param $pri_id　栏目ID
     * @param $sqls
     * @param $session
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/26
     */
    public function getExcelOut($mp_id,$user_info, $pri_id, $sqls, $session, $limit = 500, $action = '', $con_name = ''){
        $exceout = new ExceloutService();
        if(!$sqls){
            return ["code"=>205, 'msg'=>'暂无数据或请检查SQL日志是否打开', 'data'=>'暂无数据或请检查SQL日志是否打开'];
        }
        $list = $exceout->getSqls($sqls)['list'];
        if($list){
            $sql = $exceout->getSqls($sqls)['sqls'];
            if($action == '' ||  $con_name =='') {
                $avtion = self::getActionByPid($pri_id);
                if ($action == '') {
                    $action = $avtion['action_value'];
                }
                if ($con_name == '') {
                    $con_name = $avtion['action_name'];
                }
            }
            $adm_role = DB::table("admin_shop_role")
                ->where('adm_id',$user_info->adm_id)
                ->where('shop_id',$user_info->adm_shop_id)
                ->value('role_id as adm_role');
            $field_data = $exceout->gainFields($user_info->adm_shop_id,$adm_role,$action);//门店id，角色id，action
            if (empty($field_data)) {
                return ["code"=>205, 'msg'=>'您暂时无导出权限', 'data'=>'您暂时无导出权限'];
            }
            if(empty($mp_id)){
                $mp_id = 0;
            }
            return $exceout->createPlan($list,$sql,$limit,$action,$con_name,$user_info->adm_id,$user_info->adm_name,$mp_id);
        }else{
            return ["code"=>205, 'msg'=>'暂无数据', 'data'=>'暂无数据','sqls'=>$sqls];
        }
    }
    /**
     * @name 获取导出
     * @param $pri_id　栏目ID
     * @param $sqls
     * @param $session
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/26
     */
    public function getActionByPid($pri_id){
        $data = DB::table('privileges')->where('pri_id',$pri_id)->select('pri_method_name as action_name','pri_controller','pri_operate_method')->first();
        if($data){
            $data = CommonService::dataToArray($data);
            $pri_controller = explode('\\',$data['pri_controller'])[1];
            $pri_controller .= $data['pri_operate_method'];
            $data['action_value'] = $pri_controller;
        }
        return $data;
    }
//判定手机信息是否存在
    public function searchPhoneData ( Request $request ){
        if(isset($request['phone'])) {
            $data = Admin::where('adm_phone', $request['phone'])->select('adm_phone as phone', 'adm_name as name')->first();
            if ($data) {
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
            } else {
                return response()->json(['code' => 200, 'msg' => '暂无数据', 'data' => '']);
            }
        }else{
            return response()->json(['code' => 500, 'msg' => '请入手机号', 'data' => '']);
        }
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 版本对比
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/3/27 14:25
     * |---------------------------------------------------------------------------------
    */
    public function versionCompare ( Request $request ){
        $title = [
            ['name'=>'基础版','detail'=>'订单管理、会员管理、账单管理、会员卡管理、销售统计、员工管理。赠送3G空间+200条短信','img'=>'./images/product_edition_5_icon_01.png','price'=>'3000.00'],
            ['name'=>'企业版','detail'=>'包含完整的基础版、库存管理、会员充值、工单管理、排班计划、绩效统计。赠送5G空间+300条短信（注：包含上一版本赠送的空间和短信）','img'=>'./images/product_edition_5_icon_02.png','price'=>'5800.00'],
            ['name'=>'连锁版','detail'=>'包含完整的企业版、分店管理、积分营销、会员等级、客户关怀、分享店铺。赠送10G空间+500条短信（注：包含上一版本赠送的空间和短信）','img'=>'./images/product_edition_5_icon_03.png','price'=>'10800.00'],
            ['name'=>'连锁分店','detail'=>'连锁版本附属店铺，需要在连锁版基础上开通使用。每个分店赠送5G空间+300条短信','img'=>'./images/product_edition_5_icon_04.png','price'=>'2000.00'],
            ['name'=>'定制版','detail'=>'满足您所有需要的定制化要求<br>我们的产品不仅仅是一个简单的工具,更是您实现梦想的伙伴','img'=>'./images/product_edition_5_icon_05.png','price'=>'']
        ];

        $type = [['type'=>1,'value'=>'半径服务（客户端）'],['type'=>2,'value'=>'半径美装（技师端）'],['type'=>3,'value'=>'管理后台'],['type'=>4,'value'=>'专属功能']];
        $info = DB::table("versions_compare")
            ->where('vc_state',1)
            ->get();
        if($info){
            $info = CommonService::dataToArray($info);
            $info = CommonService::jointArrayKey($info, 'vc_type',2);
            $data['toplist'] = $title;
            $data['leftlist'] = $type;
            $data['info'] = self::joinVersionInfo($info,$type);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
        }else{
            return response()->json(['code' => 201, 'msg' => 'error', 'data' => []]);
        }
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/3/27 15:47
     * |---------------------------------------------------------------------------------
    */
    public function joinVersionInfo ( $info , $type ){
        $versionInfo = [];
        foreach($type as $k => $v){
            $versionInfo[$k]['name'] = $v['value'];
            $value = [];
            $infos = $info[$v['type']];
            foreach($infos as $ks => $vs){
                $value[$ks]['name'] = $vs['vc_function'];
                $value[$ks]['v1'] = $vs['vc_one'];
                $value[$ks]['v2'] = $vs['vc_two'];
                $value[$ks]['v3'] = $vs['vc_three'];
                $value[$ks]['v4'] = $vs['vc_four'];
                $value[$ks]['v5'] = $vs['vc_five'];
            }
            $versionInfo[$k]['value'] = $value;
        }
        return $versionInfo;
    }

    /**|---------------------------------------------------------------------------------
     * @name 个人导出权限
     * @param string type 请求类型 1获取列表 2获取详情 3添加 4编辑
     * @param string amp_id 数据id
     * @param string amp_action 对应控制器
     * @param string amp_acname 控制器名称
     * @param string amp_data 字段
     * @param string amp_type 模板说明
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2025/3/5 9:21
     * |---------------------------------------------------------------------------------
    */
    public function excelPerson ( Request $request ){
        $input = $request->all();
        if(!$request->filled('type') || !in_array($input['type'], [1,2,3,4,5])){
            return $this->error('请求类型错误',ErrorInc::INVALID_PARAM);
        }else{
            $user_info = Common::getUserInfo($request['api_token']);
            $return = ExcelInfoService::excelPerson($input,$user_info,$request->ip());
            return $this->error($return['msg'],$return['code'],$return['data']);
        }
    }
}
