<?php
namespace App\Http\Controllers\Api\recycleManage;

use Illuminate\Http\Request;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\recycleManage\VerifyRecyclingController;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Models\Api\AccountingSettlement;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\WarehouseManage\Stocktake;
use App\Http\Models\Services\PublicSearch;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Http\Models\Services\WarehouseManage\JunkRecycling;
use Pinyin;

// 仓储系统 -- 旧货回收
class RecyclingController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        $list_data = DB::table('junk_recycle as r')
            ->leftJoin('junk_client as c', 'r.jur_id', '=', 'c.jucl_jur_id')
            ->where('jur_cid', $user_info->adm_cid)
            ->where('jur_superior_shop_id', $shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_state'])) { //回收状态 1.未回收 2.已回收 3不回收
                    $query->where('r.jur_state', $search_data['jur_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //日期
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('jur_date', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('jur_date', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('jur_date', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_number'])) { //回收单号
                    $query->where('r.jur_number', 'like', '%' . $search_data['jur_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_ord_order_number'])) { //订单编号
                    $query->where('r.jur_ord_order_number', 'like', '%' . $search_data['jur_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jucl_channel_unit'])) { //客户单位
                    $query->where('c.jucl_channel_unit', 'like', '%' . $search_data['jucl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_ware_id'])) { //仓库名称
                    $query->where('jur_ware_id', $search_data['jur_ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_source'])) { //旧货来源
                    $query->where('r.jur_source', $search_data['jur_source']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_service_adm_id'])) { //服务技师
                    $query->where('r.jur_service_adm_id', $search_data['jur_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_create_adm_id'])) { //记录人
                    $query->where('r.jur_create_adm_id', $search_data['jur_create_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jucl_client_id'])) { //客户单位id
                    $query->where('jucl_client_id', $search_data['jucl_client_id']);
                }
            })
            ->select('r.jur_id', 'r.jur_date', 'r.jur_number', 'r.jur_source', 'r.jur_price', 'r.jur_amount', 'r.jur_ware_id', 'c.jucl_channel_unit', 'r.jur_state', 'r.jur_service_adm_id', 'r.jur_create_adm_id', 'r.jur_remark', 'r.jur_is_mobile', 'r.jur_ord_order_number', 'jur_is_print', 'jur_ord_id', 'jur_type', 'jucl_name', 'jur_add_type', 'jucl_client_id')
            ->orderBy('r.jur_id', 'desc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $jur_service_adm_id = array_column($list_items, 'jur_service_adm_id'); //服务技师id
            $jur_create_adm_id = array_column($list_items, 'jur_create_adm_id'); //创建人id
            $adm_id = array_unique(array_merge($jur_service_adm_id, $jur_create_adm_id));
            $jur_ware_id = array_unique(array_column($list_items, 'jur_ware_id')); //仓库id

            // 查找账号id对应的账号姓名
            $admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            // 查找仓库id对应的仓库名称
            $ware = DB::table('warehouse')
                ->whereIn('ware_id', $jur_ware_id)
                ->pluck('ware_name', 'ware_id')->toArray();

            foreach ($list_items as $key => $value) {
                $list_items[$key]->jur_service_adm_name = isset($admin[$value->jur_service_adm_id]) ? $admin[$value->jur_service_adm_id] : '';
                $list_items[$key]->jur_create_adm_name = isset($admin[$value->jur_create_adm_id]) ? $admin[$value->jur_create_adm_id] : '';
                // 仓库名称
                $list_items[$key]->jur_ware_name = isset($ware[$value->jur_ware_id]) ? $ware[$value->jur_ware_id] : '';
                unset($list_items[$key]->jucl_client_id);
                unset($list_items[$key]->jur_create_adm_id);
                unset($list_items[$key]->jur_service_adm_id);
                unset($list_items[$key]->jur_service_adm_id);
            }
        }
        // 查询门店打印模板
        $shpt_data = DB::table('shop_print_template')
            ->where('shpt_shop_id', $user_info->adm_shop_id)
            ->whereIn('shpt_print_type', [2, 3])
            ->where('shpt_delete', 1)
            ->select('shpt_id', 'shpt_print_type', 'shpt_isdefault')
            ->get()->toArray();
        if (empty($shpt_data)) {
            $shpt_data = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $this->show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['shpt_data'] = $shpt_data;                    //模板id

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data, 'list_button'=>$list_button]);
    }

    // 新增【暂时用不到】
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 验证数据
        $jur_amount = 0;
        foreach ($request['goo_id'] as $key => $value) {
            if (!is_numeric($value) || $value < 0 || empty($request['goo_name'][$key]) || !is_numeric($request['goo_amount'][$key]) || $request['goo_amount'][$key] < 0 || !is_numeric($request['goo_ampere_hour'][$key]) || $request['goo_ampere_hour'][$key] < 0) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误']);
            }
            $jugo_data[$key]['jugo_goo_id'] = $value;
            // 根据商品id查询商品名称
            $goo_name = DB::table('goods')
                ->where('goo_id', $value)
                ->value('goo_name');
            $jugo_data[$key]['jugo_goo_name'] = $goo_name;
            $jugo_data[$key]['jugo_goo_goods_encode'] = isset($request['goo_goods_encode'][$key]) ? $request['goo_goods_encode'][$key] : '';
            $jugo_data[$key]['jugo_recycle_number'] = 0;
            $jugo_data[$key]['jugo_goo_ampere_hour'] = $request['goo_ampere_hour'][$key];
            $jugo_data[$key]['jugo_sell_number'] = $request['goo_amount'][$key];
            $jur_amount += $request['goo_amount'][$key];
        }
        // 回收单表
        $jur_number = 'JH' . rand(100, 999) . date('mdHis') . rand(100000, 999999); // 回收单号
        $add_recycle['jur_cid'] = $user_info->adm_cid; //公司id
        $add_recycle['jur_shop_id'] = $user_info->adm_shop_id; //门店id
        $add_recycle['jur_superior_shop_id'] = $shop_id; //所属总店id
        $add_recycle['jur_number'] = $jur_number; //回收单号
        $add_recycle['jur_source'] = 1; //旧货来源1.旧货收购
        $add_recycle['jur_amount'] = $jur_amount; //回收总数量
        $add_recycle['jur_ware_id'] = $request['jur_ware_id']; //仓库id
        $add_recycle['jur_waon_class'] = $request['jur_waon_class']; //1货物仓2非货物仓3旧货仓4临时仓
        $add_recycle['jur_create_adm_id'] = $user_info->adm_id; //创建人id
        $add_recycle['jur_remark'] = $request['jur_remark'] ? $request['jur_remark'] : ''; //备注
        $add_recycle['jur_state'] = 1; //回收状态 1.未回收 2.已回收
        $add_recycle['jur_type'] = $request['jur_type']; //买家类型 1.门店零售 2.来往单位 3加盟店
        $add_recycle['jur_is_mobile'] = 2; //1.移动端添加 2.pc端添加
        $add_recycle['jur_date'] = date('Y-m-d'); //回收日期
        $add_recycle['jur_add_type'] = 1;
        if (!empty($request['jur_ord_id'])) {
            $add_recycle['jur_ord_id'] = $request['jur_ord_id']; //订单id
            // 根据订单id查询订单类型
            $find_ord_service_type = DB::table('order')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_id', $request['jur_ord_id'])
                ->value('ord_service_type');
            $add_recycle['jur_ord_order_number'] = $request['jur_ord_order_number']; //订单单号
            if (empty($request['jur_wor_id']) && $find_ord_service_type != 5 && $find_ord_service_type != 4) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入工单单号']);
            }
            if ($find_ord_service_type != 4 && $find_ord_service_type != 5) {
                $add_recycle['jur_wor_id'] = $request['jur_wor_id']; //工单id
                $add_recycle['jur_wor_number'] = $request['jur_wor_number']; //工单单号
                // 判断该工单是否审核
                $find_wor_state = DB::table('work_order')
                    ->where('wor_cid', $user_info->adm_cid)
                    ->where('wor_superior_shop_id', $shop_id)
                    ->where('wor_id', $request['jur_wor_id'])
                    ->value('wor_state');
                if ($find_wor_state != 8) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前工单不是完成待审核状态,无法提交']);
                }
            } elseif ($find_ord_service_type == 5) { //订单类型为5发货单
                // 判断有没有发货
                $find_dego_type = DB::table('dispatch_bill')
                    ->where('dego_cid', $user_info->adm_cid)
                    ->where('dego_superior_shop_id', $shop_id)
                    ->where('dego_wor_id', $request['jur_ord_id'])
                    ->where('dego_type', 2)
                    ->value('dego_id');
                if ($find_dego_type) { //类型：1未出库2已出库3作废4锁定
                    // 判断该订单是否结算
                    $find_ord_state = DB::table('order')
                        ->where('ord_cid', $user_info->adm_cid)
                        ->where('ord_superior_shop_id', $shop_id)
                        ->where('ord_id', $request['jur_ord_id'])
                        ->value('ord_state');
                    if ($find_ord_state != 1) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单不是未结算状态,无法提交']);
                    }
                } else {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单尚未发货,无法提交']);
                }
            } elseif ($find_ord_service_type == 4) {
                // 判断是否回收
                $find_rec_state = DB::table('recede_recycle')
                    ->where('rec_cid', $user_info->adm_cid)
                    ->where('rec_shop_id', $shop_id)
                    ->where('rec_ord_id', $request['jur_ord_id'])
                    ->where('rec_state', 2)
                    ->value('rec_id');
                if ($find_rec_state) {
                    // 判断该订单是否结算
                    $find_ord_state = DB::table('order')
                        ->where('ord_cid', $user_info->adm_cid)
                        ->where('ord_superior_shop_id', $shop_id)
                        ->where('ord_id', $request['jur_ord_id'])
                        ->value('ord_state');
                    if ($find_ord_state != 1) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单不是未结算状态,无法提交']);
                    }
                } else {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前退货单尚未入库,无法提交']);
                }
            } else {
                $add_recycle['jur_wor_id'] = ''; //工单id
                $add_recycle['jur_wor_number'] = ''; //工单单号
            }
        }

        DB::beginTransaction();
        // 回收单表
        $recycle_id = DB::table('junk_recycle')->insertGetId($add_recycle);

        // 回收单商品表
        foreach ($jugo_data as $key => $value) {
            $jugo_data[$key]['jugo_jur_id'] = $recycle_id;
        }
        $add_goods =  DB::table('junk_goods')->insert($jugo_data);
        // 会员零售
        if ($request['jur_type'] == 1) {
            $list = DB::table('member')
                ->where('mem_id', $request['mem_id'])
                ->select('mem_name', 'mem_phone', 'mem_car_num')
                ->first();
            if (empty($list)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'信息错误']);
            }
            $jucl_data['jucl_car_num'] = $list->mem_car_num; //车牌号
        }
        // 客户单位
        if ($request['jur_type'] == 2) {
            $list =  DB::table('channel_unit')
                ->where('chun_id', $request['mem_id'])
                ->select('chun_name as mem_name', 'chun_phone as mem_phone', 'chun_unit_name')
                ->first();
            if (empty($list)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'信息错误']);
            }
            $jucl_data['jucl_channel_unit'] = $list->chun_unit_name; //渠道单位
        }
        // 加盟店
        if ($request['jur_type'] == 3) {
            $list =  DB::table('shop')
                ->where('shop_id', $request['mem_id'])
                ->select('shop_name as mem_name', 'shop_phone as mem_phone', 'shop_store_name')
                ->first();
            if (empty($list)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'信息错误']);
            }
            $jucl_data['jucl_channel_unit'] = $list->shop_store_name; //加盟店名称
        }
        // 回收单客户表
        $jucl_data['jucl_jur_id'] = $recycle_id; //回收单id
        $jucl_data['jucl_client_id'] = $request['mem_id']; //来往单位id/客户id
        $jucl_data['jucl_name'] = $list->mem_name; //客户姓名
        $jucl_data['jucl_phone'] = $list->mem_phone; //联系电话
        $add_client =  DB::table('junk_client')->insert($jucl_data);
        if ($recycle_id && $add_goods && $add_client) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '旧货回收', '新增', '新增旧货回收单：' . $jur_number . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'新增旧货回收单：成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新增旧货回收单：失败']);
        }
    }

    // 回收入库-旧货回收新增调用这个接口【暂时用不到】
    public function affirm(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->affirmValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 获取回收单数据
        $find_junk = DB::table('junk_recycle as a')
            ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
            ->where('jur_id', $request['jur_id'])
            ->first(['adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_remark', 'jur_waon_class', 'jur_ware_id']);
        if ($request['type'] == 1) {
            if (empty($find_junk)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
            }
            // 查询出客户单位名称 客户姓名 联系电话
            $client = DB::table('junk_client')
                ->where('jucl_jur_id', $request['jur_id'])
                ->first(['jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jucl_client_id']);
            // $find_junk->jucl_channel_unit = $client->jucl_channel_unit;
            // 查询客户单位名称
            $find_junk->jucl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $client->jucl_client_id)
                ->value('chun_unit_name');
            unset($find_junk->jucl_client_id);
            $find_junk->jucl_name = $client->jucl_name;
            $find_junk->jucl_phone = $client->jucl_phone;
            // 查询出仓库名称
            $find_junk->ware_name = DB::table('warehouse')
                ->where('ware_id', $find_junk->jur_ware_id)
                ->value('ware_name');
            // 获取页面数据
            $find_goods = DB::table('junk_goods')
                ->where('jugo_jur_id', $request['jur_id'])
                ->get(['jugo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_ampere_hour', 'jugo_sell_number as goo_amount']);
            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        foreach ($request['jugo_id'] as $key => $value) {
            if (!is_numeric($value) || $value < 0 || !is_numeric($request['actual_goo_amount'][$key]) || $request['actual_goo_amount'][$key] < 0) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误']);
            }
        }
        DB::beginTransaction();
        // 3.1 订单商品表中减去删除的商品数量
        $update_sql = 'UPDATE `faster_junk_goods` SET ';
        $recycle_quantity = '';
        $jugo_id = '';
        $update_time = '';
        foreach ($request['jugo_id'] as $key => $value) {
            // 实际回收数量
            $recycle_quantity = $recycle_quantity . ' WHEN ' . $value;
            $recycle_quantity = $recycle_quantity . ' THEN ' . $request['actual_goo_amount'][$key];

            // 更新时间
            $update_time = $update_time . ' WHEN ' . $value;
            $update_time = $update_time . ' THEN "' . date('Y-m-d H:i:s') . '"';

            //要更改的商品id
            $jugo_id = $jugo_id . $value . ',';
        }
        $update_sql = $update_sql . ' `jugo_recycle_number`=  CASE `jugo_id` ' . $recycle_quantity . ' END,';

        $update_sql = $update_sql . ' `jugo_update_time`=  CASE `jugo_id` ' . $update_time . ' END';
        $update_sql = $update_sql . ' WHERE `jugo_jur_id` = ' . $request['jur_id'] . ' AND `jugo_id` IN (' . trim($jugo_id, ',') . ')';

        $recycle_update = DB::update($update_sql);
        // 修改主表状态
        $juck['jur_update_time'] = date('Y-m-d H:i:s');
        $juck['jur_add_type'] = 2;
        $jur_res = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($juck);

        if ($recycle_update && $jur_res) {
            $jur_number = DB::table('junk_recycle')
                ->where('jur_id', $request['jur_id'])
                ->value('jur_number');
            Common::addLog($user_info, getRealIp($request), '旧货回收', '回收入库', '回收入库：' . $jur_number . '成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'回收入库成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'回收入库失败']);
        }
    }

    // 审核【暂时用不到】
    public function audit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->showAuditValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        if ($request['type'] == 1) {
            // 获取回收单数据
            $find_junk = DB::table('junk_recycle as a')
                ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
                ->where('jur_id', $request['jur_id'])
                ->select('adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_remark', 'jur_waon_class', 'jur_ware_id', 'jur_ord_id', 'jur_ord_order_number', 'jur_wor_id', 'jur_wor_number')
                ->first();
            if (empty($find_junk)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
            }

            // 查询出客户单位名称 客户姓名 联系电话
            $client = DB::table('junk_client')
                ->where('jucl_jur_id', $request['jur_id'])
                ->select('jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jucl_client_id')
                ->first();
            // $find_junk->jucl_channel_unit = $client->jucl_channel_unit;
            // 查询客户单位名称
            $find_junk->jucl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $client->jucl_client_id)
                ->value('chun_unit_name');
            unset($find_junk->jucl_client_id);
            $find_junk->jucl_name = $client->jucl_name;
            $find_junk->jucl_phone = $client->jucl_phone;
            // 查询出仓库名称
            $find_junk->ware_name = DB::table('warehouse')
                ->where('ware_id', $find_junk->jur_ware_id)
                ->value('ware_name');
            // 获取页面数据
            $find_goods = DB::table('junk_goods as jugo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
                ->where('jugo_jur_id', $request['jur_id'])
                ->select('jugo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_goo_id', 'jugo_goo_ampere_hour', 'goo_recycle_price')
                ->get();
            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->auditValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if (!empty($request['jur_ord_id'])) {
            $add_recycle['jur_ord_id'] = $request['jur_ord_id']; //订单id
            // 根据订单id查询订单类型
            $find_ord_service_type = DB::table('order')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_id', $request['jur_ord_id'])
                ->value('ord_service_type');
            $add_recycle['jur_ord_order_number'] = $request['jur_ord_order_number']; //订单单号
            if ($find_ord_service_type != 4 && $find_ord_service_type != 5) {
                $add_recycle['jur_wor_id'] = $request['jur_wor_id']; //工单id
                $add_recycle['jur_wor_number'] = $request['jur_wor_number']; //工单单号
                // 判断该工单是否审核
                $find_wor_state = DB::table('work_order')
                    ->where('wor_cid', $user_info->adm_cid)
                    ->where('wor_superior_shop_id', $shop_id)
                    ->where('wor_id', $request['jur_wor_id'])
                    ->value('wor_state');
                if ($find_wor_state != 8) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前工单不是完成待审核状态,无法提交']);
                }
            } elseif ($find_ord_service_type == 5) { //订单类型为5发货单
                // 判断有没有发货
                $find_dego_type = DB::table('dispatch_bill')
                    ->where('dego_cid', $user_info->adm_cid)
                    ->where('dego_superior_shop_id', $shop_id)
                    ->where('dego_wor_id', $request['jur_ord_id'])
                    ->where('dego_type', 2)
                    ->value('dego_id');
                if ($find_dego_type) { //类型：1未出库2已出库3作废4锁定
                    // 判断该订单是否结算
                    $find_ord_state = DB::table('order')
                        ->where('ord_cid', $user_info->adm_cid)
                        ->where('ord_superior_shop_id', $shop_id)
                        ->where('ord_id', $request['jur_ord_id'])
                        ->value('ord_state');
                    if ($find_ord_state != 1) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单不是未结算状态,无法提交']);
                    }
                } else {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单尚未发货,无法提交']);
                }
            } elseif ($find_ord_service_type == 4) { //订单类型为4退货单
                // 判断是否回收
                $find_rec_state = DB::table('recede_recycle')
                    ->where('rec_cid', $user_info->adm_cid)
                    ->where('rec_shop_id', $shop_id)
                    ->where('rec_ord_id', $request['jur_ord_id'])
                    ->where('rec_state', 2)
                    ->value('rec_id');
                if ($find_rec_state) {
                    // 判断该订单是否结算
                    $find_ord_state = DB::table('order')
                        ->where('ord_cid', $user_info->adm_cid)
                        ->where('ord_superior_shop_id', $shop_id)
                        ->where('ord_id', $request['jur_ord_id'])
                        ->value('ord_state');
                    if ($find_ord_state != 1) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单不是未结算状态,无法提交']);
                    }
                } else {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前退货单尚未入库,无法提交']);
                }
            } else {
                $add_recycle['jur_wor_id'] = ''; //工单id
                $add_recycle['jur_wor_number'] = ''; //工单单号
            }
        }

        DB::beginTransaction();

        // 3.1 订单商品表中减去删除的商品数量1
        $update_sql = 'UPDATE `faster_junk_goods` SET ';
        $jugo_remark = '';
        $jugo_id = '';
        $update_time = '';
        foreach ($request['jugo_id'] as $key => $value) {
            if (!empty($request['jugo_remark'][$key])) {
                // 实际回收数量
                $jugo_remark = $jugo_remark . ' WHEN ' . $value;
                $jugo_remark = $jugo_remark . ' THEN "' . $request['jugo_remark'][$key] . '"';
                // 更新时间
                $update_time = $update_time . ' WHEN ' . $value;
                $update_time = $update_time . ' THEN "' . date('Y-m-d H:i:s') . '"';

                //要更改的商品id
                $jugo_id = $jugo_id . $value . ',';
            } else {
                $recycle_update = true;
            }
        }
        if (!empty($jugo_remark)) {
            $update_sql = $update_sql . ' `jugo_remark`=  CASE `jugo_id` ' . $jugo_remark . ' END,';
            $update_sql = $update_sql . ' `jugo_update_time`=  CASE `jugo_id` ' . $update_time . ' END';
            $update_sql = $update_sql . ' WHERE `jugo_jur_id` = ' . $request['jur_id'] . ' AND `jugo_id` IN (' . trim($jugo_id, ',') . ')';
            $recycle_update = DB::update($update_sql);
        } else {
            $recycle_update = true;
        }
        // 添加
        $goods_number_sum = 0; //回收商品总数量
        $recycle_all_price = 0; //回收商品总金额
        foreach ($request['jugo_goo_id'] as $key => $value) {
            if (!is_numeric($value) || $value < 0 || !is_numeric($request['goo_recycle_amount'][$key]) || $request['goo_recycle_amount'][$key] < 0 || !is_numeric($request['goo_recycle_price'][$key])) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误']);
            }
            // 记录仓库商品表 所有要做修改的商品id 及其对应的数量
            $goods_data[$value] = $request['goo_recycle_amount'][$key];
            // 记录总入库商品数量
            $goods_number_sum =  $goods_number_sum + $request['goo_recycle_amount'][$key];
            $recycle_all_price += $request['goo_recycle_price'][$key] * $request['goo_recycle_amount'][$key]; //回收商品总金额
            $oure_goods_data[$value]['goo_quantity'] = $request['goo_recycle_amount'][$key]; //出入库商品数量
            $oure_goods_data[$value]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
            $jugo_update_data['jugo_goo_price'] = $request['goo_recycle_price'][$key] * 100;
            $jugo_update_data['jugo_update_time'] = date('Y-m-d H:i:s');

            // 出入库记录需要
            $oure_goods_id[$value] = $value; //出入库商品id
            $oure_goods_quantity[$value] = $request['goo_recycle_amount'][$key]; //出入库商品数量
            $oure_goods_inventory[$value] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1

            // 工单商品表新增回收的商品
            $wor_goo['wogo_wor_id'] = $request['jur_wor_id'] ? $request['jur_wor_id'] : ''; //工单id
            $wor_goo['wogo_ware_id'] = $request['jur_ware_id']; //仓库id
            $wor_goo['wogo_waon_class'] = $request['jur_waon_class']; //仓库类别
            $wor_goo['wogo_goo_id'] = $value; //商品id
            $wor_goo['wogo_is_recycle'] = 2; //1.回收2.不回收
            $wor_goo['wogo_goo_name'] = $request['goo_name'][$key]; //商品名称
            $wor_goo['wogo_goo_goods_encode'] = isset($request['goo_goods_encode'][$key]) ? $request['goo_goods_encode'][$key] : ''; //商品编号
            $wor_goo['wogo_goo_price'] = $request['goo_recycle_price'][$key] * 100; //商品售价
            $wor_goo['wogo_goo_type'] = 4; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $wor_goo['wogo_state'] = 3; //商品状态1.正常 2.删除3回收的商品
            $wor_goo['wogo_goo_amount'] = $request['goo_recycle_amount'][$key]; //可派单商品数量，商品数量
            $wor_goo['wogo_goo_inventory'] = 1; //库存扣除方式1.良品 2.优先
            $wor_goo['wogo_recycle_quantity'] = $request['goo_recycle_amount'][$key]; //回收数量
            $wor_goo['wogo_actual_recycle_number'] = $request['goo_recycle_amount'][$key]; //实际回收数量
            $wor_goo['wogo_remark'] = isset($request['goo_remark'][$key]) ? $request['goo_remark'][$key] : ''; //备注
            $wor_goo['wogo_update_time'] = date('Y-m-d H:i:s');

            // 订单商品表新增回收的商品
            $ord_goo['orgo_ord_id'] = $request['jur_ord_id']; //订单id
            $ord_goo['orgo_order_number'] = $request['jur_ord_order_number']; //订单号
            $ord_goo['orgo_ware_id'] = $request['jur_ware_id']; //仓库id
            $ord_goo['orgo_waon_class'] = $request['jur_waon_class']; //仓库类别
            $ord_goo['orgo_goo_id'] = $value; //商品id
            $ord_goo['orgo_goo_name'] = $request['goo_name'][$key]; //商品名称
            $ord_goo['orgo_goo_goods_encode'] = isset($request['goo_goods_encode'][$key]) ? $request['goo_goods_encode'][$key] : ''; //商品编号
            $ord_goo['orgo_goo_ampere_hour'] = $request['goo_ampere_hour'][$key]; //商品安时数
            $ord_goo['orgo_goo_type'] = 4; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $ord_goo['orgo_goo_price'] = $request['goo_recycle_price'][$key] * 100; //商品售价（单位：分）
            $ord_goo['orgo_collection_price'] =  0; //代收金额（单位：分）
            $ord_goo['orgo_goo_quantity'] = $request['goo_recycle_amount'][$key]; //订单商品数量
            $ord_goo['orgo_goo_inventory'] = 1; //库存扣除方式1.良品 2.优先
            $ord_goo['orgo_state'] = 3; //商品状态1.正常 2.删除3回收的商品
            $ord_goo['orgo_is_recycle'] = 2; //回收状态：1回收2不回收
            $ord_goo['orgo_recycle_quantity'] = $request['goo_recycle_amount'][$key]; //商品回收数量
            $ord_goo['orgo_can_assign_quantity'] = 0; //剩余可以派工单的商品数量
            $ord_goo['orgo_update_time'] = date('Y-m-d H:i:s');

            // 判断订单是否为空
            if (!empty($request['jur_ord_id'])) {
                // 工单商品表添加数据
                $wogo_res = DB::table('work_good')->insertGetId($wor_goo);
                $jugo_update_data['jugo_wogo_id'] = $wogo_res;
                // 订单商品表添加数据
                $orgo_res = DB::table('order_goods')->insertGetId($ord_goo);
                $jugo_update_data['jugo_orgo_id'] = $orgo_res;
            } else {
                $orgo_res = true;
                $wogo_res = true;
            }
            $jugo_res = DB::table('junk_goods')
                ->where('jugo_jur_id', $request['jur_id'])
                ->where('jugo_goo_id', $value)
                ->update($jugo_update_data);
            if (!$jugo_res || !$orgo_res || !$wogo_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核：失败']);
            }
        }

        // 修改主表状态
        $juck['jur_update_time'] = date('Y-m-d H:i:s');
        $juck['jur_add_type'] = 3;
        $juck['jur_state'] = 2;
        $juck['jur_amount'] = $goods_number_sum; //总数量
        $juck['jur_price'] = $recycle_all_price * 100; //回收总金额(单位:分)
        if (!empty($request['jur_ord_id'])) {
            $juck['jur_ord_id'] = $request['jur_ord_id']; //订单id
            $juck['jur_ord_order_number'] = $request['jur_ord_order_number']; //订单号
            if (empty($request['jur_wor_id']) && $find_ord_service_type != 4 && $find_ord_service_type != 5) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入工单单号']);
            } else {
                $juck['jur_wor_id'] = $request['jur_wor_id'] ? $request['jur_wor_id'] : ''; //工单id
                $juck['jur_wor_number'] = $request['jur_wor_number'] ? $request['jur_wor_number'] : ''; //工单单号
            }
        } else {
            $juck['jur_ord_id'] = ''; //订单id
            $juck['jur_ord_order_number'] = ''; //订单号
            $juck['jur_wor_id'] = ''; //工单id
            $juck['jur_wor_number'] = ''; //工单单号
        }
        // 判断订单是否为空
        if (!empty($request['jur_ord_id'])) {
            if ($find_ord_service_type != 4 && $find_ord_service_type != 5) {
                // 查询出订单的结算金额
                $find_ord_actual_price = DB::table('order')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_id', $request['jur_ord_id'])
                    ->select('ord_actual_price', 'ord_plus_minus')
                    ->first();
                if ($find_ord_actual_price->ord_plus_minus == '1') {
                    $actual_price = $find_ord_actual_price->ord_actual_price - $recycle_all_price * 100;
                } else {
                    $actual_price = $find_ord_actual_price->ord_actual_price + $recycle_all_price * 100;
                }
                if ($actual_price < 0) {
                    $ord_data['ord_plus_minus'] = 2;
                } else {
                    $ord_data['ord_plus_minus'] = 1;
                }
                $ord_data['ord_actual_price'] = abs($actual_price);
                $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_res = DB::table('order')
                    ->where('ord_id', $request['jur_ord_id'])
                    ->update($ord_data);
                // 工单表修改数据
                // 查询出订单的结算金额
                $find_wor_actual_price = DB::table('work_order')
                    ->where('wor_cid', $user_info->adm_cid)
                    ->where('wor_superior_shop_id', $shop_id)
                    ->where('wor_id', $request['jur_wor_id'])
                    ->select('wor_actual_price', 'wor_plus_minus')
                    ->first();
                if ($find_wor_actual_price->wor_plus_minus == '1') {
                    $actual_price = $find_wor_actual_price->wor_actual_price - $recycle_all_price * 100;
                } else {
                    $actual_price = $find_wor_actual_price->wor_actual_price + $recycle_all_price * 100;
                }
                if ($actual_price < 0) {
                    $wor_data['wor_plus_minus'] = 2;
                } else {
                    $wor_data['wor_plus_minus'] = 1;
                }
                $wor_data['wor_recycle_price'] = abs($recycle_all_price) * 100; //回收金额(单位:分)
                $wor_data['wor_actual_price'] = abs($actual_price);
                $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
                $wor_res = DB::table('work_order')
                    ->where('wor_id', $request['jur_wor_id'])
                    ->update($wor_data);
                if (!$ord_res || !$wor_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核：失败2']);
                }
                if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
                    // 查询凭证单据是否同步U8
                    $find_vore_id = DB::table('voucher_receipts')
                        ->where('vore_cid', $user_info->adm_cid)
                        ->where('vore_superior_shop_id', $shop_id)
                        ->where('vore_shop_id', $user_info->adm_shop_id)
                        ->where('vore_order_type', 1)
                        ->where('vore_ord_id', $request['jur_ord_id'])
                        ->where('vore_ord_number', $request['jur_ord_order_number'])
                        ->select('vore_state', 'vore_id')
                        ->first();
                    if (!empty($find_vore_id)) {
                        if ($find_vore_id->vore_state == 1) {
                            $vore_data['vore_recycle_price'] = $recycle_all_price;
                            $vore_data['vore_update_time'] = date('Y-m-d H:i:s');
                            $vore_res = DB::table('voucher_receipts')
                                ->where('vore_cid', $user_info->adm_cid)
                                ->where('vore_superior_shop_id', $shop_id)
                                ->where('vore_shop_id', $user_info->adm_shop_id)
                                ->where('vore_order_type', 1)
                                ->where('vore_ord_id', $request['jur_ord_id'])
                                ->where('vore_ord_number', $request['jur_ord_order_number'])
                                ->update($vore_data);
                            $volo_data['volo_shop_id'] = $user_info->adm_shop_id;
                            $volo_data['volo_vore_id'] = $find_vore_id->vore_id;
                            $volo_data['volo_type'] = 1; //类型1借方2贷方
                            $volo_data['volo_borrow_subject'] = '140501'; //借方科目
                            $volo_data['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                            $volo_data['volo_borrow_price'] = $recycle_all_price; //借方金额
                            $volo_data['volo_loan_subject'] = ''; //贷方科目
                            $volo_data['volo_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data['volo_loan_price'] = $recycle_all_price; //贷方金额
                            $volo_data['volo_update_time'] = date('Y-m-d H:i:s');
                            $volo_res = DB::table('voucher_loan')->insert($volo_data);
                            // 根据凭证id,查询借方金额
                            $volo_borrow_price = DB::table('voucher_loan')
                                ->where('volo_shop_id', $user_info->adm_cid)
                                ->where('volo_vore_id', $find_vore_id->vore_id)
                                ->value('volo_borrow_price');
                            $loan_price = $volo_borrow_price - $recycle_all_price;
                            $volo_edit_res['volo_borrow_price'] = abs($loan_price);
                            $volo_edit_res['volo_update_time'] = date('Y-m-d H:i:s');
                            $volo_edit_res = DB::table('voucher_loan')
                                ->where('volo_shop_id', $user_info->adm_cid)
                                ->where('volo_vore_id', $find_vore_id->vore_id)
                                ->update($volo_edit_res);
                            if (!$vore_res || !$volo_res) {
                                DB::rollBack();
                                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败4']);
                            }
                        } else {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前凭证已同步U8']);
                        }
                    }
                }
            } elseif ($find_ord_service_type == 5 || $find_ord_service_type == 4) { //订单类型为发货单
                // 查询出订单的结算金额
                $find_ord_actual_price = DB::table('order')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_id', $request['jur_ord_id'])
                    ->select('ord_actual_price', 'ord_plus_minus')
                    ->first();
                if ($find_ord_actual_price->ord_plus_minus == '1') {
                    $actual_price = $find_ord_actual_price->ord_actual_price - $recycle_all_price * 100;
                    $recr_data['recr_plus_minus'] = 1;
                    $ord_data['ord_plus_minus'] = 1;
                } else {
                    $actual_price = $find_ord_actual_price->ord_actual_price + $recycle_all_price * 100;
                    $recr_data['recr_plus_minus'] = 2;
                    $ord_data['ord_plus_minus'] = 2;
                }
                $ord_data['ord_actual_price'] = abs($actual_price);
                $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
                // 调整订单结算金额
                $ord_res = DB::table('order')
                    ->where('ord_id', $request['jur_ord_id'])
                    ->update($ord_data);
                // 查询是否生成应收应付
                $recr_id = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_shop_id', $user_info->adm_shop_id)
                    ->where('recr_original_id', $request['jur_ord_id'])
                    ->where('recr_original_number', $request['jur_ord_order_number'])
                    ->whereIn('recr_account_type', [1, 10])
                    ->select('recr_id')
                    ->first();
                if (!empty($recr_id)) {
                    // 调整应收应付的金额
                    $recr_data['recr_settle_price'] = abs($actual_price);
                    $recr_data['recr_actual_price'] = abs($actual_price);
                    $recr_data['recr_update_time'] = date('Y-m-d H:i:s');
                    $recr_res = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_shop_id', $user_info->adm_shop_id)
                        ->where('recr_original_id', $request['jur_ord_id'])
                        ->where('recr_original_number', $request['jur_ord_order_number'])
                        ->whereIn('recr_account_type', [1, 10])
                        ->update($recr_data);
                } else {
                    $recr_res = true;
                }
                if (!$ord_res || !$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核：失败3']);
                }
                if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
                    // 查询凭证单据是否同步U8
                    $find_vore_id = DB::table('voucher_receipts')
                        ->where('vore_cid', $user_info->adm_cid)
                        ->where('vore_superior_shop_id', $shop_id)
                        ->where('vore_shop_id', $user_info->adm_shop_id)
                        ->where('vore_order_type', 1)
                        ->where('vore_ord_id', $request['jur_ord_id'])
                        ->where('vore_ord_number', $request['jur_ord_order_number'])
                        ->select('vore_state', 'vore_id')
                        ->first();
                    if (!empty($find_vore_id)) {
                        if ($find_vore_id->vore_state == 1) {
                            $vore_data['vore_recycle_price'] = $recycle_all_price;
                            $vore_data['vore_update_time'] = date('Y-m-d H:i:s');
                            $vore_res = DB::table('voucher_receipts')
                                ->where('vore_cid', $user_info->adm_cid)
                                ->where('vore_superior_shop_id', $shop_id)
                                ->where('vore_shop_id', $user_info->adm_shop_id)
                                ->where('vore_order_type', 1)
                                ->where('vore_ord_id', $request['jur_ord_id'])
                                ->where('vore_ord_number', $request['jur_ord_order_number'])
                                ->update($vore_data);
                            $volo_data['volo_shop_id'] = $user_info->adm_shop_id;
                            $volo_data['volo_vore_id'] = $find_vore_id->vore_id;
                            $volo_data['volo_type'] = 1; //类型1借方2贷方
                            $volo_data['volo_borrow_subject'] = '140501'; //借方科目
                            $volo_data['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                            $volo_data['volo_borrow_price'] = $recycle_all_price; //借方金额
                            $volo_data['volo_loan_subject'] = ''; //贷方科目
                            $volo_data['volo_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data['volo_loan_price'] = $recycle_all_price; //贷方金额
                            $volo_data['volo_update_time'] = date('Y-m-d H:i:s');
                            $volo_res = DB::table('voucher_loan')->insert($volo_data);
                            // 根据凭证id,查询借方金额
                            $volo_borrow_price = DB::table('voucher_loan')
                                ->where('volo_shop_id', $user_info->adm_cid)
                                ->where('volo_vore_id', $find_vore_id->vore_id)
                                ->value('volo_borrow_price');
                            $loan_price = $volo_borrow_price - $recycle_all_price;
                            $volo_edit_res['volo_borrow_price'] = abs($loan_price);
                            $volo_edit_res['volo_update_time'] = date('Y-m-d H:i:s');
                            $volo_edit_res = DB::table('voucher_loan')
                                ->where('volo_shop_id', $user_info->adm_cid)
                                ->where('volo_vore_id', $find_vore_id->vore_id)
                                ->update($volo_edit_res);
                            if (!$vore_res || !$volo_res) {
                                DB::rollBack();
                                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败4']);
                            }
                        } else {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前凭证已同步U8']);
                        }
                    }
                }
            } else {
                // 工单商品表添加数据
                $wor_res = true;
            }
        } else {
            $wor_res = true;
        }
        $jur_res = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($juck);
        // 4. 仓库商品表
        // 4.1 查询旧货仓库类表的商品库存数量
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $request['jur_ware_id'])
            ->where('wago_class', $request['jur_waon_class'])
            ->whereIn('wago_goo_id', $request['jugo_goo_id'])
            ->select('wago_id', 'wago_goo_id', 'wago_stock_number')
            ->get()
            ->toArray();
        if (empty($warehouse_goods)) {
            $ware_edit_res = true;
        } else {
            // 4.2 仓库商品表中已存在的商品，更改库存数量，整理更改SQL语句
            $sql = 'UPDATE `faster_warehouse_goods` SET ';
            $stock_number_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($warehouse_goods as $key => $value) {
                if (isset($goods_data[$value->wago_goo_id])) {
                    // 更改商品库存数量
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $value->wago_id;
                    $stock_number_sql = $stock_number_sql . ' THEN wago_stock_number + ' . $goods_data[$value->wago_goo_id];
                    // 更改时间
                    $update_time_sql = $update_time_sql . ' WHEN ' . $value->wago_id;
                    $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $value->wago_id . ',';
                    // 删除已更改的商品数据
                    unset($goods_data[$value->wago_goo_id]);
                }
            }
            if (!empty($stock_number_sql)) {
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $ware_edit_res = DB::update($sql);
            } else {
                $ware_edit_res = true;
            }
        }
        // 4.3 仓库商品表中没有的商品，新增仓库商品
        if (!empty($warehouse_goods) && empty($goods_data)) {
            $ware_add_res = true;
        } else {
            $num = 0;
            foreach ($goods_data as $key => $value) {
                $ware_add_data[$num]['wago_ware_id'] = $request['jur_ware_id'];
                $ware_add_data[$num]['wago_class'] = $request['jur_waon_class'];
                $ware_add_data[$num]['wago_goo_id'] = $key;
                $ware_add_data[$num]['wago_stock_number'] = $value;
                $num++;
            }
            $ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
        }

        // 5.修改仓库表 总库存量
        $stock_amount_res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $request['jur_ware_id'])
            ->where('waon_class', $request['jur_waon_class'])
            ->increment('waon_stock_fine_amount', $goods_number_sum);
        $all_amount_res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $request['jur_ware_id'])
            ->where('waon_class', $request['jur_waon_class'])
            ->increment('waon_all_amount', $goods_number_sum);

        $find_ware = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $request['jur_ware_id'])
            ->where('waon_class', $request['jur_waon_class'])
            ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
            ->first();
        // 1. 新增一条入库记录
        if (config('apisystem.WAREHOUSE')) {
            $find_junk = DB::table('junk_recycle as jure')
                ->leftJoin('junk_client as jucl', 'jucl.jucl_jur_id', '=', 'jure.jur_id')
                ->where('jur_id', $request['jur_id'])
                ->select('jur_id', 'jur_number', 'jur_type', 'jucl_client_id')
                ->first();
            if (!empty($request['jur_ord_id'])) {
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $request['jur_ord_id'], //原始单的关联id
                    $request['jur_ord_order_number'], //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                    $request['jur_number'], //原始单号，旧货回收单单号
                    $request['jur_ware_id'], //入库仓库id
                    0, //出库仓库id
                    $goods_number_sum, //出库的商品总数量
                    4, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                    3, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    2, //出入库类型：1出库，2入库
                    $request['jur_waon_class'], //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory //出库类型1良品2优先
                );
            } else {
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $request['jur_id'], //原始单的关联id
                    $request['jur_number'], //原始单的关联单号
                    5, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                    $request['jur_number'], //原始单号，旧货回收单单号
                    $request['jur_ware_id'], //入库仓库id
                    0, //出库仓库id
                    $goods_number_sum, //出库的商品总数量
                    4, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                    3, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    2, //出入库类型：1出库，2入库
                    $request['jur_waon_class'], //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory //出库类型1良品2优先
                );
            }
        } else {
            $oure_res = OutinRecord::create(
                $user_info, //用户信息
                $request['jur_number'], //原始单号，旧货回收单单号
                $request['jur_ware_id'], //入库仓库id
                0, //出库仓库id
                $request['jur_waon_class'], //仓库类别
                $goods_number_sum, //出库的商品总数量
                4, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库
                $oure_goods_data, //数组，商品数据，['商品id'=>['商品出库数量','出库类型']
                3, //操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                2 //出入库类型：1出库，2入库
            );
        }

        $jur_info = DB::table('junk_recycle as jr')
            ->leftjoin('junk_client as jc', 'jr.jur_id', '=', 'jc.jucl_jur_id')
            ->where('jur_id', $request['jur_id'])
            ->select('jur_number', 'jur_type', 'jucl_client_id', 'jucl_channel_unit', 'jur_remark', 'jur_create_time')
            ->first();

        if (empty($request['jur_wor_id']) && empty($request['jur_ord_id'])) {
            if ($request['total_price'] > 0 && !empty($request['acti_id'])) {
                // 旧货回收应付
                $ord_bill = ReceivableBill::create(
                    $user_info, //用户信息
                    13, //类型：12.加盟店订单代收13.旧货回收
                    0, //应收账款id
                    $request['jur_id'], //旧货回收id
                    $request['jur_number'], //旧货回收单号
                    $jur_info->jur_type, //客户类型：1.门店零售 2.来往单位
                    $jur_info->jucl_client_id, //派单门店id
                    $jur_info->jucl_channel_unit, //派单门店名称
                    $request['total_price'] * 100, //结算金额(应收金额)
                    '', //结款时间
                    $request['acti_id'], //会计科目id
                    $request['total_price'] * 100, //实际金额(应收金额)
                    0, //抹零金额
                    1,  //状态：1.未核销 2.已核销
                    1,  //应收账单id是否是自己 1.不是 2.是
                    $jur_info->jur_remark,  //备注
                    0,  //已收金额
                    '', //截止时间
                    2, //金额正负1正   2负值
                    16, //显示类型：1订单收款
                    2, //是否合并代收：1是2否
                    $jur_info->jur_create_time
                );

                // 生成结款明细
                $acset_res = AccountingSettlement::add(
                    $user_info, // [用户信息]
                    19, // [单据类型1订单结算2订单账单3工单账单11订单退款12工单代收]
                    $request['jur_id'], // [与单据类型对应的id]
                    $request['jur_number'], // [与单据类型对应的单号]
                    $jur_info->jur_type, // [买家类型1门店零售2来往单位]
                    $jur_info->jucl_client_id, // [买家类型对应id]
                    $jur_info->jucl_channel_unit, // [买家类型对应名称]
                    $request['acti_id'], // [会计科目id]
                    2, // [类型1收入2支出]
                    $request['total_price'] * 100, // [实际金额](此次的实收金额)
                    $request['total_price'] * 100, // [合计金额](此次的应收金额)
                    0, // [欠收金额](此次结款后还应收金额)
                    0, // [抹零金额]
                    '' //[备注]
                );
            } else {
                $ord_bill = true;
                $acset_res = true;
            }
        } else {
            $ord_bill = true;
            $acset_res = true;
        }

        if ($oure_res && $all_amount_res && $stock_amount_res && $ware_add_res && $ware_edit_res && $jur_res && $recycle_update && $ord_bill && $acset_res) {
            Common::addLog($user_info, getRealIp($request), '旧货回收', '审核', '审核通过：' . $request['jur_number'] . '成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'审核：成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核：失败4']);
        }
    }

    // 编辑【废弃】
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 回收单数据
        $find_junk = DB::table('junk_recycle as jure')
            ->leftjoin('admin as adm', 'adm.adm_id', '=', 'jure.jur_create_adm_id')
            ->where('jur_id', $request['jur_id'])
            ->select('jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_wor_number', 'jur_ord_id', 'jur_ord_order_number', 'jur_create_adm_id', 'adm_name as jur_create_adm_name', 'jur_is_mobile', 'jur_state', 'jur_type', 'jur_service_adm_id', 'jur_remark', 'jur_ware_id', 'jur_waon_class')
            ->first();

        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }

        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('junk_client')
            ->where('jucl_jur_id', $request['jur_id'])
            ->select('jucl_channel_unit', 'jucl_name', 'jucl_phone')
            ->first();
        $find_junk->jucl_channel_unit = $client->jucl_channel_unit;
        $find_junk->jucl_name = $client->jucl_name;
        $find_junk->jucl_phone = $client->jucl_phone;

        // 查询仓库名称
        $find_junk->ware_name = DB::table('warehouse')
            ->where('ware_id', $find_junk->jur_ware_id)
            ->value('ware_name');

        // 查询当前工单状态,尚未审核可以进行编辑
        $wor_pass = DB::table('work_order')
            ->where('wor_id', $find_junk->jur_wor_id)
            ->value('wor_pass');
        if ($wor_pass != '1') {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前工单已通过审核,无法进行编辑操作']);
        }

        if ($request['type'] == 1) {
            $adm_id[] = $find_junk->jur_create_adm_id;
            $adm_id[] = $find_junk->jur_service_adm_id;
            $adm_id = array_unique($adm_id);
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->get(['adm_id', 'adm_name']);

            // 获取页面数据
            $find_goods = DB::table('junk_goods')
                ->where('jugo_jur_id', $request['jur_id'])
                ->select('jugo_id', 'jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_recycle_number as goo_recycle_amount', 'jugo_goo_ampere_hour as goo_ampere_hour')
                ->get();
            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;
            $data['adm_data'] = $find_admin;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $request['goodsDataList'] = json_decode($request['goodsDataList'], true);
        $new_goods_data = [];
        $old_goods_data = [];
        $new_goo_id = [];
        DB::beginTransaction();
        foreach ($request['goodsDataList'] as $key => $value) {
            // 判断有没有新的回收商品
            if (!empty($value['new_goo_id']) && $value['old_goo_id'] != $value['new_goo_id']) {
                $new_goo_id[] = $value['new_goo_id']; //新换的回收商品
                $old_goo_id[] = $value['old_goo_id']; //原来的回收商品
                // 记录仓库商品表 所有要做修改的商品id 及其对应的数量
                $new_goods_data[$value['new_goo_id']] = $value['goo_recycle_number'];
                $old_goods_data[$value['old_goo_id']] = $value['goo_recycle_number'];

                // 更改旧货回收商品表数据
                $jugo_data['jugo_goo_id'] = $value['new_goo_id']; //商品id
                $jugo_data['jugo_goo_name'] = $value['new_goo_name']; //商品名称
                $jugo_data['jugo_goo_goods_encode'] = $value['new_goo_goods_encode']; //商品编号
                $jugo_data['jugo_goo_ampere_hour'] = $value['new_goo_ampere_hour']; //安时数
                $jugo_data['jugo_update_time'] = date('Y-m-d H:i:s');
                $jugo_edit_res = DB::table('junk_goods')
                    ->where('jugo_id', $value['jugo_id'])
                    ->where('jugo_goo_id', $value['old_goo_id'])
                    ->update($jugo_data);
                // 更改订单商品表数据
                $orgo_data['orgo_goo_id'] = $value['new_goo_id']; //商品id
                $orgo_data['orgo_goo_name'] = $value['new_goo_name']; //商品名称
                $orgo_data['orgo_goo_goods_encode'] = $value['new_goo_goods_encode']; //商品编号
                $orgo_data['orgo_goo_ampere_hour'] = $value['new_goo_ampere_hour']; //安时数
                $orgo_edit_res = DB::table('order_goods')
                    ->where('orgo_ord_id', $find_junk->jur_ord_id)
                    ->where('orgo_goo_id', $value['old_goo_id'])
                    ->where('orgo_state', 3)
                    ->update($orgo_data);
                // 根据订单id,查询订单类型
                $find_service_type = DB::table('order')
                    ->where('ord_id', $find_junk->jur_ord_id)
                    ->value('ord_service_type');
                if ($find_service_type != 5) {
                    // 更改工单商品表数据
                    $wogo_data['wogo_goo_id'] = $value['new_goo_id']; //商品id
                    $wogo_data['wogo_goo_name'] = $value['new_goo_name']; //商品名称
                    $wogo_data['wogo_goo_goods_encode'] = $value['new_goo_goods_encode']; //商品编号
                    $wogo_edit_res = DB::table('work_good')
                        ->where('wogo_wor_id', $find_junk->jur_wor_id)
                        ->where('wogo_goo_id', $value['old_goo_id'])
                        ->where('wogo_state', 3)
                        ->update($wogo_data);
                } else {
                    $wogo_edit_res = true;
                }
                $oude_data['oude_goo_id'] = $value['new_goo_id']; //商品id
                $oude_data['oude_update_time'] = date('Y-m-d H:i:s');
                // 修改出入库记录
                $oure_res = DB::table('outin_record as oure')
                    ->leftjoin('outin_details as oude', 'oude.oude_oure_id', '=', 'oure.oure_id')
                    ->where('oure_cid', $user_info->adm_cid)
                    ->where('oure_superior_shop_id', $shop_id)
                    ->where('oure_original_number', $find_junk->jur_number)
                    ->update($oude_data);
                if (!$jugo_edit_res || !$orgo_edit_res || !$wogo_edit_res || !$oure_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑旧货回收单失败']);
                }
            }
        }
        if ($new_goo_id) {
            // 查询旧货仓库类表的商品库存数量
            $new_warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_junk->jur_ware_id)
                ->where('wago_class', $find_junk->jur_waon_class)
                ->whereIn('wago_goo_id', $new_goo_id)
                ->select('wago_id', 'wago_goo_id', 'wago_stock_number')
                ->get()
                ->toArray();
            if (empty($new_warehouse_goods)) {
                $new_ware_edit_res = true;
            } else {
                // 仓库商品表中已存在的商品,库存数量减少
                $sql = 'UPDATE `faster_warehouse_goods` SET ';
                $unchecked_stock_sql = '';
                $update_time_sql = '';
                $ids = '';
                foreach ($new_warehouse_goods as $key => $value) {
                    // 更改商品库存数量
                    $unchecked_stock_sql = $unchecked_stock_sql . ' WHEN ' . $value->wago_id;
                    $unchecked_stock_sql = $unchecked_stock_sql . ' THEN wago_stock_number + ' . $new_goods_data[$value->wago_goo_id];
                    // 更改时间
                    $update_time_sql = $update_time_sql . ' WHEN ' . $value->wago_id;
                    $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $value->wago_id . ',';
                    unset($new_goods_data[$value->wago_goo_id]); //删除已更改的商品数据
                }
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $unchecked_stock_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $new_ware_edit_res = DB::update($sql);
            }
            // 仓库商品表中没有的商品，新增仓库商品
            if (!empty($new_warehouse_goods) && empty($new_goods_data)) {
                $new_ware_add_res = true;
            } else {
                $num = 0;
                foreach ($new_goods_data as $key => $value) {
                    $ware_add_data[$num]['wago_ware_id'] = $find_junk->jur_ware_id; //仓库id
                    $ware_add_data[$num]['wago_class'] = $find_junk->jur_waon_class; //仓库类别1货物仓2费货物仓3旧货仓4临时仓
                    $ware_add_data[$num]['wago_goo_id'] = $key;
                    $ware_add_data[$num]['wago_stock_number'] = $value;
                    $num++;
                }
                $new_ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
            }

            // 查询旧货仓库类表的商品库存数量
            $old_warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_junk->jur_ware_id)
                ->where('wago_class', $find_junk->jur_waon_class)
                ->whereIn('wago_goo_id', $old_goo_id)
                ->select('wago_id', 'wago_goo_id', 'wago_stock_number')
                ->get()
                ->toArray();
            if (empty($old_warehouse_goods)) {
                $old_ware_edit_res = true;
            } else {
                // 仓库商品表中已存在的商品,库存数量减少
                $sql = 'UPDATE `faster_warehouse_goods` SET ';
                $unchecked_stock_sql = '';
                $update_time_sql = '';
                $ids = '';
                foreach ($old_warehouse_goods as $key => $value) {
                    // 判断仓库内商品数量是否够减
                    $goods_quantity = $value->wago_stock_number - $old_goods_data[$value->wago_goo_id];
                    if ($goods_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足']);
                    }
                    // 更改商品库存数量
                    $unchecked_stock_sql = $unchecked_stock_sql . ' WHEN ' . $value->wago_id;
                    $unchecked_stock_sql = $unchecked_stock_sql . ' THEN wago_stock_number - ' . $old_goods_data[$value->wago_goo_id];
                    // 更改时间
                    $update_time_sql = $update_time_sql . ' WHEN ' . $value->wago_id;
                    $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $value->wago_id . ',';
                    unset($old_goods_data[$value->wago_goo_id]); //删除已更改的商品数据
                }
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $unchecked_stock_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $old_ware_edit_res = DB::update($sql);
            }
            // 仓库商品表中没有的商品，新增仓库商品
            if (!empty($old_warehouse_goods) && empty($old_goods_data)) {
                $old_ware_add_res = true;
            } else {
                $num = 0;
                foreach ($old_goods_data as $key => $value) {
                    $ware_add_data[$num]['wago_ware_id'] = $find_junk->jur_ware_id; //仓库id
                    $ware_add_data[$num]['wago_class'] = $find_junk->jur_waon_class; //仓库类别1货物仓2费货物仓3旧货仓4临时仓
                    $ware_add_data[$num]['wago_goo_id'] = $key;
                    $ware_add_data[$num]['wago_stock_number'] = $value;
                    $num++;
                }
                $old_ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
            }
        } else {
            $new_ware_add_res = true;
            $new_ware_edit_res = true;
            $old_ware_edit_res = true;
            $old_ware_add_res = true;
        }

        if ($new_ware_add_res && $new_ware_edit_res && $old_ware_edit_res && $old_ware_add_res) {
            Common::addLog($user_info, getRealIp($request), '旧货回收', '编辑', '编辑旧货回收单：' . $find_junk->jur_number . '成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑旧货回收单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑旧货回收单失败']);
        }
    }

    // 搜索商品
    public function searchGoods(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->searchGoodsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }
        $search_data = $request->all();
        $list_data = DB::table('goods')
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $user_info->adm_cid);
                } else {
                    $query->where('goo_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                } else {
                    $query->where('goo_shop_id', $user_info->adm_shop_id);
                }
            })
            ->where('goo_type', $request['goo_type'])
            ->where('goo_delete', 1)
            ->where('goo_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_brse_id'])) {
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            }) //品牌系列id
            ->select('goo_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'goo_ampere_hour', 'goo_brse_id', 'goo_bra_name', 'goo_class')
            ->orderBy('goo_goods_encode', 'asc')
            ->paginate($this->show_count);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['brse_data'] = []; //品牌系列数据
        if ($data_info['data']) {
            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['data'], 'goo_brse_id')));
            if ($goo_brse_id) {
                $data_info['brse_data'] = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->select('brse_id', 'brse_name')
                    ->get();
            }
            $goo_id = array_column($data_info['data'], 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($data_info['data'] as $key => $value) {
                if ($value->goo_class == 2 && isset($gosa_data[$value->goo_id]) && !empty($gosa_data[$value->goo_id])) {
                    $data_info['data'][$key]->goo_name = $gosa_data[$value->goo_id];
                }
                if (isset($goaf_data[$value->goo_id]) && !empty($goaf_data[$value->goo_id])) { // 商品别名
                    $data_info['data'][$key]->goo_name = $goaf_data[$value->goo_id];
                }
                unset($data_info['data'][$key]->goo_class);
            }
        }
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 旧货回收0510
    public function recycle(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->recycleShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取回收单数据
        $find_junk = DB::table('junk_recycle as a')
            ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
            ->where('jur_id', $request['jur_id'])
            ->select('adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_ord_id', 'jur_ord_order_number', 'jur_wor_number', 'jur_service_adm_id', 'jur_type', 'jur_waon_class')
            ->first();
        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }
        if ($find_junk->jur_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单已回收']);
        }

        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('junk_client')
            ->where('jucl_jur_id', $request['jur_id'])
            ->first(['jucl_client_id', 'jucl_channel_unit', 'jucl_name', 'jucl_phone']);
        // 查询仓库类型
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $request['jur_ware_id'])
            ->value('ware_type');
        // 查询回收单的数据
        if ($request['type'] == 1) {
            // 查询客户单位名称
            $find_junk->jucl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $client->jucl_client_id)
                ->value('chun_unit_name');
            $find_junk->jucl_name = $client->jucl_name;
            $find_junk->jucl_phone = $client->jucl_phone;
            // 查询出仓库名称
            $find_junk->ware_name = DB::table('warehouse')
                ->where('ware_id', $find_junk->jur_ware_id)
                ->value('ware_name');
            // 查询出服务技师名称
            $find_junk->jur_service_adm_name = DB::table('admin')
                ->where('adm_id', $find_junk->jur_service_adm_id)
                ->value('adm_name');
            // 获取旧货商品页面数据
            $find_goods = DB::table('junk_goods as jugo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
                ->where('jugo_jur_id', $request['jur_id'])
                ->select('jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_remark as goo_remark', 'jugo_goo_ampere_hour', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo.goo_id')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($find_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_goods, 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($find_goods as $key => $value) {
                if ($value->goo_class == 2 && isset($gosa_data[$value->goo_id]) && !empty($gosa_data[$value->goo_id])) {
                    $find_goods[$key]->goo_name = $gosa_data[$value->goo_id];
                }
                if (isset($goaf_data[$value->goo_id]) && !empty($goaf_data[$value->goo_id])) { // 商品别名
                    $find_goods[$key]->goo_name = $goaf_data[$value->goo_id];
                }
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $find_goods[$key]->goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $find_goods[$key]->goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $find_goods[$key]->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $find_goods[$key]->goo_name;
                        }
                    }
                }
                unset($find_goods[$key]->goo_brse_id);
            }
            // 判断是否是无工单的订单
            if ($find_junk->jur_source == 2) {
                $find_junk->ord_wor_state = DB::table('order')
                    ->where('ord_id', $find_junk->jur_ord_id)
                    ->value('ord_wor_state');
            } else {
                $find_junk->ord_wor_state = 0;
            }

            // 查询当前账号所拥有的仓库权限
            $adms_ware_id = DB::table('admin_set')
                ->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
                ->value('adms_ware_id');
            $adms_ware_id = explode(',', $adms_ware_id);

            // 搜索仓库
            $find_ware = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_superior_shop_id', $shop_id)
                ->where('ware_state', 1)
                ->where('ware_type', 1)
                ->get(['ware_id', 'ware_name']);

            // 获取订单商品数据
            $find_ord_goods = DB::table('order_goods')
                ->where('orgo_ord_id', $find_junk->jur_ord_id)
                ->where('orgo_order_number', $find_junk->jur_ord_order_number)
                ->where('orgo_state', '!=', 2)
                ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'orgo_goo_quantity')
                ->get()->toArray();

            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;
            $data['warehouse_data'] = $find_ware;
            $data['orgo_goods_data'] = $find_ord_goods;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->recyclesValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['jur_source'] == 2 && $request['ord_wor_state'] != 5 && empty($request['wor_id'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        // 根据工单id查询是否是加盟店
        $find_wocl_wor_type = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wocl_wor_id', $find_junk->jur_wor_id)
            ->select('wocl_wor_type', 'wocl_join_wor_id', 'wor_order_id', 'wor_id')
            ->first();
        // 根据外派工单id,查询出总店工单id和订单id
        $ord_ids = DB::table('work_order')
            ->where('wor_id', $find_wocl_wor_type->wocl_join_wor_id)
            ->select('wor_id', 'wor_order_id', 'wor_order_number')
            ->first();

        DB::beginTransaction();

        // 1 删除原来收回单id对应的商品数据
        $del_goods = DB::table('junk_goods')
            ->where('jugo_jur_id', $request['jur_id'])
            ->delete();

        // 2021-05-25 程晓旭 判断订单商品仓位表是否存在 把订单商品的数据加入到新的记录表
        $order_goods_freight_base = DB::table('order_goods_freight')
            ->where('orgf_shop_id', $user_info->adm_shop_id)
            ->where('orgf_ord_id', $request['jur_ord_id'])
            ->where('orgf_order_number', $request['jur_ord_order_number'])
            ->where('orgf_delete', 1)
            ->select('orgf_id')
            ->get()->toArray();
        if (empty($order_goods_freight_base)) { //订单商品的数据没有就新增
            // 查询订单商品的数据
            $order_goods_base = DB::table('order_goods')
                ->where('orgo_ord_id', $request['jur_ord_id'])
                ->where('orgo_order_number', $request['jur_ord_order_number'])
                ->where('orgo_state', '!=', 3) //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                ->select('orgo_id', 'orgo_ware_id', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory')
                ->get()->toArray();
            $order_goods_base = json_decode(json_encode($order_goods_base, true), true);
            foreach ($order_goods_base as $key => $value) {
                // 订单商品仓位表
                $orgf_data['orgf_shop_id'] = $user_info->adm_shop_id; //门店id
                $orgf_data['orgf_ord_id'] = $request['jur_ord_id']; //订单id
                $orgf_data['orgf_order_number'] = $request['jur_ord_order_number']; //订单号
                $orgf_data['orgf_orgo_id'] = $value['orgo_id']; //订单商品id
                $orgf_data['orgf_ware_id'] = $value['orgo_ware_id']; //仓库id
                $orgf_data['orgf_wago_id'] = $value['orgo_wago_id']; //仓库商品主键id
                $orgf_data['orgf_wafr_id'] = 0; //仓位id
                $orgf_data['orgf_wafg_id'] = 0; //仓位商品主键id
                $orgf_data['orgf_goo_id'] = $value['orgo_goo_id']; //商品id
                $orgf_data['orgf_goo_quantity'] = $value['orgo_goo_quantity']; //商品数量
                $orgf_data['orgf_goo_inventory'] = $value['orgo_goo_inventory']; //出库类型1良品2优先
                $orgf_data['orgf_original_id'] = $request['jur_ord_id']; //订单id
                $orgf_data['orgf_outin_type'] = 1; //出入库类型：1出库2入库
                // 添加订单商品仓位数据
                $orgf_ids = DB::table('order_goods_freight')->insertGetId($orgf_data);
                unset($orgf_data);
                if (!$orgf_ids) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'回收：失败2']);
                }
            }
        }

        // 旧货回收
        $junk_return = JunkRecycling::junkRecycle(
            $user_info, //用户信息
            $request->all(), //前端传过来的数据
            $find_junk, //旧货回收单的数据
            $ware_type //类型：1固定仓2技师库3移动仓
        );
        // 记录日志
        $log_data['function'] = '旧货回收';
        $log_data['user_info'] = $user_info;
        $log_data['jur_number'] = $request['jur_number'];
        $log_data['request'] = $request->all();
        Common::write_record_log($log_data, 'pc/RecyclingController.txt', 'recycle');
        if ($junk_return['code'] == 200) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '旧货回收', '回收', '回收 旧货回收单：' . $request['jur_number'] . '成功');
        } else {
            DB::rollBack();
        }
        return response()->json($junk_return);
    }

    // 备注
    public function remark(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->remarkValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $jur_state = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->value('jur_state');
        if (empty($jur_state)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'无此旧货回收单']);
        }

        $update_data['jur_remark'] = $request['jur_remark'];
        $update_data['jur_update_time'] = date('Y-m-d H:i:s');
        $update_remark = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($update_data);

        if ($update_remark) {
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '旧货回收', '备注', '备注旧货回收单：' . $request['jur_number'] . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'备注旧货回收单：成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'备注旧货回收单：失败']);
        }
    }

    // 删除
    public function del(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->delValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 限制回收后不得删除
        $jur_state = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->value('jur_state');
        if (empty($jur_state)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'无此回收单']);
        }
        if ($jur_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该回收单已回收,不得删除']);
        }

        DB::beginTransaction();
        // 删除回收单表
        $del_recycle = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->delete();
        // 删除回收单商品表
        $del_goods = DB::table('junk_goods')
            ->where('jugo_jur_id', $request['jur_id'])
            ->delete();
        // 删除回收单客户表
        $del_client = DB::table('junk_client')
            ->where('jucl_jur_id', $request['jur_id'])
            ->delete();

        if ($del_recycle && $del_goods && $del_client) {
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '旧货回收', '删除', '删除旧货回收单：' . $request['jur_number'] . '成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'删除旧货回收单：成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'删除旧货回收单：失败']);
        }
    }

    // 详情
    public function details(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取回收单数据
        $find_junk = DB::table('junk_recycle as a')
            ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
            ->where('jur_id', $request['jur_id'])
            ->first(['adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_wor_number', 'jur_ord_order_number', 'jur_service_adm_id', 'jur_wor_number', 'jur_ord_order_number', 'jur_waon_class']);
        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }
        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('junk_client')
            ->where('jucl_jur_id', $request['jur_id'])
            ->first(['jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jucl_client_id']);
        // 查询客户单位名称
        $find_junk->jucl_channel_unit = DB::table('channel_unit')
            ->where('chun_id', $client->jucl_client_id)
            ->value('chun_unit_name');
        unset($find_junk->jucl_client_id);
        $find_junk->jucl_name = $client->jucl_name;
        $find_junk->jucl_phone = $client->jucl_phone;
        // 查询出仓库名称
        $find_junk->ware_name = DB::table('warehouse')
            ->where('ware_id', $find_junk->jur_ware_id)
            ->value('ware_name');
        // 查询出服务技师名称
        $find_junk->jur_service_adm_name = DB::table('admin')
            ->where('adm_id', $find_junk->jur_service_adm_id)
            ->value('adm_name');
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 获取页面数据
        $find_goods = DB::table('junk_goods as jugo')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
            ->where('jugo_jur_id', $request['jur_id'])
            ->select('jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_remark', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo.goo_id', 'jugo_id')
            ->get()->toArray();
        // 查询系列数据
        $goo_brse_id = array_column($find_goods, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        $goo_id = array_column($find_goods, 'goo_id');
        // 查询商品附属表信息
        $goaf_data = DB::table('goods_affiliate')
            ->where('goaf_shop_id', $user_info->adm_shop_id)
            ->whereIn('goaf_goo_id', $goo_id)
            ->pluck('goaf_another_name', 'goaf_goo_id')
            ->toArray();
        // 查询系统商品属性表信息
        $gosa_data = DB::table('goods_system_affiliate')
            ->where('gosa_shop_id', $user_info->adm_shop_id)
            ->whereIn('gosa_goo_id', $goo_id)
            ->pluck('gosa_another_name', 'gosa_goo_id')
            ->toArray();
        foreach ($find_goods as $key => $value) {
            //查询仓位数据 数量仓位名称商品类型
            $find_wfog_data = DB::table('warehouse_freight_outin_goods as w')
                ->leftJoin('warehouse_freight as wf', 'w.wfog_wafr_id', '=', 'wf.wafr_id')
                ->where('wfog_original_id', $request['jur_id'])
                ->where('wfog_outin_type', 2)
                ->where('wfog_primary_id', $value->jugo_id)
                ->select('wfog_wafr_id', 'wfog_stock_amount as goo_recycle_amount', 'wafr_name as jugo_wafr_name', 'wfog_stock_type as jugo_goo_inventory')
                ->get()->toArray();
            $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
            if ($find_wfog_data) {
                $find_goods[$key]->wafr_data = $find_wfog_data; //仓位数据
            } else {
                $ware_name = DB::table('warehouse')
                    ->where('ware_id', $find_junk->jur_ware_id)
                    ->value('ware_name');
                $new_data['goo_recycle_amount'] = $value->goo_recycle_amount;
                if ($find_junk->jur_waon_class == 3) { //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                    $new_data['jugo_goo_inventory'] = 2; //优先
                } else {
                    $new_data['jugo_goo_inventory'] = 1; //良品
                }
                $new_data['jugo_wafr_name'] = $ware_name; //仓库名称
                $find_goods[$key]->wafr_data[] = $new_data;
            }
            if ($value->goo_class == 2 && isset($gosa_data[$value->goo_id]) && !empty($gosa_data[$value->goo_id])) {
                $find_goods[$key]->goo_name = $gosa_data[$value->goo_id];
            }
            if (isset($goaf_data[$value->goo_id]) && !empty($goaf_data[$value->goo_id])) { // 商品别名
                $find_goods[$key]->goo_name = $goaf_data[$value->goo_id];
            }
            // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                if (!empty($value->goo_brse_id)) {
                    if ($value->goo_class == 2) {
                        $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $find_goods[$key]->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $find_goods[$key]->goo_name;
                        }
                    }
                }
            }
            // 显示品牌名称
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                if ($value->goo_class == 2) {
                    $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $find_goods[$key]->goo_name;
                } else {
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                        $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $find_goods[$key]->goo_name;
                    }
                }
            }
            unset($find_goods[$key]->goo_brse_id);
        }
        $data['junk_data'] = $find_junk;
        $data['goods_data'] = $find_goods;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 搜索
    public function searchAll(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->searchAllValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;

        $search_data = $request->all();

        if ($search_data['type'] == 1) { //搜索会员
            $data = DB::table('member')
                ->where('mem_cid', $user_info->adm_cid)
                ->where('mem_shop_id', $shop_id)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['mem_name'])) {
                        $query->where('mem_name', 'like', '%' . $search_data['mem_name'] . '%');
                    }
                })
                ->get(['mem_id', 'mem_name', 'mem_phone']);
        } elseif ($search_data['type'] == 2) { //搜索订单
            $ord_service_type = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_shop_id', $shop_id)
                ->where('ord_delete', 1)
                ->where('orcl_shipment_party', '!=', 4)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->value('ord_service_type');
            if ($ord_service_type == 4 || $ord_service_type == 5) { //订单类型为退货单或发货单
                $data = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_delete', 1)
                    ->where('orcl_shipment_party', '!=', 4)
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    })
                    ->select('ord_id', 'ord_order_number', 'ord_wor_state')
                    ->paginate(8);
                $data = $data->items();
            } else {
                $data = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->leftjoin('work_order as wor', 'wor.wor_order_id', '=', 'ord.ord_id')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_delete', 1)
                    ->where('orcl_shipment_party', '!=', 4)
                    ->where('wor_delete', 1)
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    })
                    ->select('ord_id', 'ord_order_number', 'ord_wor_state', 'wor_id', 'wor_number')
                    ->paginate(8);
                $data = $data->items();
            }
        } elseif ($search_data['type'] == 3) { // 搜索订单下的工单以及该工单下的商品(已回收的工单/生成回收单的工单给出提示)
            $data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_cid', $user_info->adm_cid)
                ->where('wor_superior_shop_id', $shop_id)
                ->where('wor_service_adm_id', '>', 0)
                ->where('wocl_wor_type', '!=', 4)
                ->where('wocl_junk_type', 2)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('wor_order_number', 'like', '%' . $search_data['ord_order_number'] . '%'); //订单号
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['wor_number'])) {
                        $query->where('wor_number', 'like', '%' . $search_data['wor_number'] . '%');
                    }
                })
                ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_service_adm_id')
                ->paginate(8);
            $data = $data->items();
        } elseif ($search_data['type'] == 4) { // 搜索技师
            $data = DB::table('admin')
                ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
                ->where('asr.shop_cid', $user_info->adm_cid)
                ->where('asr.shop_id', $user_info->adm_shop_id)
                ->where('asr.adm_state', 1)
                ->whereIn('asr.adm_shop_leave', [0 => 3, 1 => 5])
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['adm_name'])) {
                        $query->where('admin.adm_name', 'like', '%' . $search_data['adm_name'] . '%');
                    }
                })
                ->get(['admin.adm_id', 'admin.adm_name']);
        } elseif ($search_data['type'] == 5) { // 搜索客户单位类型
            $data = DB::table('channel_type')
                ->where('chty_cid', $user_info->adm_cid)
                ->where('chty_superior_shop_id', $shop_id)
                ->where('chty_delete', 1)
                ->where('chty_state', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['chty_name'])) {
                        $query->where('chty_name', 'like', '%' . $search_data['chty_name'] . '%');
                    }
                })
                ->get(['chty_id', 'chty_name']);
        } elseif ($search_data['type'] == 6) { // 搜索客户单位类型下的客户单位
            $data = DB::table('channel_unit')
                ->where('chun_cid', $user_info->adm_cid)
                ->where('chun_superior_shop_id', $shop_id)
                ->where('chun_state', 1)
                ->where('chun_chty_id', $search_data['chty_id'])
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['chun_unit_name'])) {
                        $query->where('chun_unit_name', 'like', '%' . $search_data['chun_unit_name'] . '%');
                    }
                })
                ->get(['chun_id', 'chun_unit_name', 'chun_name', 'chun_phone']);
        } elseif ($search_data['type'] == 7) { // 搜索仓库
            $data = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $shop_id)
                ->where('ware_state', 1)
                ->whereIn('ware_type', [1, 3])
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ware_name'])) {
                        $query->where('ware_name', 'like', '%' . $search_data['ware_name'] . '%');
                    }
                })
                ->get(['ware_id', 'ware_name']);
        } elseif ($search_data['type'] == 8) { // 搜索创建人
            $select_field = "adm_id, adm_name";
            $public_search = new PublicSearch;
            $list_data = $public_search->searchPersonel($user_info, $request->all(), $select_field);
            $data = $list_data['data'];
        }

        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 打印详情
    public function labelPrint(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取打印数据
        $find_junk = DB::table('junk_recycle as a')
            ->leftjoin('admin as b', 'b.adm_id', '=', 'a.jur_service_adm_id')
            ->leftjoin('warehouse as c', 'c.ware_id', '=', 'a.jur_ware_id')
            ->leftjoin('junk_client as d', 'd.jucl_jur_id', '=', 'a.jur_id')
            ->where('jur_id', $request['jur_id'])
            ->select('jur_wor_number', 'jur_ord_order_number', 'jur_wor_id', 'jucl_channel_unit', 'jucl_car_num', 'jur_remark', 'ware_freight_space', 'adm_name', 'jucl_client_id')
            ->first();
        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }
        $find_junk->jucl_channel_unit = DB::table('channel_unit')
            ->where('chun_id', $find_junk->jucl_client_id)
            ->value('chun_unit_name');
        unset($find_junk->jucl_client_id);
        // 获取工单商品的最后一个数据
        $find_goods = DB::table('work_good')
            ->where('wogo_wor_id', $find_junk->jur_wor_id)
            ->where('wogo_state', 1)
            ->select('wogo_goo_name', 'wogo_goo_goods_encode')
            ->orderBy('wogo_id', 'desc')
            ->first();
        if (empty($find_goods)) {
            $find_goods['wogo_goo_name'] = '';
            $find_goods['wogo_goo_goods_encode'] = '';
        }

        // 查询旧货回收商品的数量、属性
        $junk_goods = DB::table('junk_goods as jugo')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
            ->where('jugo_jur_id', $request['jur_id'])
            ->select('goo_name', 'goo_goods_encode', 'goo_attribute', 'jugo_recycle_number', 'jugo_print_state', 'jugo_id', 'goo_ampere_hour', 'goo_id', 'goo_class')
            ->get()->toArray();
        $junk_goods = json_decode(json_encode($junk_goods), true);

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $goo_id = array_column($junk_goods, 'goo_id');
        // 查询商品附属表信息
        $goaf_data = DB::table('goods_affiliate')
            ->where('goaf_shop_id', $user_info->adm_shop_id)
            ->whereIn('goaf_goo_id', $goo_id)
            ->pluck('goaf_another_name', 'goaf_goo_id')
            ->toArray();
        // 查询系统商品属性表信息
        $gosa_data = DB::table('goods_system_affiliate')
            ->where('gosa_shop_id', $user_info->adm_shop_id)
            ->whereIn('gosa_goo_id', $goo_id)
            ->pluck('gosa_another_name', 'gosa_goo_id')
            ->toArray();
        foreach ($junk_goods as $key => $value) {
            if ($value['goo_class'] == 2 && isset($gosa_data[$value['goo_id']]) && !empty($gosa_data[$value['goo_id']])) {
                $junk_goods[$key]['goo_name'] = $gosa_data[$value['goo_id']];
            }
            if (isset($goaf_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) { // 商品别名
                $junk_goods[$key]['goo_name'] = $goaf_data[$value['goo_id']];
            }
            $junk_goods[$key]['jugo_recycle_number'] = $value['jugo_recycle_number']; //旧货回收的数量
            $junk_goods[$key]['specification'] = $value['goo_ampere_hour'] . 'AH'; //安时数
        }
        $data['adm_name'] = strtoupper(Pinyin::abbr($find_junk->adm_name));
        $data['junk_data'] = $find_junk;
        $data['goods_data'] = $find_goods;
        $data['junk_goods'] = $junk_goods;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 标签打印
    public function print(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $jur_number = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->value('jur_number');

        DB::beginTransaction();

        $jur_data['jur_is_print'] = 2;
        $jur_data['jur_update_time'] = date('Y-m-d H:i:s');
        $jur_res = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($jur_data);

        $jugo_data['jugo_print_state'] = 2;
        $jugo_data['jugo_update_time'] = date('Y-m-d H:i:s');
        $jugo_res = DB::table('junk_goods')
            ->where('jugo_id', $request['jugo_id'])
            ->update($jugo_data);
        if ($jur_res && $jugo_res) {
            DB::commit();
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '旧货回收', '打印标签', '打印标签' . $jur_number . '成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'打印成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'打印失败']);
        }
    }

    // 不回收按钮【取消回收】
    public function noRecycle(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->noRecycleValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 取消回收状态3
        $jur_data['jur_state'] = 3;
        $jur_data['jur_update_time'] = date('Y-m-d H:i:s');

        $res = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($jur_data);

        if (empty($res)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消回收失败']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $jur_number = DB::table('junk_recycle')->where('jur_id', $request['jur_id'])->value('jur_number');
        Common::addLog($user_info, getRealIp($request), '旧货回收', '取消回收', $jur_number . '取消回收成功');
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'取消回收成功']);
    }

    // 导出
    public function export(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $search_data = $request->all();
        $data = DB::table('junk_recycle as jure')
            ->leftJoin('junk_client as jucl', 'jure.jur_id', '=', 'jucl.jucl_jur_id')
            ->leftJoin('junk_goods as jugo', 'jugo.jugo_jur_id', '=', 'jure.jur_id')
            ->where('jur_cid', $user_info->adm_cid)
            ->where('jur_superior_shop_id', $shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_state'])) {
                    $query->where('jur_state', $search_data['jur_state']);
                }
            }) //是否回收
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('jur_date', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('jur_date', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('jur_date', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //日期
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_number'])) {
                    $query->where('jur_number', 'like', '%' . $search_data['jur_number'] . '%');
                }
            }) //回收单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_ord_order_number'])) {
                    $query->where('jur_ord_order_number', 'like', '%' . $search_data['jur_ord_order_number'] . '%');
                }
            }) //订单编号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jucl_channel_unit'])) {
                    $query->where('jucl_channel_unit', 'like', '%' . $search_data['jucl_channel_unit'] . '%');
                }
            }) //客户单位
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_ware_id'])) {
                    $query->where('jur_ware_id', $search_data['jur_ware_id']);
                }
            }) //仓库名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_source'])) {
                    $query->where('jur_source', $search_data['jur_source']);
                }
            }) //旧货来源
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_service_adm_id'])) {
                    $query->where('jur_service_adm_id', $search_data['jur_service_adm_id']);
                }
            }) //服务技师
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jur_create_adm_id'])) {
                    $query->where('jur_create_adm_id', $search_data['jur_create_adm_id']);
                }
            }) //记录人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['jucl_client_id'])) {
                    $query->where('jucl_client_id', $search_data['jucl_client_id']);
                }
            }) //客户单位id
            ->select('jur_number', 'jur_ord_order_number', 'jur_ord_id', 'jur_service_adm_id', 'jur_create_adm_id', 'jur_source', 'jur_state', 'jur_amount', 'jur_price', 'jur_ware_id', 'jur_type', 'jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jur_date', 'jur_remark', 'jugo_goo_goods_encode', 'jugo_goo_name', 'jugo_goo_price', 'jugo_recycle_number', 'jugo_remark', 'jucl_client_id', 'jugo_goo_id')
            ->orderBy('jur_id', 'desc')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            $jur_service_adm_id = array_column($data, 'jur_service_adm_id'); //服务技师id
            $jur_create_adm_id = array_column($data, 'jur_create_adm_id'); //创建人id
            $adm_id = array_unique(array_merge($jur_service_adm_id, $jur_create_adm_id));
            $jur_ware_id = array_unique(array_column($data, 'jur_ware_id')); //仓库id

            // 查找账号id对应的账号姓名
            $admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            // 查找仓库id对应的仓库名称
            $ware = DB::table('warehouse')
                ->whereIn('ware_id', $jur_ware_id)
                ->pluck('ware_name', 'ware_id')->toArray();

            $jur_ord_id = array_unique(array_column($data, 'jur_ord_id')); //订单号
            // 查询订单对应的速电单号
            $find_order_data = DB::table('order')
                ->where('ord_other_system_number', '<>', '')
                ->whereIn('ord_id', $jur_ord_id)
                ->pluck('ord_other_system_number', 'ord_id')->toArray();

            $jugo_goo_id = array_unique(array_column($data, 'jugo_goo_id')); //商品id
            // 查询系统商品属性表信息
            $find_goods_data = DB::table('goods')
                ->whereIn('goo_id', $jugo_goo_id)
                ->select('goo_id', 'goo_class', 'goo_bra_name', 'goo_brse_id')
                ->get()->toArray();
            $find_goods_data = array_column($find_goods_data, null, 'goo_id');
            if ($find_goods_data) {
                $goo_brse_id = array_unique(array_column($find_goods_data, 'goo_brse_id'));
                $find_brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')->toArray();
            }

            foreach ($data as $key => $value) {
                $data[$key]['jur_price'] = $value['jur_price'] / 100;
                $data[$key]['jugo_goo_price'] = $value['jugo_goo_price'] / 100;
                // 服务技师id
                if (isset($admin[$value['jur_service_adm_id']])) {
                    $data[$key]['jur_service_adm_id'] = $admin[$value['jur_service_adm_id']];
                } else {
                    $data[$key]['jur_service_adm_id'] = '';
                }
                // 记录人id
                if (isset($admin[$value['jur_create_adm_id']])) {
                    $data[$key]['jur_create_adm_id'] = $admin[$value['jur_create_adm_id']];
                } else {
                    $data[$key]['jur_create_adm_id'] = '';
                }
                // 速电单号
                if (isset($find_order_data[$value['jur_ord_id']])) {
                    $data[$key]['jur_ord_id'] = $find_order_data[$value['jur_ord_id']];
                } else {
                    $data[$key]['jur_ord_id'] = '';
                }

                // 旧货来源
                if ($value['jur_source'] == '1') {
                    $data[$key]['jur_source'] = '旧货收购';
                } elseif ($value['jur_source'] == '2') {
                    $data[$key]['jur_source'] = '订单回收';
                } else {
                    $data[$key]['jur_source'] = '';
                }

                // 回收状态1未回收2已回收3不回收
                if ($value['jur_state'] == '1') {
                    $data[$key]['jur_state'] = '未回收';
                } elseif ($value['jur_state'] == '2') {
                    $data[$key]['jur_state'] = '已回收';
                } elseif ($value['jur_state'] == '3') {
                    $data[$key]['jur_state'] = '不回收';
                } else {
                    $data[$key]['jur_state'] = '';
                }

                // 仓库
                if ($value['jur_ware_id'] == '0') {
                    $data[$key]['jur_ware_id'] = '';
                } else {
                    $data[$key]['jur_ware_id'] = $ware[$value['jur_ware_id']];
                }

                // 买家类型1门店零售2客户单位3加盟店
                if ($value['jur_type'] == '1') {
                    $data[$key]['jur_type'] = '会员零售';
                } elseif ($value['jur_type'] == '2') {
                    $data[$key]['jur_type'] = '客户单位';
                } elseif ($value['jur_type'] == '3') {
                    $data[$key]['jur_type'] = '速电网单';
                } else {
                    $data[$key]['jur_type'] = '';
                }

                // 客户单位名称
                if (isset($channel_name[$value['jucl_client_id']])) {
                    $data[$key]['jucl_channel_unit'] = $channel_name[$value['jucl_client_id']];
                } else {
                    $data[$key]['jucl_channel_unit'] = $value['jucl_channel_unit'] ? $value['jucl_channel_unit'] : $value['jucl_name'];
                }

                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if (isset($find_goods_data[$value['jugo_goo_id']])) {
                        // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                        if (isset($find_brse_data[$find_goods_data[$value['jugo_goo_id']]->goo_brse_id])) {
                            if ($find_goods_data[$value['jugo_goo_id']]->goo_class == 2) {
                                $data[$key]['jugo_goo_name'] = $find_brse_data[$find_goods_data[$value['jugo_goo_id']]->goo_brse_id] . ' ' . $data[$key]['jugo_goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $data[$key]['jugo_goo_name'] = $find_brse_data[$find_goods_data[$value['jugo_goo_id']]->goo_brse_id] . ' ' . $data[$key]['jugo_goo_name'];
                                }
                            }
                        }
                    }
                }

                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if (isset($find_goods_data[$value['jugo_goo_id']])) {
                        if ($find_goods_data[$value['jugo_goo_id']]->goo_class == 2) {
                            $data[$key]['jugo_goo_name'] = $find_goods_data[$value['jugo_goo_id']]->goo_bra_name . ' ' . $data[$key]['jugo_goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $data[$key]['jugo_goo_name'] = $find_goods_data[$value['jugo_goo_id']]->goo_bra_name . ' ' . $data[$key]['jugo_goo_name'];
                            }
                        }
                    }
                }

                // 检索编号
                $data[$key]['jugo_goo_goods_encode'] = "\t" . $value['jugo_goo_goods_encode'];
                unset($data[$key]['jucl_client_id']);
                unset($data[$key]['jugo_goo_id']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = '旧货回收' . time() . rand(1000, 9999) . '.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '旧货回收';
        $where['field_name'] = ['回收单号', '订单单号', '速电单号', '服务技师', '记录人', '旧货来源', '回收状态', '回收总数量', '回收总金额', '仓库名称', '买家类型', '客户单位', '姓名', '联系电话', '日期', '备注', '检索编码', '商品名称', '商品结算金额', '商品回收数量', '商品备注'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 详情打印
    public function infoPrint(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 获取回收单数据
        $find_junk = DB::table('junk_recycle as jur')
            ->leftJoin('admin as adm', 'adm.adm_id', '=', 'jur.jur_create_adm_id')
            ->leftJoin('print_number as prnu', 'prnu.prnu_original_id', 'jur.jur_id')
            ->where('jur_id', $request['jur_id'])
            ->select('adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_wor_number', 'jur_ord_order_number', 'jur_service_adm_id', 'prnu_print_num')
            ->first();
        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }
        // 查询出客户单位名称 客户姓名 联系电话
        $client = DB::table('junk_client')
            ->where('jucl_jur_id', $request['jur_id'])
            ->select('jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jucl_client_id')
            ->first();
        // 查询客户单位名称
        $find_junk->jucl_channel_unit = DB::table('channel_unit')
            ->where('chun_id', $client->jucl_client_id)
            ->value('chun_unit_name');
        unset($find_junk->jucl_client_id);
        $find_junk->jucl_name = $client->jucl_name;
        $find_junk->jucl_phone = $client->jucl_phone;
        // 查询出仓位
        $find_junk->ware_freight_space = DB::table('warehouse')
            ->where('ware_id', $find_junk->jur_ware_id)
            ->value('ware_freight_space');

        // 获取商品数据
        $find_goods = DB::table('junk_goods as jugo')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
            ->where('jugo_jur_id', $request['jur_id'])
            ->select('jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_remark', 'goo_bra_name', 'goo_brse_id', 'goo_class')
            ->get()->toArray();
        // 查询系列数据
        $goo_brse_id = array_column($find_goods, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        foreach ($find_goods as $key => $value) {
            // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                if (!empty($value->goo_brse_id)) {
                    if ($value->goo_class == 2) {
                        $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        }
                    }
                }
            }
            // 显示品牌名称
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                if ($value->goo_class == 2) {
                    $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                } else {
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                        $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    }
                }
            }
            unset($find_goods[$key]->goo_brse_id);
        }

        // 查询业务负责人
        $find_junk->chun_adm_name = DB::table('channel_unit')
            ->where('chun_id', $client->jucl_client_id)
            ->value('chun_adm_id');
        // 获取采购商(仓库负责人)/创建人
        $adm_id = [$find_junk->chun_adm_name];
        $adm_id = array_filter($adm_id);
        $find_admin = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_id', 'adm_name', 'adm_phone')
            ->get()->toArray();
        $adm_name = array_column($find_admin, null, 'adm_id');
        if (isset($adm_name[$find_junk->chun_adm_name]->adm_phone)) {
            $find_junk->chun_adm_phone = $find_junk->chun_adm_name ? $adm_name[$find_junk->chun_adm_name]->adm_phone : ''; //业务员联系电话
            $find_junk->chun_adm_name = $find_junk->chun_adm_name ? $adm_name[$find_junk->chun_adm_name]->adm_name : ''; //业务员
        } else {
            $find_junk->chun_adm_phone = ''; //业务员联系电话
            $find_junk->chun_adm_name = '';
        }

        $data['junk_data'] = $find_junk;
        $data['goods_data'] = $find_goods;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 打印次数提交,更新备注
    public function infoPrintNumber(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->printNumberValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 判断是否有打印数据
        $prnu_id = DB::table('print_number')
            ->where('prnu_adm_cid', $user_info->adm_cid)
            ->where('prnu_superior_shop_id', $shop_id)
            ->where('prnu_type', 5)
            ->where('prnu_original_id', $request['jur_id'])
            ->select('prnu_id', 'prnu_print_num')
            ->first();

        $prnu_data['prnu_adm_cid'] = $user_info->adm_cid;   //公司id
        $prnu_data['prnu_shop_id'] = $user_info->adm_shop_id;   //所属门店id
        $prnu_data['prnu_superior_shop_id'] = $shop_id;   //所属总店id
        $prnu_data['prnu_type'] = 5;   //所属类型
        $prnu_data['prnu_original_id'] = $request['jur_id'];   //旧货回收单id
        $prnu_data['prnu_update_time'] = date('Y-m-d H:i:s');
        DB::beginTransaction();
        if ($prnu_id) {
            $prnu_data['prnu_print_num'] = $prnu_id->prnu_print_num + 1;   //打印次数
            $prnu_res = DB::table('print_number')
                ->where('prnu_original_id', $request['jur_id'])
                ->update($prnu_data);
        } else {
            $prnu_data['prnu_print_num'] = 1;   //打印次数
            $prnu_res = DB::table('print_number')->insert($prnu_data);
        }

        // 判断是否存储了缓存：存储了更新,没有存储新增
        $prca_id = DB::table('print_cache')
            ->where('prca_create_adm_id', $user_info->adm_id) //创建人id
            ->where('prca_type', 5) //类型5旧货回收单
            ->value('prca_id');
        $prca_data['prca_com_name'] = $request['prca_com_name'] ? $request['prca_com_name'] : ''; //公司名称
        $prca_data['prca_serve_provider'] = $request['prca_serve_provider'] ? $request['prca_serve_provider'] : ''; //服务提供商
        $prca_data['prca_serve_order'] = $request['prca_serve_order'] ? $request['prca_serve_order'] : ''; //打印单的类型
        $prca_data['prca_type'] = 5; //类型5旧货回收单
        $prca_data['prca_update_time'] = date('Y-m-d H:i:s'); //更新时间

        if (empty($prca_id)) {
            // 新增
            $prca_data['prca_cid'] = $user_info->adm_cid; //公司id
            $prca_data['prca_shop_id'] = $user_info->adm_shop_id; //门店id
            $prca_data['prca_superior_shop_id'] = $shop_id; //所属总店id
            $prca_data['prca_create_adm_id'] = $user_info->adm_id; //创建人id
            $prca_data['prca_type'] = 5; //类型5旧货回收单
            $prca_res = DB::table('print_cache')->insert($prca_data);
        } else {
            // 更新
            $prca_res = DB::table('print_cache')
                ->where('prca_id', $prca_id)
                ->update($prca_data);
        }

        if ($prnu_res && $prca_res) {
            DB::commit();
            $jur_number = DB::table('junk_recycle')->where('jur_id', $request['jur_id'])->value('jur_number');
            Common::addLog($user_info, getRealIp($request), '旧货回收', '打印', $jur_number . '打印成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'打印成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'打印失败']);
        }
    }

    // 撤销(打开多个界面,会出现重复数据)
    public function revocation(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRecyclingController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取回收单数据
        $find_junk = DB::table('junk_recycle as a')
            ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
            ->leftJoin('junk_client as jucl', 'jucl.jucl_jur_id', '=', 'a.jur_id')
            ->where('jur_id', $request['jur_id'])
            ->select('adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_ord_id', 'jur_ord_order_number', 'jur_wor_number', 'jur_service_adm_id', 'jur_type', 'jur_waon_class', 'jucl_client_id', 'jur_add_type')
            ->first();
        if (empty($find_junk)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
        }
        if ($find_junk->jur_add_type != 3 || $find_junk->jur_state != 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单尚未回收,无法撤销']);
        }
        // 判断工单是否审核
        if (!empty($find_junk->jur_wor_id)) {
            // 判断工单是否审核,未审核可以撤回
            $find_wor_state = DB::table('work_order')
                ->where('wor_id', $find_junk->jur_wor_id)
                ->value('wor_state');
            if ($find_wor_state != 8) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前工单不是未审核状态,无法撤销']);
            }
        }
        if (!empty($find_junk->jur_ord_id) && empty($find_junk->jur_wor_id)) {
            // 判断该订单是否结算
            $find_ord_state = DB::table('order')
                ->where('ord_id', $find_junk->jur_ord_id)
                ->value('ord_state');
            if ($find_ord_state != 1) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单不是未结算状态,无法撤销']);
            }
        }
        DB::beginTransaction();
        // 查询旧货回收商品信息
        $find_junk_goods = DB::table('junk_goods')
            ->where('jugo_jur_id', $request['jur_id'])
            ->get()->toArray();
        $find_junk_goods = json_decode(json_encode($find_junk_goods), true);
        $jugo_goo_id = array_column($find_junk_goods, 'jugo_goo_id');
        $orgo_id = array_column($find_junk_goods, 'jugo_orgo_id');
        $wogo_id = array_column($find_junk_goods, 'jugo_wogo_id');
        $goods_number_sum = 0;
        $recycle_all_price = 0; //回收商品总金额
        foreach ($find_junk_goods as $key => $value) {
            // 记录仓库商品表 所有要做修改的商品id 及其对应的数量
            $goods_data[$value['jugo_goo_id']] = $value['jugo_recycle_number'];

            // 出入库记录需要的的商品数组
            $oure_goods_data[$value['jugo_goo_id']]['goo_quantity'] = $value['jugo_recycle_number']; //出入库商品数量
            $oure_goods_data[$value['jugo_goo_id']]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1

            // 出入库记录需要
            $oure_goods_id[$value['jugo_goo_id']] = $value['jugo_goo_id']; //出入库商品id
            $oure_goods_quantity[$value['jugo_goo_id']] = $value['jugo_recycle_number']; //出入库商品数量
            // 临时仓的默认到待还回(良品库存)
            // 旧货仓的默认到废旧品(优先库存)
            if ($find_junk->jur_waon_class == 3) {
                // 旧货仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 2; //出入库商品类型，类型1良品2优先
            } else {
                // 临时仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 1; //出入库商品类型，类型1良品2优先
            }

            // 记录总入库商品数量
            $goods_number_sum =  $goods_number_sum + $value['jugo_recycle_number'];

            // 回收商品总金额
            $recycle_all_price += $value['jugo_goo_price'] * $value['jugo_recycle_number']; //回收商品总金额
        }

        if ($find_junk->jur_ord_id != 0) {
            // 先查询出订单回收的商品id
            $find_orgo_goo_id = DB::table('order_goods')
                ->where('orgo_ord_id', $find_junk->jur_ord_id)
                ->where('orgo_ware_id', $find_junk->jur_ware_id)
                ->where('orgo_waon_class', $find_junk->jur_waon_class)
                ->where('orgo_state', 3)
                ->select('orgo_goo_id')
                ->get()->toArray();
            $find_orgo_goo_id = array_column($find_orgo_goo_id, 'orgo_goo_id');
            if (empty($find_orgo_goo_id)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'撤销失败1']);
            }

            // 根据订单id,查询出订单回收商品信息,并删除
            $del_orgo_res = DB::table('order_goods')
                ->where('orgo_ord_id', $find_junk->jur_ord_id)
                ->where('orgo_ware_id', $find_junk->jur_ware_id)
                ->where('orgo_waon_class', $find_junk->jur_waon_class)
                ->whereIn('orgo_goo_id', $find_orgo_goo_id)
                ->whereIn('orgo_id', $orgo_id)
                ->where('orgo_state', 3)
                ->delete();
            // 修改订单结算金额
            $ord_actual_price = DB::table('order')
                ->where('ord_id', $find_junk->jur_ord_id)
                ->select('ord_actual_price', 'ord_plus_minus')
                ->first();
            if ($ord_actual_price->ord_plus_minus == '1') {
                $actual_price = $ord_actual_price->ord_actual_price + $recycle_all_price;
            } else {
                $actual_price = $recycle_all_price - $ord_actual_price->ord_actual_price;
            }
            if ($actual_price < 0) {
                $update_ord_data['ord_plus_minus'] = 2;
                $recr_data['recr_plus_minus'] = 2;
            } else {
                $update_ord_data['ord_plus_minus'] = 1;
                $recr_data['recr_plus_minus'] = 1;
            }
            $update_ord_data['ord_actual_price'] = abs($actual_price);
            $update_ord_data['ord_update_time'] = date('Y-m-d H:i:s');
            // 调整订单
            $update_ord_res = DB::table('order')
                ->where('ord_id', $find_junk->jur_ord_id)
                ->update($update_ord_data);
            // 调整应收应付的金额
            $recr_data['recr_settle_price'] = abs($actual_price);
            $recr_data['recr_actual_price'] = abs($actual_price);
            $recr_data['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_shop_id', $shop_id)
                ->where('recr_original_id', $find_junk->jur_ord_id)
                ->where('recr_original_number', $find_junk->jur_ord_order_number)
                ->whereIn('recr_account_type', [1, 10])
                ->update($recr_data);
            if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
                // 查询凭证单据是否同步U8
                $find_vore_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $user_info->adm_cid)
                    ->where('vore_superior_shop_id', $shop_id)
                    ->where('vore_shop_id', $user_info->adm_shop_id)
                    ->where('vore_order_type', 1)
                    ->where('vore_ord_id', $find_junk->jur_ord_id)
                    ->where('vore_ord_number', $find_junk->jur_ord_order_number)
                    ->select('vore_state', 'vore_id')
                    ->first();
                if (!empty($find_vore_id)) {
                    if ($find_vore_id->vore_state == 1) {
                        $vore_data['vore_recycle_price'] = 0;
                        $vore_data['vore_update_time'] = date('Y-m-d H:i:s');
                        $vore_res = DB::table('voucher_receipts')
                            ->where('vore_cid', $user_info->adm_cid)
                            ->where('vore_superior_shop_id', $shop_id)
                            ->where('vore_shop_id', $user_info->adm_shop_id)
                            ->where('vore_order_type', 1)
                            ->where('vore_ord_id', $find_junk->jur_ord_id)
                            ->where('vore_ord_number', $find_junk->jur_ord_order_number)
                            ->update($vore_data);
                        $volo_res = DB::table('voucher_loan')
                            ->where('volo_shop_id', $user_info->adm_shop_id)
                            ->where('volo_vore_id', $find_vore_id->vore_id)
                            ->where('volo_loan_subject', 0)
                            ->where('volo_loan_subject_name', '')
                            ->delete();
                        if (!$vore_res || !$volo_res) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败4']);
                        }
                    } else {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前凭证已同步U8']);
                    }
                }
            }
        } else {
            $update_ord_res = true;
            $recr_res = true;
        }
        if ($find_junk->jur_wor_id != 0) {
            // 先查询出工单回收的商品id
            $find_wogo_goo_id = DB::table('work_good')
                ->where('wogo_wor_id', $find_junk->jur_wor_id)
                ->where('wogo_ware_id', $find_junk->jur_ware_id)
                ->where('wogo_waon_class', $find_junk->jur_waon_class)
                ->where('wogo_state', 3)
                ->select('wogo_goo_id')
                ->get()->toArray();
            $find_wogo_goo_id = array_column($find_wogo_goo_id, 'wogo_goo_id');
            if (empty($find_wogo_goo_id)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'撤销失败2']);
            }

            // 根据订单id,判断订单类型是否为发货单
            $ord_service_type = DB::table('order')
                ->where('ord_id', $find_junk->jur_ord_id)
                ->value('ord_service_type');
            if ($ord_service_type != 5 && $ord_service_type != 4) {
                // 根据工单id,查询出工单回收商品信息,并删除
                $del_wogo_res = DB::table('work_good')
                    ->where('wogo_wor_id', $find_junk->jur_wor_id)
                    ->where('wogo_ware_id', $find_junk->jur_ware_id)
                    ->where('wogo_waon_class', $find_junk->jur_waon_class)
                    ->whereIn('wogo_goo_id', $find_wogo_goo_id)
                    ->whereIn('wogo_id', $wogo_id)
                    ->where('wogo_state', 3)
                    ->delete();
                // 修改工单结算金额
                $wor_actual_price = DB::table('work_order')
                    ->where('wor_id', $find_junk->jur_wor_id)
                    ->select('wor_actual_price', 'wor_plus_minus')
                    ->first();
                if ($wor_actual_price->wor_plus_minus == '1') {
                    $actual_price = $wor_actual_price->wor_actual_price + $recycle_all_price;
                } else {
                    $actual_price = $recycle_all_price - $wor_actual_price->wor_actual_price;
                }
                if ($actual_price < 0) {
                    $update_wor_data['wor_plus_minus'] = 2;
                } else {
                    $update_wor_data['wor_plus_minus'] = 1;
                }
                $update_wor_data['wor_actual_price'] = abs($actual_price);
                $update_wor_data['wor_update_time'] = date('Y-m-d H:i:s');
                $update_wor_res = DB::table('work_order')
                    ->where('wor_id', $find_junk->jur_wor_id)
                    ->update($update_wor_data);
                if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
                    // 查询凭证单据是否同步U8
                    $find_vore_id = DB::table('voucher_receipts')
                        ->where('vore_cid', $user_info->adm_cid)
                        ->where('vore_superior_shop_id', $shop_id)
                        ->where('vore_shop_id', $user_info->adm_shop_id)
                        ->where('vore_order_type', 1)
                        ->where('vore_ord_id', $find_junk->jur_wor_id)
                        ->where('vore_ord_number', $find_junk->jur_wor_number)
                        ->select('vore_state', 'vore_id')
                        ->first();
                    if (!empty($find_vore_id)) {
                        if ($find_vore_id->vore_state == 1) {
                            $vore_data['vore_recycle_price'] = 0;
                            $vore_data['vore_update_time'] = date('Y-m-d H:i:s');
                            $vore_res = DB::table('voucher_receipts')
                                ->where('vore_cid', $user_info->adm_cid)
                                ->where('vore_superior_shop_id', $shop_id)
                                ->where('vore_shop_id', $user_info->adm_shop_id)
                                ->where('vore_order_type', 1)
                                ->where('vore_ord_id', $find_junk->jur_wor_id)
                                ->where('vore_ord_number', $find_junk->jur_wor_number)
                                ->update($vore_data);
                            $volo_res = DB::table('voucher_loan')
                                ->where('volo_shop_id', $user_info->adm_shop_id)
                                ->where('volo_vore_id', $find_vore_id->vore_id)
                                ->delete();
                            if (!$vore_res || !$volo_res) {
                                DB::rollBack();
                                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败4']);
                            }
                        } else {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前凭证已同步U8']);
                        }
                    }
                }
            } else {
                $update_wor_res = true;
            }
        } else {
            $update_wor_res = true;
        }

        // 删除应收应付
        if (empty($find_junk->jur_ord_id) && empty($find_junk->jur_wor_id)) {
            // 删除应收应付
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_shop_id', $shop_id)
                ->where('recr_type', 13)
                ->where('recr_account_type', 16)
                ->where('recr_original_id', $request['jur_id'])
                ->where('recr_original_number', $find_junk->jur_number)
                ->delete();
            // 删除结款明细
            $acset_res = DB::table('accounting_settlement')
                ->where('acset_adm_cid', $user_info->adm_cid)
                ->where('acset_superior_shop_id', $shop_id)
                ->where('acset_shop_id', $shop_id)
                ->where('acset_type', 19)
                ->where('acset_original_id', $request['jur_id'])
                ->where('acset_original_number', $find_junk->jur_number)
                ->delete();
        }

        // 3 回收单表 修改 回收仓库/备注/回收数量/金额/回收状态
        $update_recycle['jur_state'] = 1; //回收状态 1.未回收 2.已回收 3不回收
        $update_recycle['jur_add_type'] = 2; //新增回收状态1回收入库2审核3已审核
        $update_recycle['jur_update_time'] = date("Y-m-d H:i:s"); //更新时间
        $junk_recycle = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($update_recycle);

        // 查询仓位数据 数量仓位名称商品类型
        $find_wfog_data = DB::table('warehouse_freight_outin_goods')
            ->where('wfog_original_id', $request['jur_id'])
            ->where('wfog_outin_type', 2)
            ->where('wfog_isdel', 1)
            ->select('wfog_wafr_id', 'wfog_stock_amount', 'wfog_stock_type', 'wfog_goo_id')
            ->get()->toArray();
        $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
        if (!empty($find_wfog_data)) {
            foreach ($find_wfog_data as $key => $value) {
                // 仓位商品表库存减少
                if ($value['wfog_stock_type'] == 2) { //优先库存
                    // 仓位商品表优先库存减少
                    $wafg_priority_stock_number = DB::table('warehouse_freight_goods')
                        ->where('wafg_wafr_id', $value['wfog_wafr_id'])
                        ->where('wafg_class', $find_junk->jur_waon_class)
                        ->where('wafg_goo_id', $value['wfog_goo_id'])
                        ->value('wafg_priority_stock_number');
                    $wafg_priority_stock_number = $wafg_priority_stock_number - $value['wfog_stock_amount'];
                    if ($wafg_priority_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位库存优先数量不足']);
                    }
                    $wafg_decr = DB::table('warehouse_freight_goods')
                        // ->where('wafg_ware_id', $request['jur_ware_id'])
                        ->where('wafg_wafr_id', $value['wfog_wafr_id'])
                        ->where('wafg_class', $find_junk->jur_waon_class)
                        ->where('wafg_goo_id', $value['wfog_goo_id'])
                        ->decrement('wafg_priority_stock_number', $value['wfog_stock_amount']);

                    // 仓库商品表仓位优先库存（仓库+仓位）减少
                    $wago_priority_stock_number = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->value('wago_priority_stock_number');
                    $wago_priority_stock_number = $wago_priority_stock_number - $value['wfog_stock_amount'];
                    if ($wago_priority_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'库存（仓库+仓位）优先数量不足']);
                    }
                    $wogo_decr = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->decrement('wago_priority_stock_number', $value['wfog_stock_amount']);

                    // 仓库商品表仓位优先库存减少
                    $wago_freight_priority_stock_number = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->value('wago_freight_priority_stock_number');
                    $wago_freight_priority_stock_number = $wago_freight_priority_stock_number - $value['wfog_stock_amount'];
                    if ($wago_freight_priority_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位优先库存数量不足']);
                    }
                    $wogo_decrs = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->decrement('wago_freight_priority_stock_number', $value['wfog_stock_amount']);

                    // 仓位表仓位优先库存减少
                    $wafr_priority_all_stock = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfog_wafr_id'])
                        ->value('wafr_priority_all_stock');
                    $wafr_priority_all_stock = $wafr_priority_all_stock - $value['wfog_stock_amount'];
                    if ($wafr_priority_all_stock < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位优先库存数量不足']);
                    }
                    // 仓位表仓位优先库存减少
                    $wafr_update_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfog_wafr_id'])
                        ->decrement('wafr_priority_all_stock', $value['wfog_stock_amount']);
                } else {
                    // 仓位商品表良品库存减少
                    $wafg_stock_number = DB::table('warehouse_freight_goods')
                        ->where('wafg_wafr_id', $value['wfog_wafr_id'])
                        ->where('wafg_class', $find_junk->jur_waon_class)
                        ->where('wafg_goo_id', $value['wfog_goo_id'])
                        ->value('wafg_stock_number');
                    $wafg_stock_number = $wafg_stock_number - $value['wfog_stock_amount'];
                    if ($wafg_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位库存良品数量不足']);
                    }
                    $wafg_decr = DB::table('warehouse_freight_goods')
                        // ->where('wafg_ware_id', $request['jur_ware_id'])
                        ->where('wafg_wafr_id', $value['wfog_wafr_id'])
                        ->where('wafg_class', $find_junk->jur_waon_class)
                        ->where('wafg_goo_id', $value['wfog_goo_id'])
                        ->decrement('wafg_stock_number', $value['wfog_stock_amount']);

                    // 仓库商品表仓位良品库存（仓库+仓位）减少
                    $wago_stock_number = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->value('wago_stock_number');
                    $wago_stock_number = $wago_stock_number - $value['wfog_stock_amount'];
                    if ($wago_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'（仓库+仓位）库存良品数量不足']);
                    }
                    $wogo_decr = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->decrement('wago_stock_number', $value['wfog_stock_amount']);

                    // 仓库商品表仓位良品库存减少
                    $wago_freight_stock_number = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->value('wago_freight_stock_number');
                    $wago_freight_stock_number = $wago_freight_stock_number - $value['wfog_stock_amount'];
                    if ($wago_freight_stock_number < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位库存良品数量不足']);
                    }
                    $wogo_decrs = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_junk->jur_ware_id)
                        ->where('wago_class', $find_junk->jur_waon_class)
                        ->where('wago_goo_id', $value['wfog_goo_id'])
                        ->decrement('wago_freight_stock_number', $value['wfog_stock_amount']);
                    // 仓位表仓位良品库存减少
                    $wafr_all_stock = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfog_wafr_id'])
                        ->value('wafr_all_stock');
                    $wafr_all_stock = $wafr_all_stock - $value['wfog_stock_amount'];
                    if ($wafr_all_stock < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位良品库存数量不足']);
                    }
                    // 仓位表仓位优先库存减少
                    $wafr_update_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfog_wafr_id'])
                        ->decrement('wafr_all_stock', $value['wfog_stock_amount']);
                }
                $update_wfog_data = DB::table('warehouse_freight_outin_goods')
                    ->where('wfog_original_id', $request['jur_id'])
                    ->where('wfog_wafr_id', $value['wfog_wafr_id'])
                    ->where('wfog_goo_id', $value['wfog_goo_id'])
                    ->where('wfog_outin_type', 2)
                    ->update(['wfog_isdel' => 2, 'wfog_update_time' => date('Y-m-d H:i:s')]);
                $primary_id = DB::table('junk_goods')
                    ->where('jugo_jur_id', $request['jur_id'])
                    ->where('jugo_goo_id', $value['wfog_goo_id'])
                    ->value('jugo_id');

                // 仓位出入库记录 出库记录
                $out_recore_res = Stocktake::junkaddition(
                    $user_info,
                    $find_junk->jur_ware_id, //仓库id
                    $find_junk->jur_waon_class, //仓库类型
                    $value['wfog_wafr_id'], //仓位id
                    5, //旧货回收
                    $request['jur_id'], //原始单id
                    $find_junk->jur_number, //原始单单号
                    $primary_id, //关联商品表主键id
                    $value['wfog_goo_id'], //商品表主键id
                    1, //出入库类型：1出库2入库
                    $value['wfog_stock_amount'], //商品数量
                    $inventory = $find_junk->jur_waon_class == 3 ? 2 : 1 //仓库类别3旧货仓 出库类型1良品2优先3待检测
                );
                if ($out_recore_res['code'] == 500 || !$wogo_decrs || !$wogo_decr || !$wafg_decr || !$update_wfog_data || !$wafr_update_res) {
                    DB::rollBack();
                    return response()->json(['code'=>5001, 'msg'=>'error', 'data'=>'撤销失败4']);
                }
            }
        }
        if (!empty($find_junk_goods) && empty($find_wfog_data)) {
            // 4. 仓库商品表
            // 4.1 查询旧货仓库类表的商品库存数量
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_junk->jur_ware_id)
                ->where('wago_class', $find_junk->jur_waon_class)
                ->whereIn('wago_goo_id', $jugo_goo_id)
                ->get(['wago_id', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number'])
                ->toArray();
            if (empty($warehouse_goods)) {
                $ware_edit_res = true;
            } else {
                // 4.2 仓库商品表中已存在的商品，更改库存数量，整理更改SQL语句
                $sql = 'UPDATE `faster_warehouse_goods` SET ';
                $stock_number_sql = '';
                $update_time_sql = '';
                $ids = '';
                foreach ($warehouse_goods as $key => $value) {
                    // 更改商品库存数量
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $value->wago_id;
                    if ($find_junk->jur_waon_class == 3) {
                        $stock_number_sql = $stock_number_sql . ' THEN wago_priority_stock_number - ' . $goods_data[$value->wago_goo_id];
                    } else {
                        $stock_number_sql = $stock_number_sql . ' THEN wago_stock_number - ' . $goods_data[$value->wago_goo_id];
                    }
                    // 更改时间
                    $update_time_sql = $update_time_sql . ' WHEN ' . $value->wago_id;
                    $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $value->wago_id . ',';
                    // 删除已更改的商品数据
                    unset($goods_data[$value->wago_goo_id]);
                }
                // 临时仓的默认到待还回(良品库存)
                // 旧货仓的默认到废旧品(优先库存)
                if ($find_junk->jur_waon_class == 3) {
                    // 旧货仓
                    $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
                } else {
                    // 临时仓
                    $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
                }
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $ware_edit_res = DB::update($sql);
            }
        }

        // 5.修改仓库表 总库存量
        if ($find_junk->jur_waon_class == 3) {
            $waon_stock_priority_amount = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $find_junk->jur_ware_id)
                ->where('waon_class', $find_junk->jur_waon_class)
                ->value('waon_stock_priority_amount');
            $num = $waon_stock_priority_amount - $goods_number_sum;
            if ($num < 0) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'库存数量不足']);
            }
            $stock_amount_res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $find_junk->jur_ware_id)
                ->where('waon_class', $find_junk->jur_waon_class)
                ->decrement('waon_stock_priority_amount', $goods_number_sum);
        } else {
            $waon_stock_fine_amount = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $find_junk->jur_ware_id)
                ->where('waon_class', $find_junk->jur_waon_class)
                ->value('waon_stock_fine_amount');
            $num = $waon_stock_fine_amount - $goods_number_sum;
            if ($num < 0) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'库存数量不足']);
            }
            $stock_amount_res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $find_junk->jur_ware_id)
                ->where('waon_class', $find_junk->jur_waon_class)
                ->decrement('waon_stock_fine_amount', $goods_number_sum);
        }
        $all_amount = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_junk->jur_ware_id)
            ->where('waon_class', $find_junk->jur_waon_class)
            ->value('waon_all_amount');
        $all_amount = $all_amount - $goods_number_sum;
        if ($all_amount < 0) {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'库存数量不足']);
        }
        $all_amount_res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_junk->jur_ware_id)
            ->where('waon_class', $find_junk->jur_waon_class)
            ->decrement('waon_all_amount', $goods_number_sum);

        $find_ware = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_junk->jur_ware_id)
            ->where('waon_class', $find_junk->jur_waon_class)
            ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
            ->first();

        // 
        $osld_out_key = 0;
        foreach ($find_junk_goods as $key => $value) {
            // 临时仓的默认到待还回(良品库存)
            // 旧货仓的默认到废旧品(优先库存)
            if ($find_junk->jur_waon_class == 3) {
                // 旧货仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 2; //出入库商品类型，类型1良品2优先
            } else {
                // 临时仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 1; //出入库商品类型，类型1良品2优先
            }

            // 记录总入库商品数量
            $goods_number_sum =  $goods_number_sum + $value['jugo_recycle_number'];

            // 库存锁定-出入库记录表
            $osld_goo_data[$osld_out_key]['goo_waon_class'] = $find_junk->jur_waon_class; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            $osld_goo_data[$osld_out_key]['goo_id'] = $value['jugo_goo_id']; //商品id
            $osld_goo_data[$osld_out_key]['goo_number'] = $value['jugo_recycle_number']; //商品数量
            $osld_goo_data[$osld_out_key]['goo_out_in_type'] = 2; //出入库类型：1出库2入库3锁定4取消锁定
            $osld_goo_data[$osld_out_key]['goo_inventory'] = $oure_goods_inventory[$value['jugo_goo_id']]; //类型1良品2优先3待检测
            // 查询仓库商品库存数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_junk->jur_ware_id)
                ->where('wago_class', $find_junk->jur_waon_class)
                ->where('wago_goo_id', $value['jugo_goo_id'])
                ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
            if ($oure_goods_inventory[$value['jugo_goo_id']] == 1) { //良品
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number + $value['jugo_recycle_number']; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
            } else { //优先
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number + $value['jugo_recycle_number']; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
            }
            $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
            $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
            $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
            $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
            $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
            $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            $osld_goo_data[$osld_out_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $osld_goo_data[$osld_out_key] = (object)$osld_goo_data[$osld_out_key];
            $osld_out_key++;
        }
        // 新增一条出库记录
        if (!empty($find_junk->jur_ord_id)) {
            $oure_res = OutinRecord::addition(
                $user_info, //用户信息
                $find_junk->jur_ord_id, //原始单的关联id
                $find_junk->jur_ord_order_number, //原始单的关联单号
                1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                $find_junk->jur_number, //原始单号，旧货回收单单号
                0, //入库仓库id
                $find_junk->jur_ware_id, //出库仓库id
                $find_junk->jur_amount, //出库的商品总数量
                4, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2, //操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $find_junk->jur_waon_class, //仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory //出库类型1良品2优先
            );
            // 库存锁定-出入库记录
            $oslr_res = OutinStockLock::addition(
                $user_info, //用户信息
                $find_junk->jur_ord_id, //原始单的关联id
                $find_junk->jur_ord_order_number, //原始单的关联单号
                1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                $find_junk->jur_number, //原始单号
                $find_junk->jur_ware_id, //出库/入库的仓库id
                $find_junk->jur_amount, //出库/入库总数量
                4, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $osld_goo_data
            );
            unset($osld_goo_data);
        } else {
            $oure_res = OutinRecord::addition(
                $user_info, //用户信息
                $request['jur_id'], //原始单的关联id
                $find_junk->jur_number, //原始单的关联单号
                5, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                $find_junk->jur_number, //原始单号，旧货回收单单号
                0, //入库仓库id
                $find_junk->jur_ware_id, //出库仓库id
                $find_junk->jur_amount, //出库的商品总数量
                4, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2, //操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $find_junk->jur_waon_class, //仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory //出库类型1良品2优先
            );
            // 库存锁定-出入库记录
            $oslr_res = OutinStockLock::addition(
                $user_info, //用户信息
                $request['jur_id'], //原始单的关联id
                $find_junk->jur_number, //原始单的关联单号
                5, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
                $find_junk->jur_number, //原始单号
                $find_junk->jur_ware_id, //出库/入库的仓库id
                $find_junk->jur_amount, //出库/入库总数量
                4, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $osld_goo_data
            );
            unset($osld_goo_data);
        }

        // 删除对应的订单商品仓位表数据
        $del_orgf_res = DB::table('order_goods_freight')
            ->where('orgf_shop_id', $user_info->adm_shop_id)
            ->where('orgf_original_id', $request['jur_id'])
            ->where('orgf_delete', 1)
            ->update(['orgf_delete' => 2, 'orgf_update_time' => date('Y-m-d H:i:s')]);

        if ($junk_recycle && $update_ord_res && $update_wor_res && $stock_amount_res && $all_amount_res && $del_orgf_res) {
            // 删除原来的进销存记录->高献昌
            if ($find_junk->jur_ord_id == '0') {
                $ense_order_number = $find_junk->jur_number;
            } else {
                $ense_order_number = $find_junk->jur_ord_order_number;
            }
            $enterres = DB::table('enters_sells_saves')
                ->where('ense_order_number', $ense_order_number)
                ->where('ense_out_in', '2')
                ->where('ense_type', '4')
                ->delete();
            Common::addLog($user_info, getRealIp($request), '旧货回收', '撤销', '撤销 旧货回收单：' . $find_junk->jur_number . '成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'撤销成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'撤销失败3']);
        }
    }
}
