<?php

namespace App\Http\Controllers\Api\YongYou;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

/**
 * 用友U8财务系统
 * U8版本2.7
 */
class YongYouController extends Controller
{
    protected $api_function = [
            '会计科目查询'=>'uapbdAccsubjQuery',
            '会计科目新增'=>'uapbdAccsubjInsert',
            '会计科目从公司新增'=>'uapbdAccsubjforcorpInsert',
            '凭证查询'=>'glVoucherPagequery',
            '凭证新增'=>'glVoucherInsert',
            '凭证作废'=>'glVoucherAbandon',
            '币种档案查询'=>'uapbdBdcurrtypeQuery',
            '人员档案查询'=>'uapbdBdpsnQuery',
            '客商基本档案查询'=>'uapbdCustdocQuery',
            '客商基本档案新增'=>'uapbdCustdocInsert',
            '客商基本档案分配'=>'uapbdCustdocAssign',
            '地区分类查询'=>'uapbdBdareaclQuery',
            '公司档案查询'=>'uapbdBdcorpQuery',
        ];
    protected $u8cloud_api = [
            '会计科目查询'=>'/u8cloud/api/uapbd/accsubj/query',
            '会计科目新增'=>'/u8cloud/api/uapbd/accsubj/insert',
            '会计科目从公司新增'=>'/u8cloud/api/uapbd/accsubjforcorp/insert',
            '凭证查询'=>'/u8cloud/api/gl/voucher/pagequery',
            '凭证新增'=>'/u8cloud/api/gl/voucher/insert',
            '凭证作废'=>'/u8cloud/api/gl/voucher/abandon',
            '币种档案查询'=>'/u8cloud/api/uapbd/bdcurrtype/query',
            '人员档案查询'=>'/u8cloud/api/uapbd/bdpsn/query',
            '客商基本档案查询'=>'/u8cloud/api/uapbd/custdoc/query',
            '客商基本档案新增'=>'/u8cloud/api/uapbd/custdoc/insert',
            '客商基本档案分配'=>'/u8cloud/api/uapbd/custdoc/assign',
            '地区分类查询'=>'/u8cloud/api/uapbd/bdareacl/query',
            '公司档案查询'=>'/u8cloud/api/uapbd/bdcorp/query',
        ];
	// 测试
    public function test(Request $request)
    {
    	$api_function_name = $this->api_function[$request['api_function']];//调用方法名称
        $url = config('apiu8cloud.U8CLOUD_SERVER_IP').$this->u8cloud_api[$request['api_function']];//用友api接口地址
    	dump($url);
    	$res = $this->$api_function_name($url, $request->all());
    	dump($res);
        // 123.57.163.50:8088
        // 'usercode: test',
        // 'password: 59f2443a4317918ce29ad28a14e1bdb7',
        // 'system: gylu8',
    }

    // 用友u8cloud系统api接口
    public function u8cloudApi($function_name, $request)
    {
        $api_function_name = $this->api_function[$function_name];//调用方法名称
        $url = config('apiu8cloud.U8CLOUD_SERVER_IP').$this->u8cloud_api[$function_name];//用友api接口地址
        $return_data = $this->$api_function_name($url, (array)$request);
        return $return_data;
    }

    // 公司档案查询
    private function uapbdBdcorpQuery($url, $request)
    {
        // 公司档案查询
        $param['page_now'] = '1';//否 当前页
        $param['page_size'] = '10';//否 每页条数

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'undefined');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 会计科目查询
    private function uapbdAccsubjQuery($url, $request)
    {
        // 会计科目查询
        // $param['page_now'] = '1';//否 当前页
        // $param['page_size'] = '10';//否 每页条数
        // $param['pk_subjscheme'] = '0003';//是 会计方案（科目方案），会计科目编码
        $param['glorgbookcode'] = $request['unitcode'].'-'.$request['subjschemecode'];//否 会计主体账簿编码
        $param['pk_subjscheme'] = $request['subjschemecode'];//是 会计方案（科目方案），会计科目编码
        $param['subjcode'] = isset($request['subjcode']) ? $request['subjcode'] : '';//否 会计科目编码
        $param['subjname'] = isset($request['subjname']) ? $request['subjname'] : '';//否 会计科目名称

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'undefined');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 会计科目新增
    private function uapbdAccsubjInsert($url, $request)
    {
        // 会计科目新增
        // $param['billvo']['accsubjParentVO']['pk_corp'] = '0001';//否 公司编码
        $param['billvo']['accsubjParentVO']['currency'] = 'CNY';//否 科目默认币种
        // $param['billvo']['accsubjParentVO']['pk_glorgbook'] = '0003';//否    会计主体账簿
        // $param['billvo']['accsubjParentVO']['pk_subjscheme'] = '4-2-2-2';//科目方案
        $param['billvo']['accsubjParentVO']['pk_subjscheme'] = '0003';//科目方案
        $param['billvo']['accsubjParentVO']['subjtypename'] = '资产';//科目类型
        // $param['billvo']['accsubjParentVO']['pk_subjtype'] = '资产';//科目类型
        $param['billvo']['accsubjParentVO']['subjcode'] = '100204';//科目编码
        $param['billvo']['accsubjParentVO']['subjname'] = '农业银行';//科目名称
        // $param['billvo']['accsubjParentVO']['pk_grpaccsubj'] = '1002';//对应集团科目
        $param['billvo']['subjtypename'] = '资产';//科目名称

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        // dump($param);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 会计科目从公司新增
    private function uapbdAccsubjforcorpInsert($url, $request)
    {
        // 会计科目从公司新增
        $param['billvo'][0]['accsubjParentVO']["accremove"] = $request['accremove'];//是否核销科目
        $param['billvo'][0]['accsubjParentVO']["balanflag"] = $request['balanflag'];//是否余额方向控制
        $param['billvo'][0]['accsubjParentVO']["balanorient"] = $request['balanorient'];//科目方向 1 - 借; 2- 贷
        $param['billvo'][0]['accsubjParentVO']["currency"] = $request['currency'];//科目默认币种
        $param['billvo'][0]['accsubjParentVO']["dispname"] = $request['subjname'];//显示名称
        $param['billvo'][0]['accsubjParentVO']["engsubjname"] = $request['engsubjname'];//英文名称
        $param['billvo'][0]['accsubjParentVO']["incurflag"] = $request['incurflag'];//发生额方向控制
        $param['billvo'][0]['accsubjParentVO']["sumprint_level"] = $request['sumprint_level'];//汇总打印级次 取值范围 0 ~ 9
        // $param['billvo'][0]['accsubjParentVO']["innerinfonull"] = $request['innerinfonull'];//内部交易信息是否必录

        $param['billvo'][0]['accsubjParentVO']["cashbankflag"] = $request['cashbankflag'];//现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
        $param['billvo'][0]['accsubjParentVO']["sealflag"] = $request['sealflag'];//封存标志:封存日期；数据库存的是日期，页面显示 Y N
        $param['billvo'][0]['accsubjParentVO']["bothorient"] = $request['bothorient'];//帐簿余额双向显示取值：Y：是/N：否
        $param['billvo'][0]['accsubjParentVO']["innersubj"] = $request['innersubj'];//内部交易科目取值：Y：是/N：否
        $param['billvo'][0]['accsubjParentVO']["unit"] = $request['unit'];//计量单位
        $param['billvo'][0]['accsubjParentVO']["outflag"] = $request['outflag'];//外科目取值：Y：是/N：否
        $param['billvo'][0]['accsubjParentVO']["remcode"] = $request['remcode'];//助记码

        $param['billvo'][0]['accsubjParentVO']["pk_accsubj"] = $request['subjcode'];//科目编码
        $param['billvo'][0]['accsubjParentVO']["pk_corp"] = $request['unitcode'];//公司主键 9999
        $param['billvo'][0]['accsubjParentVO']["pk_glorgbook"] = $request['unitcode'].'-'.$request['subjschemecode'];//会计主体账簿 9999-0003
        $param['billvo'][0]['accsubjParentVO']["pk_subjscheme"] = $request['subjschemecode'];//会计主体账簿 0003
        $param['billvo'][0]['accsubjParentVO']["subjcode"] = $request['subjcode'];//科目编码
        $param['billvo'][0]['accsubjParentVO']["subjname"] = $request['subjname'];//科目名称
        $param['billvo'][0]['subjtypename'] = $request['subjtypename'];//科目类型
        $param['billvo'][0]['unitcode'] = $request['unitcode'];//公司编码 9999

        if ($request['bdin_id_json']) {
            // 添加辅助核算项数据
            $bdin_id_json = json_decode($request['bdin_id_json'], true);
            foreach ($bdin_id_json as $key => $value) {
                $param['billvo'][0]['vecSubjAss'][$key]["index"] = $key + 1;//序号
                $param['billvo'][0]['vecSubjAss'][$key]["pk_bdinfo"] = $value['bdcode'];//辅助核算编码
                // $vlau['print_type'] 是否汇总打印 1否2是 门店系统
                // $vlau['balance_type'] 是否余额方向控制 1否2是 门店系统
                $param['billvo'][0]['vecSubjAss'][$key]["blnSumPrint"] = $value['print_type'] == 1 ? false : true;//是否汇总打印 boolean
                $param['billvo'][0]['vecSubjAss'][$key]["isbalancecontrol"] = $value['balance_type'] == 1 ? false : true;//是否余额方向控制 boolean
                $param['billvo'][0]['vecSubjAss'][$key]["pk_accsubj"] = $request['subjcode'];//科目主键
                $param['billvo'][0]['vecSubjAss'][$key]["pk_glorgbook"] = $request['unitcode'].'-'.$request['subjschemecode'];//会计主体账簿主键
            }
        }

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    private function uapbdAccsubjforcorpInsert999($url, $request)
    {
        // 会计科目从公司新增
        $param['billvo'][0]['accsubjParentVO']["balanorient"] = "1";//科目方向 1 - 借; 2- 贷
        $param['billvo'][0]['accsubjParentVO']["currency"] = "CNY";//科目默认币种
        $param['billvo'][0]['accsubjParentVO']["dispname"] = "浦发银行08";//显示名称
        $param['billvo'][0]['accsubjParentVO']["pk_accsubj"] = "100208";//科目编码
        $param['billvo'][0]['accsubjParentVO']["pk_corp"] = "9999";//公司主键
        $param['billvo'][0]['accsubjParentVO']["pk_glorgbook"] = "9999-0003";//会计主体账簿
        // $param['billvo'][0]['accsubjParentVO']["pk_glorgbook"] = "0003";//会计主体账簿
        $param['billvo'][0]['accsubjParentVO']["pk_subjscheme"] = "0003";//会计主体账簿
        $param['billvo'][0]['accsubjParentVO']["subjcode"] = "100208";//科目编码
        $param['billvo'][0]['accsubjParentVO']["subjname"] = "浦发银行08";//科目名称
        $param['billvo'][0]['subjtypename'] = "资产";//科目类型
        $param['billvo'][0]['unitcode'] = "9999";//公司编码

        $param['billvo'][0]['vecSubjAss'][0]["index"] = "1";//序号
        $param['billvo'][0]['vecSubjAss'][0]["pk_bdinfo"] = "DHR705";//辅助核算编码
        // $param['billvo'][0]['vecSubjAss'][0]["bddispname"] = "运输方式";//辅助核算显示名称
        // $param['billvo'][0]['vecSubjAss'][0]["bdname"] = "运输方式";//辅助核算名称
        $param['billvo'][0]['vecSubjAss'][0]["blnSumPrint"] = false;//是否汇总打印 boolean
        $param['billvo'][0]['vecSubjAss'][0]["isbalancecontrol"] = false;//是否余额方向控制 boolean
        $param['billvo'][0]['vecSubjAss'][0]["pk_accsubj"] = "100208";//科目主键
        $param['billvo'][0]['vecSubjAss'][0]["pk_glorgbook"] = "9999-0003";//会计主体账簿主键

        $param['billvo'][0]['vecSubjAss'][1]["index"] = "2";//序号
        $param['billvo'][0]['vecSubjAss'][1]["pk_bdinfo"] = "20";//辅助核算编码
        $param['billvo'][0]['vecSubjAss'][1]["blnSumPrint"] = false;//是否汇总打印 boolean
        $param['billvo'][0]['vecSubjAss'][1]["isbalancecontrol"] = false;//是否余额方向控制 boolean
        $param['billvo'][0]['vecSubjAss'][1]["pk_accsubj"] = "100208";//科目主键
        $param['billvo'][0]['vecSubjAss'][1]["pk_glorgbook"] = "9999-0003";//会计主体账簿主键

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        dump($param);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 凭证查询
    private function glVoucherPagequery($url, $request)
    {
    	// 凭证查询
        $param['pk_glorgbook'] = '9999-0003';//是 主体账簿档案
        $param['page_now'] = '1';//是 当前页
    	$param['page_size'] = '10';//是	每页条数

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'undefined');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 凭证新增
    private function glVoucherInsert($url, $request)
    {
        // 凭证新增
        $param = json_encode($request, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 凭证作废
    private function glVoucherAbandon($url, $request)
    {
        // 凭证作废
        // $add['bills'][0]['abandoner_code'] = '13811067666';
        // $add['bills'][0]['glorgbook_code'] = '9999-0003';
        // $add['bills'][0]['no'] = '100';
        // $add['bills'][0]['period'] = '07';
        // $add['bills'][0]['year'] = '2020';
        // $add['bills'][0]['vouchertype_code'] = '记账';

        $param = json_encode($request, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 客商基本档案新增
    private function uapbdCustdocInsert($url, $request)
    {
    	// 客商基本档案新增
		// $add['cbdocvo'][0]['parentvo']['creator'] ='api接口';//否	创建人	
		// $add['cbdocvo'][0]['parentvo']['custcode'] ='KH175';//是	客商编码	
		// $add['cbdocvo'][0]['parentvo']['custname'] ='天津供应商';//是	客商名称	
		// $add['cbdocvo'][0]['parentvo']['custprop'] ='0';//否	客商类型(0 - 外部单位,1 - 内部核算单位,2 - 内部法人单位,3 - 内部渠道成员)	
		// $add['cbdocvo'][0]['parentvo']['custshortname'] ='天津供应商';//是	客商简称
        // $add['cbdocvo'][0]['parentvo']['pk_areacl'] =config('apiu8cloud.areaclcode');//否   所属地区(填写编码)
		// $add['cbdocvo'][0]['parentvo']['mnecode'] ='TJGYS';//否 助记码

        $param = json_encode($request, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'code');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 客商基本档案分配
    private function uapbdCustdocAssign($url, $request)
    {
        // 客商基本档案分配
        // $add['custbasvo'][0]['pk_corp'] = '1002';//公司主键
        // $add['custbasvo'][0]['pk_cubasdoc'] ='0001F810000000000E2Z';//客商基本档案主键

        $param = json_encode($request, JSON_UNESCAPED_UNICODE);
        $curl_return = $this->curlPost($url, $param, 'pk');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 客商基本档案查询
    private function uapbdCustdocQuery($url, $request)
    {
    	// 客商基本档案查询
    	$param = '{}';
        $curl_return = $this->curlPost($url, $param, 'undefined');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    // 币种档案查询
    private function uapbdBdcurrtypeQuery($url, $request)
    {
    	// 币种档案查询
    	$param = '{}';
        $curl_return = $this->curlPost($url, $param, 'undefined');
        $curl_return = json_decode($curl_return, true);
        return $curl_return;
    }

    /**
     * [curlPost 模拟post请求]
     * @param  [string] $url      [接口地址]
     * @param  [array] $param    [请求参数]
     * @param  string $trantype [翻译类型，无类型undefined，编码类型code，主键类型pk]
     * @return [type]           [description]
     */
    private function curlPost($url, $param, $trantype = 'undefined'){
        $header = array(
            'Content-Type: application/json',
            'trantype: '.$trantype,
            'system: '.config('apiu8cloud.SYSTEM_HEADER.system'),
            'usercode: '.config('apiu8cloud.SYSTEM_HEADER.usercode'),
            'password: '.config('apiu8cloud.SYSTEM_HEADER.password'),
            // 'needStackTrace: Y',
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $response = curl_exec($ch);
        curl_close($ch);
        return trim($response);
    }
}
