<?php

namespace App\Http\Controllers\Api\WarehouseManage;

use App\Http\Controllers\Common\CommonController;
use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\WarehouseManage\VerifyTransferringOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\Warehouse;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\WarehouseManage\TransferringOrders;
use App\Http\Models\Services\Dispatch;
use App\Http\Models\Services\WarehouseLock;
use App\Http\Models\Api\WarehouseManage\Stocktake;
use App\Http\Enum\Business\TransferringOrdersEnum;
use App\Services\Business\WashOrderBasicService;

// 仓储系统 -- 调拨单
class TransferringOrdersController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $page_size  = (int) $request->input('show_count', 10);
        $search_data = $request->all();
        $list_data = DB::table('transferring_order')
            ->where('tror_cid', $user_info->adm_cid)
            ->where('tror_shop_id', $shop_id)
            ->where('tror_delete', 1)
            // ->where('tror_state', '<>', 6)
            ->where(function ($query) use ($search_data) {
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('tror_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('tror_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('tror_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_number'])) {
                    $query->where('tror_number', 'like', '%' . $search_data['tror_number'] . '%');
                }
            }) //调拨单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_out_ware_id'])) {
                    $query->where('tror_out_ware_id', $search_data['tror_out_ware_id']);
                }
            }) //出货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_in_ware_id'])) {
                    $query->where('tror_in_ware_id', $search_data['tror_in_ware_id']);
                }
            }) //入货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_create_id'])) {
                    $query->where('tror_create_id', $search_data['tror_create_id']);
                }
            }) //创建人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_state'])) {
                    $query->where('tror_state', $search_data['tror_state']);
                }
            }) //状态
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_service_adm_id'])) {
                    $query->where('tror_service_adm_id', $search_data['tror_service_adm_id']);
                }
            }) //服务技师id
            ->select('tror_id', 'tror_create_time', 'tror_number', 'tror_in_ware_id', 'tror_out_ware_id', 'tror_create_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_remark', 'tror_state', 'tror_type', 'tror_service_adm_id')
            ->orderBy('tror_id', 'desc')
            ->paginate($page_size);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;       //一页显示多少个

        $data = $list_data->items();
        if ($data) {
            // 获取调拨出库的仓库id
            $out_ware_id = array_column($data, 'tror_out_ware_id');
            // 获取调拨入库的仓库id
            $in_ware_id = array_column($data, 'tror_in_ware_id');
            $ware_id = array_unique(array_merge($out_ware_id, $in_ware_id));
            // 查询出库仓库信息
            $find_ware = DB::table('warehouse')
                ->whereIn('ware_id', $ware_id)
                ->select('ware_id', 'ware_type', 'ware_name')
                ->get();
            $data_info['out_ware'] = $find_ware;
            foreach ($find_ware as $ware_key => $ware_value){
                $ware_type[$ware_value->ware_id] = $ware_value->ware_type;
            }

            // 获取创建人id
            $create_id = array_column($data, 'tror_create_id');
            // 获取服务技师id
            $service_adm_id = array_column($data, 'tror_service_adm_id');
            $adm_id = array_unique(array_merge($create_id, $service_adm_id));
            // 查询账号信息
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name')
                ->get();
            $data_info['admin'] = $find_admin;
        }

        $data_count = DB::table('transferring_order')
            ->where('tror_cid', $user_info->adm_cid)
            ->where('tror_shop_id', $shop_id)
            ->where('tror_delete', 1)
            ->where(function ($query) use ($search_data) {
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('tror_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('tror_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('tror_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_number'])) {
                    $query->where('tror_number', 'like', '%' . $search_data['tror_number'] . '%');
                }
            }) //调拨单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_out_ware_id'])) {
                    $query->where('tror_out_ware_id', $search_data['tror_out_ware_id']);
                }
            }) //出货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_in_ware_id'])) {
                    $query->where('tror_in_ware_id', $search_data['tror_in_ware_id']);
                }
            }) //入货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_create_id'])) {
                    $query->where('tror_create_id', $search_data['tror_create_id']);
                }
            }) //创建人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_state'])) {
                    $query->where('tror_state', $search_data['tror_state']);
                }
            }) //状态
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_service_adm_id'])) {
                    $query->where('tror_service_adm_id', $search_data['tror_service_adm_id']);
                }
            }) //服务技师id
            ->select(DB::raw('sum(tror_goo_fine_amount) as tror_goo_fine_amount,sum(tror_goo_priority_amount) as tror_goo_priority_amount'))
            ->first();
        // 查询门店打印模板
        $shpt_data = DB::table('shop_print_template')
            ->where('shpt_shop_id', $user_info->adm_shop_id)
            ->whereIn('shpt_print_type', [11])
            ->where('shpt_delete', 1)
            ->select('shpt_id', 'shpt_print_type', 'shpt_isdefault')
            ->get()->toArray();
        if (empty($shpt_data)) {
            $shpt_data = [];
        }

        // 获取枚举数据
        $object_enum = new TransferringOrdersEnum();
        $ord_enum = $object_enum->trans_ord_status_enum;
        $ord_ret = array_column($ord_enum, 'state_show', 'state');
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        foreach ($data as $k => $v){
            $data[$k]->tror_state_name = $ord_ret[$v->tror_state];

            $buttonData = [];
            if($v->tror_state == 2 && $ware_type[$v->tror_out_ware_id] == 1){
                $buttonData[] = 'edit';//编辑
            }
            if($v->tror_state == 1){
                $buttonData[] = 'audit';//审核
            }
            if($v->tror_state == 3 && $ware_type[$v->tror_in_ware_id] == 1){
                $buttonData[] = 'putInStorage';//入库
            }
            if($v->tror_state == 2 && $ware_type[$v->tror_out_ware_id] == 1){
                $buttonData[] = 'delivery';//出库
            }
            if($v->tror_state == 1){
                $buttonData[] = 'delete';//删除
            }
            if(in_array($v->tror_state,[2,3]) && $v->tror_type == 1){
                $buttonData[] = 'revocation';//撤销
            }
            if($v->tror_state == 4){
                $buttonData[] = 'info';//查看
            }
            if($v->tror_state != 6){
                $buttonData[] = 'print';//打印
            }
            $button = CommonService::getListButton($buttonData,$list_button);
            $data[$k]->button_one = $button['button_one']??[];
            $data[$k]->button_two = $button['button_two']??[];
            $data[$k]->button_three = $button['button_three']??[];
        }
        $data_info['fine_amount'] = $data_count->tror_goo_fine_amount;
        $data_info['priority_amount'] = $data_count->tror_goo_priority_amount;
        $data_info['data'] = $data;
        $data_info['shpt_data'] = $shpt_data;                   //模板id



        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据', 'list_button'=>$list_button]);
        }
    }

    // 详情查看
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $data_return = $this->publicDetails($request->all());
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_return['data']]);
    }

    // 打印
    public function print(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_number', 'tror_out_ware_id', 'tror_in_ware_id', 'tror_out_wafr_id')
            ->first();

        // 仓库名称
        $ware_name = DB::table('warehouse')
            ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
            ->select('ware_id', 'ware_name')
            ->get();
        // 调出仓位名称
        $find_tror->wafr_name = DB::table('warehouse_freight')
            ->where('wafr_shop_id', $user_info->adm_shop_id)
            ->where('wafr_id', $find_tror->tror_out_wafr_id)
            ->value('wafr_name');
        unset($find_tror->tror_out_wafr_id);

        // 调拨单商品信息
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_encode', 'trog_stock_number', 'trog_priority_stock_number', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id', 'trog_id', 'goo_unit')
            ->get()->toArray();
        // 查询系列数据
        $goo_brse_id = array_column($find_trog, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        $goo_id = array_column($find_trog, 'goo_id');
        // 查询商品附属表信息
        $gosu_data = DB::table('goods_subsidiary')
            ->where('gosu_shop_id', $user_info->adm_shop_id)
            ->whereIn('gosu_goo_id', $goo_id)
            ->pluck('gosu_another_name', 'gosu_goo_id')
            ->toArray();
        foreach ($find_trog as $key => $value) {
            // 查询仓位商品出入库表
            $find_wfog_data = DB::table('warehouse_freight_outin_goods as wfog')
                ->leftJoin('warehouse_freight as wafr', 'wfog.wfog_wafr_id', '=', 'wafr.wafr_id')
                ->where('wfog_shop_id', $user_info->adm_shop_id)
                ->where('wfog_type', 3)
                ->where('wfog_original_id', $request['tror_id'])
                ->where('wfog_original_number', $find_tror->tror_number)
                ->where('wfog_primary_id', $value->trog_id)
                ->where('wfog_outin_type', 2)
                ->select('wfog_wafr_id', 'wfog_stock_amount', 'wafr_name', 'wfog_stock_type')
                ->get()->toArray();
            $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
            if ($find_wfog_data) {
                $find_trog[$key]->wafr_data = $find_wfog_data;
            } else {
                $find_trog[$key]->wafr_data = [];
            }
            if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { //商品别名
                $find_trog[$key]->goo_name = $gosu_data[$value->goo_id];
            }
            // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($brse_data[$value->goo_brse_id])) {
                if (!empty($value->goo_brse_id)) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        unset($find_trog[$key]->goo_brse_id);
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($find_trog[$key]->goo_brse_id);
                        }
                    }
                }
            }
            // 显示品牌名称
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                if ($value->goo_class == 2) {
                    $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                } else {
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    }
                }
            }
            unset($find_trog[$key]->goo_class);
        }
        $data['find_tror'] = $find_tror;
        $data['ware_name'] = $ware_name;
        $data['find_trog'] = $find_trog;
        Common::addLog($user_info, getRealIp($request), '调拨单', '打印', $find_tror->tror_number . '打印成功');
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 新增调拨单0518
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $goo_fine_amount = 0; //良品总数量
        $goo_priority_amount = 0; //优先总数量
        $goods_data = json_decode($request['goods_data'], true);
        if (empty($goods_data)) {
            return response()->json(['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品']);
        }
        // ware_type类型：1固定仓2技师库3移动仓
        $ware_out_type = DB::table('warehouse')
            ->where('ware_id', $request['tror_out_ware_id'])
            ->value('ware_type');
        // ware_type类型：1固定仓2技师库3移动仓
        $ware_in_type = DB::table('warehouse')
            ->where('ware_id', $request['tror_in_ware_id'])
            ->value('ware_type');
        if ($ware_out_type == 3 && $ware_in_type == 3) {
            return response()->json(['code'=>500, 'msg'=>'移动仓不能调拨移动仓', 'data'=>'移动仓不能调拨移动仓']);
        }
        $neaten_goods_data = []; //整理后的仓库商品库存数据
        foreach ($goods_data as $key => $value) {
            if (!is_numeric($value['goo_wago_id']) || !is_numeric($value['goo_id']) || !is_numeric($value['goo_waon_class']) || !is_numeric($value['goo_quantity']) || !in_array($value['goo_inventory'], [1, 2])) {
                return response()->json(['code'=>500, 'msg'=>'商品参数类型错误', 'data'=>'商品参数类型错误']);
            }
            $trog_data[$key]['trog_wago_id'] = $value['goo_wago_id']; //仓库商品id
            $trog_data[$key]['trog_goo_id'] = $value['goo_id']; //商品id
            $trog_data[$key]['trog_waon_class'] = $value['goo_waon_class']; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            if ($value['goo_inventory'] == 1) { //库存扣除方式1.良品 2.优先
                $goo_priority_amount += 0; //优先总数量
                $goo_fine_amount += $value['goo_quantity']; //良品总数量
                $trog_data[$key]['trog_stock_number'] = $value['goo_quantity']; //良品库存数量
                $trog_data[$key]['trog_priority_stock_number'] = 0; //优先库存数量
            } else {
                $goo_fine_amount += 0; //良品总数量
                $goo_priority_amount += $value['goo_quantity']; //优先总数量
                $trog_data[$key]['trog_stock_number'] = 0; //良品库存数量
                $trog_data[$key]['trog_priority_stock_number'] = $value['goo_quantity']; //优先库存数量
            }
            $trog_data[$key]['trog_update_time'] = date('Y-m-d H:i:s');
            $wago_id[] = $value['goo_wago_id'];
            $goo_id[] = $value['goo_id'];
            $goo_waon_class[] = $value['goo_waon_class'];
            // [仓库商品id][出库类型：良品/优先]
            if (isset($neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']])) {
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
            } else {
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']] = $value;
            }
        }

        // 查询调出仓库类别的id
        $tror_out_waon_id = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $request['tror_out_ware_id'])
            ->where('waon_class', $request['tror_out_waon_class'])
            ->value('waon_id');
        $tror_in_waon_id = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $request['tror_in_ware_id'])
            ->where('waon_class', $request['tror_out_waon_class'])
            ->value('waon_id');
        // 1、新增调拨单数据
        $tror_data['tror_cid'] = $user_info->adm_cid;
        $tror_data['tror_superior_shop_id'] = $shop_id;
        $tror_data['tror_shop_id'] = $user_info->adm_shop_id;
        $tror_data['tror_create_id'] = $user_info->adm_id;
        $tror_data['tror_number'] = 'DB' . rand(10, 99) . date('mdHis') . rand(100000, 999999);
        $tror_data['tror_state'] = 2; //状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        $tror_data['tror_out_waon_id'] = $tror_out_waon_id; //调出仓库类别id
        $tror_data['tror_out_ware_id'] = $request['tror_out_ware_id']; //调出的仓库id
        $tror_data['tror_out_wafr_id'] = empty($request['tror_out_wafr_id']) ? 0 : $request['tror_out_wafr_id']; //调出的仓位id
        $tror_data['tror_in_waon_id'] = $tror_in_waon_id; //调入仓库类别id
        $tror_data['tror_in_ware_id'] = $request['tror_in_ware_id']; //调入的仓库id
        $tror_data['tror_out_waon_class'] = $request['tror_out_waon_class']; //出库仓库类别：1货物仓2非货物仓3旧货仓4临时仓
        $tror_data['tror_goo_fine_amount'] = $goo_fine_amount; //良品总数量
        $tror_data['tror_goo_priority_amount'] = $goo_priority_amount; //优先总数量
        $tror_data['tror_remark'] = $request['tror_remark'] ? $request['tror_remark'] : '';
        $tror_data['tror_service_adm_id'] = $request['tror_service_adm_id'] ? $request['tror_service_adm_id'] : 0; //服务技师id

        DB::beginTransaction();
        // 新增调拨单
        $tror_id = DB::table('transferring_order')->insertGetId($tror_data);

        foreach ($goods_data as $key => $value) {
            $trog_data[$key]['trog_tror_id'] = $tror_id;
        }
        $order_data['data']['ord_order_number'] = $tror_data['tror_number'];
        $order_data['data']['ord_id'] = $tror_id;
        $request['ware_id'] = $request['tror_out_ware_id'];
        if (!empty($neaten_goods_data) && empty($request['tror_out_wafr_id'])) {
            $type = 2;
            $ware_lock_return = WarehouseLock::warehouseLockInventory(
                $user_info,
                $request->all(),
                $order_data,
                $neaten_goods_data,
                $type
            );
            if ($ware_lock_return['code'] == 500) {
                DB::rollBack();
                return response()->json($ware_lock_return);
            }
            $neaten_wago_id = []; //良品商品
            $priority_neaten_wago_id = []; //优先商品
            $wagl_key = 0;
            $wfgl_key = 0;
            $wagl_lock_quantity = []; //仓库锁定表的商品锁定数量
            foreach ($neaten_goods_data as $wago_id => $wago_id_value) {
                foreach ($wago_id_value as $goo_inventory => $goo_value) {
                    if ($goo_inventory == 1) {
                        // 良品商品锁定库存
                        $ware_id[$wago_id] = $request['ware_id'];
                        $wago_goo_id[$wago_id] = $goo_value['goo_id'];
                        $wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                        $wago_goo_inventory[$wago_id] = $goo_inventory;
                        $wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                        $neaten_wago_id[] = $wago_id;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 1;
                    } else {
                        // 优先商品锁定库存
                        $priority_ware_id[$wago_id] = $request['ware_id'];
                        $priority_wago_goo_id[$wago_id] = $goo_value['goo_id'];
                        $priority_wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                        $priority_wago_goo_inventory[$wago_id] = $goo_inventory;
                        $priority_wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                        $priority_neaten_wago_id[] = $wago_id;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 2;
                    }
                    // 仓库锁定表的商品锁定数量：良品+优先 总的锁定数量
                    if (isset($wagl_lock_quantity[$wago_id])) {
                        $wagl_lock_quantity[$wago_id] += $goo_value['goo_quantity'];
                    } else {
                        $wagl_lock_quantity[$wago_id] = $goo_value['goo_quantity'];
                    }
                    // 仓位商品锁定表
                    $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                    $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $request['ware_id']; //仓库id
                    $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $goo_value['goo_waon_class']; //仓库类别
                    $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $goo_value['goo_wago_id']; //仓库商品主键id
                    $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                    $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                    $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $order_data['data']['ord_id']; //关联id：订单id/发货单id/调拨单id
                    $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                    $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $order_data['data']['ord_id']; //原始id：订单id/调拨单id
                    $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $order_data['data']['ord_order_number']; //原始单号：订单号/调拨单号
                    $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                    $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                    $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $goo_value['goo_quantity'];
                    $wfgl_key++;
                }

                // 仓库商品锁定表
                $wagl_data[$wagl_key]['wagl_shop_id'] = $user_info->adm_shop_id;
                $wagl_data[$wagl_key]['wagl_ware_id'] = $request['ware_id'];
                $wagl_data[$wagl_key]['wagl_wago_id'] = $wago_id;
                $wagl_data[$wagl_key]['wagl_original_id'] = $order_data['data']['ord_id'];
                $wagl_data[$wagl_key]['wagl_original_number'] = $order_data['data']['ord_order_number'];
                $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $order_data['data']['ord_id']; //关联id：订单id/发货单id/调拨单id
                $wagl_data[$wagl_key]['wagl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                $wagl_data[$wagl_key]['wagl_type'] = 2; //  原始单类型：1订单2调拨单
                $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                $wagl_data[$wagl_key]['wagl_lock_quantity'] = $wagl_lock_quantity[$wago_id]; //商品锁定库存数量
                $wagl_key++;
            }
            // ware_type类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $request['ware_id'])
                ->value('ware_type');
            if ($ware_type == 3) {
                // 仓位商品锁定表
                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_freight_data);
            }
        }
        $trog_id = DB::table('transferring_order_goods')->insert($trog_data);
        // 锁定商品库存表
        $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);

        // 记录日志
        $log_data['tror_number'] = $tror_data['tror_number'];
        $log_data['user_info'] = $user_info;
        $log_data['request'] = $request->all();
        Common::write_record_log($log_data, 'pc/TransferringOrdersController.txt', 'add');
        if ($tror_id && $trog_id && $wagl_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '调拨单', '新增', '新增调拨单：' . $tror_data['tror_number'] . '成功');
            return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'新增调拨单：成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'新增调拨单：失败']);
        }
    }

    // 审核【已废弃】
    public function audit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->auditShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查询信息
        if ($request['type'] == 1) {
            $find_tror = DB::table('transferring_order')
                ->where('tror_id', $request['tror_id'])
                ->select('tror_id', 'tror_number', 'tror_create_time', 'tror_state', 'tror_create_id', 'tror_out_ware_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_service_adm_id', 'tror_remark')
                ->first();
            // 创建人
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', [$find_tror->tror_create_id, $find_tror->tror_service_adm_id])
                ->select('adm_id', 'adm_name')
                ->get();

            // 出货仓库
            $out_ware_id = DB::table('warehouse')
                ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
                ->select('ware_id', 'ware_name')
                ->get();

            // 调拨单商品信息
            $find_trog = DB::table('transferring_order_goods as trog')
                ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
                ->where('trog_tror_id', $request['tror_id'])
                ->select('goo_name', 'goo_goods_code', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type')
                ->get();
            $data['find_tror'] = $find_tror;
            $data['find_admin'] = $find_admin;
            $data['out_ware_id'] = $out_ware_id;
            // $data['in_ware_id'] = $in_ware_id;
            $data['find_trog'] = $find_trog;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->auditValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_number', 'tror_state')
            ->first();
        if ($find_tror->tror_state != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单不是待审核状态']);
        }

        // 更改调拨单数据
        $update_data['tror_state'] = $request['tror_state']; //状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        $update_data['tror_update_time'] = date('Y-m-d H:i:s');
        $tror_res = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($update_data);

        if ($tror_res) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            Common::addLog($user_info, getRealIp($request), '调拨单', '审核', '调拨单' . $find_tror->tror_number . ' 审核成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'审核成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败']);
        }
    }

    // 删除【已废弃】
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->deleteValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 根据调拨单id，查询调拨单商品信息
        $trog_id = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get();
        $tror_updata_data['tror_delete'] = 2;
        $tror_updata_data['tror_update_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction();

        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';
        $stock_priority_sql = '';
        $lock_fine_sql = '';
        $lock_priority_sql = '';
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = 0; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0; //仓库类别对应优先库存总数量
        // 调拨单要出库的商品
        foreach ($trog_id as $key => $value) {
            // 良品
            if ($value->trog_stock_number > 0) {
                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` + ' . $value->trog_stock_number;
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity` - ' . $value->trog_stock_number;

                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` - 0';
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` + 0';

                $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
            }
            // 优先
            if ($value->trog_priority_stock_number > 0) {
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` - ' . $value->trog_priority_stock_number;
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` + ' . $value->trog_priority_stock_number;

                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` - 0';
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity`  + 0';

                $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
            }
            $time_sql = $time_sql . ' WHEN ' . $value->trog_wago_id . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value->trog_wago_id . ',';
        }

        // 2.1 固定仓商品表减锁定库存
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_fine_sql . ' END,'; //修改良品库存数量
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_fine_sql . ' END,'; //修改良品锁定数量
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_priority_sql . ' END,'; //修改优先库存数量
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $lock_priority_sql . ' END,'; //修改优先锁定数量
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $wago_edit_res = DB::update($sql);

        // 查询调出仓库类别的id
        $tror_out_waon_id = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->value('tror_out_waon_id');
        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $tror_out_waon_id . ' THEN `waon_stock_fine_amount` + ' . $waon_class_fine_quantity;
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $tror_out_waon_id . ' THEN `waon_lock_fine_amount` - ' . $waon_class_fine_quantity;
            $time_sql = $time_sql . ' WHEN ' . $tror_out_waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $tror_out_waon_id . ',';
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $tror_out_waon_id . ' THEN `waon_stock_priority_amount` + ' . $waon_class_priority_quantity;
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $tror_out_waon_id . ' THEN `waon_lock_priority_amount` - ' . $waon_class_priority_quantity;
            $time_sql = $time_sql . ' WHEN ' . $tror_out_waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $tror_out_waon_id . ',';
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `waon_id` = (' . trim($ids, ',') . ')';
        $waon_priority_res = DB::update($sql);

        $tror_updata_res = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($tror_updata_data);
        if ($tror_updata_res && $wago_edit_res && $waon_priority_res) {
            DB::commit();
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 查询信息
            $tror_number = DB::table('transferring_order')
                ->where('tror_id', $request['tror_id'])
                ->value('tror_number');
            Common::addLog($user_info, getRealIp($request), '调拨单', '删除', '调拨单：' . $tror_number . '删除成功');
            return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'删除调拨单：成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'删除调拨单：失败']);
        }
    }

    // 出库
    public function delivery(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->auditShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        if ($request['type'] == 1) {
            $find_tror = DB::table('transferring_order')
                ->where('tror_id', $request['tror_id'])
                ->select('tror_id', 'tror_number', 'tror_create_time', 'tror_state', 'tror_create_id', 'tror_out_ware_id', 'tror_out_wafr_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_service_adm_id', 'tror_remark')
                ->first();
            // 创建人
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', [$find_tror->tror_create_id, $find_tror->tror_service_adm_id])
                ->select('adm_id', 'adm_name')
                ->get();

            // 出货仓库
            $out_ware_id = DB::table('warehouse')
                ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
                ->select('ware_id', 'ware_name')
                ->get();
            if ($find_tror->tror_out_wafr_id != 0) {
                $find_tror->tror_out_wafr_name = DB::table('warehouse_freight')
                    ->where('wafr_id', $find_tror->tror_out_wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->value('wafr_name');
            }

            // 调拨单商品信息
            $find_trog = DB::table('transferring_order_goods as trog')
                ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
                ->where('trog_tror_id', $request['tror_id'])
                ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_class', 'goo_brse_id', 'goo_id', 'trog_wago_id', 'trog_waon_class', 'trog_goo_id', 'goo_unit')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($find_trog, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_trog, 'goo_id');
            // 查询商品附属表信息
            $gosu_data = DB::table('goods_subsidiary')
                ->where('gosu_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosu_goo_id', $goo_id)
                ->pluck('gosu_another_name', 'gosu_goo_id')
                ->toArray();
            // 查询仓位商品锁定表
            $find_wfgl_data = DB::table('warehouse_freight_goods_lock as w')
                ->leftJoin('warehouse_freight as wf', 'w.wfgl_wafr_id', '=', 'wf.wafr_id')
                ->where('wfgl_shop_id', $user_info->adm_shop_id)
                ->where('wfgl_type', 2)
                ->where('wfgl_state', 1)
                ->where('wfgl_original_id', $request['tror_id'])
                ->where('wfgl_original_number', $find_tror->tror_number)
                ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type', 'wafr_name', 'wfgl_waon_class')
                ->get()->toArray();
            $find_wfgl_data = json_decode(json_encode($find_wfgl_data, true), true);
            $new_wfgl_sate = false; //是否重新组仓位数据
            if (empty($find_wfgl_data)) {
                //没有查询到仓位锁定库存，需要重新组数据
                $new_wfgl_sate = true;
            }
            $new_wfgl_data = []; //新的仓位数据
            foreach ($find_trog as $key => $value) {
                // 查询仓库商品表中有可发货商品的数据
                $option_ware[] = DB::table('warehouse_goods as wago')
                    ->leftjoin('warehouse as w', 'wago.wago_ware_id', '=', 'w.ware_id')
                    ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                    ->where('wago_id', $value->trog_wago_id)
                    ->where('wago_class', $value->trog_waon_class)
                    ->where('wago_goo_id', $value->trog_goo_id)
                    ->select('ware_id as wafr_id', 'ware_name as wafr_name', 'wago_stock_amount as wafg_stock_number', 'wago_lock_amount', 'wago_priority_lock_amount', 'wago_priority_stock_amount as wafg_priority_stock_number')
                    ->first();
                if ($value->trog_stock_number > 0) {
                    $trog_goo_inventory = 1;
                    $trog_goo_quantity = $value->trog_stock_number;
                } else {
                    $trog_goo_inventory = 2;
                    $trog_goo_quantity = $value->trog_priority_stock_number;
                }
                // 查询仓位商品表中有发货商品的数据
                $find_trog[$key]->option_freight = DB::table('warehouse_freight_goods as wafg')
                    ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
                    ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                    ->where('wafg_wago_id', $value->trog_wago_id)
                    ->where('wafg_class', $value->trog_waon_class)
                    ->where('wafg_goo_id', $value->trog_goo_id)
                    ->where(function ($query) use ($value, $trog_goo_inventory) {
                        if ($trog_goo_inventory == 1) {
                            $query->where('wafg_stock_number', '>', 0)->Orwhere('wafg_lock_quantity', '>', 0);
                        } else {
                            $query->where('wafg_priority_stock_number', '>', 0)->Orwhere('wafg_priority_lock_quantity', '>', 0);
                        }
                    })
                    ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
                    ->get()->toArray();

                if (!empty($option_ware[0])) {
                    if ($value->trog_stock_number > 0 && $option_ware[0]->wafg_stock_number > 0) {
                        $option_ware[0]->wafr_id = 0;
                        $option_ware[0]->wafr_name = '仓库';
                        $option_ware[0]->wafg_stock_number = $option_ware[0]->wafg_stock_number;
                        $option_ware[0]->wafg_priority_stock_number = $option_ware[0]->wafg_priority_stock_number;
                        $find_trog[$key]->option_freight = array_merge($option_ware, $find_trog[$key]->option_freight);
                    }

                    if ($value->trog_priority_stock_number > 0 && $option_ware[0]->wafg_priority_stock_number > 0) {
                        $option_ware[0]->wafr_id = 0;
                        $option_ware[0]->wafr_name = '仓库';
                        $option_ware[0]->wafg_stock_number = $option_ware[0]->wafg_stock_number;
                        $option_ware[0]->wafg_priority_stock_number = $option_ware[0]->wafg_priority_stock_number;
                        $find_trog[$key]->option_freight = array_merge($option_ware, $find_trog[$key]->option_freight);
                    }
                }
                unset($option_ware);
                if ($new_wfgl_sate) {
                    // 重新调整数组
                    $temp_wfgl_data['wfgl_id'] = 0; //仓位商品锁定主键id
                    $temp_wfgl_data['wafr_name'] = '仓库'; //仓位商品锁定主键id
                    $temp_wfgl_data['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                    $temp_wfgl_data['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                    $temp_wfgl_data['wfgl_wafr_id'] = 0; //仓位id
                    $temp_wfgl_data['wfgl_wafg_id'] = 0; //仓位商品主键id
                    $temp_wfgl_data['wfgl_lock_quantity'] = $trog_goo_quantity; //商品锁定数量
                    $temp_wfgl_data['wfgl_lock_type'] = $trog_goo_inventory; //商品锁定类型：1良品2优先
                    $new_wfgl_data[] = $temp_wfgl_data;
                    unset($temp_wfgl_data);
                }
                if ($new_wfgl_sate) { //没有仓位锁定商品
                    $find_trog[$key]->wfgl_data = $new_wfgl_data;
                    unset($new_wfgl_data);
                } else { //有锁定商品的
                    $num = 0;
                    $trog_goo_quantity = $trog_goo_quantity; //发货数量
                    foreach ($find_wfgl_data as $wfgl_key => $wfgl_value) { //从仓位商品表中扣除发货数量
                        if ($wfgl_value['wfgl_wago_id'] == $value->trog_wago_id && $trog_goo_inventory == $wfgl_value['wfgl_lock_type'] && $value->trog_waon_class == $wfgl_value['wfgl_waon_class']) { //判断仓库类别和发货类型和仓库商品id
                            if ($wfgl_value['wfgl_lock_quantity'] != 0) { //此仓位还有锁定数量，可以从这个仓位出库
                                $trog_goo_quantity = $trog_goo_quantity - $wfgl_value['wfgl_lock_quantity']; //出库商品-仓位中锁定的数量
                                $wafr_data[$num]['wafr_name'] = $wfgl_value['wafr_name'];
                                $wafr_data[$num]['wfgl_id'] = $wfgl_value['wfgl_id'];
                                $wafr_data[$num]['wfgl_wago_id'] = $wfgl_value['wfgl_wago_id'];
                                $wafr_data[$num]['wfgl_wafr_id'] = $wfgl_value['wfgl_wafr_id'];
                                $wafr_data[$num]['wfgl_wafg_id'] = $wfgl_value['wfgl_wafg_id'];
                                $wafr_data[$num]['wfgl_lock_type'] = $wfgl_value['wfgl_lock_type'];
                                if ($trog_goo_quantity <= 0) { //出库商品-仓位中锁定的数量小于0，仓位锁定出库后还有剩余，出完了，跳出
                                    $find_wfgl_data[$wfgl_key]['wfgl_lock_quantity'] = abs($trog_goo_quantity);
                                    $wafr_data[$num]['wfgl_lock_quantity'] = $trog_goo_quantity + $wfgl_value['wfgl_lock_quantity'];
                                    break;
                                } else { //出库商品-仓位中锁定的数量大于0，没出完，从下一个仓位扣除
                                    $find_wfgl_data[$wfgl_key]['wfgl_lock_quantity'] = 0;
                                    $wafr_data[$num]['wfgl_lock_quantity'] = $wfgl_value['wfgl_lock_quantity'];
                                }
                                $num++;
                            }
                        }
                    }

                    if ($trog_goo_quantity > 0) { //仓位出库后还有需要出库的库存，从仓库出库
                        $wafr_data[$num]['wafr_name'] = '仓库';
                        $wafr_data[$num]['wfgl_lock_quantity'] = $trog_goo_quantity;
                        $wafr_data[$num]['wfgl_id'] = $trog_goo_quantity;
                        $wafr_data[$num]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wafr_data[$num]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wafr_data[$num]['wfgl_wafr_id'] = 0;
                        $wafr_data[$num]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wafr_data[$num]['wfgl_lock_type'] = $trog_goo_inventory; //商品锁定类型：1良品2优先
                    }
                    $find_trog[$key]->wfgl_data = $wafr_data;
                    unset($trog_goo_quantity);
                    unset($wafr_data);
                }
                if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { // 商品别名
                    $find_trog[$key]->goo_name = $gosu_data[$value->goo_id];
                }
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($brse_data[$value->goo_brse_id])) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($find_trog[$key]->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                unset($find_trog[$key]->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }
                $find_trog[$key]->goo_name = $value->goo_name.'('.$value->goo_unit.')';
                unset($find_trog[$key]->goo_class);
            }
            $data['find_tror'] = $find_tror;
            $data['find_admin'] = $find_admin;
            $data['ware_name'] = $out_ware_id;
            // $data['in_ware_id'] = $in_ware_id;
            $data['find_trog'] = $find_trog;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_state', 'tror_number', 'tror_id', 'tror_out_ware_id')
            ->first();
        // tror_state 状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        if ($find_tror->tror_state == 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单尚未审核']);
        }
        if ($find_tror->tror_state == 3) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已出库']);
        }
        if ($find_tror->tror_state == 4) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已入库']);
        }
        if ($find_tror->tror_state == 5) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已驳回']);
        }
        if ($find_tror->tror_state == 6) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已撤销']);
        }

        $tror_data['tror_state'] = 3; //状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        $tror_data['tror_update_time'] = date('Y-m-d H:i:s');
        if (!empty($request['adm_id'])) {
            $tror_data['tror_service_adm_id'] = $request['adm_id'];
        } /*else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择送货人']);
        }*/
        $request_goods_data = json_decode($request['goo_data'], true); //前端提交的出库商品数据
        // ware_type类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_tror->tror_out_ware_id)
            ->value('ware_type');

        DB::beginTransaction();

        // 更改仓库、仓位发货数量
        $delivery_retrun = Dispatch::delivery(
            $user_info, //用户信息
            $request->all(), //用户信息
            $request_goods_data, //提交的商品数据
            $find_tror, //查询的调拨单信息
            $ware_type, //调拨仓库类型
            $find_tror->tror_id, //调拨单id
            $find_tror->tror_number //调拨单单号
        );
        if ($delivery_retrun['code'] == 500) {
            DB::rollBack();
            return response()->json($delivery_retrun);
        }

        // 4.新增调拨单详情
        $trod_data['trod_tror_id'] = $request['tror_id'];
        $trod_data['trod_export_adm_id'] = $user_info->adm_id;
        $trod_data['trod_export_time'] = date('Y-m-d H:i:s');
        $trod_id = DB::table('transferring_order_details')->insert($trod_data);

        $tror_updata_res = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($tror_data);
        $post_data['ware_id'] = $find_tror->tror_out_ware_id;
        $post_data['new_goods_data'] = $request_goods_data;
        $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        if ($tror_updata_res && $trod_id) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '调拨单', '出库', '调拨单：' . $find_tror->tror_number . '出库成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'调拨单出库：成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单出库：失败']);
        }
    }

    // 入库
    public function putInStorage(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->auditShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_number', 'tror_create_time', 'tror_state', 'tror_create_id', 'tror_out_ware_id', 'tror_out_wafr_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_type', 'tror_service_adm_id', 'tror_remark')
            ->first();
        // 调拨单商品信息
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_brse_id', 'goo_class', 'goo_id', 'trog_id', 'trog_wago_id', 'trog_waon_class', 'trog_goo_id', 'goo_unit')
            ->get()->toArray();
        if ($request['type'] == 1) { //获取页面数据
            // 创建人
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', [$find_tror->tror_create_id, $find_tror->tror_service_adm_id])
                ->select('adm_id', 'adm_name')
                ->get();

            // 出货仓库
            $ware_name = DB::table('warehouse')
                ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
                ->select('ware_id', 'ware_name')
                ->get();
            $find_tror->tror_out_wafr_name = DB::table('warehouse_freight')
                ->where('wafr_id', $find_tror->tror_out_wafr_id)
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->value('wafr_name');

            // 查询系列数据
            $goo_brse_id = array_column($find_trog, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_trog, 'goo_id');
            // 查询商品附属表信息
            $gosu_data = DB::table('goods_subsidiary')
                ->where('gosu_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosu_goo_id', $goo_id)
                ->pluck('gosu_another_name', 'gosu_goo_id')
                ->toArray();
            $wafr_data = DB::table('warehouse_freight')
                ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                ->select('wafr_id', 'wafr_name')
                ->get()->toArray();
            foreach ($find_trog as $key => $value) {
                if ($user_info->shop_versions == 1) { //门店
                    $find_trog[$key]->option_freight = DB::table('warehouse')
                        ->where('ware_id', $find_tror->tror_in_ware_id)
                        ->where('ware_state', 1)
                        ->select('ware_id as wafr_id', 'ware_name as wafr_name')
                        ->get()->toArray();
                } else {
                    $find_trog[$key]->option_freight = DB::table('warehouse_freight')
                        ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                        ->where('wafr_delete', 1)
                        ->select('wafr_id', 'wafr_name')
                        ->get()->toArray();
                }

                if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { // 商品别名
                    $find_trog[$key]->goo_name = $gosu_data[$value->goo_id];
                }
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($brse_data[$value->goo_brse_id])) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($find_trog[$key]->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                unset($find_trog[$key]->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }
                $find_trog[$key]->goo_name = $find_trog[$key]->goo_name.'('.$value->goo_unit.')';
                unset($find_trog[$key]->goo_class);
            }
            $data['find_tror'] = $find_tror;
            $data['find_admin'] = $find_admin;
            $data['ware_name'] = $ware_name;
            $data['find_trog'] = $find_trog;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_state', 'tror_number', 'tror_out_waon_class', 'tror_in_waon_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_type', 'tror_id', 'tror_out_ware_id', 'tror_out_waon_id', 'tror_out_wafr_id')
            ->first();
        // tror_state 状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        if ($find_tror->tror_state == 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单尚未审核']);
        }
        if ($find_tror->tror_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单未出库']);
        }
        if ($find_tror->tror_state == 4) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已入库']);
        }
        if ($find_tror->tror_state == 5) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已驳回']);
        }
        if ($find_tror->tror_state == 6) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已撤销']);
        }

        // 根据调拨单id，查询调拨单商品信息
        $find_trog_data = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('trog_id', 'trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get()->toArray();
        $tror_data['tror_in_waon_class'] = $find_tror->tror_out_waon_class; //入库仓库类别：1货物仓2非货物仓3旧货仓4临时仓
        $tror_data['tror_state'] = 4; //状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        $tror_data['tror_update_time'] = date('Y-m-d H:i:s');

        $goods_data = json_decode($request['goods_data'], true);
        if (empty($goods_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择商品']);
        }

        DB::beginTransaction();
        // 查询仓位商品锁定表
        $find_wfgl_data = DB::table('warehouse_freight_goods_lock as w')
            ->leftJoin('warehouse_goods as wg', 'w.wfgl_wago_id', '=', 'wg.wago_id')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2)
            ->where('wfgl_state', 1)
            ->where('wfgl_original_id', $request['tror_id'])
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type', 'wfgl_waon_class', 'wago_goo_id')
            ->get()->toArray();
        if (empty($find_wfgl_data)) {
            $find_wagl_goods = DB::table('warehouse_goods_lock')
                ->where('wagl_shop_id', $user_info->adm_shop_id)
                ->where('wagl_type', 2) //原始单类型：1订单2调拨单
                ->where('wagl_state', 1) //锁定状态：1下单锁定2出库解锁
                ->where('wagl_original_id', $find_tror->tror_id)
                ->where('wagl_original_number', $find_tror->tror_number)
                ->select('wagl_id', 'wagl_ware_id', 'wagl_wago_id', 'wagl_wafr_id', 'wagl_wafg_id', 'wagl_lock_quantity')
                ->get()->toArray();
            if (!empty($find_wagl_goods)) {
                $wfgl_key = 0;
                foreach ($find_trog as $key => $value) {
                    if ($value->trog_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 1; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                    if ($value->trog_priority_stock_number > 0) { //优先数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_priority_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 2; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                }
                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_freight_data);
            }
        }

        // 查询仓位商品锁定表
        $find_wfgl_data = DB::table('warehouse_freight_goods_lock as w')
            ->leftJoin('warehouse_goods as wg', 'w.wfgl_wago_id', '=', 'wg.wago_id')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2)
            ->where('wfgl_state', 1)
            ->where('wfgl_original_id', $request['tror_id'])
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type', 'wfgl_waon_class', 'wago_goo_id')
            ->get()->toArray();
        $find_wfgl_data = json_decode(json_encode($find_wfgl_data, true), true);
        $wago_class_goods = []; //良品出入库记录
        $priority_wago_class_goods = []; //优先出入库记录
        // ware_type类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_tror->tror_out_ware_id)
            ->value('ware_type');
        foreach ($find_wfgl_data as $key => $value) { //出库数据
            if ($value['wfgl_wafr_id'] == 0) { //从仓库出
                if ($value['wfgl_lock_type'] == 1) { //商品锁定类型：1良品
                    // 仓库商品表良品锁定数量减少
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->select('wago_id', 'wago_lock_quantity', 'wago_lock_amount')
                        ->first();
                    $wago_lock_quantity = $find_wago_data->wago_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wago_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足1-1']);
                    }
                    if ($ware_type == 1) {
                        // 固定仓，处理固定仓库字段数据
                        $wago_lock_amount = $find_wago_data->wago_lock_amount - $value['wfgl_lock_quantity'];
                        if ($wago_lock_amount < 0) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足1-2']);
                        }
                        $wago_out_edit['wago_lock_amount'] = $wago_lock_amount;
                    }
                    $wago_out_edit['wago_lock_quantity'] = $wago_lock_quantity;
                } else { //商品锁定类型：2优先
                    // 仓库商品表优先锁定减少
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->select('wago_id', 'wago_priority_lock_quantity', 'wago_priority_lock_amount')
                        ->first();
                    $wago_priority_lock_quantity = $find_wago_data->wago_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wago_priority_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足2']);
                    }
                    if ($ware_type == 1) {
                        $wago_priority_lock_amount = $find_wago_data->wago_priority_lock_amount - $value['wfgl_lock_quantity'];
                        if ($wago_priority_lock_amount < 0) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足1-3']);
                        }
                        $wago_out_edit['wago_priority_lock_amount'] = $wago_priority_lock_amount;
                    }
                    $wago_out_edit['wago_priority_lock_quantity'] = $wago_priority_lock_quantity;
                }
                $wago_edit_res = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                    ->where('wago_class', $value['wfgl_waon_class'])
                    ->where('wago_id', $value['wfgl_wago_id'])
                    ->update($wago_out_edit);
                unset($wago_out_edit);
                if (!$wago_edit_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单出库：失败1']);
                }
            } else { //从仓位出
                if ($value['wfgl_lock_type'] == 1) { //商品锁定类型：1良品
                    // 仓库商品表良品锁定数量减少
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->select('wago_id', 'wago_lock_quantity', 'wago_freight_lock_quantity')
                        ->first();
                    $wago_lock_quantity = $find_wago_data->wago_lock_quantity - $value['wfgl_lock_quantity'];
                    $wago_freight_lock_quantity = $find_wago_data->wago_freight_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wago_freight_lock_quantity < 0 || $wago_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足3']);
                    }
                    $wago_out_edit['wago_lock_quantity'] = $wago_lock_quantity;
                    $wago_out_edit['wago_freight_lock_quantity'] = $wago_freight_lock_quantity;
                    $wago_edit_res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->update($wago_out_edit);
                    unset($wago_out_edit);

                    // 仓位商品表减少锁定库存
                    $wafg_lock_quantity = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wafg_class', $value['wfgl_waon_class'])
                        ->where('wafg_wago_id', $value['wfgl_wago_id'])
                        ->where('wafg_wafr_id', $value['wfgl_wafr_id'])
                        ->value('wafg_lock_quantity');
                    $wafg_lock_quantity = $wafg_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wafg_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位商品表锁定数量不足']);
                    }
                    $wafg_lock_quantity_res = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wafg_class', $value['wfgl_waon_class'])
                        ->where('wafg_wago_id', $value['wfgl_wago_id'])
                        ->where('wafg_wafr_id', $value['wfgl_wafr_id'])
                        ->decrement('wafg_lock_quantity', $value['wfgl_lock_quantity']);
                    // 仓位表良品减少锁定库存
                    $wafr_lock_quantity = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                        ->value('wafr_lock_quantity');
                    $wafr_lock_quantity = $wafr_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wafr_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位表锁定数量不足']);
                    }
                    $wafr_lock_quantity_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                        ->decrement('wafr_lock_quantity', $value['wfgl_lock_quantity']);
                    if (!$wago_edit_res || !$wafg_lock_quantity_res || !$wafr_lock_quantity_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单出库：失败2']);
                    }
                } else { //商品锁定类型：2优先
                    // 仓库商品表优先锁定减少
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->select('wago_id', 'wago_priority_lock_quantity', 'wago_freight_priority_lock_quantity')
                        ->first();
                    $wago_priority_lock_quantity = $find_wago_data->wago_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    $wago_freight_priority_lock_quantity = $find_wago_data->wago_freight_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wago_freight_priority_lock_quantity < 0 || $wago_priority_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库商品表锁定数量不足4']);
                    }
                    $wago_out_edit['wago_priority_lock_quantity'] = $wago_priority_lock_quantity;
                    $wago_out_edit['wago_freight_priority_lock_quantity'] = $wago_freight_priority_lock_quantity;
                    $wago_edit_res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wago_class', $value['wfgl_waon_class'])
                        ->where('wago_id', $value['wfgl_wago_id'])
                        ->update($wago_out_edit);
                    unset($wago_out_edit);

                    $wafg_priority_lock_quantity = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wafg_class', $value['wfgl_waon_class'])
                        ->where('wafg_wago_id', $value['wfgl_wago_id'])
                        ->where('wafg_wafr_id', $value['wfgl_wafr_id'])
                        ->value('wafg_priority_lock_quantity');
                    $wafg_priority_lock_quantity = $wafg_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wafg_priority_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位商品表锁定数量不足']);
                    }
                    $wafg_lock_quantity_res = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                        ->where('wafg_class', $value['wfgl_waon_class'])
                        ->where('wafg_wago_id', $value['wfgl_wago_id'])
                        ->where('wafg_wafr_id', $value['wfgl_wafr_id'])
                        ->decrement('wafg_priority_lock_quantity', $value['wfgl_lock_quantity']);
                    // 仓位表优先锁定库存减少
                    $wafr_priority_lock_quantity = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                        ->value('wafr_priority_lock_quantity');
                    $wafr_priority_lock_quantity = $wafr_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($wafr_priority_lock_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位表锁定数量不足']);
                    }
                    $wafr_priority_lock_quantity_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                        ->decrement('wafr_priority_lock_quantity', $value['wfgl_lock_quantity']);
                    if (!$wafr_priority_lock_quantity_res || !$wafg_lock_quantity_res || !$wago_edit_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单出库：失败2']);
                    }
                }
            }

            if ($value['wfgl_lock_type'] == 1) { //良品
                // 仓库良品锁定总库存减少
                $find_waon_data = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_tror->tror_out_ware_id)
                    ->where('waon_class', $value['wfgl_waon_class'])
                    ->select('waon_id', 'waon_lock_fine_amount', 'waon_all_amount')
                    ->first();
                $waon_lock_fine_amount = $find_waon_data->waon_lock_fine_amount - $value['wfgl_lock_quantity'];
                $waon_all_amount = $find_waon_data->waon_all_amount - $value['wfgl_lock_quantity'];
                if ($waon_lock_fine_amount < 0 || $waon_all_amount < 0) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'总库存良品锁定数量不足']);
                }
                $waon_edit_data['waon_lock_fine_amount'] = $waon_lock_fine_amount;
                $waon_edit_data['waon_all_amount'] = $waon_all_amount;
            } else { //优先
                // 仓库优先锁定总库存减少
                $find_waon_data = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_tror->tror_out_ware_id)
                    ->where('waon_class', $value['wfgl_waon_class'])
                    ->select('waon_id', 'waon_lock_priority_amount', 'waon_all_amount')
                    ->first();
                $waon_lock_priority_amount = $find_waon_data->waon_lock_priority_amount - $value['wfgl_lock_quantity'];
                $waon_all_amount = $find_waon_data->waon_all_amount - $value['wfgl_lock_quantity'];
                if ($waon_lock_priority_amount < 0 || $waon_all_amount < 0) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'总库存优先锁定数量不足']);
                }
                $waon_edit_data['waon_lock_priority_amount'] = $waon_lock_priority_amount;
                $waon_edit_data['waon_all_amount'] = $waon_all_amount;
            }
            // 仓库总库存数量调整
            $waon_edit_res = DB::table('warehouse_onhand')
                ->where('waon_id', $find_waon_data->waon_id)
                ->update($waon_edit_data);
            if (!$waon_edit_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'总库存锁定数量不足']);
            }

            // 出入库记录数据处理
            if ($value['wfgl_lock_type'] == 1) { //良品
                if (isset($wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']])) {
                    // $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wfgl_lock_quantity'] += $value['wfgl_lock_quantity'];//仓库类型对应的商品，出入库记录

                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['wfgl_wafr_id']) {
                        $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wafr_goo_quantity'] = $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wafr_goo_quantity'] + $value['wfgl_lock_quantity']; //仓库类型对应的商品，出入库记录
                    } else {
                        $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wago_goo_quantity'] = $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wago_goo_quantity'] + $value['wfgl_lock_quantity']; //从仓库商品出库的商品数量
                    }
                    $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wfgl_lock_quantity'] = $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wfgl_lock_quantity'] + $value['wfgl_lock_quantity']; //仓库类型对应的商品，出入库记录
                } else {
                    $temp_data = $value;
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['wfgl_wafr_id']) {
                        $temp_data['wafr_goo_quantity'] = $value['wfgl_lock_quantity']; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                    } else {
                        $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = $value['wfgl_lock_quantity']; //从仓库商品出库的商品数量
                    }
                    $wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                    unset($temp_data);
                }
            } else {
                // 优先
                if (isset($priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']])) {
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['wfgl_wafr_id']) {
                        $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wafr_goo_quantity'] = $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wafr_goo_quantity'] + $value['wfgl_lock_quantity']; //仓库类型对应的商品，出入库记录
                    } else {
                        $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wago_goo_quantity'] = $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wago_goo_quantity'] + $value['wfgl_lock_quantity']; //从仓库商品出库的商品数量
                    }
                    $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wfgl_lock_quantity'] = $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']]['wfgl_lock_quantity'] + $value['wfgl_lock_quantity']; //仓库类型对应的商品，出入库记录
                } else {
                    $temp_data = $value;
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['wfgl_wafr_id']) {
                        $temp_data['wafr_goo_quantity'] = $value['wfgl_lock_quantity']; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                    } else {
                        $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = $value['wfgl_lock_quantity']; //从仓库商品出库的商品数量
                    }
                    $priority_wago_class_goods[$value['wfgl_waon_class']][$value['wago_goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                    unset($temp_data);
                }
            }

            if ($value['wfgl_lock_type'] == 1) {
                $primary_id = DB::table('transferring_order_goods')
                    ->where('trog_tror_id', $request['tror_id'])
                    ->where('trog_wago_id', $value['wfgl_wago_id'])
                    ->where('trog_waon_class', $value['wfgl_waon_class'])
                    ->where('trog_goo_id', $value['wago_goo_id'])
                    ->where('trog_stock_number', '>', 0)
                    ->value('trog_id');
            } else {
                $primary_id = DB::table('transferring_order_goods')
                    ->where('trog_tror_id', $request['tror_id'])
                    ->where('trog_wago_id', $value['wfgl_wago_id'])
                    ->where('trog_waon_class', $value['wfgl_waon_class'])
                    ->where('trog_goo_id', $value['wago_goo_id'])
                    ->where('trog_priority_stock_number', '>', 0)
                    ->value('trog_id');
            }
            // 仓位出库记录
            $outin_recore_res = Stocktake::junkaddition(
                $user_info,
                $find_tror->tror_out_ware_id, //仓库id
                $value['wfgl_waon_class'], //仓库类型
                $value['wfgl_wafr_id'], //仓位id
                4, //调拨出库
                $request['tror_id'], //原始单id
                $find_tror->tror_number, //原始单单号
                $primary_id, //关联商品表主键id
                $value['wago_goo_id'], //商品表主键id
                1, //出入库类型：1出库2入库
                $value['wfgl_lock_quantity'], //商品数量
                $value['wfgl_lock_type'] //出库类型1良品2优先3待检测
            );
            if ($outin_recore_res['code'] == 500) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单出库：失败4']);
            }
        }

        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        if (!empty($wago_class_goods)) {
            foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
                // 查询仓库类别的进销存计算方式
                $actual_count = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['wfgl_lock_quantity']; //出入库商品数量
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['wfgl_lock_type']; //出入库商品类型，类型1良品2优先
                    $actual_count += $value['wfgl_lock_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['wago_goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['wfgl_lock_quantity']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['wfgl_lock_type']; //出入库商品类型，类型1良品2优先
                }

                $find_waon = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', '=', $find_tror->tror_out_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                // 3.生成出库记录
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_tror->tror_id, //原始单的关联id
                    $find_tror->tror_number, //原始单的关联单号
                    2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    0, //选择的客户id,会员id/单位id
                    $find_tror->tror_number, //原始单号，旧货回收单单号
                    0, //入库仓库id
                    $find_tror->tror_out_ware_id, //出库仓库id
                    $actual_count, //出库商品总量
                    2, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    2, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_waon->waon_stock_fine_amount, //良品总库存
                    $find_waon->waon_lock_fine_amount, //良品锁定数量
                    $find_waon->waon_stock_priority_amount, //优先总库存
                    $find_waon->waon_lock_priority_amount, //优先锁定数量
                    $find_waon->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $find_tror->tror_out_waon_class, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    [], //仓位id
                    $oure_class_goo_id //仓库类别下的商品id
                );
                if (!$oure_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'出库失败01']);
                }
            }
            unset($wago_class_goods);
            unset($oure_goods_dataarray);
            unset($oure_goods_id);
            unset($oure_goods_quantity);
            unset($oure_goods_inventory);
            unset($oure_class_goo_id);
        }
        if (!empty($priority_wago_class_goods)) {
            foreach ($priority_wago_class_goods as $waon_class_key => $class_goods_data) {
                // 查询仓库类别的进销存计算方式
                $actual_count = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['wfgl_lock_quantity']; //出入库商品数量
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['wfgl_lock_type']; //出入库商品类型，类型1良品2优先
                    $actual_count += $value['wfgl_lock_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['wago_goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['wfgl_lock_quantity']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['wfgl_lock_type']; //出入库商品类型，类型1良品2优先
                }

                $find_waon = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', '=', $find_tror->tror_out_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                // 3.生成出库记录
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_tror->tror_id, //原始单的关联id
                    $find_tror->tror_number, //原始单的关联单号
                    2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    0, //选择的客户id,会员id/单位id
                    $find_tror->tror_number, //原始单号，旧货回收单单号
                    0, //入库仓库id
                    $find_tror->tror_out_ware_id, //出库仓库id
                    $actual_count, //出库商品总量
                    2, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    2, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_waon->waon_stock_fine_amount, //良品总库存
                    $find_waon->waon_lock_fine_amount, //良品锁定数量
                    $find_waon->waon_stock_priority_amount, //优先总库存
                    $find_waon->waon_lock_priority_amount, //优先锁定数量
                    $find_waon->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $find_tror->tror_out_waon_class, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    [], //仓位id
                    $oure_class_goo_id //仓库类别下的商品id
                );
                if (!$oure_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'出库失败01']);
                }
            }
            unset($priority_wago_class_goods);
            unset($oure_goods_dataarray);
            unset($oure_goods_id);
            unset($oure_goods_quantity);
            unset($oure_goods_inventory);
            unset($oure_class_goo_id);
        }

        $wago_class_goods = []; //良品出入库记录
        $priority_wago_class_goods = []; //优先出入库记录
        foreach ($goods_data as $key => $value) { //入库数据
            if ($user_info->shop_versions == 1) {
                $value['goo_wafr_id'] = 0;
            }
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                ->where('wago_class', $find_tror->tror_out_waon_class)
                ->where('wago_goo_id', $value['goo_id'])
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_stock_amount', 'wago_priority_stock_amount', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount')
                ->first();
            if (empty($find_wago_data)) {
                $add_wago_data['wago_ware_id'] = $find_tror->tror_in_ware_id; //仓库id
                $add_wago_data['wago_class'] = $find_tror->tror_out_waon_class; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                $add_wago_data['wago_goo_id'] = $value['goo_id']; //商品id
                if ($value['goo_wafr_id'] == 0) { //从仓库入
                    if ($value['goo_inventory'] == 1) {
                        $add_wago_data['wago_stock_number'] = $value['goo_quantity']; //良品库存数量（仓库+仓位）
                        $add_wago_data['wago_stock_amount'] = $value['goo_quantity']; //仓库良品库存数量
                    } else {
                        $add_wago_data['wago_priority_stock_number'] = $value['goo_quantity']; //优先库存数量（仓库+仓位）
                        $add_wago_data['wago_priority_stock_amount'] = $value['goo_quantity']; //仓库优先库存数量
                    }
                    $wago_id = DB::table('warehouse_goods')->insertGetId($add_wago_data);
                    unset($add_wago_data);
                    if (!$wago_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨失败002']);
                    }
                } else { //仓位入
                    if ($value['goo_inventory'] == 1) {
                        $add_wago_data['wago_stock_number'] = $value['goo_quantity']; //良品库存数量（仓库+仓位）
                        $add_wago_data['wago_freight_stock_number'] = $value['goo_quantity']; //仓位良品库存数量
                    } else {
                        $add_wago_data['wago_priority_stock_number'] = $value['goo_quantity']; //优先库存数量（仓库+仓位）
                        $add_wago_data['wago_freight_priority_stock_number'] = $value['goo_quantity']; //仓位优先库存数量
                    }
                    $wago_id = DB::table('warehouse_goods')->insertGetId($add_wago_data);
                    unset($add_wago_data);
                    if (!$wago_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨失败002']);
                    }
                    $find_wafg_data = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                        ->where('wafg_class', $value['goo_waon_class'])
                        ->where('wafg_wago_id', $wago_id)
                        ->where('wafg_wafr_id', $value['goo_wafr_id'])
                        ->value('wafg_id');
                    if (empty($find_wafg_data)) {
                        $add_wafg_data['wafg_wafr_id'] = $value['goo_wafr_id'];
                        $add_wafg_data['wafg_wago_id'] = $wago_id;
                        $add_wafg_data['wafg_ware_id'] = $find_tror->tror_in_ware_id;
                        $add_wafg_data['wafg_class'] = $value['goo_waon_class'];
                        $add_wafg_data['wafg_goo_id'] = $value['goo_id'];
                        if ($value['goo_inventory'] == 1) {
                            $add_wafg_data['wafg_stock_number'] = $value['goo_quantity'];
                        } else {
                            $add_wafg_data['wafg_priority_stock_number'] = $value['goo_quantity'];
                        }
                        $add_wafg_res = DB::table('warehouse_freight_goods')->insert($add_wafg_data);
                        unset($add_wafg_data);
                        if (!$add_wafg_res) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨失败001']);
                        }
                        $wafg_stock_number = true;
                    } else {
                        if ($value['goo_inventory'] == 1) { //商品锁定类型：1良品
                            // 仓位商品表增加库存
                            $wafg_stock_number = DB::table('warehouse_freight_goods')
                                ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                                ->where('wafg_class', $value['goo_waon_class'])
                                ->where('wafg_wago_id', $find_wago_data->wago_id)
                                ->where('wafg_wafr_id', $value['goo_wafr_id'])
                                ->increment('wafg_stock_number', $value['goo_quantity']);
                        } else { //商品锁定类型：2优先
                            // 仓位商品表优先数量增加
                            $wafg_stock_number = DB::table('warehouse_freight_goods')
                                ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                                ->where('wafg_class', $value['goo_waon_class'])
                                ->where('wafg_wago_id', $find_wago_data->wago_id)
                                ->where('wafg_wafr_id', $value['goo_wafr_id'])
                                ->increment('wafg_priority_stock_number', $value['goo_quantity']);
                        }
                    }
                    if ($value['goo_inventory'] == 1) { //商品锁定类型：1良品
                        // 仓位表良品锁定库存增加
                        $wafr_all_stock = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                            ->increment('wafr_all_stock', $value['goo_quantity']);
                    } else { //商品锁定类型：2优先
                        // 仓位表优先锁定库存增加
                        $wafr_all_stock = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                            ->increment('wafr_priority_all_stock', $value['goo_quantity']);
                    }
                    if (!$wafg_stock_number || !$wafr_all_stock) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位数量增加失败']);
                    }
                }
            } else {
                if ($value['goo_wafr_id'] == 0) { //从仓库入
                    // 判断移动仓库内是否有入库商品id，有商品id就更改库存数量
                    if ($value['goo_inventory'] == 1) { //商品锁定类型：1良品
                        // 仓库商品表良品数量增加
                        $wago_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_stock_number', $value['goo_quantity']);
                        $wago_stock_amount = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_stock_amount', $value['goo_quantity']);
                    } else { //商品锁定类型：2优先
                        // 仓库商品表优先增加
                        $wago_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_priority_stock_number', $value['goo_quantity']);
                        $wago_stock_amount = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_priority_stock_amount', $value['goo_quantity']);
                    }
                    if (!$wago_stock_number || !$wago_stock_amount) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库数量增加失败']);
                    }
                } else { //从仓位入库
                    $find_wafg_data = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                        ->where('wafg_class', $value['goo_waon_class'])
                        ->where('wafg_wago_id', $find_wago_data->wago_id)
                        ->where('wafg_wafr_id', $value['goo_wafr_id'])
                        ->value('wafg_id');
                    if (empty($find_wafg_data)) {
                        $add_wafg_data['wafg_wafr_id'] = $value['goo_wafr_id'];
                        $add_wafg_data['wafg_wago_id'] = $find_wago_data->wago_id;
                        $add_wafg_data['wafg_ware_id'] = $find_tror->tror_in_ware_id;
                        $add_wafg_data['wafg_class'] = $value['goo_waon_class'];
                        $add_wafg_data['wafg_goo_id'] = $value['goo_id'];
                        if ($value['goo_inventory'] == 1) {
                            $add_wafg_data['wafg_stock_number'] = $value['goo_quantity'];
                        } else {
                            $add_wafg_data['wafg_priority_stock_number'] = $value['goo_quantity'];
                        }
                        $add_wafg_res = DB::table('warehouse_freight_goods')->insert($add_wafg_data);
                        unset($add_wafg_data);
                        if (!$add_wafg_res) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨失败001']);
                        }
                        $wafg_stock_number = true;
                    } else {
                        if ($value['goo_inventory'] == 1) { //商品锁定类型：1良品
                            // 仓位商品表增加库存
                            $wafg_stock_number = DB::table('warehouse_freight_goods')
                                ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                                ->where('wafg_class', $value['goo_waon_class'])
                                ->where('wafg_wago_id', $find_wago_data->wago_id)
                                ->where('wafg_wafr_id', $value['goo_wafr_id'])
                                ->increment('wafg_stock_number', $value['goo_quantity']);
                        } else { //商品锁定类型：2优先
                            // 仓位商品表优先数量增加
                            $wafg_stock_number = DB::table('warehouse_freight_goods')
                                ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
                                ->where('wafg_class', $value['goo_waon_class'])
                                ->where('wafg_wago_id', $find_wago_data->wago_id)
                                ->where('wafg_wafr_id', $value['goo_wafr_id'])
                                ->increment('wafg_priority_stock_number', $value['goo_quantity']);
                        }
                    }
                    if ($value['goo_inventory'] == 1) { //商品锁定类型：1良品
                        // 仓库商品表良品数量增加
                        $wago_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_stock_number', $value['goo_quantity']);
                        $wago_freight_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_freight_stock_number', $value['goo_quantity']);
                        // 仓位表良品数量增加
                        $wafr_lock_quantity_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                            ->increment('wafr_all_stock', $value['goo_quantity']);
                    } else { //商品锁定类型：2优先
                        // 仓库商品表优先数量增加
                        $wago_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_priority_stock_number', $value['goo_quantity']);
                        $wago_freight_stock_number = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_id', $find_wago_data->wago_id)
                            ->increment('wago_freight_priority_stock_number', $value['goo_quantity']);
                        // 仓位表优先库存增加
                        $wafr_lock_quantity_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->where('wafr_ware_id', $find_tror->tror_in_ware_id)
                            ->increment('wafr_priority_all_stock', $value['goo_quantity']);
                    }
                    if (!$wago_stock_number || !$wago_freight_stock_number || !$wafg_stock_number || !$wafr_lock_quantity_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓位数量增加失败']);
                    }
                }
            }
            if ($value['goo_inventory'] == 1) { //良品
                // 仓库良品锁定总库存增加
                $waon_stock_fine_amount = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_tror->tror_in_ware_id)
                    ->where('waon_class', $value['goo_waon_class'])
                    ->increment('waon_stock_fine_amount', $value['goo_quantity']);
            } else { //优先
                // 仓库优先锁定总库存增加
                $waon_stock_fine_amount = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_tror->tror_in_ware_id)
                    ->where('waon_class', $value['goo_waon_class'])
                    ->increment('waon_stock_priority_amount', $value['goo_quantity']);
            }
            // 仓库总库存增加
            $waon_all_amount = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $find_tror->tror_in_ware_id)
                ->where('waon_class', $value['goo_waon_class'])
                ->increment('waon_all_amount', $value['goo_quantity']);
            if (!$waon_all_amount || !$waon_stock_fine_amount) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库总数量增加失败']);
            }

            if ($value['goo_inventory'] == 1) {
                $primary_id = DB::table('transferring_order_goods')
                    ->where('trog_tror_id', $request['tror_id'])
                    ->where('trog_goo_id', $value['goo_id'])
                    ->where('trog_stock_number', '>', 0)
                    ->value('trog_id');
            } else {
                $primary_id = DB::table('transferring_order_goods')
                    ->where('trog_tror_id', $request['tror_id'])
                    ->where('trog_goo_id', $value['goo_id'])
                    ->where('trog_priority_stock_number', '>', 0)
                    ->value('trog_id');
            }
            // 仓位入库记录
            $outin_recore_res = Stocktake::junkaddition(
                $user_info,
                $find_tror->tror_out_ware_id, //仓库id
                $value['goo_waon_class'], //仓库类型
                $value['goo_wafr_id'], //仓位id
                3, //调拨入库
                $request['tror_id'], //原始单id
                $find_tror->tror_number, //原始单单号
                $primary_id, //关联商品表主键id
                $value['goo_id'], //商品表主键id
                2, //出入库类型：1出库2入库
                $value['goo_quantity'], //商品数量
                $value['goo_inventory'] //出库类型1良品2优先3待检测
            );

            // 出入库记录数据处理
            if ($value['goo_inventory'] == 1) {
                if (isset($wago_class_goods[$value['goo_waon_class']][$value['goo_id']])) {
                    // $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wfgl_lock_quantity'] += $value['wfgl_lock_quantity'];//仓库类型对应的商品，出入库记录

                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['goo_wafr_id']) {
                        $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
                    } else {
                        $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] + $value['goo_quantity']; //从仓库商品出库的商品数量
                    }
                    $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
                } else {
                    $temp_data = $value;
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['goo_wafr_id']) {
                        $temp_data['wafr_goo_quantity'] = $value['goo_quantity']; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                    } else {
                        $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = $value['goo_quantity']; //从仓库商品出库的商品数量
                    }
                    $wago_class_goods[$value['goo_waon_class']][$value['goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                    unset($temp_data);
                }
            } else {
                if (isset($priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']])) {
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['goo_wafr_id']) {
                        $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] = $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
                    } else {
                        $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] = $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] + $value['goo_quantity']; //从仓库商品出库的商品数量
                    }
                    $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] = $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
                } else {
                    $temp_data = $value;
                    // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                    if ($value['goo_wafr_id']) {
                        $temp_data['wafr_goo_quantity'] = $value['goo_quantity']; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                    } else {
                        $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                        $temp_data['wago_goo_quantity'] = $value['goo_quantity']; //从仓库商品出库的商品数量
                    }
                    $priority_wago_class_goods[$value['goo_waon_class']][$value['goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                    unset($temp_data);
                }
            }
        }
        if (!empty($wago_class_goods)) {
            // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
            foreach ($wago_class_goods as $goo_inventory => $class_goods_data) {
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$goo_inventory][$goo_id_key]['goo_quantity'] = $value['goo_quantity']; //出入库商品数量
                    $oure_goods_dataarray[$goo_inventory][$goo_id_key]['goo_inventory'] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                    $goo_all_amount += $value['goo_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['goo_quantity']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                }

                // 查询库存数量
                $amount = DB::table('warehouse_onhand')
                    ->where('waon_id', $find_tror->tror_in_waon_id)
                    ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                // 4.生成入库记录
                $outin_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_tror->tror_id, //原始单的关联id
                    $find_tror->tror_number, //原始单的关联单号
                    2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    0, //选择的客户id,会员id/单位id
                    $find_tror->tror_number, //调拨单号
                    $find_tror->tror_in_ware_id, //入库仓库id
                    0, //出库仓库id
                    $goo_all_amount, //入库商品总量
                    1, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    3, //操作类型：1锁定库存2出库3入库4调货5发货
                    $amount->waon_stock_fine_amount, //良品总库存
                    $amount->waon_lock_fine_amount, //良品锁定数量
                    $amount->waon_stock_priority_amount, //优先总库存
                    $amount->waon_lock_priority_amount, //优先锁定数量
                    $amount->waon_stock_unchecked_amount, //待检测总库存
                    2, //出入库类型：1出库，2入库
                    $find_tror->tror_out_waon_class, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    [], //仓位id
                    $oure_class_goo_id //仓库类别下的商品id
                );
                if (!$outin_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单入库失败01']);
                }
            }
            unset($wago_class_goods);
            unset($oure_goods_dataarray);
            unset($oure_goods_id);
            unset($oure_goods_quantity);
            unset($oure_goods_inventory);
            unset($oure_class_goo_id);
        }

        if (!empty($priority_wago_class_goods)) {
            // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
            foreach ($priority_wago_class_goods as $goo_inventory => $class_goods_data) {
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$goo_inventory][$goo_id_key]['goo_quantity'] = $value['goo_quantity']; //出入库商品数量
                    $oure_goods_dataarray[$goo_inventory][$goo_id_key]['goo_inventory'] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                    $goo_all_amount += $value['goo_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['goo_quantity']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                }

                // 查询库存数量
                $amount = DB::table('warehouse_onhand')
                    ->where('waon_id', $find_tror->tror_in_waon_id)
                    ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                // 4.生成入库记录
                $outin_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_tror->tror_id, //原始单的关联id
                    $find_tror->tror_number, //原始单的关联单号
                    2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    0, //选择的客户id,会员id/单位id
                    $find_tror->tror_number, //调拨单号
                    $find_tror->tror_in_ware_id, //入库仓库id
                    0, //出库仓库id
                    $goo_all_amount, //入库商品总量
                    1, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    3, //操作类型：1锁定库存2出库3入库4调货5发货
                    $amount->waon_stock_fine_amount, //良品总库存
                    $amount->waon_lock_fine_amount, //良品锁定数量
                    $amount->waon_stock_priority_amount, //优先总库存
                    $amount->waon_lock_priority_amount, //优先锁定数量
                    $amount->waon_stock_unchecked_amount, //待检测总库存
                    2, //出入库类型：1出库，2入库
                    $find_tror->tror_out_waon_class, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    [], //仓位id
                    $oure_class_goo_id //仓库类别下的商品id
                );
                if (!$outin_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单入库失败01']);
                }
            }
            unset($priority_wago_class_goods);
            unset($oure_goods_dataarray);
            unset($oure_goods_id);
            unset($oure_goods_quantity);
            unset($oure_goods_inventory);
            unset($oure_class_goo_id);
        }

        $wagl_res = DB::table('warehouse_goods_lock')
            ->where('wagl_original_id', $request['tror_id'])
            ->where('wagl_shop_id', $user_info->adm_shop_id)
            ->where('wagl_original_number', $find_tror->tror_number)
            ->where('wagl_type', 2)
            ->update(['wagl_state' => 2, 'wagl_update_time' => date('Y-m-d H:i:s')]);
        // 仓位商品锁定数据状态调整
        $wfgl_id = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_original_id', $request['tror_id'])
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->where('wfgl_type', 2)
            ->value('wfgl_id');
        if (!empty($wfgl_id)) {
            $wfgl_res = DB::table('warehouse_freight_goods_lock')
                ->where('wfgl_shop_id', $user_info->adm_shop_id)
                ->where('wfgl_original_id', $request['tror_id'])
                ->where('wfgl_original_number', $find_tror->tror_number)
                ->where('wfgl_type', 2)
                ->update(['wfgl_state' => 2, 'wfgl_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $wfgl_res = true;
        }

        // 4.更新调拨单详情数据
        $trod_data['trod_import_adm_id'] = $user_info->adm_id; //调入账号id
        $trod_data['trod_import_time'] = date('Y-m-d H:i:s'); //调入时间
        $trod_id = DB::table('transferring_order_details')
            ->where('trod_tror_id', $request['tror_id'])
            ->update($trod_data);

        $tror_updata_res = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($tror_data);

        //调拨单入库修改商品单价和总价
        $amount_ret = $this->updateWagoAmount($request['tror_id']);
        if($amount_ret['code'] != 200){
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单入库失败011']);
        }
        $post_data['ware_id'] = $find_tror->tror_in_ware_id;
        $post_data['new_goods_data'] = $goods_data;
        $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        // 记录日志
        $log_data['tror_number'] = $find_tror->tror_number;
        $log_data['user_info'] = $user_info;
        $log_data['request'] = $request->all();
        Common::write_record_log($log_data, 'pc/TransferringOrdersController.txt', 'putInStorage');
        if ($wagl_res && $wfgl_res && $tror_updata_res && $trod_id) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '调拨单', '入库', '调拨单：' . $find_tror->tror_number . '入库成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'调拨单入库成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单入库失败2']);
        }
    }

    /* 商品库存有变化的时候，修改仓库商品得总价 20230518
     * $id 调拨单id
     */
    public function updateWagoAmount($id)
    {
        //调拨单信息
        $transferring_res = DB::table('transferring_order_goods as tg')
            ->leftJoin('transferring_order as t', 't.tror_id', '=', 'tg.trog_tror_id')
            ->where('trog_tror_id', $id)
            ->select('trog_goo_id', 'tror_in_ware_id', 'tror_out_ware_id')
            ->get()->toArray();
        if(empty($transferring_res)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'调拨单不存在'];
        }
        $good_ids = array_column($transferring_res,'trog_goo_id');//调拨单里的商品id
        $tror_in_ware_id = array_column($transferring_res,'tror_in_ware_id');//调入仓库的id
        $tror_out_ware_id = array_column($transferring_res,'tror_out_ware_id');//调出仓库的id
        $ware_ids = array_merge(array_unique($tror_in_ware_id),array_unique($tror_out_ware_id));
        $ware_data['in'] = array_unique($tror_in_ware_id);
        $ware_data['out'] = array_unique($tror_out_ware_id);
        // 查询仓库商品信息
        $find_tror = DB::table('warehouse_goods')
            ->whereIn('wago_goo_id', $good_ids)
            ->where('wago_class', 1)
            ->where(function ($query) use ($ware_data) {
                $query->where('wago_ware_id', $ware_data['in'])
                    ->orwhere('wago_ware_id', $ware_data['out']);
            })
            ->select('wago_id', 'wago_goo_price', 'wago_goo_amount', 'wago_stock_number', 'wago_lock_quantity', 'wago_ware_id', 'wago_goo_id', 'wago_goo_price')
            ->get()->toArray();
        if(empty($find_tror)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库商品不存在'];
        }
        //$out_price 出库仓的商品单价
        foreach ($find_tror as $out_key => $out_value){
            if($out_value->wago_ware_id == $ware_data['out'][0]){
                $out_price[$out_value->wago_goo_id] = $out_value->wago_goo_price;
            }
        }
        //修改入库出库商品的总价
        foreach ($find_tror as $k => $v){
            $trod_data = [];
            //仓库商品得总价 = 商品单价 * （商品库存 + 商品锁定数量）
            $amount = $v->wago_goo_price * ($v->wago_stock_number + $v->wago_lock_quantity);
            $trod_data['wago_goo_amount'] = $amount;
            $trod_data['wago_update_time'] =  date('Y-m-d H:i:s'); //更新时间
            if($v->wago_ware_id == $ware_data['in'][0] && empty($v->wago_goo_price) && isset($out_price[$v->wago_goo_id])){//如果入库仓的单价为空
                $trod_data['wago_goo_price'] = $out_price[$v->wago_goo_id];
                //仓库商品得总价 = 商品单价 * （商品库存 + 商品锁定数量）
                $amount = $out_price[$v->wago_goo_id] * ($v->wago_stock_number + $v->wago_lock_quantity);
                $trod_data['wago_goo_amount'] = $amount;
            }
            //修改仓库商品的总价
            $ware_goo_ret = DB::table('warehouse_goods')
                ->where('wago_ware_id', $v->wago_ware_id)
                ->where('wago_goo_id', $v->wago_goo_id)
                ->where('wago_class', 1)
                ->update($trod_data);
        }
        //查找仓库所有商品总价
        $find_tror_all = DB::table('warehouse_goods')
            ->whereIn('wago_ware_id', $ware_ids)
            ->where('wago_class', 1)
            ->select('wago_id', 'wago_goo_amount', 'wago_ware_id')
            ->get()->toArray();
        if(empty($find_tror_all)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库不存在'];
        }
        $ware_all_data = [];
        foreach ($find_tror_all as $a_k => $a_v){
            if(isset($ware_all_data[$a_v->wago_ware_id])){
                $ware_all_data[$a_v->wago_ware_id] += $a_v->wago_goo_amount;
            }else{
                $ware_all_data[$a_v->wago_ware_id] = $a_v->wago_goo_amount;
            }
        }
        foreach ($ware_all_data as $k => $v){
            //修改仓库商品的总金额
            $ware_ret = DB::table('warehouse')
                ->where('ware_id', $k)
                ->where('ware_type', 1)
                ->update(['ware_goo_amount'=>$v]);
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'修改总价成功'];
    }

    // 撤销
    public function revocation(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->deleteValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_state', 'tror_number', 'tror_out_waon_id', 'tror_out_waon_class', 'tror_out_ware_id', 'tror_out_wafr_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount')
            ->first();
        // tror_state 状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        if ($find_tror->tror_state == 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单尚未审核']);
        }
        if ($find_tror->tror_state == 4) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已入库']);
        }
        if ($find_tror->tror_state == 5) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已驳回']);
        }
        if ($find_tror->tror_state == 6) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前调拨单已撤销']);
        }
        // 根据调拨单id，查询调拨单商品信息
        $find_trog_data = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get();

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $tror_data['tror_state'] = 6; //状态1提交/待审核2已通过/待出库3.已出库/待入库4已入库5已驳回6撤销
        $tror_data['tror_update_time'] = date('Y-m-d H:i:s');
        // 1.待出库状态的撤销，调拨单改为已撤销状态
        // 1.1调出仓库商品表【良品/优先】锁定数量转正常数量，【良品/优先】库存数量增加，锁定数量减少，
        // 1.2仓库类别总数量表，库存数量增加，锁定数量减少
        // 2.已出库状态的撤销
        // 2.1调出仓库商品库存数量增加，仓库总数量增加
        // 2.2添加出入库记录
        // 2.3状态：已撤销
        DB::beginTransaction();
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_class', 'goo_brse_id', 'goo_id', 'trog_wago_id', 'trog_waon_class', 'trog_goo_id')
            ->get()->toArray();
        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
            ->where('wfgl_original_id', $request['tror_id'])
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
            ->get()->toArray();

        if (empty($find_wfgl_goods)) {
            $find_wagl_goods = DB::table('warehouse_goods_lock')
                ->where('wagl_shop_id', $user_info->adm_shop_id)
                ->where('wagl_type', 2) //原始单类型：1订单2调拨单
                ->where('wagl_state', 1) //锁定状态：1下单锁定2出库解锁
                ->where('wagl_original_id', $find_tror->tror_id)
                ->where('wagl_original_number', $find_tror->tror_number)
                ->select('wagl_id', 'wagl_ware_id', 'wagl_wago_id', 'wagl_wafr_id', 'wagl_wafg_id', 'wagl_lock_quantity')
                ->get()->toArray();
            if (!empty($find_wagl_goods)) {
                $wfgl_key = 0;
                foreach ($find_trog as $key => $value) {
                    if ($value->trog_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 1; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                    if ($value->trog_priority_stock_number > 0) { //优先数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_priority_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 2; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                }
                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_freight_data);
            }
            // 查询仓位商品锁定表
            $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
                ->where('wfgl_shop_id', $user_info->adm_shop_id)
                ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
                ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
                ->where('wfgl_original_id', $request['tror_id'])
                ->where('wfgl_original_number', $find_tror->tror_number)
                ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
                ->get()->toArray();
        }

        // 查询仓库类型1固定仓2移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_tror->tror_out_ware_id)
            ->value('ware_type');
        $real_return = Dispatch::shipmentsChangeLock(
            $user_info, //用户信息
            $find_tror, //调拨单数据
            $ware_type, //发货仓库类型
            $request['tror_id'], //调拨单id
            $find_tror->tror_number, //调拨单单号
            $find_trog, //查询调拨单商品数据
            $find_wfgl_goods, //查询仓位锁定数据
            $type = 2 //单据类型1订单2调拨单
        );
        if ($real_return['code'] == 500) {
            DB::rollBack();
            return response()->json($real_return);
        }

        $tror_updata_res = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($tror_data);
        if ($tror_updata_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '调拨单', '撤销', '调拨单：' . $find_tror->tror_number . '撤销成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'调拨单撤销：成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单撤销：失败']);
        }
    }

    // 搜索商品
    public function searchGoods(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }
        $post['string'] = 'goo_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $search_data = $request->all();
        $list_data = DB::table('warehouse_goods as wago')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'wago.wago_goo_id')
            ->where('wago_ware_id', $request['ware_id'])
            ->where('wago_class', $request['waon_class'])
            ->where('goo_delete', 1)
            ->where('goo_state', 1)
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $user_info->adm_cid);
                } else {
                    $query->where('goo_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $where_data) {
                // if ($shop_state) {
                //     $query->where('goo_shop_id', 0)
                //         ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                // } else {
                // }
                $query->whereIn($where_data['string'], $where_data['shop_id']);
            })
            ->where(function ($query) {
                $query->where('wago_stock_number', '>', 0)
                    ->orWhere('wago_priority_stock_number', '>', 0);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_type'])) {
                    $query->where('goo_type', $search_data['goo_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_brse_id'])) {
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            }) //品牌系列id
            ->select('wago_id', 'wago_goo_id', 'goo_name', 'goo_goods_encode', 'goo_type', 'wago_stock_number', 'wago_priority_stock_number', 'goo_brse_id', 'goo_bra_name', 'goo_class', 'goo_id', 'goo_unit','goo_unta_id')
            ->orderBy('wago_stock_number', 'desc')
            ->paginate($this->show_count);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['brse_data'] = []; //品牌系列数据
        if ($data_info['data']) {
            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['data'], 'goo_brse_id')));
            if ($goo_brse_id) {
                $data_info['brse_data'] = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->select('brse_id', 'brse_name')
                    ->get();
            }
            $goo_id = array_column($data_info['data'], 'goo_id');
            // 查询商品附属表信息
            $gosu_data = DB::table('goods_subsidiary')
                ->where('gosu_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosu_goo_id', $goo_id)
                ->pluck('gosu_another_name', 'gosu_goo_id')
                ->toArray();
            // 查询入库仓库的商品的预警值
            $wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $request['in_ware_id'])
                ->where('wago_class', $request['waon_class'])
                ->whereIn('wago_goo_id', $goo_id)
                ->pluck('wago_min_warn', 'wago_goo_id')
                ->toArray();
            foreach ($data_info['data'] as $key => $value) {
                if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { // 商品别名
                    $data_info['data'][$key]->goo_name = $gosu_data[$value->goo_id];
                }
                if (isset($wago_data[$value->wago_goo_id])) { //仓库商品预警值
                    $data_info['data'][$key]->wago_min_warn = $wago_data[$value->wago_goo_id];
                } else {
                    $data_info['data'][$key]->wago_min_warn = 0;
                }
            }
        }

        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 详情和打印的公有代码
    private function publicDetails($request)
    {
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_number', 'tror_create_time', 'tror_state', 'tror_create_id', 'tror_out_ware_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_service_adm_id', 'tror_remark', 'tror_out_wafr_id')
            ->first();
        // 调出仓位名称
        $find_tror->wafr_name = DB::table('warehouse_freight')
            ->where('wafr_id', $find_tror->tror_out_wafr_id)
            ->value('wafr_name');
        unset($find_tror->tror_out_wafr_id);

        // 创建人
        $find_admin = DB::table('admin')
            ->whereIn('adm_id', [$find_tror->tror_create_id, $find_tror->tror_service_adm_id])
            ->select('adm_id', 'adm_name')
            ->get();

        // 出货仓库
        $out_ware_id = DB::table('warehouse')
            ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
            ->select('ware_id', 'ware_name')
            ->get();

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 调拨单商品信息
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_code', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_brse_id', 'goo_class', 'goo_id', 'trog_id', 'goo_unit', 'goo_unta_id')
            ->get()->toArray();
        // 查询系列数据
        $goo_brse_id = array_column($find_trog, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        $goo_id = array_column($find_trog, 'goo_id');
        // 查询商品附属表信息
        $gosu_data = DB::table('goods_subsidiary')
            ->where('gosu_shop_id', $user_info->adm_shop_id)
            ->whereIn('gosu_goo_id', $goo_id)
            ->pluck('gosu_another_name', 'gosu_goo_id')
            ->toArray();
        foreach ($find_trog as $key => $value) {
            // 查询仓位商品出入库表
            $find_wfog_data = DB::table('warehouse_freight_outin_goods as wfog')
                ->leftJoin('warehouse_freight as wafr', 'wfog.wfog_wafr_id', '=', 'wafr.wafr_id')
                ->where('wfog_shop_id', $user_info->adm_shop_id)
                ->where('wfog_type', 3)
                ->where('wfog_original_id', $request['tror_id'])
                ->where('wfog_original_number', $find_tror->tror_number)
                ->where('wfog_primary_id', $value->trog_id)
                ->where('wfog_outin_type', 2)
                ->select('wfog_wafr_id', 'wfog_stock_amount', 'wafr_name', 'wfog_stock_type')
                ->get()->toArray();
            $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
            if ($find_wfog_data) {
                $find_trog[$key]->wafr_data = $find_wfog_data;
            } else {
                $find_trog[$key]->wafr_data = [];
            }
            if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { //商品别名
                $find_trog[$key]->goo_name = $gosu_data[$value->goo_id];
            }
            // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($brse_data[$value->goo_brse_id])) {
                if (!empty($value->goo_brse_id)) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        unset($find_trog[$key]->goo_brse_id);
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($find_trog[$key]->goo_brse_id);
                        }
                    }
                }
            }
            // 显示品牌名称
            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                if ($value->goo_class == 2) {
                    $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                } else {
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    }
                }
            }
            unset($find_trog[$key]->goo_class);
        }
        $data['find_tror'] = $find_tror;
        $data['find_admin'] = $find_admin;
        $data['ware_name'] = $out_ware_id;
        $data['find_trog'] = $find_trog;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 导出
    public function export(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        DB::connection()->enableQueryLog();#开启执行日志
        $search_data = $request->all();
        $data = DB::table('transferring_order_goods as trog')
            ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->leftJoin('warehouse_goods as wgo', function($join)
            {
                $join->on('wgo.wago_ware_id', '=', 'tror.tror_out_ware_id')
                    ->whereRaw('faster_wgo.wago_goo_id = faster_trog.trog_goo_id'); // 添加额外条件
            })
            ->where('tror_cid', $user_info->adm_cid)
            ->where('tror_superior_shop_id', $shop_id)
            ->where('tror_delete', 1)
            // ->where('tror_state', '<>', 6)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('tror_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('tror_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('tror_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_number'])) {
                    $query->where('tror_number', 'like', '%' . $search_data['tror_number'] . '%');
                }
            }) //调拨单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_out_ware_id'])) {
                    $query->where('tror_out_ware_id', $search_data['tror_out_ware_id']);
                }
            }) //出货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_in_ware_id'])) {
                    $query->where('tror_in_ware_id', $search_data['tror_in_ware_id']);
                }
            }) //入货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_create_id'])) {
                    $query->where('tror_create_id', $search_data['tror_create_id']);
                }
            }) //创建人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_state'])) {
                    $query->where('tror_state', $search_data['tror_state']);
                }
            }) //状态
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['tror_service_adm_id'])) {
                    $query->where('tror_service_adm_id', $search_data['tror_service_adm_id']);
                }
            }) //服务技师id
            ->select('tror_id', 'tror_number', 'tror_out_ware_id', 'tror_in_ware_id', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'tror_create_id', 'tror_service_adm_id', 'tror_create_time', 'tror_state', 'tror_remark', 'trog_goo_id','wago_goo_price', 'goo_unit')
            ->selectRaw('wago_goo_price * (trog_stock_number + trog_priority_stock_number) AS all_price')
            ->orderBy('tror_id', 'desc')
            ->get()->toArray();
        $data['sqls'] = DB::getQueryLog()[0];
        $sqls = $data['sqls'];
        $excel = new CommonController();
        $amp_id = $search_data['amp_id']??0;
        return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token']);

        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            // 获取调拨出库的仓库id
            $out_ware_id = array_column($data, 'tror_out_ware_id');
            // 获取调拨入库的仓库id
            $in_ware_id = array_column($data, 'tror_in_ware_id');
            $ware_id = array_unique(array_merge($out_ware_id, $in_ware_id));
            // 查找仓库名称
            $find_ware = DB::table('warehouse')
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id');
            // 获取创建人id
            $create_id = array_column($data, 'tror_create_id');
            // 获取服务技师id
            $service_adm_id = array_column($data, 'tror_service_adm_id');
            $adm_id = array_unique(array_merge($create_id, $service_adm_id));
            // 查找技师id对应的账号姓名
            $find_adm_data = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id');
            // 获取调拨单的商品id
            $trog_goo_id = array_unique(array_column($data, 'trog_goo_id'));
            // 查询商品id对应的品类、品牌和系列
            $find_goo_data = DB::table('goods')
                ->whereIn('goo_id', $trog_goo_id)
                ->select('goo_bra_name', 'goo_cate_name', 'goo_brse_id', 'goo_class', 'goo_id')
                ->get()->toArray();
            $goo_data = array_column($find_goo_data, null, 'goo_id');
            $goo_brse_id = array_column($find_goo_data, 'goo_brse_id', 'goo_id');
            // 查询系列数据
            $find_brse_id = array_column($find_goo_data, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $find_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($data as $key => $value) {
                // 调出仓库
                $data[$key]['tror_out_ware_id'] = $find_ware[$value['tror_out_ware_id']];
                // 调入仓库
                $data[$key]['tror_in_ware_id'] = $find_ware[$value['tror_in_ware_id']];
                // 创建人
                if (isset($find_adm_data[$value['tror_create_id']])) {
                    $data[$key]['tror_create_id'] = $find_adm_data[$value['tror_create_id']];
                } else {
                    $data[$key]['tror_create_id'] = '';
                }
                // 服务技师
                if (isset($find_adm_data[$value['tror_service_adm_id']])) {
                    $data[$key]['tror_service_adm_id'] = $find_adm_data[$value['tror_service_adm_id']];
                } else {
                    $data[$key]['tror_service_adm_id'] = '';
                }
                if ($value['tror_state'] == 1) {
                    $data[$key]['tror_state'] = '待审核';
                } elseif ($value['tror_state'] == 2) {
                    $data[$key]['tror_state'] = '待出库';
                } elseif ($value['tror_state'] == 3) {
                    $data[$key]['tror_state'] = '待入库';
                } elseif ($value['tror_state'] == 4) {
                    $data[$key]['tror_state'] = '已入库';
                } elseif ($value['tror_state'] == 5) {
                    $data[$key]['tror_state'] = '驳回';
                } elseif ($value['tror_state'] == 6) {
                    $data[$key]['tror_state'] = '撤销';
                }
                // 商品编号
                $data[$key]['goo_goods_encode'] = empty("\t" . $value['goo_goods_encode']) ? '' : "\t" . $value['goo_goods_encode'];
                // 显示系列名称
                if (!empty($goo_brse_id[$value['trog_goo_id']]) && isset($brse_data[$goo_brse_id[$value['trog_goo_id']]])) {
                    $data[$key]['goo_name'] = $brse_data[$goo_brse_id[$value['trog_goo_id']]] . ' ' . $value['goo_name'];
                }
                // 显示品牌名称
                if (!empty($goo_data[$value['trog_goo_id']]->goo_bra_name)) {
                    $data[$key]['goo_name'] = $goo_data[$value['trog_goo_id']]->goo_bra_name . ' ' . $data[$key]['goo_name'];
                }
                // $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
                unset($data[$key]['tror_id']);
                unset($data[$key]['trog_goo_id']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = '调拨单' . time() . rand(1000, 9999) . '.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '调拨单';
        $where['field_name'] = ['单号', '调出仓库', '调入仓库', '商品名称', '检索编码', '商品类型', '良品数量', '优先数量', '创建人', '送货人', '创建时间', '状态', '备注'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->auditShowValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 调拨单数据
        $find_tror = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->select('tror_id', 'tror_number', 'tror_create_time', 'tror_state', 'tror_create_id', 'tror_out_ware_id', 'tror_out_wafr_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_service_adm_id', 'tror_remark')
            ->first();

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 调拨单商品信息
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_code', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_class', 'goo_brse_id', 'goo_id', 'trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'goo_unit')
            ->get()->toArray();
        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
            ->where('wfgl_original_id', $find_tror->tror_id)
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
            ->get()->toArray();

        if (empty($find_wfgl_goods)) {
            $find_wagl_goods = DB::table('warehouse_goods_lock')
                ->where('wagl_shop_id', $user_info->adm_shop_id)
                ->where('wagl_type', 2) //原始单类型：1订单2调拨单
                ->where('wagl_state', 1) //锁定状态：1下单锁定2出库解锁
                ->where('wagl_original_id', $find_tror->tror_id)
                ->where('wagl_original_number', $find_tror->tror_number)
                ->select('wagl_id', 'wagl_ware_id', 'wagl_wago_id', 'wagl_wafr_id', 'wagl_wafg_id', 'wagl_lock_quantity')
                ->get()->toArray();
            if (!empty($find_wagl_goods)) {
                $wfgl_key = 0;
                foreach ($find_trog as $key => $value) {
                    if ($value->trog_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 1; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                    if ($value->trog_priority_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value['trog_waon_class']; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_priority_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 2; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                }
                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_freight_data);
            }
        }
        $wago_id = array_column($find_trog, 'trog_wago_id');
        // 获取页面数据
        if ($request['type'] == 1) {
            // 创建人/服务技师
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', [$find_tror->tror_create_id, $find_tror->tror_service_adm_id])
                ->select('adm_id', 'adm_name')
                ->get();
            // 出/入库仓库
            $out_ware_id = DB::table('warehouse')
                ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
                ->select('ware_id', 'ware_name')
                ->get();
            $find_tror->tror_out_wafr_name = DB::table('warehouse_freight')
                ->where('wafr_id', $find_tror->tror_out_wafr_id)
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->value('wafr_name');

            // 查询系列数据
            $goo_brse_id = array_column($find_trog, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_trog, 'goo_id');
            // 查询商品附属表信息
            $gosu_data = DB::table('goods_subsidiary')
                ->where('gosu_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosu_goo_id', $goo_id)
                ->pluck('gosu_another_name', 'gosu_goo_id')
                ->toArray();

            $find_wogo_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                ->whereIn('wago_id', $wago_id)
                ->select('wago_id', 'wago_stock_number', 'wago_priority_stock_number')
                ->get()->toArray();
            $find_wogo_data = array_column($find_wogo_data, null, 'wago_id');
            // 查询入库仓库的商品的预警值
            $wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                ->where('wago_class', $find_tror->tror_out_waon_class)
                ->whereIn('wago_goo_id', $goo_id)
                ->pluck('wago_min_warn', 'wago_goo_id')
                ->toArray();
            foreach ($find_trog as $key => $value) {
                if (isset($gosu_data[$value->goo_id]) && !empty($gosu_data[$value->goo_id])) { //商品别名
                    $find_trog[$key]->goo_name = $gosu_data[$value->goo_id];
                }
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP')) && isset($brse_data[$value->goo_brse_id])) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($value->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                unset($value->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }
                if (isset($find_wogo_data[$value->trog_wago_id])) {
                    $find_trog[$key]->wago_stock_number = $find_wogo_data[$value->trog_wago_id]->wago_stock_number;
                    $find_trog[$key]->wago_priority_stock_number = $find_wogo_data[$value->trog_wago_id]->wago_priority_stock_number;
                } else {
                    $find_trog[$key]->wago_stock_number = 0;
                    $find_trog[$key]->wago_priority_stock_number = 0;
                }
                if (isset($wago_data[$value->goo_id])) { //仓库商品预警值
                    $find_trog[$key]->wago_min_warn = $wago_data[$value->goo_id];
                } else {
                    $find_trog[$key]->wago_min_warn = 0;
                }
                $find_trog[$key]->goo_name = $find_trog[$key]->goo_name.'('.$value->goo_unit.')';
                unset($find_trog[$key]->goo_class);
            }
            $data['find_tror'] = $find_tror;
            $data['find_admin'] = $find_admin;
            $data['ware_name'] = $out_ware_id;
            $data['find_trog'] = $find_trog;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 验证数据
        $verify_data = new VerifyTransferringOrdersController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $goo_fine_amount = 0; //良品总数量
        $goo_priority_amount = 0; //优先总数量
        $goods_data = json_decode($request['goods_data'], true);
        $request_goods_data = json_decode($request['goods_data'], true);
        // ware_type类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_tror->tror_out_ware_id)
            ->value('ware_type');
        if (empty($goods_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择商品']);
        }

        foreach ($goods_data as $key => $value) {
            if (!is_numeric($value['goo_wago_id']) || !is_numeric($value['goo_id']) || !is_numeric($value['goo_waon_class']) || !is_numeric($value['goo_quantity']) || !in_array($value['goo_inventory'], [1, 2])) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'商品参数类型错误']);
            }
            $trog_data[$key]['trog_tror_id'] = $request['tror_id'];
            $trog_data[$key]['trog_wago_id'] = $value['goo_wago_id']; //仓库商品id
            $trog_data[$key]['trog_goo_id'] = $value['goo_id']; //商品id
            $trog_data[$key]['trog_waon_class'] = $value['goo_waon_class']; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            if ($value['goo_inventory'] == 1) { //库存扣除方式1.良品 2.优先
                $goo_priority_amount += 0; //优先总数量
                $goo_fine_amount += $value['goo_quantity']; //良品总数量
                $trog_data[$key]['trog_stock_number'] = $value['goo_quantity']; //良品库存数量
                $trog_data[$key]['trog_priority_stock_number'] = 0; //优先库存数量
            } else {
                $goo_fine_amount += 0; //良品总数量
                $goo_priority_amount += $value['goo_quantity']; //优先总数量
                $trog_data[$key]['trog_stock_number'] = 0; //良品库存数量
                $trog_data[$key]['trog_priority_stock_number'] = $value['goo_quantity']; //优先库存数量
            }
            $trog_data[$key]['trog_update_time'] = date('Y-m-d H:i:s');
            $wago_id[] = $value['goo_wago_id'];
            $goo_id[] = $value['goo_id'];
            $goo_waon_class[] = $value['goo_waon_class'];
            // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
            if (isset($neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']])) {
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
            } else {
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']] = $value;
            }
        }

        // 查询调出仓库类别的id
        $tror_out_waon_id = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_tror->tror_out_ware_id)
            ->where('waon_class', $find_tror->tror_out_waon_class)
            ->value('waon_id');
        // 1、编辑调拨单数据
        $tror_data['tror_goo_fine_amount'] = $goo_fine_amount; //良品总数量
        $tror_data['tror_goo_priority_amount'] = $goo_priority_amount; //优先总数量
        $tror_data['tror_remark'] = $request['tror_remark'] ? $request['tror_remark'] : '';
        $tror_data['tror_service_adm_id'] = $request['tror_service_adm_id'] ? $request['tror_service_adm_id'] : 0; //服务技师id
        $tror_data['tror_update_time'] = date('Y-m-d H:i:s');

        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
            ->where('wfgl_original_id', $find_tror->tror_id)
            ->where('wfgl_original_number', $find_tror->tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
            ->get()->toArray();

        DB::beginTransaction();
        // 把原来仓库锁定库存还回去
        $type = 2; //单据类型1订单2调拨单
        $change_lock_return = Dispatch::shipmentsChangeLock(
            $user_info, //用户信息
            $find_tror, //调拨单数据
            $ware_type, //出库仓库类型
            $find_tror->tror_id, //调拨单id
            $find_tror->tror_number, //调拨单单号
            $find_trog, //查询调拨单商品数据
            $find_wfgl_goods, //查询仓位锁定数据
            $type
        );
        if ($change_lock_return['code'] == 500) {
            DB::rollBack();
            return response()->json($change_lock_return);
        }
        $order_data['data']['ord_order_number'] = $find_tror->tror_number;
        $order_data['data']['ord_id'] = $find_tror->tror_id;
        $request['ware_id'] = $request['tror_out_ware_id'];
        if (!empty($neaten_goods_data) && empty($request['tror_out_wafr_id'])) {
            $type = 2;
            $ware_lock_return = WarehouseLock::warehouseLockInventory(
                $user_info,
                $request->all(),
                $order_data,
                $neaten_goods_data,
                $type
            );
            if ($ware_lock_return['code'] == 500) {
                DB::rollBack();
                return response()->json($ware_lock_return);
            }
            $neaten_wago_id = []; //良品商品
            $priority_neaten_wago_id = []; //优先商品
            $wagl_key = 0;
            $wagl_lock_quantity = []; //仓库锁定表的商品锁定数量
            foreach ($neaten_goods_data as $wago_id => $wago_id_value) {
                foreach ($wago_id_value as $goo_inventory => $goo_value) {
                    if ($goo_inventory == 1) {
                        // 良品商品锁定库存
                        $ware_id[$wago_id] = $request['ware_id'];
                        $wago_goo_id[$wago_id] = $goo_value['goo_id'];
                        $wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                        $wago_goo_inventory[$wago_id] = $goo_inventory;
                        $wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                        $neaten_wago_id[] = $wago_id;
                    } else {
                        // 优先商品锁定库存
                        $priority_ware_id[$wago_id] = $request['ware_id'];
                        $priority_wago_goo_id[$wago_id] = $goo_value['goo_id'];
                        $priority_wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                        $priority_wago_goo_inventory[$wago_id] = $goo_inventory;
                        $priority_wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                        $priority_neaten_wago_id[] = $wago_id;
                    }
                    // 仓库锁定表的商品锁定数量：良品+优先 总的锁定数量
                    if (isset($wagl_lock_quantity[$wago_id])) {
                        $wagl_lock_quantity[$wago_id] += $goo_value['goo_quantity'];
                    } else {
                        $wagl_lock_quantity[$wago_id] = $goo_value['goo_quantity'];
                    }
                }

                // 仓库商品锁定表
                $wagl_data[$wagl_key]['wagl_shop_id'] = $user_info->adm_shop_id;
                $wagl_data[$wagl_key]['wagl_ware_id'] = $request['ware_id'];
                $wagl_data[$wagl_key]['wagl_wago_id'] = $wago_id;
                $wagl_data[$wagl_key]['wagl_original_id'] = $order_data['data']['ord_id'];
                $wagl_data[$wagl_key]['wagl_original_number'] = $order_data['data']['ord_order_number'];
                $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $order_data['data']['ord_id']; //关联id：订单id/发货单id/调拨单id
                $wagl_data[$wagl_key]['wagl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                $wagl_data[$wagl_key]['wagl_type'] = 2; //  原始单类型：1订单2调拨单
                $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                $wagl_data[$wagl_key]['wagl_lock_quantity'] = $wagl_lock_quantity[$wago_id]; //商品锁定库存数量
                $wagl_key++;
            }
        }

        // 编辑调拨单
        $tror_id = DB::table('transferring_order')
            ->where('tror_id', $request['tror_id'])
            ->update($tror_data);

        // 删除原来的调拨单商品
        $del_trog_id = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $request['tror_id'])
            ->delete();

        // 重新添加提交的调拨单数据
        $trog_id = DB::table('transferring_order_goods')->insert($trog_data);
        // 锁定商品库存表
        $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);
        if ($tror_id && $del_trog_id && $trog_id && $wagl_res) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '调拨单', '编辑', '编辑调拨单：' . $find_tror->tror_number . '成功');
            return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'编辑调拨单：成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'编辑调拨单：失败']);
        }
    }

}
