<?php

namespace App\Http\Controllers\Api\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\Export;

// 仓储系统 -- 商品流水记录
class GoodsRecordController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function oldindex(Request $request)
    {
        $search_data = $request->all();

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $page_size  = (int) $request->input('show_count', 10);
        $list_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', $user_info->adm_cid)
            ->where('oure_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) { //选择的客户id,会员id/单位id
                if (!empty($request['client_id'])) {
                    $query->where('oure_client_id', $request['client_id']);
                }
            })
            ->where(function ($query) use ($request) { //仓库id
                if (!empty($request['ware_id'])) {
                    $query->where('oure_out_ware_id', $request['ware_id'])
                        ->orwhere('oure_in_ware_id', $request['ware_id']);
                }
            })
            ->where(function ($query) use ($request) { //品牌id
                if (!empty($request['goo_bra_id'])) {
                    $query->where('goo_bra_id', $request['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //出入库类型：1出库，2入库
                if (!empty($search_data['oure_out_in_type'])) {
                    $query->where('oure_out_in_type', $search_data['oure_out_in_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('oure_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('oure_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('oure_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                if (!empty($search_data['oure_waon_class'])) {
                    $query->where('oure_waon_class', $search_data['oure_waon_class']);
                }
            })
            ->where(function ($query) use ($search_data) { //单号
                if (!empty($search_data['oure_number'])) {
                    $query->where('oure_number', 'like', '%' . $search_data['oure_number'] . '%')
                        ->orwhere('oure_original_correlation_number', 'like', '%' . $search_data['oure_number'] . '%')
                        ->orwhere('oure_original_number', 'like', '%' . $search_data['oure_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                if (!empty($search_data['oure_client_type'])) {
                    $query->where('oure_client_type', $search_data['oure_client_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //选择的客户id,会员id/单位id
                if (!empty($search_data['oure_client_id'])) {
                    $query->where('oure_client_id', $search_data['oure_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //品牌系列id
                if (!empty($search_data['goo_brse_id'])) {
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            })
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_oldnum', 'oude_goo_number', 'oude_goo_newnum', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_correlation_type', 'oure_client_type', 'oure_client_id', 'oure_out_in_type', 'goo_brse_id', 'goo_bra_name', 'goo_class', 'oure_out_ware_id', 'oure_in_ware_id', 'goo_unit', 'goo_unta_id', 'goo_unit_conversion', 'oure_type', 'oude_goo_id')
            ->orderBy('oure_create_time', 'desc')
            // ->orderBy('oude_id', 'desc')
            ->paginate($page_size);
        $list_items = $list_data->items();
        $list_items = json_decode(json_encode($list_items), true);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据
        $data_info['brse_data'] = []; //品牌系列数据

        if ($data_info['data']) {
            $goo_id = array_column($data_info['data'], 'goo_id');
            $oure_client_id = array_unique(array_column($data_info['data'], 'oure_client_id'));
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();

            // 查询来往单位
            $channel_data = DB::table('channel_unit')
                ->where('chun_shop_id', $user_info->adm_shop_id)
                ->where('chun_state', '1')
                ->whereIn('chun_id', $oure_client_id)
                ->pluck('chun_unit_name', 'chun_id')
                ->toArray();
            // 查询会员客户
            $member_data = DB::table('member')
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->whereIn('mem_id', $oure_client_id)
                ->pluck('mem_name', 'mem_id')
                ->toArray();

            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['data'], 'goo_brse_id')));
            if ($goo_brse_id) {
                $data_info['brse_data'] = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->select('brse_id', 'brse_name')
                    ->get();
            }

            // 获取出入库记录的仓库id
            $out_ware_id = array_column($data_info['data'], 'oure_out_ware_id');
            $in_ware_id = array_column($data_info['data'], 'oure_in_ware_id');
            $ware_id = array_unique(array_merge($out_ware_id, $in_ware_id));
            // 查询仓库信息
            $find_ware = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id')->toArray();
            foreach ($data_info['data'] as $key => $value) {
                if ($value['goo_class'] == 2 && isset($gosa_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) {
                    $data_info['data'][$key]['goo_name'] = $gosa_data[$value['goo_id']];
                }
                if (isset($goaf_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) { // 商品别名
                    $data_info['data'][$key]['goo_name'] = $goaf_data[$value['goo_id']];
                }
                if ($value['oure_client_type'] == 5) { //5运营中心与基础门店
                    $data_info['data'][$key]["oure_client_name"] = DB::table('shop')
                        ->where('shop_id', $value['oure_client_id'])
                        ->value('shop_store_name');
                } elseif ($value['oure_client_type'] == 1) { //会员零售
                    if (isset($member_data[$value['oure_client_id']])) {
                        $data_info['data'][$key]["oure_client_name"] = $member_data[$value['oure_client_id']];
                    } else {
                        $data_info['data'][$key]["oure_client_name"] = '';
                    }
                } else {
                    if (isset($channel_data[$value['oure_client_id']])) {
                        $data_info['data'][$key]["oure_client_name"] = $channel_data[$value['oure_client_id']];
                    } else {
                        $data_info['data'][$key]["oure_client_name"] = '';
                    }
                }
                if ($value['oure_out_ware_id']) {
                    $data_info['data'][$key]['oure_out_ware_id'] = isset($find_ware[$value['oure_out_ware_id']]) ? $find_ware[$value['oure_out_ware_id']] : '';
                } else {
                    $data_info['data'][$key]['oure_out_ware_id'] = '';
                }
                if ($value['oure_in_ware_id']) {
                    $data_info['data'][$key]['oure_in_ware_id'] = isset($find_ware[$value['oure_in_ware_id']]) ? $find_ware[$value['oure_in_ware_id']] : '';
                } else {
                    $data_info['data'][$key]['oure_in_ware_id'] = '';
                }
                if ($value['oure_type'] == 9) {
                    $dego_original_number[] = $value['oure_original_correlation_number'];
                    $wor_number = DB::table('work_order')->where('wor_order_number',$value['oure_original_correlation_number'])->value('wor_number');
                    if(!empty($wor_number)){
                        $dego_original_number[] = $wor_number;
                    }
                    $find_order = DB::table('dispatch_bill as a')
                        ->leftJoin('dispatch_goods as b', 'b.digo_dego_id','=','a.dego_id')
                        ->whereIn('dego_original_number',$dego_original_number)
                        ->where('digo_goo_id',$value['oude_goo_id'])
                        ->select('digo_goo_unta_id as orgo_goo_unta_id')
                        ->first();
                    $data_info['data'][$key]['oude_goo_number'] = $value['oude_goo_number'] .$value['goo_unit'];
                } else {
                    if ($value['goo_unta_id'] == 1) {
                        $data_info['data'][$key]['oude_goo_number'] = $value['oude_goo_number'] .'米';
                        $data_info['data'][$key]['goo_unit'] = '米';
                    } else {
                        $data_info['data'][$key]['oude_goo_number'] = $value['oude_goo_number'] .$value['goo_unit'];
                    }
                }
                unset($data_info['data'][$key]['goo_id']);
                unset($data_info['data'][$key]['goo_class']);
            }
        }

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 列表
    public function index(Request $request)
    {
        $search_data = $request->all();

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $page_size  = (int) $request->input('show_count', 10);
        $list_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', $user_info->adm_cid)
            ->where('oure_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) { //选择的客户id,会员id/单位id
                if (!empty($request['client_id'])) {
                    $query->where('oure_client_id', $request['client_id']);
                }
            })
            ->where(function ($query) use ($request) { //仓库id
                if (!empty($request['ware_id'])) {
                    $query->where('oure_out_ware_id', $request['ware_id'])
                        ->orwhere('oure_in_ware_id', $request['ware_id']);
                }
            })
            ->where(function ($query) use ($request) { //品牌id
                if (!empty($request['goo_bra_id'])) {
                    $query->where('goo_bra_id', $request['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //出入库类型：1出库，2入库
                if (!empty($search_data['oure_out_in_type'])) {
                    $query->where('oure_out_in_type', $search_data['oure_out_in_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('oure_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('oure_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('oure_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                if (!empty($search_data['oure_waon_class'])) {
                    $query->where('oure_waon_class', $search_data['oure_waon_class']);
                }
            })
            ->where(function ($query) use ($search_data) { //单号
                if (!empty($search_data['oure_number'])) {
                    $query->where('oure_number', 'like', '%' . $search_data['oure_number'] . '%')
                        ->orwhere('oure_original_correlation_number', 'like', '%' . $search_data['oure_number'] . '%')
                        ->orwhere('oure_original_number', 'like', '%' . $search_data['oure_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //商品名称
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                if (!empty($search_data['oure_client_type'])) {
                    $query->where('oure_client_type', $search_data['oure_client_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //选择的客户id,会员id/单位id
                if (!empty($search_data['oure_client_id'])) {
                    $query->where('oure_client_id', $search_data['oure_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //品牌系列id
                if (!empty($search_data['goo_brse_id'])) {
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            })
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_oldnum', 'oude_goo_number', 'oude_goo_newnum', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_correlation_type', 'oure_client_type', 'oure_client_id', 'oure_out_in_type', 'goo_brse_id', 'goo_bra_name', 'goo_class', 'oure_out_ware_id', 'oure_in_ware_id', 'goo_unit', 'goo_unta_id', 'goo_unit_conversion', 'oure_type', 'oude_goo_id')
            ->orderBy('oure_create_time', 'desc')
            // ->orderBy('oude_id', 'desc')
            ->paginate($page_size);
        $list_items = $list_data->items();
        $list_items = json_decode(json_encode($list_items), true);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据
        $data_info['brse_data'] = []; //品牌系列数据

        if ($data_info['data']) {
            $goo_id = array_column($data_info['data'], 'goo_id');
            $oure_client_id = array_unique(array_column($data_info['data'], 'oure_client_id'));
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();

            // 查询来往单位
            $channel_data = DB::table('channel_unit')
                ->where('chun_shop_id', $user_info->adm_shop_id)
                ->where('chun_state', '1')
                ->whereIn('chun_id', $oure_client_id)
                ->pluck('chun_unit_name', 'chun_id')
                ->toArray();
            // 查询会员客户
            $member_data = DB::table('member')
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->whereIn('mem_id', $oure_client_id)
                ->pluck('mem_name', 'mem_id')
                ->toArray();

            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['data'], 'goo_brse_id')));
            if ($goo_brse_id) {
                $data_info['brse_data'] = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->select('brse_id', 'brse_name')
                    ->get();
            }

            // 获取出入库记录的仓库id
            $out_ware_id = array_column($data_info['data'], 'oure_out_ware_id');
            $in_ware_id = array_column($data_info['data'], 'oure_in_ware_id');
            $ware_id = array_unique(array_merge($out_ware_id, $in_ware_id));
            // 查询仓库信息
            $find_ware = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->whereIn('ware_id', $ware_id)
                ->pluck('ware_name', 'ware_id')->toArray();
            foreach ($data_info['data'] as $key => $value) {
                if ($value['goo_class'] == 2 && isset($gosa_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) {
                    $data_info['data'][$key]['goo_name'] = $gosa_data[$value['goo_id']];
                }
                if (isset($goaf_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) { // 商品别名
                    $data_info['data'][$key]['goo_name'] = $goaf_data[$value['goo_id']];
                }
                if ($value['oure_client_type'] == 5) { //5运营中心与基础门店
                    $data_info['data'][$key]["oure_client_name"] = DB::table('shop')
                        ->where('shop_id', $value['oure_client_id'])
                        ->value('shop_store_name');
                } elseif ($value['oure_client_type'] == 1) { //会员零售
                    if (isset($member_data[$value['oure_client_id']])) {
                        $data_info['data'][$key]["oure_client_name"] = $member_data[$value['oure_client_id']];
                    } else {
                        $data_info['data'][$key]["oure_client_name"] = '';
                    }
                } else {
                    if (isset($channel_data[$value['oure_client_id']])) {
                        $data_info['data'][$key]["oure_client_name"] = $channel_data[$value['oure_client_id']];
                    } else {
                        $data_info['data'][$key]["oure_client_name"] = '';
                    }
                }
                if ($value['oure_out_ware_id']) {
                    $data_info['data'][$key]['oure_out_ware_id'] = isset($find_ware[$value['oure_out_ware_id']]) ? $find_ware[$value['oure_out_ware_id']] : '';
                } else {
                    $data_info['data'][$key]['oure_out_ware_id'] = '';
                }
                if ($value['oure_in_ware_id']) {
                    $data_info['data'][$key]['oure_in_ware_id'] = isset($find_ware[$value['oure_in_ware_id']]) ? $find_ware[$value['oure_in_ware_id']] : '';
                } else {
                    $data_info['data'][$key]['oure_in_ware_id'] = '';
                }
                if ($value['oure_type'] == 9) {
                    $dego_original_number[] = $value['oure_original_correlation_number'];
                    $wor_number = DB::table('work_order')->where('wor_order_number',$value['oure_original_correlation_number'])->value('wor_number');
                    if(!empty($wor_number)){
                        $dego_original_number[] = $wor_number;
                    }
                    $find_order = DB::table('dispatch_bill as a')
                        ->leftJoin('dispatch_goods as b', 'b.digo_dego_id','=','a.dego_id')
                        ->whereIn('dego_original_number',$dego_original_number)
                        ->where('digo_goo_id',$value['oude_goo_id'])
                        ->select('digo_goo_unta_id as orgo_goo_unta_id')
                        ->first();
                    $data_info['data'][$key]['oude_goo_number'] = $value['oude_goo_number'] .$value['goo_unit'];
                } else {
                    $data_info['data'][$key]['oude_goo_number'] = $value['oude_goo_number'] .$value['goo_unit'];
                }
                unset($data_info['data'][$key]['goo_id']);
                unset($data_info['data'][$key]['goo_class']);
            }
        }

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 导出
    public function export(Request $request)
    {
        $search_data = $request->all();

        if (!empty($search_data['ware_id']) || !empty($search_data['oure_waon_class']) || !empty($search_data['oure_number']) || !empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['oure_original_number']) || !empty($search_data['goo_name']) || !empty($search_data['goo_goods_encode'])) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

            $data = DB::table('outin_details as a')
                ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
                ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
                ->where('oure_cid', $user_info->adm_cid)
                ->where('oure_shop_id', $shop_id)
                ->where(function ($query) use ($request) {
                    if (!empty($request['client_id'])) {
                        $query->where('oure_client_id', $request['client_id']);
                    }
                })
                ->where(function ($query) use ($request) { //仓库id
                    if (!empty($request['ware_id'])) {
                        $query->where('oure_out_ware_id', $request['ware_id'])
                            ->orwhere('oure_in_ware_id', $request['ware_id']);
                    }
                })
                ->where(function ($query) use ($request) { //品牌id
                    if (!empty($request['goo_bra_id'])) {
                        $query->where('goo_bra_id', $request['goo_bra_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //出入库类型：1出库，2入库
                    if (!empty($search_data['oure_out_in_type'])) {
                        $query->where('oure_out_in_type', $search_data['oure_out_in_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //创建时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                        $query->whereBetween('oure_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])) {
                            $query->where('oure_create_time', '>=', $search_data['start_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('oure_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                    if (!empty($search_data['oure_waon_class'])) {
                        $query->where('oure_waon_class', $search_data['oure_waon_class']);
                    }
                })
                ->where(function ($query) use ($search_data) { //单号
                    if (!empty($search_data['oure_number'])) {
                        $query->where('oure_number', 'like', '%' . $search_data['oure_number'] . '%')
                            ->orwhere('oure_original_correlation_number', 'like', '%' . $search_data['oure_number'] . '%')
                            ->orwhere('oure_original_number', 'like', '%' . $search_data['oure_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //商品名称
                    if (!empty($search_data['goo_name'])) {
                        $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //检索编码
                    if (!empty($search_data['goo_goods_encode'])) {
                        $query->where('goo_goods_encode', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    if (!empty($search_data['oure_client_type'])) {
                        $query->where('oure_client_type', $search_data['oure_client_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //选择的客户id,会员id/单位id
                    if (!empty($search_data['oure_client_id'])) {
                        $query->where('oure_client_id', $search_data['oure_client_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //品牌系列id
                    if (!empty($search_data['goo_brse_id'])) {
                        $query->where('goo_brse_id', $search_data['goo_brse_id']);
                    }
                })
                ->select('oure_original_correlation_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_brse_id', 'oure_out_in_type', 'goo_id', 'oude_goo_oldnum', 'oude_goo_number', 'oude_goo_newnum', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time', 'oure_client_id', 'goo_id', 'goo_class', 'oure_client_type', 'goo_unit')
                ->orderBy('oure_create_time', 'desc')
                ->get()->toArray();
            if (!empty($data)) {
                // 将对象转化为数组
                $data = json_decode(json_encode($data), true);
                $oure_client_id = array_unique(array_column($data, 'oure_client_id'));
                // 查询系列数据
                $goo_brse_id = array_column($data, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                // 查询来往单位
                $channel = DB::table('channel_unit')
                    ->whereIn('chun_id', $oure_client_id)
                    ->where('chun_shop_id', $shop_id)
                    ->where('chun_state', '1')
                    ->pluck('chun_unit_name', 'chun_id')
                    ->toArray();
                // 查询会员客户
                $member_data = DB::table('member')
                    ->where('mem_shop_id', $user_info->adm_shop_id)
                    ->whereIn('mem_id', $oure_client_id)
                    ->pluck('mem_name', 'mem_id')
                    ->toArray();
                $goo_id = array_column($data, 'goo_id');
                // 查询商品附属表信息
                $goaf_data = DB::table('goods_affiliate')
                    ->where('goaf_shop_id', $user_info->adm_shop_id)
                    ->whereIn('goaf_goo_id', $goo_id)
                    ->pluck('goaf_another_name', 'goaf_goo_id')
                    ->toArray();
                // 查询系统商品属性表信息
                $gosa_data = DB::table('goods_system_affiliate')
                    ->where('gosa_shop_id', $user_info->adm_shop_id)
                    ->whereIn('gosa_goo_id', $goo_id)
                    ->pluck('gosa_another_name', 'gosa_goo_id')
                    ->toArray();
                $dataarray = array();
                foreach ($data as $key => $value) {
                    $dataarray[$key]['oure_original_correlation_number'] = $value['oure_original_correlation_number'];
                    $dataarray[$key]['oure_original_number'] = $value['oure_original_number'];
                    if ($value['oure_client_type'] == 5) { //5运营中心与基础门店
                        $dataarray[$key]["oure_client_name"] = DB::table('shop')
                            ->where('shop_id', $value['oure_client_id'])
                            ->value('shop_store_name');
                    } elseif ($value['oure_client_type'] == 1) { //会员零售
                        if (isset($member_data[$value['oure_client_id']])) {
                            $dataarray[$key]["oure_client_name"] = $member_data[$value['oure_client_id']];
                        } else {
                            $dataarray[$key]["oure_client_name"] = '';
                        }
                    } else {
                        if (isset($channel[$value['oure_client_id']])) {
                            $dataarray[$key]["oure_client_name"] = $channel[$value['oure_client_id']];
                        } else {
                            $dataarray[$key]["oure_client_name"] = '';
                        }
                    }
                    $dataarray[$key]['goo_name'] = $value['goo_name'].'('.$value['goo_unit'].')';
                    if ($value['goo_class'] == 2 && isset($gosa_data[$value['goo_id']]) && !empty($gosa_data[$value['goo_id']])) {
                        $dataarray[$key]['goo_name'] = $gosa_data[$value['goo_id']];
                    }
                    if (isset($goaf_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) { // 商品别名
                        $dataarray[$key]['goo_name'] = $goaf_data[$value['goo_id']];
                    }
                    // 商品编号
                    $dataarray[$key]['goo_goods_encode'] = "\t" . $value['goo_goods_encode'];
                    $dataarray[$key]['goo_bra_name'] = $value['goo_bra_name'];
                    if (!empty($value['goo_brse_id'])) {
                        $dataarray[$key]['goo_brse_id'] = $brse_data[$value['goo_brse_id']];
                    } else {
                        $dataarray[$key]['goo_brse_id'] = '';
                    }
                    // 出入库类型：1出库，2入库
                    if ($value['oure_out_in_type'] == 1) {
                        $dataarray[$key]['oure_out_in_type'] = '出库';
                    } else {
                        $dataarray[$key]['oure_out_in_type'] = '入库';
                    }
                    $dataarray[$key]['oude_goo_oldnum'] = "\t" . $value['oude_goo_oldnum'];
                    if ($value['oure_out_in_type'] == 1) {
                        $dataarray[$key]['oude_goo_number'] = '-' . $value['oude_goo_number'];
                    } else {
                        $dataarray[$key]['oude_goo_number'] = $value['oude_goo_number'];
                    }
                    $dataarray[$key]['oude_goo_newnum'] = "\t" . $value['oude_goo_newnum'];
                    // 商品类型
                    if ($value['goo_type'] == 1) {
                        $dataarray[$key]['goo_type'] = '正常';
                    } elseif ($value['goo_type'] == 2) {
                        $dataarray[$key]['goo_type'] = '赠品';
                    } elseif ($value['goo_type'] == 4) {
                        $dataarray[$key]['goo_type'] = '旧货';
                    }
                    // 仓库类别
                    if ($value['oure_waon_class'] == 1) {
                        $dataarray[$key]['oure_waon_class'] = '货物仓';
                    } elseif ($value['oure_waon_class'] == 2) {
                        $dataarray[$key]['oure_waon_class'] = '非商品仓';
                    } elseif ($value['oure_waon_class'] == 3) {
                        $dataarray[$key]['oure_waon_class'] = '旧货仓';
                    } elseif ($value['oure_waon_class'] == 4) {
                        $dataarray[$key]['oure_waon_class'] = '临时仓';
                    }
                    // 类型1良品2优先
                    if ($value['oude_type'] == 1) {
                        $dataarray[$key]['oude_type'] = '良品';
                    } else {
                        $dataarray[$key]['oude_type'] = '优先';
                    }
                    $dataarray[$key]['oure_create_time'] = $value['oure_create_time'];
                }
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
            }
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }

            $streamFileRand = '商品流水记录' . time() . rand(100, 999) . '.xls'; //
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '商品流水记录';
            $where['field_name'] = ['单号', '原始单号', '单位名称', '商品名称', '检索编码', '品牌名称', '系列名称', '记录类型', '更变前结存', '数量', '更变后结存', '商品类型', '仓库类别', '出入库类型', '操作时间'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $dataarray      //导出数据
            );

            // 判断文件是否存在 存在则成功  不存在则失败
            if (file_exists($streamFilename)) {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择搜索条件']);
        }
    }
}
