<?php

namespace App\Http\Controllers\Api\WarehouseManage;

use App\Http\Models\Api\Common;
use App\Services\Business\MemberLevelService;
use App\Services\LoginUserService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Business\DeliveryService;

class DeliveryController extends Controller
{

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::list($user_info,$input);
        return response()->json($data);
    }

    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     */
    public function add (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::add($user_info,$request);
        return response()->json($data);

    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function edit (Request $request)
    {
        $request = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::edit($user_info,$request);
        return response()->json($data);
    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function editStatus (Request $request)
    {
        $request = $request->all();
        $data = DeliveryService::editStatus($request);
        return response()->json($data);
    }

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     */
    public function allIndex (Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::allIndex($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function addDelivery(Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::addDelivery($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function deliveryList(Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::deliveryList($user_info,$input);
        return response()->json($data);
    }

    //给发货单添加快递信息
    public function deliveryEdit(Request $request)
    {
        $input = $request->all();
        $user_info = Common::getUserInfo($request['api_token']);
        $data = DeliveryService::editDelivery($user_info,$input);
        return response()->json($data);
    }
}
