<?php

namespace App\Http\Controllers\Api\Verify\recycleManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyRecedeRecycleController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '参数错误',
            'rec_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_type.required' => '参数错误',
            'rec_type.in' => '参数类型错误',
            'mem_name.required' => '参数错误',
            'mem_name.max' => '参数类型错误',
            'mem_phone.required' => '参数错误',
            'mem_phone.regex' => '参数类型错误',
            'chun_unit_name.required_if' => '参数错误',
            'chun_unit_name.max' => '参数类型错误',
            'mem_id.required' => '参数错误',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数错误',
            'rec_date.required' => '请输入:日期',
            'rec_date.date' => '参数类型错误',
            'rec_price.required' => '请输入:金额',
            'rec_price.numeric' => '参数类型错误',
            'rec_price.min' => '请输入正数',
            'rec_amount.required' => '参数错误',
            'rec_amount.numeric' => '参数类型错误',
            'rec_amount.min' => '总数量至少为1',
            'rec_ware_id.required' => '参数错误',
            'rec_ware_id.integer' => '参数类型错误',
            'rec_ware_id.min' => '参数错误',
            // 'rec_remark.required' => '请输入:备注',
            'rec_remark.max' => '备注长度超过最大限制',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型不正确',
            'goo_name.required' => '参数错误',
            'goo_name.array' => '参数类型不正确',
            'goo_goods_encode.required' => '参数错误',
            'goo_goods_encode.array' => '参数类型不正确',
            'goo_amount.required' => '参数错误',
            'goo_amount.array' => '参数类型不正确',
            'goo_price.required' => '参数错误',
            'goo_price.array' => '参数类型不正确',
            'goo_recycle_amount.required' => '参数错误',
            'goo_recycle_amount.array' => '参数类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //买家类型 1.门店零售 2.来往单位
            'mem_name' => 'required|max:20', //会员名称/客户名称
            'mem_phone' => 'required|regex:/^1[3456789]\d{9}$/', //会员手机号/客户电话
            'mem_id' => 'required|integer|min:1', //来往单位id/客户id
            'chun_unit_name' => 'required_if:rec_type,2|max:20', //来往单位名称
            'rec_date' => 'required|date', //日期
            'rec_price' => 'required|numeric|min:0', //回收总金额
            'rec_amount' => 'required|numeric|min:1', //回收总数量
            'rec_ware_id' => 'required|integer|min:1', //仓库id
            'rec_remark' => 'sometimes|max:255', //备注
            'goo_id' => 'required|array', //商品id
            'goo_name' => 'required|array', //商品名称
            'goo_goods_encode' => 'required|array', //商品编号
            'goo_amount' => 'required|array', //商品数量
            'goo_price' => 'required|array', //售价
            'goo_recycle_amount' => 'required|array', //退货数量

        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '参数错误',
            'rec_id.min' => '参数错误',
            'rec_number.required_if' => '参数错误',
            'rec_number.max' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1',
            'rec_number' => 'required_if:type,2|max:20',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器(待修改)
    public function recycleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_date.required' => '参数错误',
            'rec_date.date' => '参数类型不正确',
            'rec_price.required' => '参数错误',
            'rec_price.numeric' => '参数类型不正确',
            'rec_amount.required' => '参数错误',
            'rec_amount.numeric' => '参数类型错误',
            'rec_amount.min' => '总数量至少为1',
            'rec_ware_id.required' => '参数错误',
            'rec_ware_id.integer' => '参数类型错误',
            'rec_ware_id.min' => '参数错误',
            // 'rec_remark.required' => '请输入:备注',
            'rec_remark.max' => '备注长度超过最大限制',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型不正确',
            'goo_name.required' => '参数错误',
            'goo_name.array' => '参数类型不正确',
            'goo_goods_encode.required' => '参数错误',
            'goo_goods_encode.array' => '参数类型不正确',
            'goo_amount.required' => '参数错误',
            'goo_amount.array' => '参数类型不正确',
            'goo_price.required' => '参数错误',
            'goo_price.array' => '参数类型不正确',
            'goo_recycle_amount.required' => '参数错误',
            'goo_recycle_amount.array' => '参数类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_date' => 'required|date', //日期
            'rec_price' => 'required|numeric', //回收总金额
            'rec_amount' => 'required|numeric|min:1', //回收总数量
            'rec_ware_id' => 'required|integer|min:1', //仓库id
            'rec_remark' => 'sometimes|max:255', //备注
            'goo_id' => 'required|array', //商品id
            'goo_name' => 'required|array', //商品名称
            'goo_goods_encode' => 'required|array', //商品编号
            'goo_amount' => 'required|array', //商品数量
            'goo_price' => 'required|array', //售价
            'goo_recycle_amount' => 'required|array', //退货数量
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器(待修改)
    public function recyclesValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_date.required' => '参数错误',
            'rec_date.date' => '参数类型不正确',
            'rec_ware_id.required' => '参数错误',
            'rec_ware_id.integer' => '参数类型错误',
            'rec_ware_id.min' => '参数错误',
            // 'rec_remark.required' => '请输入:备注',
            'rec_remark.max' => '备注长度超过最大限制',
            'goo_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_date' => 'required|date', //日期
            'rec_ware_id' => 'required|integer|min:1', //仓库id
            'rec_remark' => 'sometimes|max:255', //备注
            'goo_data' => 'required', //商品id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '参数错误',
            'rec_id.min' => '参数错误',
            'rec_number.required' => '参数错误',
            'rec_number.max' => '参数类型错误',
            'rec_remark.required' => '参数错误',
            'rec_remark.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1',
            'rec_number' => 'required|max:20',
            'rec_remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '参数错误',
            'rec_id.min' => '参数错误',
            'rec_number.required' => '参数错误',
            'rec_number.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1',
            'rec_number' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
