<?php

namespace App\Http\Controllers\Api\Verify\Workbench;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyLocationController extends Controller
{
    // 搜索技师定位验证器
    public function searchLocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索移动仓验证器
    public function searchMobileSiloValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '数据类型不正确',
            'adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
