<?php

namespace App\Http\Controllers\Api\Verify\Workbench;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyCashierDeskController extends Controller
{
    // 搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_bra_id.required' => '参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.required' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_cate_id' => 'sometimes|required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //获取门店商品信息
    public function getShopGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //验证获取服务
    public function getStoreServiceValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取商品库存数量
    public function goodsStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'goo_id.required' => '请选择商品',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //给下级门店派单
    public function createWorkAssignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'order_id.required' => '参数错误',
            'order_id.integer' => '数据类型不正确',
            'order_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'order_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
	
    //给下级门店重新派单
    public function assignAgainValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '数据类型不正确',
            'wor_id.min' => '参数错误',
			'service_shop_id.required' => '请选择服务门店',
			'service_shop_id.integer' => '服务门店数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
			'service_shop_id' => 'required|integer|min:0',//服务门店id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成订单验证器
    public function addOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_type.required' => '请选择订单类型',
            'ord_service_type.in' => '订单类型参数错误',
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_id.integer' => '服务技师数据类型不正确',
            'service_adm_id.min' => '服务技师参数错误',
            'service_shop_id.required' => '请选择服务门店',
            'service_shop_id.integer' => '服务门店数据类型不正确',
            'service_shop_id.min' => '服务门店参数错误',
            'service_sepr_id.required' => '请选择服务项目',
            'service_sepr_id.integer' => '服务项目数据类型不正确',
            'service_sepr_id.min' => '服务项目参数错误',
            'ware_id.required' => '请选择供货仓库',
            'ware_id.integer' => '供货仓库数据类型不正确',
            'ware_id.min' => '供货仓库参数错误',

            'orcl_shipment_party.required' => '请选择出货方',
            'orcl_shipment_party.in' => '出货方参数错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '结算方式参数错误',
            'ord_type.required' => '请选择买家类型',
            'ord_type.in' => '买家类型参数错误',

            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_car_num.required_if' => '请输入:车牌号',
            'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_standby_battery_type.required' => '参数错误',
            'orcl_standby_battery_type.in' => '参数错误',

            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',

            'orcl_whether_app.required_if' => '请选择是否走技师流程',
            'orcl_whether_app.in' => '参数错误',
            'orcl_junk_type.required' => '请选择是否回收旧货',
            'orcl_junk_type.in' => '参数错误',
            'orcl_chin_type.required' => '请选择是否铺货',
            'orcl_chin_type.in' => '参数错误',
            'orcl_collect_state.required' => '请选择技师是否收钱',
            'orcl_collect_state.in' => '参数错误',
            'precise_lock.required' => '请选择技师是否精确打卡',
            'precise_lock.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_service_type' => [
                    'required',
                    Rule::in(config('apisystem.ORDER_TYPE')),
                ],//订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
            'service_adm_id' => 'required|integer|min:0',//服务技师id
            'service_shop_id' => 'required|integer|min:0',//服务门店id
            'service_sepr_id' => 'required|integer|min:0',//服务项目id
            'ware_id' => 'required|integer|min:0',//仓库id
            'orcl_shipment_party' => [//出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
                'required',
                Rule::in([1, 4, 5]),
            ],
            'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
                    'required',
                    Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
                ],
            'ord_type' => [//读取配置文件数据，买家类型：1门店零售2渠道单位
                    'required',
                    Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
                ],
            // 'ord_remark' => 'sometimes|required|max:255',

            'orcl_name' => 'required|max:20',//客户姓名
            // 'orcl_phone' => ['sometimes','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            'orcl_province' => 'required|max:50',
            'orcl_city' => 'required|max:50',
            'orcl_county' => 'required|max:50',
            'orcl_address' => 'required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            'orcl_whether_app' => [//APP流程1是2否
                'required_if:orcl_shipment_party,4',
                Rule::in(['1', '2']),
            ],
            'orcl_junk_type' => [//是否回收1是2否
                'required',
                Rule::in(['1', '2']),
            ],
            'orcl_chin_type' => [//是否铺货：1是2否
                'required',
                Rule::in(['1', '2']),
            ],
            'orcl_collect_state' => [//技师收钱：1是2否
                    'required',
                    Rule::in(['1', '2']),
                ],
            'precise_lock' => [//精准抵达1是2否
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单显示验证器
    public function assignShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '数据类型不正确',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 有商品派单验证器
    public function goodsAssignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '数据类型不正确',
            'ord_id.min' => '参数错误',
            'wor_service_shop_id.required' => '请选择服务门店',
            'wor_service_shop_id.integer' => '数据类型不正确',
            'wor_service_shop_id.min' => '参数错误',
            'wor_service_sepr_id.required' => '请选择服务项目',
            'wor_service_sepr_id.integer' => '数据类型不正确',
            'wor_service_sepr_id.min' => '参数错误',
            'wor_service_adm_id.required' => '请选择服务技师',
            'wor_service_adm_id.integer' => '数据类型不正确',
            'wor_service_adm_id.min' => '参数错误',
            // 'wor_ware_id.required' => '仓库必选',
            // 'wor_ware_id.integer' => '参数类型错误',
            // 'wor_ware_id.min' => '参数错误',
            'wor_remark.required' => '请输入订单备注',
            'wor_remark.max' => '备注内容长度超过最大限制',
            'wor_type.required' => '请选择客户类型',
            'wor_type.in' => '参数错误',

            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'goo_price.required' => '请输入商品金额',
            'goo_price.array' => '数据类型不正确',
            'goo_quantity.required' => '请输入商品数量',
            'goo_quantity.array' => '数据类型不正确',
            'goo_recycle.required' => '请选择是否回收',
            'goo_recycle.array' => '数据类型不正确',
            'goo_collection_price.required' => '请输入代收金额',
            'goo_collection_price.array' => '数据类型不正确',
            'goo_inventory.required' => '请输入库存扣除方式',
            'goo_inventory.array' => '数据类型不正确',
            
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_phone.required' => '请输入:联系电话',
            // 'orcl_phone.regex' => '手机号格式不正确',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:渠道单位',
            'orcl_channel_unit.max' => '渠道单位长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'wocl_longitude.required' => '请输入经纬度',
            'wocl_longitude.numeric' => '地址长度超过最大限制',
            'wocl_latitude.required' => '请输入经纬度',
            'wocl_latitude.numeric' => '地址长度超过最大限制',
            'wocl_collect_state.required' => '请输入技师收款',
            'wocl_collect_state.in' => '技师收款参数错误',
            'wocl_standby_battery_type.required' => '参数错误',
            'wocl_standby_battery_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'wor_service_shop_id' => 'required|integer|min:0',
            'wor_service_sepr_id' => 'required|integer|min:1',
            'wor_service_adm_id' => 'required|integer|min:1',
            'wor_remark' => 'sometimes|required|max:255',
            'wor_type' => [
                'required',
                Rule::in(['1', '2', '3', '4','5']),
            ],
            // 'wor_ware_id' => 'required|integer|min:1',

            // 'goo_id' => 'required|array',
            // 'goo_price' => 'required|array',
            // 'goo_quantity' => 'required|array',
            // 'goo_recycle' => 'required|array',
            // 'goo_collection_price' => 'required|array', //商品代收金额
            // 'goo_inventory' => 'required|array', //库存扣除方式 1.良品 2.优先

            'wocl_client_id' => 'required|integer|min:0',
            'wocl_channel_unit' => 'sometimes|required_if:wor_type,2|max:50',
            'wocl_name' => 'sometimes|required|max:20',
            // 'wocl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            'wocl_car_num' => 'sometimes|max:10',
            'wocl_address' => 'sometimes|required|max:255',
            'wocl_longitude' => 'required|numeric',
            'wocl_latitude' => 'required|numeric',
            'wocl_collect_state' => [
                'required',
                Rule::in(['0', '1', '2']),
            ], //技师收钱：0未选择1是2否
            'wocl_standby_battery_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //是否为备用电池1是2否
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 无商品派单验证器
    public function assignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '数据类型不正确',
            'ord_id.min' => '参数错误',
            'wor_service_shop_id.required' => '请选择服务门店',
            'wor_service_shop_id.integer' => '数据类型不正确',
            'wor_service_shop_id.min' => '参数错误',
            'wor_service_sepr_id.required' => '请选择服务项目',
            'wor_service_sepr_id.integer' => '数据类型不正确',
            'wor_service_sepr_id.min' => '参数错误',
            'wor_service_adm_id.required' => '请选择服务技师',
            'wor_service_adm_id.integer' => '数据类型不正确',
            'wor_service_adm_id.min' => '参数错误',
            // 'wor_ware_id.required' => '仓库必选',
            // 'wor_ware_id.integer' => '参数类型错误',
            // 'wor_ware_id.min' => '参数错误',
            'wor_remark.required' => '请输入订单备注',
            'wor_remark.max' => '备注内容长度超过最大限制',
            'wor_type.required' => '请选择客户类型',
            'wor_type.in' => '参数错误',

            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_phone.required' => '请输入:联系电话',
            // 'orcl_phone.regex' => '手机号格式不正确',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:渠道单位',
            'orcl_channel_unit.max' => '渠道单位长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'wocl_longitude.required' => '请输入经纬度',
            'wocl_longitude.numeric' => '地址长度超过最大限制',
            'wocl_latitude.required' => '请输入经纬度',
            'wocl_latitude.numeric' => '地址长度超过最大限制',
            'wocl_collect_state.required' => '请输入技师收款',
            'wocl_collect_state.in' => '技师收款参数错误',
            'wocl_standby_battery_type.required' => '参数错误',
            'wocl_standby_battery_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'wor_service_shop_id' => 'required|integer|min:0',
            'wor_service_sepr_id' => 'required|integer|min:1',
            'wor_service_adm_id' => 'required|integer|min:1',
            'wor_remark' => 'sometimes|required|max:255',
            'wor_type' => [
                'required',
                Rule::in(['1', '2', '3', '4','5']),
            ],
            // 'wor_ware_id' => 'required|integer|min:1',

            'wocl_client_id' => 'required|integer|min:0',
            'wocl_channel_unit' => 'sometimes|required_if:wor_type,2|max:50',
            'wocl_name' => 'sometimes|required|max:20',
            // 'wocl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            'wocl_car_num' => 'sometimes|max:10',
            'wocl_address' => 'sometimes|required|max:255',
            'wocl_longitude' => 'required|numeric',
            'wocl_latitude' => 'required|numeric',
            'wocl_collect_state' => [
                'required',
                Rule::in(['0', '1', '2']),
            ], //技师收钱：0未选择1是2否
            'wocl_standby_battery_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //是否为备用电池1是2否
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成订单/工单+派单
    public function workOrderAssignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_type.required' => '请选择订单类型',
            'ord_service_type.in' => '订单类型参数错误',
            // 'ware_id.required' => '请选择供货仓库',
            // 'ware_id.integer' => '数据类型不正确',
            // 'ware_id.min' => '参数错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '参数错误',
            'ord_actual_price.required' => '请输入结算金额',
            'ord_actual_price.numeric' => '数据类型不正确',
            'ord_actual_price.min' => '参数错误',
            'ord_type.required' => '请选择订单类型',
            'ord_type.in' => '参数错误',
            'ord_remark.required' => '请输入订单备注',
            'ord_remark.max' => '备注内容长度超过最大限制',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'goo_price.required' => '请输入商品金额',
            'goo_price.array' => '数据类型不正确',
            'goo_quantity.required' => '请输入商品数量',
            'goo_quantity.array' => '数据类型不正确',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_phone.required' => '请输入:联系电话',
            // 'orcl_phone.regex' => '手机号格式不正确',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:渠道单位',
            'orcl_channel_unit.max' => '渠道单位长度超过最大限制',
            
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',

            'service_shop_id.required' => '请选择服务门店',
            'service_shop_id.integer' => '数据类型不正确',
            'service_shop_id.min' => '参数错误',
            'service_sepr_id.required' => '请选择服务项目',
            'service_sepr_id.integer' => '数据类型不正确',
            'service_sepr_id.min' => '参数错误',
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_id.integer' => '数据类型不正确',
            'service_adm_id.min' => '参数错误',
            'longitude.required' => '请输入经度',
            'longitude.numeric' => '经度长度超过最大限制',
            'latitude.required' => '请输入纬度',
            'latitude.numeric' => '纬度长度超过最大限制',
            'ord_collection_price.required' => '请输入代收金额',
            'ord_collection_price.numeric' => '数据类型不正确',
            'ord_collection_price.min' => '参数错误',
            'goo_collection_price.required' => '请输入代收金额',
            'goo_collection_price.array' => '数据类型不正确',
            'goo_inventory.required' => '请输入库存扣除方式',
            'goo_inventory.array' => '数据类型不正确',
            'chin_type.sometimes' => '请选择是否铺货',
            'chin_type.in' => '参数错误',
            // 'orla_id.required' => '请选择供货仓库',
            // 'orla_id.integer' => '数据类型不正确',
            // 'orla_id.min' => '参数错误',
            // 'orcl_collect_state.required' => '请输入技师收款字段',
            // 'orcl_collect_state.in' => '技师收款参数错误',
            'orcl_standby_battery_type.required' => '参数错误',
            'orcl_standby_battery_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_client_id' => 'required|integer|min:0',
            'ord_service_type' => [
                'required',
                Rule::in(config('apisystem.ORDER_TYPE')),
            ],
            // 'ware_id' => 'required|integer|min:1',
            'ord_payment_way' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
            'ord_actual_price' => 'required|numeric|min:0',
            'ord_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'ord_remark' => 'sometimes|required|max:255',
            // 'goo_id' => 'required|array',
            // 'goo_price' => 'required|array',
            // 'goo_quantity' => 'required|array',
            // 'goo_recycle' => 'required|array',
            // 'goo_collection_price' => 'required|array', //商品代收金额
            // 'goo_inventory' => 'required|array', //库存扣除方式 1.良品 2.优先
            
            'orcl_name' => 'sometimes|required|max:20',
            // 'orcl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',
            'orcl_province' => 'required|max:50',
            'orcl_city' => 'required|max:50',
            'orcl_county' => 'required|max:50',
            'orcl_address' => 'required|max:255',

            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'service_shop_id' => 'required|integer|min:0',
            'service_sepr_id' => 'required|integer|min:1',
            'service_adm_id' => 'required|integer|min:1',
            'longitude' => 'required|numeric', //经度
            'latitude' => 'required|numeric', //纬度
            'ord_collection_price' => 'required|numeric|min:0', //商品总代收金额
            'chin_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //铺货类型：1是铺货 2不是铺货
            'orla_id' => 'required|integer|min:0',
            // 'orcl_collect_state' => [
            //     'required',
            //     Rule::in(['0', '1', '2']),
            // ], //技师收钱：0未选择1是2否
            'orcl_standby_battery_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //是否为备用电池1是2否
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }


    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_shop_id.required' => '请选择服务门店',
            'ord_service_shop_id.integer' => '数据类型不正确',
            'ord_service_shop_id.min' => '参数错误',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'ord_service_type.required' => '请选择订单类型',
            'ord_service_type.in' => '参数错误',
            'ord_service_sepr_id.required_unless' => '请选择服务项目',
            'ord_service_sepr_id.integer' => '数据类型不正确',
            'ord_service_sepr_id.min' => '参数错误',
            'ord_service_adm_id.required_unless' => '请选择服务技师',
            'ord_service_adm_id.integer' => '数据类型不正确',
            'ord_service_adm_id.min' => '参数错误',
            'ware_id.required' => '请选择供货仓库',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '参数错误',
            'ord_actual_price.required' => '请输入结算金额',
            'ord_actual_price.numeric' => '数据类型不正确',
            'ord_actual_price.min' => '参数错误',
            'ord_type.required' => '请选择买家类型',
            'ord_type.in' => '参数错误',
            'ord_state.required' => '请选择订单状态',
            'ord_state.in' => '参数错误',
            'ord_remark.required' => '请输入订单备注',
            'ord_remark.max' => '备注内容长度超过最大限制',
            'chin_type.sometimes' => '请选择是否铺货',
            'chin_type.in' => '参数错误',

            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'goo_price.required' => '请输入商品金额',
            'goo_price.array' => '数据类型不正确',
            'goo_amount.required' => '请输入商品数量',
            'goo_amount.array' => '数据类型不正确',
            'goo_inventory.required' => '请输入库存扣除方式',
            'goo_inventory.array' => '数据类型不正确',

            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_phone.required' => '请输入:联系电话',
            // 'orcl_phone.regex' => '手机号格式不正确',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:渠道单位',
            'orcl_channel_unit.max' => '渠道单位长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',

            'ord_collection_price.required' => '请输入代收金额',
            'ord_collection_price.numeric' => '数据类型不正确',
            'ord_collection_price.min' => '参数错误',
            'goo_collection_price.required' => '请输入代收金额',
            'goo_collection_price.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_service_shop_id' => 'required|integer|min:0',
            'ord_client_id' => 'required|integer|min:0',
            'ord_service_type' => [
                    'required',
                    Rule::in(config('apisystem.ORDER_TYPE')),
                ],
            'ord_service_sepr_id' => 'required_unless:ord_service_type,1|integer|min:0',
            'ord_service_adm_id' => 'required_unless:ord_service_type,1|integer|min:0',
            'ware_id' => 'required|integer|min:1',
            'ord_payment_way' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ],
            'ord_actual_price' => 'required|numeric|min:0',
            'ord_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'ord_state' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'ord_remark' => 'sometimes|required|max:255',

            'goo_id' => 'required|array',
            'goo_price' => 'required|array',
            'goo_amount' => 'required|array',

            'orcl_name' => 'sometimes|required|max:20',
            // 'orcl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',
            'orcl_address' => 'sometimes|required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',

            'ord_collection_price' => 'required|numeric|min:0', //商品总代收金额
            'goo_collection_price' => 'required|array', //商品代收金额
            'goo_inventory' => 'required|array', //库存扣除方式 1.良品 2.优先
            'chin_type' => [
                    'sometimes',
                    Rule::in(['1', '2']),
                ], //铺货类型：1是铺货 2不是铺货
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结算
    public function settlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'ord_actual_price.required' => '参数错误',
            'ord_actual_price.integer' => '参数错误',
            'ord_actual_price.min' => '参数错误',
            'orcl_acc_subject_id.required' => '请选择会计科目',
            'orcl_acc_subject_id.integer' => '参数错误',
            'orcl_acc_subject_id.min' => '参数错误',
            'orcl_img.sometimes' => '参数错误',
            'orcl_img.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_actual_price' => 'required|numeric|min:0',
            'orcl_acc_subject_id' => 'required|integer|min:1',
            'orcl_img' => 'sometimes|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 取消订单
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 撤销结算
    public function cancelSettlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'ord_remark.required' => '参数错误',
            'ord_remark.max' => '参数错误',
            'ord_remark.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_remark' => 'required|max:255|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索商品验证器
    public function searchLocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
            'longitude.required' => '参数错误',
            'longitude.numeric' => '数据类型不正确',
            'longitude.min' => '参数错误',
            'latitude.required' => '参数错误',
            'latitude.numeric' => '数据类型不正确',
            'latitude.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:0',
            'longitude' => 'required|numeric|min:0',
            'latitude' => 'required|numeric|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索商品验证器
    public function searchMobileSiloValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '数据类型不正确',
            'adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索技师验证器
    public function searchTechnicianValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索服务技师验证器
    public function getTechnicianValidator($data)
    {
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索供货仓库验证器
    public function searchWareValidator($data)
    {
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '数据类型不正确',
            'adm_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 根据商品编码搜索商品
    public function searchGoodsEncodeValidator($data)
    {
        $messages = [
            'goo_goods_encode.required' => '参数错误',
            'goo_goods_encode.numeric' => '数据类型不正确',
            'goo_goods_encode.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_goods_encode' => 'required|numeric|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 根据商品编码搜索商品
    public function getMemberCarValidator($data)
    {
        $messages = [
            'mem_id.required' => '参数错误',
            'mem_id.integer' => '数据类型不正确',
            'mem_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 验证天数
    public function oweDayValidator($data)
    {
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '数据类型不正确',
            'chun_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer|min:0'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 缓存
    public function infoCacheValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_type.sometimes' => '请选择订单类型',
            'ord_service_type.in' => '订单类型参数错误',
            'ord_payment_way.sometimes' => '请选择结算方式',
            'ord_payment_way.in' => '参数错误',
            'ware_id.sometimes' => '请选择供货仓库',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'ord_service_shop_id.sometimes' => '请选择服务门店',
            'ord_service_shop_id.integer' => '数据类型不正确',
            'ord_service_shop_id.min' => '参数错误',
            'ord_service_sepr_id.sometimes' => '请选择服务项目',
            'ord_service_sepr_id.integer' => '数据类型不正确',
            'ord_service_sepr_id.min' => '参数错误',
            'ord_service_adm_id.sometimes' => '请选择服务技师',
            'ord_service_adm_id.integer' => '数据类型不正确',
            'ord_service_adm_id.min' => '参数错误',
            'ord_remark.sometimes' => '请输入订单备注',
            'ord_remark.max' => '备注内容长度超过最大限制',
            'ord_type.sometimes' => '请选择订单类型',
            'ord_type.in' => '参数错误',
            'ord_client_id.sometimes' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'ord_actual_price.sometimes' => '请输入结算金额',
            'ord_actual_price.numeric' => '数据类型不正确',
            'ord_actual_price.min' => '参数错误',
            'goo_id.sometimes' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'goo_price.sometimes' => '请输入商品金额',
            'goo_price.array' => '数据类型不正确',
            'goo_quantity.sometimes' => '请输入商品数量',
            'goo_quantity.array' => '数据类型不正确',
            'goo_recycle.sometimes' => '请选择是否回收',
            'goo_recycle.array' => '数据类型不正确',
            'orcl_name.sometimes' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_phone.sometimes' => '请输入:联系电话',
            // 'orcl_phone.regex' => '手机号格式不正确',
            'orcl_address.sometimes' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            // 'orcl_car_num.sometimes' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'ord_collection_price.sometimes' => '请输入结算金额',
            'ord_collection_price.numeric' => '数据类型不正确',
            'goo_collection_price.sometimes' => '请输入代收金额',
            'goo_collection_price.array' => '数据类型不正确',
            // 'orcl_collect_state.required' => '请输入技师收款字段',
            // 'orcl_collect_state.in' => '技师收款参数错误',
            'ord_acti_id.sometimes' => '参数错误',
            'ord_acti_id.integer' => '数据类型不正确',
            'ord_acti_id.min' => '参数错误',
            'ord_acti_row.sometimes' => '参数错误',
            'ord_acti_row.integer' => '数据类型不正确',
            'ord_acti_row.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_service_type' => [
                    'sometimes',
                    Rule::in(config('apisystem.ORDER_TYPE')),
                ],
            'ord_payment_way' => [
                    'sometimes',
                    Rule::in(['', '1', '2', '3', '4']),
                ],
            'ware_id' => 'sometimes|integer|min:0',
            'ord_service_shop_id' => 'sometimes|integer|min:0',
            'ord_service_sepr_id' => 'sometimes|integer|min:0',
            'ord_service_adm_id' => 'sometimes|integer|min:0',
            'ord_remark' => 'sometimes|max:255',
            'ord_type' => [
                    'sometimes',
                    Rule::in(['1', '2','']),
                ],
            // 'ord_client_id' => 'sometimes|integer|min:0',,
            'ord_actual_price' => 'sometimes|numeric|min:0',
            'goo_id' => 'sometimes|array',
            'goo_price' => 'sometimes|array',
            'goo_quantity' => 'sometimes|array',
            'goo_recycle' => 'sometimes|array',
            'orcl_name' => 'sometimes|max:20',
            // 'orcl_phone' => ['sometimes', 'required', 'regex:/^1[3456789]\d{9}$/'],
            'orcl_address' => 'sometimes|max:255',
            // 'orcl_car_num' => 'sometimes|max:10',
            'ord_collection_price' => 'sometimes|numeric', //商品总代收金额
            'goo_collection_price' => 'sometimes|array', //商品代收金额
            // 'orcl_collect_state' => [
            //     'required',
            //     Rule::in(['0', '1', '2']),
            // ], //技师收款：0未选择1是2否
            'ord_acti_id' => 'sometimes|integer|min:1',
            'ord_acti_row' => 'sometimes|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索库存验证器
    public function searchInventoryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.in' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索商品验证器
    public function searchExchangeGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_type.required' => '参数错误',
            'ord_type.in' => '参数错误',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_type' => [
                'required',
                Rule::in(['1', '2','']),
            ],
            'ord_client_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
