<?php
namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyTransferringOrdersController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '权限id数据类型不正确',
            'pri_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情查看验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_id.required' => '请输入调拨单id',
            'tror_id.integer' => '调拨单id数据类型不正确',
            'tror_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_out_ware_id.required' => '请选择出货仓库',
            'tror_out_ware_id.integer' => '参数类型错误',
            'tror_out_ware_id.min' => '参数错误',
            'tror_in_ware_id.required' => '请选择入货仓库',
            'tror_in_ware_id.integer' => '参数类型错误',
            'tror_in_ware_id.min' => '参数错误',
            'tror_out_waon_class.required' => '请选择仓库类别',
            'tror_out_waon_class.integer' => '参数类型错误',
            'tror_out_waon_class.min' => '参数错误',
            'tror_remark.required' => '请输入备注',
            'tror_remark.max' => '备注长度超过最大限制',
            'goods_data.required' => '请选择商品',
            'goods_data.json' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_out_ware_id' => 'required|integer|min:1',
            'tror_in_ware_id' => 'required|integer|min:1',
            'tror_out_waon_class' => 'required|integer|min:1',
            'tror_remark' => 'sometimes|max:255',
            'goods_data' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核查看验证器
    public function auditShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'tror_id.required' => '参数错误',
            'tror_id.integer' => '参数类型错误',
            'tror_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'tror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_state.required' => '参数错误',
            'tror_state.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_state' => [
                'required',
                Rule::in(['2', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_id.required' => '参数错误',
            'tror_id.integer' => '参数类型错误',
            'tror_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 入库验证器
    public function putInStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_in_waon_class.required' => '请选择仓库类别',
            'tror_in_waon_class.integer' => '参数类型错误',
            'tror_in_waon_class.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_in_waon_class' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_remark.required' => '请输入备注',
            'tror_remark.max' => '备注长度超过最大限制',

            'goods_data.required' => '请选择商品',
            'goods_data.json' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_remark' => 'sometimes|max:255',

            'goods_data' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 库存转换-提交验证器
    public function transitionsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误',
            'wafg_id.required' => '参数错误',
            'wafg_id.integer' => '参数类型错误',
            'wafg_id.min' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'goo_count.required' => '请输入数量',
            'goo_count.integer' => '参数类型错误',
            'goo_count.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'wafg_id' => 'required|integer|min:1',
            'goo_count' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2','3','4']),
            ],//转换类型：1良品转优先2优先转良品3待检测转优品4待检测转良品
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
