<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMyWarehouseController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '权限id数据类型不正确',
            'pri_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 查看仓库商品
    public function goodsListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',
            'waon_class.required' => '请选择仓库类别',
            'waon_class.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'waon_class' => [
                'required',
                Rule::in(config('apisystem.WAREHOUSE_CLASS')),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_name.required' => '请输入:仓库名称',
            'ware_name.max' => '仓库名称长度超过最大限制',
            'ware_type.required' => '请选择仓库类型',
            'ware_type.in' => '参数类型错误',
            'ware_leader_id.required' => '请选择负责人',
            // 'ware_leader_id.integer' => '参数错误',
            // 'ware_leader_id.min' => '参数错误',
            'ware_address.required_if' => '请输入地址',
            'ware_address.max' => '地址长度超过最大限制',
            'ware_default.required_if' => '参数错误',
            'ware_default.integer' => '参数类型错误',
            /*'ware_superior_id.integer' => '固定仓ID为空',
            'ware_superior_id.required_if' => '固定仓ID为空',*/
            'ware_freight_space.required' => '请输入:仓位名称',
            'ware_freight_space.max' => '仓位名称长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_name' => 'required|max:20',
            'ware_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'ware_leader_id' => 'required',
            'ware_address' => 'required_if:ware_type,1|max:255',
            'ware_default' => 'required_if:ware_type,1|integer',
            /*'ware_superior_id' => 'required_if:ware_type,2|integer',*/
            'ware_freight_space' => 'sometimes|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',
            'ware_name.required' => '请输入:仓库名称',
            'ware_name.max' => '仓库名称长度超过最大限制',
            'ware_leader_id.required' => '请选择负责人',
            /*'ware_leader_id.integer' => '参数错误',
            'ware_leader_id.min' => '参数错误',*/
            'ware_address.required_if' => '请输入地址',
            'ware_address.max' => '地址长度超过最大限制',
            'ware_freight_space.required' => '请输入:仓位名称',
            'ware_freight_space.max' => '仓位名称长度超过最大限制',
            /*'ware_superior_id.integer' => '固定仓ID为空',
            'ware_superior_id.required_if' => '固定仓ID为空',*/
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'ware_name' => 'required|max:20',
            'ware_leader_id' => 'required',
            'ware_address' => 'required_if:ware_type,1|max:255',
            'ware_freight_space' => 'sometimes|max:20',
            /*'ware_superior_id' => 'required_if:ware_type,2|integer',*/
        ], $messages);


        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设为默认仓库
    public function setDefaultValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 调货-提交验证器
    public function allocatingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'in_war_id.required' => '参数错误',
            'in_war_id.integer' => '参数类型错误',
            'in_war_id.min' => '参数错误',
            'out_war_id.required' => '参数错误',
            'out_war_id.integer' => '参数类型错误',
            'in_war_id.min' => '参数错误',
            // 'in_info.required' => '参数错误',
            // 'in_info.array' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型错误',
            'goo_num.required' => '参数错误',
            'goo_num.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'in_war_id' => 'required|integer|min:1',
            'out_war_id' => 'required|integer|min:1',
            // 'in_info' => 'required|array',
            'goo_id' => 'required|array',
            'goo_num' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 库存转换-提交验证器
    public function transitionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误1',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误2',
            'wago_id.required' => '参数错误3',
            'wago_id.integer' => '参数类型错误',
            'wago_id.min' => '参数类型错误',
            'waon_class.required' => '请选择仓库类别',
            'waon_class.integer' => '参数类型错误',
            'waon_class.min' => '参数类型错误',
            'type.required' => '参数错误4',
            'type.in' => '参数错误5',
            'goo_count.required' => '请输入数量',
            'goo_count.integer' => '参数类型错误',
            'goo_count.min' => '请输入正确的数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'waon_class' => 'required|integer|min:1',
            'wago_id' => 'required|integer|min:1',
            'goo_count' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ], //转换类型：1良品转优先2优先转良品3待检测转优品4待检测转良品
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 调货-搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'goo_bra_id.required' => '参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.required' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_cate_id' => 'sometimes|required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 调货-从左向右调货获取库存量
    public function stockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 调货-获取右侧商品的库存数量
    public function goodsStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设置仓库预警类型
    public function setWarningValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //转换类型：1获取数据 2提交数据
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设置仓库预警类型提交
    public function setWarningSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'waon_id.required' => '参数错误',
            'waon_id.array' => '数据类型不正确',
            'waon_warn_state.required' => '参数错误',
            'waon_warn_state.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'waon_id' => 'required|array',
            'waon_warn_state' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //商品预警设置
    public function goodsWarningValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'wago_id.required' => '参数错误',
            'wago_id.array' => '数据类型不正确',
            'wago_min_warn.required' => '参数错误',
            'wago_min_warn.array' => '数据类型不正确',
            'wago_goo_id.required' => '参数错误',
            'wago_goo_id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'wago_id' => 'required|array',
            'wago_min_warn' => 'required|array',
            'wago_goo_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 临时仓转换旧货仓
    public function adjacentTransitionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型错误',
            'goo_num.required' => '参数错误',
            'goo_num.array' => '参数类型错误',
            'goo_inventory.required' => '参数错误',
            'goo_inventory.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'goo_num' => 'required|array',
            'goo_inventory' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 我的仓库-直接入库
    public function warehousingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误',
            'goods_data.required' => '请选择商品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goods_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 导入提交验证器
    public function leadValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'file.required' => '请上传文件',
            'file.file' => '请上传文件',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'file' => 'required|file',
        ], $messages);

        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
