<?php
namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyDispatchController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发货验证器
    public function sendCargoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发货验证器
    public function shipmentsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    } 

    // 打印验证器
    public function printValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_print_type.required' => '参数错误',
            'shpt_print_type.in' => '参数类型错误',
            'print_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'print_id' => 'required|integer',
            'shpt_print_type' => [
                    'required',
                    Rule::in(['1','2','3']),
                ], //模板系统类型1半径门店2半径供应链3速电4智配
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 查看订单凭证验证器
    public function getorderpicValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 获取仓库
    public function getWareHousesValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 更换仓库
    public function changeWareValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'dego_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
}
