<?php

namespace App\Http\Controllers\Api\Verify;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyExcelpermissController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adex_action.required' => 'adex_action必填',
            'adex_acname.required' => 'adex_acname必填',
            'adex_data.required' => 'adex_data必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adex_action' => 'required',
            'adex_acname' => 'required',
            'adex_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adex_id.required' => '参数错误',
            'adex_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adex_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adex_id.required' => '参数错误',
            'adex_id.integer' => '数据类型不正确',
            'adex_action.required' => 'adex_action必填',
            'adex_acname.required' => 'adex_acname必填',
            'adex_data.required' => 'adex_data必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adex_id' => 'required|integer',
            'adex_action' => 'required',
            'adex_acname' => 'required',
            'adex_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function execExcelOutValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
