<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyPersonalController extends Controller
{
    // 类型验证器
    public function typeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //type为1或者2
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 原密码验证
    public function oldpwdValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'old_pwd.required' => '请输入原密码',
            'old_pwd.regex' => '密码由6-15位数字或字母,或下划线组成！',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'old_pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新密码验证
    public function newpwdValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'new_pwd.required' => '请输入原密码',
            'new_pwd.regex' => '密码由6-15位数字或字母,或下划线组成！',
            'renew_pwd.required' => '请输入确认密码',
            'renew_pwd.same'=>'密码与确认密码不一致',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'new_pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'renew_pwd'=>['required',"same:new_pwd"], //不为空,两次密码是否相同
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 手机号验证器
    public function telValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'tel.required' => '参数错误',
            'tel.regex' => '参数类型错误',
            'code.required_if' => '参数错误',
            'code.integer' => '参数类型错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ], //type为1或者2
            'tel' => ['required','regex:/^1[3456789]\d{9}$/'],
            'code' => 'required_if:type,2,4|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 验证图片上传
    public function imgValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'img.required' => '请选择图片上传',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'img' => ['required'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 公司信息编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_store_name.required' => '请输入企业名称',
            'shop_store_name.max' => '企业名称长度超过最大限制',
            'shop_name.required' => '请输入联系人',
            'shop_name.max' => '联系人名称长度超过最大限制',
            'shop_phone.required' => '请输入手机号',
            'shop_phone.regex' => '手机号格式不正确',
            'shop_province.required' => '请选择省',
            'shop_province.max' => '文字长度超过最大限制',
            'shop_city.required' => '请选择市',
            'shop_city.max' => '文字长度超过最大限制',
            'shop_county.required' => '请选择区县',
            'shop_county.max' => '文字长度超过最大限制',
            'shop_address.required' => '请输入地址',
            'shop_address.max' => '详细地址长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_store_name' => 'required|max:50',
            'shop_name' => 'required|max:50',
            'shop_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'shop_province' => 'required|max:50',
            'shop_city' => 'required|max:50',
            'shop_county' => 'required|max:50',
            'shop_address' => 'required|max:200',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 公司信息提交审核验证器
    public function submitAuditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_store_name.required' => '请输入企业名称',
            'shop_store_name.max' => '企业名称长度超过最大限制',
            'shop_name.required' => '请输入联系人',
            'shop_name.max' => '联系人名称长度超过最大限制',
            'shop_phone.required' => '请输入手机号',
            'shop_phone.regex' => '手机号格式不正确',
            'shop_province.required' => '请选择省',
            'shop_province.max' => '文字长度超过最大限制',
            'shop_city.required' => '请选择市',
            'shop_city.max' => '文字长度超过最大限制',
            'shop_county.required' => '请选择区县',
            'shop_county.max' => '文字长度超过最大限制',
            'shop_address.required' => '请输入地址',
            'shop_address.max' => '详细地址长度超过最大限制',
            'shop_reason.required' => '请输入变更原因',
            'shop_reason.max' => '变更原因长度超过最大限制',
            'shop_image.required' => '请上传营业执照图片',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_store_name' => 'required|max:50',
            'shop_name' => 'required|max:50',
            'shop_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'shop_province' => 'required|max:50',
            'shop_city' => 'required|max:50',
            'shop_county' => 'required|max:50',
            'shop_address' => 'required|max:200',
            'shop_reason' => 'required|max:200',
            'shop_image' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //审核账号列表验证
    public function processIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
