<?php
namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyFeaturesController extends Controller
{
    // 获取数据验证器
    public function addShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '请选择类型',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shse_login.required' => '参数错误',
            'shse_login.in' => '参数错误',
            'shse_assign.required' => '参数错误',
            'shse_assign.in' => '参数错误',
            'shse_procurement_audit.required' => '参数错误',
            'shse_procurement_audit.in' => '参数错误',
            'shse_order_price.required' => '参数错误',
            'shse_order_price.in' => '参数错误',
            'shse_procurement_price.required' => '参数错误',
            'shse_procurement_price.in' => '参数错误',
            'shse_sell_price.required' => '参数错误',
            'shse_sell_price.in' => '参数错误',
            'shse_junk_recycle_price.required' => '参数错误',
            'shse_junk_recycle_price.in' => '参数错误',
            'shse_ampere_hour_price.required' => '请输入旧电池1安时的回收金额',
            'shse_ampere_hour_price.numeric' => '回收金额参数类型错误',
            'shse_ampere_hour_price.min' => '回收金额超出最小值',
            // 'shse_stock_sell_storage.required' => '参数错误',
            // 'shse_stock_sell_storage.in' => '参数错误',
            'shse_reception_phone.required' => '参数错误',
            'shse_reception_phone.max' => '参数错误',
            'shse_rescue_phone.required' => '参数错误',
            'shse_rescue_phone.max' => '参数错误',
            'shse_inform.required' => '参数错误',
            'shse_customer_evaluation.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shse_login' => [
                'required',
                Rule::in(['1', '2']),
            ], //登录验证：1关闭验证2验证绑定地址
            'shse_assign' => [
                'required',
                Rule::in(['1', '2']),
            ], //派单：1可拆分派单2整单派单
            'shse_procurement_audit' => [
                'required',
                Rule::in(['1', '2']),
            ], //采购审核：1提交审核2提交不审核
            'shse_order_price' => [
                'required',
                Rule::in(['1', '2']),
            ], //订单售价：1可以改售价2不可以改售价
            'shse_procurement_price' => [
                'required',
                Rule::in(['1', '2']),
            ], //采购售价：1可以改价格2不可以改价格
            'shse_sell_price' => [
                'required',
                Rule::in(['1', '2']),
            ], //销售出库单价格：1可以改价格2不可以改价格
            'shse_junk_recycle_price' => [
                'required',
                Rule::in(['1', '2']),
            ], //旧货回收价格：1可以改价格2不可以改价格
            'shse_ampere_hour_price' => 'required|numeric|min:0',
            // 'shse_stock_sell_storage' => [
            //     'required',Features
            //     Rule::in(['1', '2']),
            // ], //进销存核算方式：1统一总仓核算2各仓库独立核算
            // 'shse_reception_phone' => 'required|max:50',//业务受理电话
            // 'shse_rescue_phone' => 'required|max:50',//24小时救援电话
            // 'shse_inform' => 'required',
            // 'shse_customer_evaluation' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 图片上传模板设置验证器
    public function imageUploadTemplateSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'shit_image_type.required_if' => '请选择类型',
            'shit_image_type.in' => '类型参数错误',
            'shit_template_set.required_if' => '请设置图片模板数据',
            'shit_template_name.required_if' => '请输入模板名称',
            'shit_image_type.max' => '模板名称字数超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            //1获取数据2提交
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            // 类型：1服务单2销售单3换货单4退货单5发货单6结清单7救援单
            'shit_image_type' => [
                'required_if:type,2',
                Rule::in(['1', '7']),
            ],
            // 图片模板设置json数据
            'shit_template_set' => 'required_if:type,2',
            //模板名称
            'shit_template_name' => 'required_if:type,2|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
