<?php

namespace App\Http\Controllers\Api\Verify\SupplyChains;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySpoiledReplenishsController extends Controller
{
    // 详情
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darb_id.required' => '参数错误',
            'darb_id.int' => '参数类型错误',
            'darb_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darb_id' => 'required|int|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 残损单号详情
    public function reportsDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darb_id.required' => '参数错误',
            'darb_id.int' => '参数类型错误',
            'darb_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darb_id' => 'required|int|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darb_id.required' => '参数错误',
            'darb_id.int' => '参数类型错误',
            'darb_id.min' => '参数类型错误',
            'remark.required' => '参数类型错误',
            'remark.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darb_id' => 'required|int|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 收货接口
    public function showTakeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darb_id.required' => '参数错误',
            'darb_id.int' => '参数类型错误',
            'darb_id.min' => '参数类型错误',
            'type.required'=>'参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darb_id' => 'required|int|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货
    public function takeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'amount.required' => '参数错误',
            'amount.array' => '参数类型错误',
            'drgb_id.required' => '参数类型错误',
            'drgb_id.array'=>'参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'amount' => 'required|array',
            'drgb_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
