<?php
namespace App\Http\Controllers\Api\Verify\Purchase;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyPurchasePlanController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 基本信息
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
            'contract_number.required' => '参数错误',
            'contract_number.max' => '合同单号长度超过最大限制',
            'cg_amount.required' => '参数错误',
            'cg_amount.integer' => '数据类型不正确',
            'cg_amount.min' => '参数错误',
            'business_type.required' => '请勾选业务类型',
            'business_type.in' => '参数错误',
            'cg_wareid.required' => '请勾选采购仓库',
            'cg_wareid.integer' => '数据类型不正确',
            'cg_wareid.min' => '参数错误',
            'cg_waon_class.required' => '请勾选仓库类别',
            'cg_waon_class.in' => '参数错误',
            'cg_remark.required' => '参数错误',
            'cg_remark.max' => '备注长度超过最大限制',

            // 供货方
            'cg_supplyunit.required' => '参数错误',
            'cg_supplyunit.integer' => '数据类型不正确',
            'cg_supplyunit.min' => '参数错误',
            'contact_name.required' => '请输入联系人姓名',
            'contact_name.max' => '联系人姓名长度超过最大限制',
            // 'contact_phone.required' => '请输入手机号',
            // 'contact_phone.regex' => '手机号格式不正确',

            // 结算信息
            'cg_paymentype.required' => '请勾选仓库类别',
            'cg_paymentype.in' => '参数错误',
            'cg_delivertype.required' => '请勾选仓库类别',
            'cg_delivertype.in' => '参数错误',
            'cg_invoicetype.required' => '请勾选仓库类别',
            'cg_invoicetype.in' => '参数错误',

            // 商品信息
            'goods.required' => '参数错误',
            'goods.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 基本信息
            'cg_number' => 'required|max:20',
            'contract_number' => 'required|max:20',
            'cg_amount' => 'required|numeric|min:0',
            'business_type' => [
                'required',
                Rule::in(['1', '2']),
            ],//业务类型1普通采购2样品采购
            'cg_wareid' => 'required|integer|min:1',//仓库id
            'cg_waon_class' => [
                'required',
                Rule::in(['1', '2']),
            ],//仓库类别1货物仓2非货物仓
            'cg_remark' => 'sometimes|max:255',//备注
            'cg_supplyunit' => 'required|integer|min:1',//供应商
            'contact_name' => 'required|max:10',//联系人
            // 'contact_phone' => ['required','regex:/^1[3456789]\d{9}$/'],//联系方式
            'cg_paymentype' => [
                'required',
                Rule::in(['1', '2', '3', '4', '5', '6', '7', '8']),
            ],//结算方式1现金2定期3款到发货4货到付款5月结15天6月结30天7月结60天8免费
            'cg_delivertype' => [
                'required',
                Rule::in(['1', '2']),
            ],//交货方式1送货上门2自提
            'cg_invoicetype' => [
                'required',
                Rule::in(['0', '1', '2']),
            ],//票据类型0不开票1普通发票2专用发票
            'goods' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 转采购验证器
    public function turnPurchaseValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
