<?php
namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyWearingPartController extends Controller
{
    // 易损件列表验证器
    public function wearingPartindexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增易损件验证器
    public function addwearingPartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_name.required' => '请输入:商品名称',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_code.required' => '请输入:商品编号',
            'goo_goods_code.max' => '商品编号长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_cate_name.required_with' => '请输入:品类名称',
            'goo_cate_name.max' => '品类名称长度超过最大限制',
            'goo_cate_id.required' => '请选择品类',
            'goo_cate_id.integer' => '参数类型错误',
            'goo_cate_id.min' => '请选择正确的品类',
            'goo_price.required' => '请输入:售价金额',
            'goo_price.numeric' => '参数类型错误',
            'goo_wholesale_price.required' => '请输入:批发价',
            'goo_wholesale_price.numeric' => '参数类型错误',
            'goo_purchase_price.required' => '请输入:进货价',
            'goo_purchase_price.numeric' => '参数类型错误',
            'goo_channel_price.required' => '请输入:渠道价',
            'goo_channel_price.numeric' => '参数类型错误',
            'goo_shop_price.required' => '请输入:分店价',
            'goo_shop_price.numeric' => '参数类型错误',
            'goo_vip_price.required' => '请输入:会员价',
            'goo_vip_price.numeric' => '参数类型错误',
            'goaf_weight.required' => '请输入:重量',
            'goaf_weight.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正数',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_name' => 'required|max:80',
            'goo_goods_code' => 'sometimes|max:13',
            'goo_goods_encode' => 'sometimes|max:80',
            'goo_cate_name' => 'required_with:goo_cate_id|max:10',
            'goo_cate_id' => 'required|integer|min:1',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_price' => 'required|numeric|min:0',
            'goo_wholesale_price' => 'required|numeric|min:0',
            'goo_purchase_price' => 'required|numeric|min:0',
            'goo_channel_price' => 'required|numeric|min:0',
            'goo_shop_price' => 'required|numeric|min:0',
            'goo_vip_price' => 'required|numeric|min:0',
            'goaf_weight' => 'required|numeric|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑易损件页面查看验证器
    public function editwearingPartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            // 'goaf_id.required_if' => '参数错误',
            // 'goaf_id.integer' => '参数错误',
            // 'goaf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goo_id' => 'required|integer|min:1',
            // 'goaf_id' => 'required_if:type,2|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_name.required' => '请输入:商品名称',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_code.required' => '请输入:商品编号',
            'goo_goods_code.max' => '商品编号长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_cate_name.required_with' => '请输入:品类名称',
            'goo_cate_name.max' => '品类名称长度超过最大限制',
            'goo_cate_id.required' => '请选择品类',
            'goo_cate_id.integer' => '参数类型错误',
            'goo_cate_id.min' => '请选择正确的品类',
            'goo_price.required' => '请输入:售价金额',
            'goo_price.numeric' => '参数类型错误',
            'goo_wholesale_price.required' => '请输入:批发价',
            'goo_wholesale_price.numeric' => '参数类型错误',
            'goo_purchase_price.required' => '请输入:进货价',
            'goo_purchase_price.numeric' => '参数类型错误',
            'goo_channel_price.required' => '请输入:渠道价',
            'goo_channel_price.numeric' => '参数类型错误',
            'goo_shop_price.required' => '请输入:分店价',
            'goo_shop_price.numeric' => '参数类型错误',
            'goo_vip_price.required' => '请输入:会员价',
            'goo_vip_price.numeric' => '参数类型错误',
            'goaf_weight.required' => '请输入:重量',
            'goaf_weight.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正数',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1',
            'goo_name' => 'required|max:80',
            'goo_goods_encode' => 'sometimes|max:80',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_price' => 'required|numeric|min:0',
            'goo_type' => [
                'required',
                Rule::in(['1', '2', '3', '4', '5', '6']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 价格维护
    public function editPriceValidator($data)
    {
    	// 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'goo_price.required' => '参数错误',
            'goo_wholesale_price.required' => '参数错误',
            'goo_purchase_price.required' => '参数错误',
            'goo_channel_price.required' => '参数错误',
            'goo_shop_price.required' => '参数错误',
            'goo_vip_price.required' => '参数错误',
            // 'goaf_id.required_if' => '参数错误',
            // 'goaf_id.integer' => '参数错误',
            // 'goaf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goo_id' => 'required|integer|min:1',
            'goo_price' => 'required',
            'goo_wholesale_price' => 'required',
            'goo_purchase_price' => 'required',
            'goo_channel_price' => 'required',
            'goo_shop_price' => 'required',
            'goo_vip_price' => 'required',
            // 'goaf_id' => 'required_if:type,2|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
	
	// 匹配车型
    public function matchModelValidator($data)
    {
    	// 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            // 'goaf_id.required_if' => '参数错误',
            // 'goaf_id.integer' => '参数错误',
            // 'goaf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goo_id' => 'required|integer|min:1',
            // 'goaf_id' => 'required_if:type,2|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}