<?php

namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyServiceProjectController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sepr_name.required' => '请输入:服务项目',
            'sepr_name.max' => '服务项目名称长度超过最大限制',
            'sepr_order_money.required' => '请输入:服务费用',
            'sepr_order_money.numeric' => '服务费用参数类型错误',
//            'sepr_img.required' => '请上传图片',
            'sepr_check_car.required' => '请选择是否验车',
            'sepr_check_car.in' => '是否验车参数类型错误',
            'sepr_show_location.required' => '请选择显示平台',
            'sepr_show_location.in' => '显示平台参数类型错误',
            'sepr_work_type.required' => '请选择流程分类',
            'sepr_work_type.in' => '流程分类参数类型错误',
            'sepr_sort.required' => '请输入排序',
            'sepr_sort.integer' => '排序参数类型错误',
        ];
        $data = array_filter($data);
        // 数据验证
        $validator = Validator::make($data, [
            'sepr_name' => 'required|max:20',
            'sepr_order_money' => 'sometimes|required|numeric',
            // 'sepr_img' => 'required',
            'sepr_check_car' => [//是否验车1是2否
                'sometimes',
                'required',
                Rule::in([1,2]),
            ],
            // 'sepr_show_location' => [//显示平台0无1半径美装2半径服务-合作商3半径美装和合作商4无
            //     'sometimes',
            //     'required',
            //     Rule::in([0,1,2,3,4]),
            // ],
            // 'sepr_work_type' => [//流程分类1生成工单2不生成工单
            //     'required',
            //     Rule::in([1,2]),
            // ],
            'sepr_sort' => 'sometimes|required|integer',//排序
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sepr_id.required' => '参数错误',
            'sepr_id.integer' => '参数错误',
            'sepr_id.min' => '参数错误',
            'sepr_name.required' => '请输入:服务项目',
            'sepr_name.max' => '服务项目名称长度超过最大限制',
            'sepr_order_money.required' => '请输入:服务费用',
            'sepr_order_money.numeric' => '服务费用参数类型错误',
//            'sepr_img.required' => '请上传图片',
            'sepr_check_car.required' => '请选择是否验车',
            'sepr_check_car.in' => '是否验车参数类型错误',
            'sepr_show_location.required' => '请选择显示平台',
            'sepr_show_location.in' => '显示平台参数类型错误',
            'sepr_work_type.required' => '请选择流程分类',
            'sepr_work_type.in' => '流程分类参数类型错误',
            'sepr_sort.required' => '请输入排序',
            'sepr_sort.integer' => '排序参数类型错误',
        ];
        $data = array_filter($data);
        // 数据验证
        $validator = Validator::make($data, [
            'sepr_id' => 'required|integer|min:1',
            'sepr_name' => 'required|max:20',
            'sepr_order_money' => 'sometimes|required|numeric',
//            'sepr_img' => 'required',
            'sepr_check_car' => [//是否验车1是2否
                'sometimes',
                'required',
                Rule::in([1,2]),
            ],
            'sepr_show_location' => [//显示平台0无1半径美装2半径服务-合作商3半径美装和合作商4无
                'sometimes',
                'required',
                Rule::in([0,1,2,3,4]),
            ],
            'sepr_work_type' => [//流程分类1生成工单2不生成工单
                'required',
                Rule::in([1,2]),
            ],
            'sepr_sort' => 'sometimes|required|integer',//排序
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
    // 编辑验证器
    public function editValidatorWeChat($data)
    {
        // 自定义错误消息
        $messages = [
            'sepr_id.required' => '参数错误',
            'sepr_id.integer' => '参数错误',
            'sepr_id.min' => '参数错误',
//            'sepr_name.required' => '请输入:服务项目',
//            'sepr_name.max' => '服务项目名称长度超过最大限制',
            'sepr_order_money.required' => '请输入:服务费用',
            'sepr_order_money.numeric' => '服务费用参数类型错误',
//            'sepr_img.required' => '请上传图片',
            'sepr_check_car.required' => '请选择是否验车',
            'sepr_check_car.in' => '是否验车参数类型错误',
            'sepr_show_location.required' => '请选择显示平台',
            'sepr_show_location.in' => '显示平台参数类型错误',
            'sepr_work_type.required' => '请选择流程分类',
            'sepr_work_type.in' => '流程分类参数类型错误',
            'sepr_sort.required' => '请输入排序',
            'sepr_sort.integer' => '排序参数类型错误',
        ];
        $data = array_filter($data);
        // 数据验证
        $validator = Validator::make($data, [
            'sepr_id' => 'required|integer|min:1',
//            'sepr_name' => 'required|max:20',
            'sepr_order_money' => 'sometimes|required|numeric',
//            'sepr_img' => 'required',
            'sepr_check_car' => [//是否验车1是2否
                'sometimes',
                'required',
                Rule::in([1,2]),
            ],
            'sepr_show_location' => [//显示平台0无1半径美装2半径服务-合作商3半径美装和合作商4无
                'sometimes',
                'required',
                Rule::in([0,1,2,3,4]),
            ],
            'sepr_work_type' => [//流程分类1生成工单2不生成工单
                'required',
                Rule::in([1,2]),
            ],
            'sepr_sort' => 'sometimes|required|integer',//排序
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sepr_id.required' => '参数错误',
            'sepr_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sepr_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 绑定验证器
    public function bindingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'spcs_sepr_id.required' => '请选择服务项目',
            'spcs_sepr_id.integer' => '参数错误',
            'spcs_sepr_id.min' => '参数错误',
            'spcs_other_sepr_id.required' => '请选择绑定的服务项目',
            'spcs_other_sepr_id.integer' => '参数错误',
            'spcs_other_sepr_id.min' => '参数错误',
            'spcs_system_type.required' => '请选择绑定类型',
            'spcs_system_type.integer' => '参数错误',
            'spcs_system_type.min' => '参数错误',
            'sepr_other_sepr_name.required' => '请选择服务项目名称',
            'sepr_other_sepr_name.integer' => '参数错误',
            'sepr_other_sepr_name.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'spcs_sepr_id' => 'required|integer|min:1',
            'spcs_other_sepr_id' => 'required|integer|min:1',
            'spcs_system_type' => 'required|integer|min:1',
            'sepr_other_sepr_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 订单外派-搜索商品
    public function assignSearchValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑展示验证
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sepr_id.required' => '参数错误',
            'sepr_id.integer' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sepr_id' => 'required|integer',
            'type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
