<?php
namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOrderLabelController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orla_name.required' => '请输入:订单标签',
            'orla_name.max' => '订单标签名称长度超过最大限制',
            'orla_ord_service_type.required' => '请选择:订单类型',
            'orla_ord_service_type.in' => '订单类型错误',
            'orla_recycle_state.required' => '请选择是否回收',
            'orla_recycle_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orla_name' => 'required|max:10',
            'orla_ord_service_type' => [
                'required',
                Rule::in(config('apisystem.ORDER_TYPE')),
            ],
            'orla_recycle_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orla_id.required' => '参数错误',
            'orla_id.integer' => '参数错误',
            'orla_id.min' => '参数错误',
            'orla_name.required' => '请输入:订单标签',
            'orla_name.max' => '订单标签名称长度超过最大限制',
            'orla_ord_service_type.required' => '请选择:订单类型',
            'orla_ord_service_type.in' => '订单类型错误',
            'orla_recycle_state.required' => '请选择是否回收',
            'orla_recycle_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orla_id' => 'required|integer|min:1',
            'orla_name' => 'required|max:10',
            'orla_ord_service_type' => [
                'required',
                Rule::in(config('apisystem.ORDER_TYPE')),
            ],
            'orla_recycle_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orla_id.required' => '参数错误',
            'orla_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orla_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
