<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifySystemPrintController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            'shpt_system.required' => '参数错误',
            'shpt_system.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
            'shpt_system' => [
                    'required',
                    Rule::in(['1','2','3','4']),
                ], //1.半径门店2.半径供应链3.速电4.智配
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取模板类型验证器
    public function getshptTypeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_system.required' => '参数错误',
            'shpt_system.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpt_system' => [
                    'required',
                    Rule::in(['1','2','3','4']),
                ], //1半径门店2半径供应链3速电4智配
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 创建模板验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_template_name.required' => '参数错误',
            'shpt_paper_width.required' => '参数错误',
            'shpt_print_type.required' => '参数错误',
            'shpt_print_type.in' => '数据类型不正确',
            'shpt_system.required' => '参数错误',
            'shpt_system.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpt_template_name' => 'required',
            'shpt_paper_width' => 'required',
            'shpt_print_type' => [
                    'required',
                    Rule::in(['1','2','3','4','5','6','7','8','9','10','11','12','13','14']),
                ], //打印模板分类 1发货单2旧货回收3旧货回收标签
            'shpt_system' => [
                    'required',
                    Rule::in(['1','2','3','4']),
                ], //模板系统类型1半径门店2半径供应链3速电4智配
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设置模板验证器
    public function setValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '数据类型不正确',
            'shpt_print_type.required' => '参数错误',
            'shpt_print_type.in' => '参数类型错误',
            'shpt_id.required' => '参数错误',
            'shpt_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpt_id' => 'required|integer',
            'shpt_print_type' => [
                    'required',
                    Rule::in(['1','2','3','4','5','6','7','8','9','10','11','12','13','14']),
                ], //打印模板分类 1发货单2旧货回收3旧货回收标签
            'type' => [
                    'required',
                    Rule::in(['1','2']),
                ], //类型1查询2打印设置
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设置模板获取组件验证器
    public function getshptComponentValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_print_type.required' => '参数错误',
            'shpt_print_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpt_print_type' => [
                    'required',
                    Rule::in(['1','2','3','4','5','6','7','8','9','10','11','12','13','14']),
                ], //打印模板分类 1发货单2旧货回收3旧货回收标签
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打印验证器
    public function printValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_print_type.required' => '参数错误',
            'shpt_print_type.in' => '参数类型错误',
            'print_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'print_id' => 'required|integer',
            'shpt_print_type' => [
                    'required',
                    Rule::in(['1','2','3']),
                ], //打印模板分类 1发货单2旧货回收3旧货回收标签
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除打印模板验证器
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpt_id.required' => '参数错误',
            'shpt_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpt_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
