<?php

namespace App\Http\Controllers\Api\Verify\OtherSystemInterfaces;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOtherSystemOrdersController extends Controller
{
    // 订单下单
    public function placeOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'timeStamp.required' => '签名参数错误',
            'key.required' => '签名参数错误',
            'signature.required' => '签名参数错误',
            'shop_code.required' => '门店编码为空',
            'goods_data.required' => '平台单号为空',
            'orcl_name.required' => '客户姓名为空',
            'orcl_phone.required' => '请输入:联系电话',
            'orcl_phone.regex' => '手机号格式不正确',
            'orcl_province.required' => '省份为空',
            'orcl_city.required' => '城市为空',
            'orcl_county.required' => '区县为空',
            'orcl_address.required' => '详细地址为空',
            'ord_order_price.required' => '订单金额不能为空',
            'ord_payment_way.in' => '订单支付方式错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'timeStamp' => 'required',
            'key' => 'required',
            'signature' => 'required',
            'shop_code' => 'required',
            'goods_data' => 'required',
            'orcl_name' => 'required',
            'orcl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            'orcl_province' => 'required',
            'orcl_city' => 'required',
            'orcl_county' => 'required',
            'orcl_address' => 'required',
            'ord_order_price' => 'required',
            'ord_payment_way' => [
                    Rule::in(['0', '1', '2', '3', '4', '8']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 订单同步
    public function importOrdersValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'token.required' => 'token为空',
            'platform_number.required' => '平台单号为空',
            'orcl_name.required' => '客户姓名为空',
            'orcl_phone.required' => '请输入:联系电话',
            'orcl_phone.regex' => '手机号格式不正确',
            'orcl_province.required' => '省份为空',
            'orcl_city.required' => '城市为空',
            'orcl_county.required' => '区县为空',
            'orcl_address.required' => '详细地址为空',
            'ord_service_shop_id.required' => '指派门店id为空',
            'ord_service_shop_id.integer' => '指派门店id不是整型',
            'ord_service_shop_id.min' => '指派门店id不能小于1',
            'ord_service_type.required' => '订单类型为空',
            'ord_service_type.in' => '订单类型参数错误',
            // 'goo_is_recycle.required' => '商品是否回收不能为空',
            // 'goo_is_recycle.in' => '商品是否回收参数错误',
            'ord_client_id.required' => '客户单位为空',
            'ord_client_id.integer' => '客户单位为空',
            'ord_client_id.min' => '客户单位为空',
            'ord_order_number.required' => '客户单位为空',
            'goo_id.required' => '商品id为空',
            'goo_id.integer' => '商品id为空',
            'goo_id.min' => '商品id为空',
            'goo_quantity.required' => '商品数量为空',
            'goo_quantity.integer' => '商品数量为空',
            'goo_quantity.min' => '商品数量为空',
            'goo_price.required' => '商品金额为空',
            'goo_price.numeric' => '商品金额为空',
            'goo_price.min' => '商品金额为空',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'token' => 'required',
            'platform_number' => 'required',
            'orcl_name' => 'required',
            'orcl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            'orcl_province' => 'required',
            'orcl_city' => 'required',
            'orcl_county' => 'required',
            'orcl_address' => 'required',
            'ord_service_shop_id' => 'required|integer|min:0',
            'ord_service_type' => 'required',
            'ord_service_type' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ],//订单类型：1服务单 2销售单 3换货单 4退货单
            // 'goo_is_recycle' => 'required',
            // 'goo_is_recycle' => [
            //         'required',
            //         Rule::in(['1', '2']),
            //     ],//商品是否回收:1回收2不回收
            'ord_client_id' => 'required|integer|min:0',
            'ord_order_number' => 'required',
            'goo_id' => 'required|integer|min:1',
            'goo_quantity' => 'required|integer|min:1',
            'goo_price' => 'required|numeric|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 售后同步
    public function importAfterOrdersValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'token.required' => 'token为空',
            'platform_number.required' => '平台单号为空',
            'after_number.required' => '售后单号为空',
            'orcl_name.required' => '客户姓名为空',
            'orcl_phone.required' => '请输入:联系电话',
            'orcl_phone.regex' => '手机号格式不正确',
            'orcl_province.required' => '省份为空',
            'orcl_city.required' => '城市为空',
            'orcl_county.required' => '区县为空',
            'orcl_address.required' => '详细地址为空',
            'ord_service_shop_id.required' => '指派门店id为空',
            'ord_service_shop_id.integer' => '指派门店id不是整型',
            'ord_service_shop_id.min' => '指派门店id不能小于1',
            'ord_service_type.required' => '订单类型为空',
            'ord_service_type.in' => '订单类型参数错误',
            // 'goo_is_recycle.required' => '商品是否回收不能为空',
            // 'goo_is_recycle.in' => '商品是否回收参数错误',
            'ord_client_id.required' => '客户单位为空',
            'ord_client_id.integer' => '客户单位为空',
            'ord_client_id.min' => '客户单位为空',
            'ord_order_number.required' => '客户单位为空',
            'afla_name.required' => '售后标签为空',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'token' => 'required',
            'platform_number' => 'required',
            'after_number' => 'required',
            'orcl_name' => 'required',
            'orcl_phone' => ['sometimes','required','regex:/^1[3456789]\d{9}$/'],
            'orcl_province' => 'required',
            'orcl_city' => 'required',
            'orcl_county' => 'required',
            'orcl_address' => 'required',
            'ord_service_shop_id' => 'required|integer|min:0',
            'ord_service_type' => 'required',
            'ord_service_type' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ],//订单类型：1服务单 2销售单 3换货单 4退货单
            'ord_client_id' => 'required|integer|min:0',
            'ord_order_number' => 'required',
            'afla_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 接单
    public function orderReceivingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            // 'adm_id.required' => '参数错误',
            // 'adm_id.integer' => '参数错误',
            // 'adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            // 'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
	//门店接单
    public function cyorderReceivingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            // 'adm_id.required' => '参数错误',
            // 'adm_id.integer' => '参数错误',
            // 'adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            // 'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 拒单
    public function orderRefuseValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            // 'label_id.required' => '参数错误',
            // 'label_id.integer' => '参数错误',
            // 'label_id.min' => '参数错误',
            // 'label_name.required' => '参数错误',
            'remark.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            // 'label_id' => 'required|integer|min:1',
            // 'label_name'=>'required',
            'remark'=>'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //审核速电的改单请求
    public function changePassValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],//订单类型：1服务单 2销售单 3换货单 4退货单
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //撤销同意驳回
    public function undoOperationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //催单反馈
    public function feedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'label_id.required' => '参数错误',
            'label_name.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'remark' => 'required|max:200',
            'label_id' => 'required',
            'label_name' => 'required',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //系统锁单
    public function orderLockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //系统取消锁单
    public function unOrderLockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
