<?php
namespace App\Http\Controllers\Api\Verify\OrderManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOrderController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //导出验证器
    public function exportValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'create_time.required' => '请输入创建时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'create_time' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结算验证器
    public function settlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'orcl_acc_subject_id.required' => '请选择会计科目',
            'orcl_acc_subject_id.integer' => '参数错误',
            'orcl_acc_subject_id.min' => '参数错误',
            'orcl_img.sometimes' => '参数错误',
            'orcl_img.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'orcl_acc_subject_id' => 'required|integer|min:1',
            'orcl_img' => 'sometimes|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结算验证器
    public function cancelSettlementtValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'ord_remark.required' => '请填写备注',
            'ord_remark.min' => '参数错误',
            'ord_remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_type.required' => '请选择订单类型',
            'ord_service_type.in' => '订单类型参数错误',
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_id.integer' => '服务技师数据类型不正确',
            'service_adm_id.min' => '服务技师参数错误',
            'service_shop_id.required' => '请选择服务门店',
            'service_shop_id.integer' => '服务门店数据类型不正确',
            'service_shop_id.min' => '服务门店参数错误',

            'service_sepr_id.required' => '请选择服务项目',
            'service_sepr_id.integer' => '服务项目数据类型不正确',
            'service_sepr_id.min' => '服务项目参数错误',
            // 'ware_id.required_unless' => '请选择供货仓库',
            // 'ware_id.integer' => '供货仓库数据类型不正确',
            // 'ware_id.min' => '供货仓库参数错误',
            'orcl_shipment_party.required' => '请选择出库方',
            'orcl_shipment_party.in' => '出库方参数错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '结算方式参数错误',
            'ord_type.required' => '请选择买家类型',
            'ord_type.in' => '买家类型参数错误',

            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_standby_battery_type.required' => '参数错误',
            'orcl_standby_battery_type.in' => '参数错误',

            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',

            'orcl_whether_app.required_if' => '请选择是否走技师流程',
            'orcl_whether_app.in' => '参数错误',
            'orcl_junk_type.required' => '请选择是否回收旧货',
            'orcl_junk_type.in' => '参数错误',
            'orcl_chin_type.required' => '请选择是否铺货',
            'orcl_chin_type.in' => '参数错误',
            'orcl_collect_state.required' => '请选择技师是否收钱',
            'orcl_collect_state.in' => '参数错误',
            'precise_lock.required' => '请选择技师是否精确打卡',
            'precise_lock.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_service_type' => [
                    'required',
                    Rule::in(config('apisystem.ORDER_TYPE')),
                ],//订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
            // 'service_adm_id' => 'required|integer|min:1',//服务技师id
            'service_shop_id' => 'required|integer|min:0',//服务门店id
            'service_sepr_id' => 'required|integer|min:0',//服务项目id
            'orcl_shipment_party' => [//出库方1库房2直营店3加盟店4虚拟加盟店
                'required',
                Rule::in([1,4,5]),
            ],
            // 'ware_id' => 'required_if:orcl_shipment_party,1|integer|min:1',//仓库id
            'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
                    'required',
                    Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
                ],
            'ord_type' => [//读取配置文件数据，买家类型：1门店零售2渠道单位
                    'required',
                    Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
                ],
            // 'ord_remark' => 'sometimes|required|max:255',

            'orcl_name' => 'required|max:20',//客户姓名
            // 'orcl_phone' => ['sometimes','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            'orcl_province' => 'required|max:50',
            'orcl_city' => 'required|max:50',
            'orcl_county' => 'required|max:50',
            'orcl_address' => 'required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            'orcl_whether_app' => [//是否走技师流程1是2否
                'required_if:orcl_shipment_party,4',
                Rule::in(['1', '2']),
            ],
            'orcl_junk_type' => [//是否回收旧货1是2否
                'required',
                Rule::in(['1', '2']),
            ],
            'orcl_chin_type' => [//铺货类型：1是铺货2不是铺货
                'required',
                Rule::in(['1', '2']),
            ],
            'orcl_collect_state' => [//技师收钱：1是2否
                    'required',
                    Rule::in(['1', '2']),
                ],
            'precise_lock' => [//精确打卡1是2否
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 转售后验证器
    public function afterSaleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'oraf_orla_id.required' => '参数错误',
            'oraf_orla_id.integer' => '参数错误',
            'oraf_orla_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'oraf_orla_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成账单验证器
    public function createBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误1',
            //'ord_id.array' => '参数错误2',
            'start_time.required' => '参数错误3',
            'start_time.date' => '参数错误4',
            'end_time.required' => '参数错误5',
            'end_time.date' => '参数错误6',
            'orbi_type.required' => '参数错误7',
            'orbi_type.in' => '参数错误8',
            'choose_collect.required' => '参数错误9',
            'choose_collect.in' => '参数错误10',
            'orbi_client_id.required' => '请选择客户单位/会员',
            'orbi_client_id.integer' => '参数错误11',
            'orbi_client_id.min' => '参数错误12',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            //'ord_id' => 'required|array',
            'start_time' => 'required|date',
            'end_time' => 'required|date',
            'orbi_type' => [
                'required',
                Rule::in(['1', '2']),
            ],//类型：1门店零售 2来往单位
            'choose_collect' => [
                'required',
                Rule::in(['1', '2']),
            ],//是否合并代收：1是2否
            'orbi_client_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打印验证器
    public function printNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'ord_remark.sometimes' => '请输入备注',
            'ord_remark.max' => '备注超过最大长度限制',
            // 'prca_com_name.required' => '请输入公司名称',
            'prca_com_name.max' => '公司名称超过长度限制',
            // 'prca_serve_provider.required' => '请输入服务提供商',
            'prca_serve_provider.max' => '服务提供商超过长度限制',
            // 'prca_serve_order.required' => '请输入打印单的类型',
            'prca_serve_order.max' => '打印单的类型超过长度限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_remark' => 'sometimes|max:255',
            'prca_com_name' => 'sometimes|max:30', //公司名称
            'prca_serve_provider' => 'sometimes|max:30', //服务提供商
            'prca_serve_order' => 'sometimes|max:10', //打印单的类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //冲单操作
    public function againstOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '参数错误',
            'acti_id.min' => '参数错误',
            'plus_minus.required' => '参数错误',
            'plus_minus.integer' => '参数错误',
            'plus_minus.min' => '参数错误',
            'remit_time.required' => '参数错误',
            'actual_price.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'acti_id' => 'required|integer|min:1',
            'plus_minus' => 'required|integer|min:1',
            'remit_time' => 'required',
            'actual_price' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核查看验证器
    public function auditShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'search_type.required' => '参数错误',
            'search_type.in' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'search_type' => [
                'required',
                Rule::in(['1', '2']),
            ]
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 外派工单
    public function assignmentOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 修改来往单位
    public function editUnitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '参数错误',
            'chun_id.min' => '参数错误',
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer|min:1',
			'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 取消订单验证器
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'remark.required' => '请填写备注',
            'remark.min' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 作废易损件订单验证器
    public function cancelOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'remark.required' => '请填写备注',
            'remark.min' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预约设置
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'appoint_time.required' => '请填写备注',
            'appoint_time.date' => '请选择日期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
