<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyWorkManageController extends Controller
{
    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}