<?php
namespace App\Http\Controllers\Api\Verify\MobileManage;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class VerifyOrderAfterController extends Controller
{
    // 列表验证器
    public function listValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'page.integer' => '参数类型错误',
            'page.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
            'page' => 'integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 拒单验证器
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'oraf_number.required' => '参数错误',
            'oraf_number.max' => '参数类型错误',
            'cause.required' => '请输入:拒单原因',
            'cause.max' => '备注长度超过最大长度限制'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_number' => 'required|max:20',
            'cause' => 'required|max:255'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预约验证器
    public function appointValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'oraf_number.required' => '参数错误',
            'oraf_number.max' => '参数类型错误',
            'orac_appoint_time.required' => '请输入时间',
            'orac_appoint_time.date' => '参数类型错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_number' => 'required|max:20',
            'orac_appoint_time' => 'required|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 出发/抵达验证器
    public function departArriveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'oraf_number.required' => '参数错误',
            'oraf_number.max' => '参数类型错误',
            'state.required' => '参数错误',
            'state.in' => '参数类型错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_number' => 'required|max:20',
            'state' => [
                    'required',
                     Rule::in(['6', '7']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 完成-验证器
    public function achieveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'oraf_number.required' => '参数错误',
            'oraf_number.max' => '参数类型错误',
            'orac_result.required' => '参数错误',
            'orac_result.integer' => '参数类型错误',
            'orac_result.min' => '参数错误',
            'goods.required' => '参数错误',
            'goods.json' => '参数类型错误',
            'code.required' => '参数错误',
            'imgs64.required' => '请上传图片',
            'oraf_plus_minus.required' => '参数错误',
            'oraf_plus_minus.in' => '参数错误',
            'oraf_collection_price.required' => '参数错误',
            'oraf_collection_price.integer' => '参数类型错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_number' => 'required|max:20',
            'orac_result' => 'required|integer|min:1',
            'goods' => 'required|json',
            // 'imgs64' => 'required',
            'oraf_plus_minus' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'oraf_collection_price' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 接单/终止/暂停验证器
    public function stateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'oraf_number.required' => '参数错误',
            'oraf_number.max' => '参数类型错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_number' => 'required|max:20'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 第一次获取经纬度验证器
    public function getLocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 实时刷新经纬度验证器
    public function realTimeLocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
            'loaf_id.required' => '参数错误',
            'loaf_id.integer' => '参数类型错误',
            'loaf_id.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'loaf_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取状态验证器
    public function getStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取工单状态/图片验证器
    public function getDataValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数类型错误',
            'oraf_id.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取经纬度验证器
    public function getLagValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'laaf_lat.required' => '经度不能为空',
            'laaf_lat.max' => '经度长度超过最大限制',
            'laaf_lon.required' => '纬度不能为空',
            'laaf_lon.max' => '纬度长度超过最大限制',
            'oraf_id.required' => '服务单id不能为空',
            'oraf_state.required' => '当前状态不能为空',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'laaf_lat' => 'required|max:20',
            'laaf_lon' => 'required|max:20',
            'oraf_id' => 'required',
            'oraf_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
