<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Validator;
use App\Http\Requests;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VerifyMyselfEvaluateController extends Controller
{
    // 我的评分
    public function gradeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'service_adm_id.required' => '参数错误',
            'service_adm_id.regex' => '参数类型错误',
            'service_adm_id.size' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'service_adm_id' => 'required|min:1|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 我的评分详情
    public function gradeDetails($data)
    {
        // 自定义错误消息
        $messages = [
            'uniqueid.required' => '参数错误',
            'uniqueid.regex' => '参数类型错误',
            'uniqueid.size' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'uniqueid' => ['required','size:32','regex:/^[a-zA-Z0-9]+$/u'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}