<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMobileController extends Controller
{
    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'lat_lat.required' => '经度不能为空',
            'lat_lat.max' => '经度长度超过最大限制',
            'lat_lon.required' => '纬度不能为空',
			'lat_lon.max' => '纬度长度超过最大限制',
			'ord_id.required' => '服务单id不能为空',
			'ord_state.required' => '当前状态不能为空',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'lat_lat' => 'required|max:20',
			'lat_lon' => 'required|max:20',
			'ord_id' => 'required',
			'ord_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}