<?php
namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMobileAfterReminderController extends Controller
{
    // 详情接口
    public function readValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afre_id.required' => '参数错误',
            'afre_id.integer' => '类型不正确',
            'afre_id.min' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afre_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
