<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyColorLabelController extends Controller
{
	// 颜色标签编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cola_id.required' => '参数错误',
            'cola_id.integer' => '参数类型错误',
            'cola_id.min' => '参数错误',
            'cola_label_name.required' => '参数错误',
            'cola_label_name.max' => '参数类型错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'cola_id' => 'required|integer|min:1',
            'cola_label_name' => 'required|max:10',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
