<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyAllocateOrdersController extends Controller
{
    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_id.required' => '请输入调货单id',
            'tror_id.integer' => '调货单id数据类型不正确',
            'tror_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_out_ware_id.required' => '请选择出货仓库',
            'tror_out_ware_id.integer' => '参数类型错误',
            'tror_out_ware_id.min' => '参数错误',
            'tror_in_ware_id.required' => '请选择入货仓库',
            'tror_in_ware_id.integer' => '参数类型错误',
            'tror_in_ware_id.min' => '参数错误',
            'tror_out_waon_class.required' => '请选择仓库类别',
            'tror_out_waon_class.integer' => '参数类型错误',
            'tror_out_waon_class.min' => '参数错误',
            'tror_remark.required' => '请输入备注',
            'tror_remark.max' => '备注长度超过最大限制',

            'goo_id.required' => '请选择商品',
            'goo_id.array' => '参数类型错误',
            'goo_wago_id.required' => '请选择仓库商品id',
            'goo_wago_id.array' => '参数类型错误',
            'goo_waon_class.required' => '请选择仓库类别',
            'goo_waon_class.array' => '参数类型错误',
            'goo_stock_number.required' => '请选择良品数量',
            'goo_stock_number.array' => '参数类型错误',
            'goo_priority_stock_number.required' => '请选择优先数量',
            'goo_priority_stock_number.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_out_ware_id' => 'required|integer|min:1',
            'tror_in_ware_id' => 'required|integer|min:1',
            'tror_out_waon_class' => 'required|integer|min:1',
            'tror_remark' => 'sometimes|max:255',

            // 'goo_id' => 'required|array',
            // 'goo_wago_id' => 'required|array',
            // 'goo_waon_class' => 'required|array',
            // 'goo_stock_number' => 'required|array',
            // 'goo_priority_stock_number' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核查看验证器
    public function auditShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'tror_id.required' => '参数错误',
            'tror_id.integer' => '参数类型错误',
            'tror_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'tror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_state.required' => '参数错误',
            'tror_state.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_state' => [
                'required',
                Rule::in(['2', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 撤销删除验证器
    public function revocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_id.required' => '参数错误',
            'tror_id.integer' => '参数类型错误',
            'tror_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 入库验证器
    public function putInStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tror_in_waon_class.required' => '请选择仓库类别',
            'tror_in_waon_class.integer' => '参数类型错误',
            'tror_in_waon_class.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tror_in_waon_class' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}

