<?php

namespace App\Http\Controllers\Api\Verify\MemberManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMemberListController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_name.required' => '请输入姓名！',
            'mem_name.max' => '姓名长度超过最大限制！',
            'mem_sex.required' => '请输入性别！',
            'mem_sex.in' => '请选择性别！',
            'mem_phone.required' => '请输入联系电话！',
            'mem_phone.regex' => '手机号格式不正确！',
            'mem_birthday.alpha_dash' => '参数错误',
            'mem_birthday.max' => '生日长度超过最大限制！',
            'mem_birthday.min' => '生日长度超过最小限制！',
            'mem_car_num.required' => '请输入车牌号！',
            'mem_car_series.required' => '请输入品牌车系！',
            'mem_car_num.max' => '车牌号长度超过最大限制！',
            'mem_car_series.max' => '车系长度超过最大限制！',
            'mem_car_model.max' => '车型长度超过最大限制！',
            // 'mem_province.required' => '请输入:省',
            // 'mem_province.max' => '省长度超过最大限制',
            // 'mem_city.required' => '请输入:市',
            // 'mem_city.max' => '市长度超过最大限制',
            // 'mem_county.required' => '请输入:县',
            // 'mem_county.max' => '县长度超过最大限制',
            // 'mem_address.required' => '请输入:地址',
            // 'mem_address.max' => '地址长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_name' => 'required|max:20',
            'mem_sex' => [
                'required',
                Rule::in(['1', '2', '3']),
            ], //mem_sex为1或者2
            'mem_phone' => ['required', 'regex:/^1[3456789]\d{9}$/'],
            'mem_birthday' => 'sometimes|alpha_dash|max:5|min:5',
            'mem_car_num' => 'required|max:10',
            'mem_car_series' => 'required|max:30',
            // 'mem_province' => 'required|max:50',
            // 'mem_city' => 'required|max:50',
            // 'mem_county' => 'required|max:50',
            // 'mem_address' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_id.required' => '参数错误',
            'mem_id.integer' => '参数错误',
            'mem_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 发送模板消息验证
    public function sendMessageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'title.required' => '参数错误',
            'title.string' => '参数错误',
            'title.max' => '参数错误',
            'message.required' => '参数错误',
            'message.string' => '参数错误',
            'message.max' => '参数错误',
            'client_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'title' => 'required|string|max:255',
            'message' => 'required|string|max:255',
            'client_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }


    // 新增节日验证器
    public function addFestValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fest_type.in' => '请选择类型！',
            'fest_name.required' => '请输入节日名称！',
            'fest_content.required' => '请输入短信内容！',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fest_name' => 'required',
            'fest_type' => [
                'required',
                Rule::in(['1', '2']),
            ], //
            'fest_content' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }


    // 添加节日提醒验证器
    public function setRemindValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.integer' => '数据类型不正确',
            //'mefe_mem_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 欠款记录验证器
    public function arrearsRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.integer' => '数据类型不正确',
            'mem_id.integer' => '数据类型不正确',
            'mem_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer',
            'mem_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }


    // 业务员替换验证器
    public function salesmanRepValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'old_salesman.required' => '参数错误',
            'old_salesman.integer' => '数据类型不正确',
            'new_salesman.integer' => '数据类型不正确',
            'new_salesman.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'old_salesman' => 'required|integer',
            'new_salesman' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 导入验证器
    public function leadValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'file.required' => '请上传文件',
            'file.file' => '请上传文件1',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'file' => 'required|file',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
}
