<?php

namespace App\Http\Controllers\Api\Verify\MemberManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMemberLevelController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meml_id.required' => '参数错误',
            'meml_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meml_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editContentValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meml_id.required' => '参数错误',
            'meml_id.integer' => '数据类型不正确',
            'meml_total_amount.required' => '消费金额必填',
            'meml_is_discount.required' => '是否享受折扣必填',
            //'meml_discount.required' => '折扣必填',
            'meml_points_multiple.required' => '积分倍数必填',
            'meml_forever.required' => '是否永久有效必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meml_id' => 'required|integer',
            'meml_total_amount' => 'required',
            'meml_is_discount' => 'required',
            //'meml_discount' => 'required',
            'meml_points_multiple' => 'required',
            'meml_forever' => 'required',
            'meml_total_amount' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑显示验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meml_id.required' => '参数错误',
            'meml_id.integer' => '数据类型不正确',
            'meml_show.required' => '参数错误',
            'meml_show.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meml_id' => 'required|integer',
            'meml_show' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }


    // 获取商品验证器
    public function getGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '请选择商品类型',
            'type.integer' => '参数类型错误',
            'type.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'memlg_id.required' => '参数错误',
            'memlg_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'memlg_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
