<?php

namespace App\Http\Controllers\Api\Verify\MemberManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMemberLabelController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mela_name.required' => 'mela_name必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mela_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mela_id.required' => '参数错误',
            'mela_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mela_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mela_id.required' => '参数错误',
            'mela_name.required' => 'mela_name必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mela_id' => 'required|integer',
            'mela_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function toMemberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mela_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mela_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
