<?php

namespace App\Http\Controllers\Api\Verify\DistributorsManages;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyReplenishBillsController extends Controller
{
    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebw_id.required' => '参数错误',
            'rebw_id.integer' => '参数类型错误',
            'rebw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebw_id.required' => '参数错误',
            'rebw_id.integer' => '参数类型错误',
            'rebw_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebw_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 账单核销
    public function verificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebw_id.required' => '参数错误',
            'rebw_id.integer' => '参数类型错误',
            'rebw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 配送账单列表详情配送状态修改
    public function detailsExportValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'regw_id.required' => '参数错误',
            'regw_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'regw_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单送货单列表
    public function deliveryListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebw_id.required' => '参数错误',
            'rebw_id.int' => '参数类型错误',
            'rebw_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebw_id' => 'required|int|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单送货单列表详情
    public function deliveryDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerw_id.required' => '参数错误',
            'rerw_id.int' => '参数类型错误',
            'rerw_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerw_id' => 'required|int|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单送货单列表详情
    public function deliveryRemarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerw_id.required' => '参数错误',
            'rerw_id.int' => '参数类型错误',
            'rerw_id.min' => '参数类型错误',
            'remark.required'=>'参数错误',
            'remark.max'=>'参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerw_id' => 'required|int|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单列表送货单收货接口
    public function showTakeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerw_id.required'=>'参数错误',
            'rerw_id.int'=>'参数错误',
            'rerw_id.min'=>'参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerw_id' => 'required|int|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单列表送货单收货接口
    public function takeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rrgw_id.required' => '参数错误',
            'rrgw_id.array' => '参数类型错误',
            'amount.required'=>'参数错误',
            'amount.array'=>'参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rrgw_id' => 'required|array',
            'amount' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //补货账单列表送货单撤销收货接口
    public function detailsRevocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerw_id.required' => '参数错误',
            'rerw_id.int' => '参数类型错误',
            'rerw_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerw_id' => 'required|int|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
